/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.taobao.utils;

import com.yqbsoft.laser.service.adapter.taobao.utils.Base64Util;
import com.yqbsoft.laser.service.adapter.taobao.utils.SignatureUtil;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class MD5Util {
    public static String generate32md5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            byte[] byteDigest = md.digest();
            StringBuffer buf = new StringBuffer("");
            for (int offset = 0; offset < byteDigest.length; ++offset) {
                int i = byteDigest[offset];
                if (i < 0) {
                    i += 256;
                }
                if (i < 16) {
                    buf.append("0");
                }
                buf.append(Integer.toHexString(i));
            }
            return buf.toString();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String getSign(Map<String, String> map, String secret) {
        String result = "";
        try {
            ArrayList<Map.Entry<String, String>> infoIds = new ArrayList<Map.Entry<String, String>>(map.entrySet());
            Collections.sort(infoIds, new Comparator<Map.Entry<String, String>>(){

                @Override
                public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                    return o1.getKey().toString().compareTo(o2.getKey());
                }
            });
            StringBuilder sb = new StringBuilder();
            for (Map.Entry entry : infoIds) {
                if (entry.getKey() == null && entry.getKey() == "" || ((String)entry.getKey()).equals("sign")) continue;
                String key = (String)entry.getKey();
                String val = (String)entry.getValue();
                if (val == "" || val == null) continue;
                sb.append(key + val);
            }
            result = sb.toString();
            result = secret + result + secret;
            result = MD5Util.generate32md5(result).toUpperCase();
        }
        catch (Exception e) {
            return null;
        }
        return result;
    }

    public static String getOMSSign(Map<String, String> map, String appPrivateKey) throws Exception {
        String signStr = SignatureUtil.getSignContent(map);
        signStr = MD5Util.generate32md5(signStr).toUpperCase();
        byte[] signed = SignatureUtil.sign(SignatureUtil.str2PrivateKey(appPrivateKey), signStr);
        return MD5Util.generate32md5(Base64Util.byte2Base64StringFun(signed)).toUpperCase();
    }

    public static Integer dateForStamp(Date data) {
        return (int)(data.getTime() / 1000L);
    }

    public static void main(String[] args) {
        HashMap params = new HashMap();
    }
}

