/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.taobao.utils;

import com.yqbsoft.laser.service.adapter.taobao.utils.Base64Util;
import java.io.ByteArrayOutputStream;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.crypto.Cipher;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;

public final class SignatureUtil {
    private static final String SIGNATURE_ALGORITHM = "SHA1withRSA";
    private static final String ALGORITHM = "RSA";
    private static final int KEYSIZE = 2048;
    public static final String PUBLIC_KEY = "publicKey";
    public static final String PRIVATE_KEY = "privateKey";
    private static final String KEY_ALGORITHM = "RSA";
    private static final int MAX_ENCRYPT_BLOCK = 500;
    private static final int MAX_DECRYPT_BLOCK = 500;

    public static byte[] sign(PrivateKey privateKey, String text) throws Exception {
        Signature signature = Signature.getInstance(SIGNATURE_ALGORITHM);
        signature.initSign(privateKey);
        signature.update(text.getBytes("UTF-8"));
        return signature.sign();
    }

    public static boolean verifySign(PublicKey publicKey, String text, byte[] signed) throws Exception {
        Signature verifySign = Signature.getInstance(SIGNATURE_ALGORITHM);
        verifySign.initVerify(publicKey);
        verifySign.update(text.getBytes("UTF-8"));
        return verifySign.verify(signed);
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static RSAPublicKey str2PublicKey(String publicKeyPerm) {
        try {
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(Base64Util.decodeBase64(publicKeyPerm));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPublicKey)keyFactory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static RSAPrivateKey str2PrivateKey(String privateKeyPerm) {
        try {
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(Base64Util.decodeBase64(privateKeyPerm));
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return (RSAPrivateKey)keyFactory.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getSignContent(Map<String, String> requestParams) {
        StringBuilder content = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>(requestParams.keySet());
        Collections.sort(keys);
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = requestParams.get(key);
            if (StringUtils.isBlank((String)value) || key.equals("sign")) continue;
            if (value.equals("true")) {
                value = "1";
            }
            if (value.equals("false")) {
                value = "0";
            }
            content.append(SignatureUtil.humpToLine(key) + value);
        }
        return content.toString();
    }

    public static String humpToLine(String str) {
        Pattern humpPattern = Pattern.compile("[A-Z]");
        Matcher matcher = humpPattern.matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, "_" + matcher.group(0).toLowerCase());
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public static Map<String, String> genKeyPair() throws NoSuchAlgorithmException {
        HashMap<String, String> keys = new HashMap<String, String>();
        SecureRandom secureRandom = new SecureRandom();
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(2048, secureRandom);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        String publicKeyBase64 = Base64.encodeBase64String((byte[])publicKey.getEncoded());
        String privateKeyBase64 = Base64.encodeBase64String((byte[])privateKey.getEncoded());
        keys.put(PUBLIC_KEY, publicKeyBase64);
        keys.put(PRIVATE_KEY, privateKeyBase64);
        return keys;
    }

    public static byte[] encrypt(byte[] data, Key key) throws Exception {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, key);
        int inputLen = data.length;
        ByteArrayOutputStream out = new ByteArrayOutputStream(data.length << 1);
        int offSet = 0;
        while (inputLen - offSet > 0) {
            byte[] cache = inputLen - offSet > 500 ? cipher.doFinal(data, offSet, 500) : cipher.doFinal(data, offSet, inputLen - offSet);
            out.write(cache);
            offSet += 500;
        }
        byte[] encryptedData = out.toByteArray();
        out.close();
        return encryptedData;
    }

    public static Key getPublicKey(String publicKey) throws Exception {
        return KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(Base64.decodeBase64((String)publicKey)));
    }

    public static void main(String[] args) {
        try {
            Map<String, String> map = SignatureUtil.genKeyPair();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

