/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.webshop.service.navision.impl;

import com.yqbsoft.laser.service.adapter.webshop.domain.EditSkuDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.OcContractDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.RsSku;
import com.yqbsoft.laser.service.adapter.webshop.domain.UmUserinfo;
import com.yqbsoft.laser.service.adapter.webshop.service.navision.OrderService;
import com.yqbsoft.laser.service.adapter.webshop.utils.JsonUtil;
import com.yqbsoft.laser.service.adapter.webshop.utils.SftpClientUtil;
import com.yqbsoft.laser.service.adapter.webshop.utils.XmlUtils;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.dom4j.DocumentException;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    private static final String SYS_CODE = "service.adapter.webshop.OrderServiceImpl";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
    private static String xmlName = "";
    private static String tenantCode = "2020021700000001";

    @Override
    public String sendOcContractToNavision(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision", (Object)ocContractDomain);
            return "false";
        }
        UmUserinfo umUserinfo = this.queryShopInfo(ocContractDomain.getMemberCcode(), ocContractDomain.getTenantCode());
        if (umUserinfo == null) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.umUserinfo", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01MemberCode:" + ocContractDomain.getMemberCcode() + "-" + ocContractDomain.getContractBillcode()));
            return "false";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\"?>");
        builder.append("<xml contentnamespace=\"NAV\" xmlns=\"http://www.to-increase.com/data/blocks\">");
        builder.append("<blocks>");
        builder.append("<block id=\"EDISalesHeader\">");
        builder.append("<members>");
        builder.append("<member id=\"No\">").append(ocContractDomain.getContractBillcode()).append("</member>");
        builder.append("<member id=\"CustomerNo\">").append("30210016").append("</member>");
        builder.append("<member id=\"ShipToCode\">").append("394").append("</member>");
        builder.append("<member id=\"OrderDate\">").append(ocContractDomain.getContractValidate()).append("</member>");
        builder.append("<member id=\"PaymentID\">").append(0).append("</member>");
        builder.append("<member id=\"PaymentMethod\">").append(0).append("</member>");
        builder.append("<member id=\"PaymentTermField\"/>");
        builder.append("<member id=\"SalespersonCode\">").append("30100005").append("</member>");
        builder.append("<member id=\"NetAmount\">").append(ocContractDomain.getContractMoney()).append("</member>");
        builder.append("<member id=\"DelayedDiscountAmount\">").append(ocContractDomain.getContractInmoney()).append("</member>");
        builder.append("</members>");
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        builder.append("<blocks>");
        int lineNo = 1;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            builder.append("<block id=\"EDISalesLine\" relation=\"EDI Sales Line\">");
            builder.append("<members>");
            builder.append("<member id=\"LineNo\">").append(lineNo).append("</member>");
            builder.append("<member id=\"No\">").append(ocContractGoodsDomain.getSkuNo()).append("</member>");
            builder.append("<member id=\"Quantity\">").append(ocContractGoodsDomain.getGoodsNum()).append("</member>");
            builder.append("<member id=\"DiscountType\">").append(0).append("</member>");
            builder.append("<member id=\"DiscountAmount\">").append(ocContractGoodsDomain.getContractGoodsMoney()).append("</member>");
            builder.append("</members>");
            builder.append("</blocks>");
            ++lineNo;
        }
        builder.append("</blocks>");
        builder.append("</block>");
        builder.append("</blocks>");
        builder.append("</xml>");
        String xml = builder.toString();
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.xml", (Object)xml);
        xmlName = "SO_ORDER_" + ocContractDomain.getContractBillcode() + ".XML";
        ByteArrayInputStream input = new ByteArrayInputStream(builder.toString().getBytes());
        String uploadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("uploadpath"));
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("password"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)uploadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + uploadpath));
            return null;
        }
        String[] split = uploadpath.split(";");
        if (split.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.uploadCancelpath", (Object)uploadpath);
            return null;
        }
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + uploadpath));
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.SftpClientUtil.connect.error", (Object)connect);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return null;
        }
        boolean uploadFlag = false;
        for (String path : split) {
            try {
                uploadFlag = SftpClientUtil.uploadFile(input, path + "/" + xmlName);
                if (!uploadFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.upload.error", (Object)(xmlName + "=:=" + path));
                    return null;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.upload.success", (Object)(xmlName + "=:=" + path));
            }
            catch (IOException e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.upload.error.e", (Object)(xmlName + "=:=" + path), (Throwable)e);
                return null;
            }
        }
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.success", (Object)"success");
        return "success";
    }

    @Override
    public String sendCanncelContractToNavision(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision", (Object)ocContractDomain);
            return "false";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\"?>");
        builder.append("<xml contentnamespace=\"NAV\" xmlns=\"http://www.to-increase.com/data/blocks\">");
        builder.append("<blocks>");
        builder.append("<block id=\"EDISalesHeader\">");
        builder.append("<member id=\"OrderNo\">").append(ocContractDomain.getContractBillcode()).append("</member>");
        builder.append("<member id=\"Cancel\">").append(1).append("</member>");
        builder.append("</block>");
        builder.append("</blocks>");
        String xml = builder.toString();
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.xml", (Object)xml);
        xmlName = "SO_CANCEL" + sdf.format(new Date()) + ".XML";
        ByteArrayInputStream input = new ByteArrayInputStream(builder.toString().getBytes());
        String uploadCancelpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("uploadCancelpath"));
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("password"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)uploadCancelpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + uploadCancelpath));
            return null;
        }
        String[] split = uploadCancelpath.split(";");
        if (split.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.uploadCancelpath", (Object)uploadCancelpath);
            return null;
        }
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + uploadCancelpath));
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.SftpClientUtil.connect.error", (Object)connect);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return null;
        }
        boolean uploadFlag = false;
        for (String path : split) {
            try {
                uploadFlag = SftpClientUtil.uploadFile(input, path + "/" + xmlName);
                if (!uploadFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.upload.error", (Object)(xmlName + "=:=" + path));
                    return null;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.upload.success", (Object)(xmlName + "=:=" + path));
            }
            catch (IOException e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.upload.error.e", (Object)(xmlName + "=:=" + path), (Throwable)e);
                return null;
            }
        }
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.success", (Object)"success");
        return "success";
    }

    @Override
    public void acceptContractCanncelNavision(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.tenantCode", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String cannceldownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("cannceldownloadpath"));
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)cannceldownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + cannceldownloadpath));
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        try {
            fileNames = SftpClientUtil.listFileInDir(cannceldownloadpath);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
            return;
        }
        String xml = "";
        for (String fileName : fileNames) {
            try {
                xml = SftpClientUtil.downloadFile(cannceldownloadpath, fileName);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                continue;
            }
            if (StringUtils.isBlank((String)xml)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                continue;
            }
            JSONObject jsonObject = null;
            try {
                jsonObject = XmlUtils.xml2Json(xml);
                if (null == jsonObject) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.xml2Json", (Object)"\u89e3\u6790\u51fa\u9519\uff01");
                    return;
                }
            }
            catch (DocumentException e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.xml2Json", (Object)"\u89e3\u6790\u5f02\u5e38\uff01.", (Throwable)e);
                return;
            }
            Object bloks = jsonObject.get((Object)"blocks");
            Map blockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(bloks), String.class, Object.class);
            Object block = blockMap.get("block");
            List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(block), Map.class);
            if (ListUtil.isEmpty((Collection)mapList)) {
                Map membersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(block), String.class, Object.class);
                Object members = membersMap.get("members");
                Map contentMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                Object cancel = contentMap.get("Cancel");
                String orderNo = contentMap.get("OrderNo").toString();
                this.updateOcContractCanncel(orderNo, tenantCode);
            } else {
                for (Map stringObjectMap : mapList) {
                    Map membersMapStr = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(stringObjectMap), String.class, Object.class);
                    Object members = membersMapStr.get("members");
                    Map orderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                    if (null == orderMap.get("OrderNo") || null == orderMap.get("Cancel")) {
                        return;
                    }
                    String orderNo = orderMap.get("OrderNo").toString();
                    String cancel = orderMap.get("Cancel").toString();
                    this.updateOcContractCanncel(orderNo, tenantCode);
                }
            }
            boolean deleteFlag = false;
            try {
                deleteFlag = SftpClientUtil.delete(cannceldownloadpath, fileName);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.delete.error.e", (Throwable)e);
                continue;
            }
            if (deleteFlag) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                continue;
            }
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
        }
    }

    private void updateOcContractCanncel(String contractBillcode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("dataState", "-1");
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        this.getInternalRouter().inInvoke("oc.contractEngine.sendContractBack", map);
    }

    private void updateOcContractState(String contractBillcode, String state, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("dataState", state);
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        this.getInternalRouter().inInvoke("oc.contractEngine.sendContractNext", map);
    }

    @Override
    public void acceptOutWhNavision(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String outdownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("outdownloadpath"));
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)outdownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + outdownloadpath));
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        try {
            fileNames = SftpClientUtil.listFileInDir(outdownloadpath);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
            return;
        }
        String xml = "";
        for (String fileName : fileNames) {
            try {
                xml = SftpClientUtil.downloadFile(outdownloadpath, fileName);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                continue;
            }
            if (StringUtils.isBlank((String)xml)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                continue;
            }
            JSONObject jsonObject = null;
            try {
                jsonObject = XmlUtils.xml2Json(xml);
                if (null == jsonObject) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.xml2Json", (Object)"\u89e3\u6790\u51fa\u9519\uff01");
                    return;
                }
            }
            catch (DocumentException e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.xml2Json", (Object)"\u89e3\u6790\u5f02\u5e38\uff01.", (Throwable)e);
                return;
            }
            Object outBlocks = jsonObject.get((Object)"blocks");
            Map outBlocksMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(outBlocks), String.class, Object.class);
            Object outBlock = outBlocksMap.get("block");
            Map outBlockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(outBlock), String.class, Object.class);
            Object inblocks = outBlockMap.get("blocks");
            Object outMembers = outBlockMap.get("members");
            Map outMembersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(outMembers), String.class, Object.class);
            Object orderNo = outMembersMap.get("OrderNo");
            System.out.println(orderNo);
            Map inblocksMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(inblocks), String.class, Object.class);
            Object inBlock = inblocksMap.get("block");
            List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(inBlock), Map.class);
            if (ListUtil.isNotEmpty((Collection)mapList)) {
                for (Map mapStr : mapList) {
                    Object inMembers = mapStr.get("members");
                    Map inMembersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(inMembers), String.class, Object.class);
                    Object itemNo = inMembersMap.get("ItemNo");
                    Object shippedQuantity = inMembersMap.get("ShippedQuantity");
                    this.updateOcContractState(shippedQuantity.toString(), "3", tenantCode);
                }
            } else {
                Map inBlockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(inBlock), String.class, Object.class);
                Object inMembers = inBlockMap.get("members");
                Map inMembersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(inMembers), String.class, Object.class);
                Object itemNo = inMembersMap.get("ItemNo");
                Object shippedQuantity = inMembersMap.get("ShippedQuantity");
                this.updateOcContractState(shippedQuantity.toString(), "3", tenantCode);
            }
            boolean deleteFlag = false;
            try {
                deleteFlag = SftpClientUtil.delete(outdownloadpath, fileName);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.delete.error.e", (Throwable)e);
                continue;
            }
            if (deleteFlag) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                continue;
            }
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
        }
    }

    @Override
    public void acceptSuccessContractNavision(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        String successdownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("successdownloadpath"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)successdownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + successdownloadpath));
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        try {
            fileNames = SftpClientUtil.listFileInDir(successdownloadpath);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
            return;
        }
        String xml = "";
        for (String fileName : fileNames) {
            try {
                xml = SftpClientUtil.downloadFile(successdownloadpath, fileName);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                continue;
            }
            if (StringUtils.isBlank((String)xml)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                continue;
            }
            JSONObject jsonObject = null;
            try {
                jsonObject = XmlUtils.xml2Json(xml);
                if (null == jsonObject) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.xml2Json", (Object)"\u89e3\u6790\u51fa\u9519\uff01");
                    return;
                }
            }
            catch (DocumentException e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.xml2Json", (Object)"\u89e3\u6790\u5f02\u5e38\uff01.", (Throwable)e);
                return;
            }
            Object blocks = jsonObject.get((Object)"blocks");
            Map blocksMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(blocks), String.class, Object.class);
            Object block = blocksMap.get("block");
            List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(block), Map.class);
            if (ListUtil.isNotEmpty((Collection)mapList)) {
                for (Map stringObjectMap : mapList) {
                    Object members = stringObjectMap.get("members");
                    Map membersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                    Object orderNo = membersMap.get("OrderNo");
                    Object PayStatus = membersMap.get("PayStatus");
                    System.out.println(orderNo + "-" + PayStatus);
                    this.updateOcContractState(orderNo.toString(), "4", tenantCode);
                }
            } else {
                Map blockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(block), String.class, Object.class);
                Object members = blockMap.get("members");
                Map membersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                Object orderNo = membersMap.get("OrderNo");
                Object PayStatus = membersMap.get("PayStatus");
                System.out.println(orderNo + "-" + PayStatus);
                this.updateOcContractState(orderNo.toString(), "4", tenantCode);
            }
            boolean deleteFlag = false;
            try {
                deleteFlag = SftpClientUtil.delete(successdownloadpath, fileName);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.delete.error.e", (Throwable)e);
                continue;
            }
            if (deleteFlag) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                continue;
            }
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
        }
    }

    @Override
    public void acceptInvContractNavision(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        String invdownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("invdownloadpath"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)invdownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + invdownloadpath));
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        try {
            fileNames = SftpClientUtil.listFileInDir(invdownloadpath);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
            return;
        }
        String xml = "";
        for (String fileName : fileNames) {
            try {
                xml = SftpClientUtil.downloadFile(invdownloadpath, fileName);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                continue;
            }
            if (StringUtils.isBlank((String)xml)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                continue;
            }
            JSONObject jsonObject = null;
            try {
                jsonObject = XmlUtils.xml2Json(xml);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            String json = JsonUtil.buildNormalBinder().toJson(jsonObject);
            Map mapstr = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
            Object item = mapstr.get("Item");
            Map itemMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(item), String.class, Object.class);
            Object documentNo = itemMap.get("DocumentNo");
            Object PDFUrl = itemMap.get("PDFUrl");
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.PDFUrl", (Object)(documentNo + "=:=" + PDFUrl));
            HashMap<String, String> map = new HashMap<String, String>();
            HashMap mapStr = new HashMap();
            mapStr.put("contractBillcode", documentNo);
            mapStr.put("tenantCode", tenantCode);
            mapStr.put("contractInvoice", PDFUrl);
            map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
            this.getInternalRouter().inInvoke("oc.contract.updateContractInv", map);
            boolean deleteFlag = false;
            try {
                deleteFlag = SftpClientUtil.delete(invdownloadpath, fileName);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.delete.error.e", (Throwable)e);
                continue;
            }
            if (deleteFlag) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                continue;
            }
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
        }
    }

    @Override
    public void acceptGoodsStork(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        String storkdownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("storkdownloadpath"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)storkdownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + storkdownloadpath));
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        try {
            fileNames = SftpClientUtil.listFileInDir(storkdownloadpath);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
            return;
        }
        String xml = "";
        for (String fileName : fileNames) {
            block24: {
                try {
                    xml = SftpClientUtil.downloadFile(storkdownloadpath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                    continue;
                }
                if (StringUtils.isBlank((String)xml)) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                    continue;
                }
                JSONObject jsonObject = null;
                try {
                    jsonObject = XmlUtils.xml2Json(xml);
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
                JSONObject outBlocks = (JSONObject)jsonObject.get((Object)"blocks");
                JSONObject outBlock = (JSONObject)outBlocks.get((Object)"block");
                JSONObject inBlocks = (JSONObject)outBlock.get((Object)"blocks");
                Object inBlock = inBlocks.get((Object)"block");
                List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(inBlock), Map.class);
                HashMap inventoryMap = new HashMap();
                if (ListUtil.isNotEmpty((Collection)mapList)) {
                    for (Map stringObjectMap : mapList) {
                        Object members = stringObjectMap.get("members");
                        Map mapStr = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                        Object itemNo = mapStr.get("ItemNo");
                        Object availableQty = mapStr.get("AvailableQty");
                        inventoryMap.put("skuNo", itemNo);
                        inventoryMap.put("tenantCode", tenantCode);
                        inventoryMap.put("num", availableQty);
                        String flagStr = "";
                        try {
                            flagStr = (String)this.getInternalRouter().inInvoke("rs.sku.updateNum", inventoryMap);
                            if (!StringUtils.isBlank((String)flagStr)) continue;
                            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.updateNum", (Object)JsonUtil.buildNormalBinder().toJson(inventoryMap));
                        }
                        catch (ApiException e) {
                            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.inInvoke", (Object)JsonUtil.buildNormalBinder().toJson(inventoryMap), (Throwable)e);
                        }
                    }
                } else {
                    Map inBlockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(inBlock), String.class, Object.class);
                    Object members = inBlockMap.get("members");
                    Map mapStr = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                    Object itemNo = mapStr.get("ItemNo");
                    Object availableQty = mapStr.get("AvailableQty");
                    inventoryMap.put("skuNo", itemNo);
                    inventoryMap.put("tenantCode", tenantCode);
                    inventoryMap.put("num", availableQty);
                    String flagStr = "";
                    try {
                        flagStr = (String)this.getInternalRouter().inInvoke("rs.sku.updateNum", inventoryMap);
                        if (StringUtils.isBlank((String)flagStr)) {
                            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.updateNum", (Object)JsonUtil.buildNormalBinder().toJson(inventoryMap));
                        }
                        break block24;
                    }
                    catch (ApiException e) {
                        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.inInvoke", (Object)JsonUtil.buildNormalBinder().toJson(inventoryMap), (Throwable)e);
                    }
                    continue;
                }
            }
            boolean deleteFlag = false;
            try {
                deleteFlag = SftpClientUtil.delete(storkdownloadpath, fileName);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.delete.error.e", (Throwable)e);
                continue;
            }
            if (deleteFlag) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                continue;
            }
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
        }
    }

    @Override
    public void acceptGoodsPrice(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        String pricedownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("pricedownloadpath"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)pricedownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + pricedownloadpath));
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        try {
            fileNames = SftpClientUtil.listFileInDir(pricedownloadpath);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
            return;
        }
        String xml = "";
        for (String fileName : fileNames) {
            try {
                xml = SftpClientUtil.downloadFile(pricedownloadpath, fileName);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                continue;
            }
            if (StringUtils.isBlank((String)xml)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                continue;
            }
            JSONObject jsonObject = null;
            try {
                jsonObject = XmlUtils.xml2Json(xml);
            }
            catch (DocumentException e) {
                e.printStackTrace();
            }
            JSONObject blocks = (JSONObject)jsonObject.get((Object)"blocks");
            Object block = blocks.get((Object)"block");
            System.out.println(JsonUtil.buildNormalBinder().toJson(block));
            List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(block), Map.class);
            if (ListUtil.isNotEmpty((Collection)mapList)) {
                for (Map stringObjectMap : mapList) {
                    Object members = stringObjectMap.get("members");
                    Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                    Object price = map.get("Price");
                    Object itemNo = map.get("ItemNo");
                    if (null == price || null == itemNo) {
                        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.members", (Object)JsonUtil.buildNormalBinder().toJson(members));
                        continue;
                    }
                    this.updateGoodsPrice(new BigDecimal(price.toString()), itemNo.toString(), null, null, tenantCode);
                }
                continue;
            }
            Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(block), String.class, Object.class);
            Object members = map.get("members");
            Map membersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
            Object price = membersMap.get("Price");
            Object itemNo = membersMap.get("ItemNo");
            if (null == price || null == itemNo) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.members", (Object)JsonUtil.buildNormalBinder().toJson(members));
                return;
            }
            this.updateGoodsPrice(new BigDecimal(price.toString()), itemNo.toString(), null, null, tenantCode);
        }
    }

    private void updateGoodsPrice(BigDecimal price, String skuNo, String memberCode, String channelCode, String tenantCode) {
        HashMap<String, String> querySkuMap = new HashMap<String, String>();
        querySkuMap.put("skuNo", skuNo);
        querySkuMap.put("memberCode", memberCode);
        querySkuMap.put("channelCode", channelCode);
        querySkuMap.put("tenantCode", tenantCode);
        String rsSkuJson = "";
        try {
            rsSkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.getSkuBySkuNo", querySkuMap);
            if (StringUtils.isBlank((String)rsSkuJson)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.updateGoodsPrice.getSkuBySkuNo", (Object)("\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570:" + querySkuMap));
                return;
            }
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.webshop.OrderServiceImpl.updateGoodsPrice.getSkuBySkuNo.e", "\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570:" + querySkuMap, (Throwable)e);
        }
        RsSku rsSku = (RsSku)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(rsSkuJson, RsSku.class);
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        editSkuDomain.setSkuId(rsSku.getSkuId());
        editSkuDomain.setSkuCode(rsSku.getSkuCode());
        editSkuDomain.setGoodsCode(rsSku.getGoodsCode());
        editSkuDomain.setTenantCode(tenantCode);
        if (price == null) {
            return;
        }
        editSkuDomain.setPricesetNprice(price.setScale(2, 4));
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("editSkuDomain", JsonUtil.buildNormalBinder().toJson(editSkuDomain));
        this.getInternalRouter().inInvoke("rs.sku.updateSkuEditOne", updateMap);
    }

    public UmUserinfo queryShopInfo(String memberCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", memberCode);
        map.put("tenantCode", tenantCode);
        String umUserInfoJson = "";
        try {
            umUserInfoJson = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", map);
            if (StringUtils.isBlank((String)umUserInfoJson)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.queryShopInfo", (Object)("\u67e5\u8be2\u95e8\u5e97\u4e3a\u7a7a\uff01\uff01\uff01map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.queryShopInfo.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map), (Throwable)e);
            return null;
        }
        return JsonUtil.buildNonEmptyBinder().getJsonToObject(umUserInfoJson, UmUserinfo.class);
    }
}

