/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.webshop.utils;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.apache.commons.net.PrintCommandListener;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;

public class FTPListAllFiles {
    private static Logger logger = Logger.getLogger(FTPListAllFiles.class);
    public FTPClient ftp = new FTPClient();
    public ArrayList<String> arFiles = new ArrayList();

    public FTPListAllFiles(boolean isPrintCommmand) {
        if (isPrintCommmand) {
            this.ftp.addProtocolCommandListener((ProtocolCommandListener)new PrintCommandListener(new PrintWriter(System.out)));
        }
    }

    public boolean login(String host, int port, String username, String password) throws IOException {
        this.ftp.connect(host, port);
        if (FTPReply.isPositiveCompletion((int)this.ftp.getReplyCode()) && this.ftp.login(username, password)) {
            this.ftp.setControlEncoding("GBK");
            return true;
        }
        if (this.ftp.isConnected()) {
            this.ftp.disconnect();
        }
        return false;
    }

    public void disConnection() throws IOException {
        if (this.ftp.isConnected()) {
            this.ftp.disconnect();
        }
    }

    public void List(String pathName) throws IOException {
        if (pathName.startsWith("/") && pathName.endsWith("/")) {
            FTPFile[] files;
            this.ftp.changeWorkingDirectory(pathName);
            for (FTPFile file : files = this.ftp.listFiles()) {
                if (file.isFile()) {
                    this.arFiles.add(pathName + file.getName());
                    continue;
                }
                if (!file.isDirectory() || ".".equals(file.getName()) || "..".equals(file.getName())) continue;
                this.List(pathName + file.getName() + "/");
            }
        }
    }

    public void List(String pathName, String ext) throws IOException {
        if (pathName.startsWith("/") && pathName.endsWith("/")) {
            FTPFile[] files;
            this.ftp.changeWorkingDirectory(pathName);
            for (FTPFile file : files = this.ftp.listFiles()) {
                if (file.isFile()) {
                    if (!file.getName().endsWith(ext)) continue;
                    this.arFiles.add(pathName + file.getName());
                    continue;
                }
                if (!file.isDirectory() || ".".equals(file.getName()) || "..".equals(file.getName())) continue;
                this.List(pathName + file.getName() + "/", ext);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        FTPListAllFiles f = new FTPListAllFiles(true);
        if (f.login("192.168.5.180", 6634, "ftproot", "123456")) {
            f.List("/var/exportExcel/", "txt");
        }
        f.disConnection();
        for (String arFile : f.arFiles) {
            logger.info((Object)arFile);
        }
    }
}

