/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.webshop.utils;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class SftpUtil
implements AutoCloseable {
    private Session session = null;
    private ChannelSftp channel = null;

    public void connectServer(String serverIP, int port, String userName, String password) throws SocketException, IOException, JSchException {
        JSch jsch = new JSch();
        this.session = jsch.getSession(userName, serverIP, port);
        this.session.setPassword(password);
        Properties config = new Properties();
        config.put("StrictHostKeyChecking", "no");
        this.session.setConfig(config);
        this.session.connect();
        this.channel = (ChannelSftp)this.session.openChannel("sftp");
        this.channel.connect();
    }

    @Override
    public void close() {
        if (this.channel != null) {
            this.channel.disconnect();
        }
        if (this.session != null) {
            this.session.disconnect();
        }
    }

    public List<ChannelSftp.LsEntry> getDirList(String path) throws SftpException {
        ArrayList<ChannelSftp.LsEntry> list = new ArrayList<ChannelSftp.LsEntry>();
        if (this.channel != null) {
            Vector vv = this.channel.ls(path);
            if (vv == null && vv.size() == 0) {
                return list;
            }
            Object[] aa = vv.toArray();
            for (int i = 0; i < aa.length; ++i) {
                ChannelSftp.LsEntry temp = (ChannelSftp.LsEntry)aa[i];
                list.add(temp);
            }
        }
        return list;
    }

    public void downloadFile(String remotePathFile, String localPathFile) throws SftpException, IOException {
        try (FileOutputStream os = new FileOutputStream(new File(localPathFile));){
            if (this.channel == null) {
                throw new IOException("sftp server not login");
            }
            this.channel.get(remotePathFile, (OutputStream)os);
        }
    }

    public void uploadFile(String remoteFile, String localFile) throws SftpException, IOException {
        try (FileInputStream in = new FileInputStream(new File(localFile));){
            if (this.channel == null) {
                throw new IOException("sftp server not login");
            }
            this.channel.put((InputStream)in, remoteFile);
        }
    }
}

