/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.webshop.service.navision.impl;

import com.yqbsoft.laser.service.adapter.webshop.dao.DelayedDiscountRealisedMapper;
import com.yqbsoft.laser.service.adapter.webshop.dao.DelayedDiscountRemainingMapper;
import com.yqbsoft.laser.service.adapter.webshop.domain.DisChannel;
import com.yqbsoft.laser.service.adapter.webshop.domain.DisDpriceConfDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.DisDpriceReDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.EditSkuDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.GoodsBean;
import com.yqbsoft.laser.service.adapter.webshop.domain.OcContractDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.OcContractReDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.OrgEmployee;
import com.yqbsoft.laser.service.adapter.webshop.domain.RsSku;
import com.yqbsoft.laser.service.adapter.webshop.domain.RsSkuDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.UmUserinfo;
import com.yqbsoft.laser.service.adapter.webshop.domain.WhOpstoreDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.WhOpstoreGoodsDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.WhOpstoreSkuDomain;
import com.yqbsoft.laser.service.adapter.webshop.domain.WhWarehouse;
import com.yqbsoft.laser.service.adapter.webshop.model.DelayedDiscountRealised;
import com.yqbsoft.laser.service.adapter.webshop.model.DelayedDiscountRemaining;
import com.yqbsoft.laser.service.adapter.webshop.model.DisDprice;
import com.yqbsoft.laser.service.adapter.webshop.model.DisDpriceConf;
import com.yqbsoft.laser.service.adapter.webshop.service.navision.OrderService;
import com.yqbsoft.laser.service.adapter.webshop.utils.JsonUtil;
import com.yqbsoft.laser.service.adapter.webshop.utils.SftpClientUtil;
import com.yqbsoft.laser.service.adapter.webshop.utils.XmlUtils;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.dom4j.DocumentException;

public class OrderServiceImpl
extends BaseServiceImpl
implements OrderService {
    private static final String SYS_CODE = "service.adapter.webshop.OrderServiceImpl";
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddhhmmss");
    private static String xmlName = "";
    private static String tenantCode = "2020021700000001";
    private DelayedDiscountRealisedMapper delayedDiscountRealisedMapper;
    private DelayedDiscountRemainingMapper delayedDiscountRemainingMapper;

    public void setDelayedDiscountRealisedMapper(DelayedDiscountRealisedMapper delayedDiscountRealisedMapper) {
        this.delayedDiscountRealisedMapper = delayedDiscountRealisedMapper;
    }

    public void setDelayedDiscountRemainingMapper(DelayedDiscountRemainingMapper delayedDiscountRemainingMapper) {
        this.delayedDiscountRemainingMapper = delayedDiscountRemainingMapper;
    }

    @Override
    public String sendOcContractToNavision(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision", (Object)ocContractDomain);
            return "false";
        }
        UmUserinfo umUserinfo = this.queryShopInfo(ocContractDomain.getMemberBcode(), ocContractDomain.getTenantCode());
        if (umUserinfo == null) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.umUserinfo", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01MemberCode:" + ocContractDomain.getMemberCcode() + "-" + ocContractDomain.getContractBillcode()));
            return "false";
        }
        String companyShortname = umUserinfo.getCompanyShortname();
        if (StringUtils.isBlank((String)companyShortname)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.umUserinfo", (Object)(companyShortname + "=:=" + ocContractDomain.getContractBillcode()));
            return null;
        }
        String endPath = this.covertPath(companyShortname);
        if (StringUtils.isBlank((String)endPath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.endPath", (Object)(endPath + "=:=" + companyShortname));
            return "false";
        }
        OrgEmployee orgEmployee = this.queryOrgEmployeeInfo(umUserinfo.getEmployeeCode(), umUserinfo.getTenantCode());
        if (orgEmployee == null) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.queryOrgEmployeeInfo", (Object)("\u67e5\u8be2\u4e1a\u52a1\u5458\u4e3a\u7a7a\uff01\uff01\uff01MemberCode:" + umUserinfo.getEmployeeCode() + "-" + umUserinfo.getTenantCode()));
            return "false";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("MMddYYYY");
        HashMap<String, Integer> queryOcMap = new HashMap<String, Integer>();
        queryOcMap.put("contractId", ocContractDomain.getContractId());
        String contractJson = (String)this.getInternalRouter().inInvoke("oc.contract.getContract", queryOcMap);
        if (StringUtils.isBlank((String)contractJson)) {
            this.logger.error("service.adapter.webshop.OrderServiceImplsendOcContractToNavision.queryOcMap", (Object)(ocContractDomain.getContractId() + "=:=" + contractJson));
            return null;
        }
        OcContractReDomain ocContractReDomain = (OcContractReDomain)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(contractJson, OcContractReDomain.class);
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\"?>");
        builder.append("<xml contentnamespace=\"NAV\" xmlns=\"http://www.to-increase.com/data/blocks\">");
        builder.append("<blocks>");
        builder.append("<block id=\"EDISalesHeader\">");
        builder.append("<members>");
        builder.append("<member id=\"No\">").append(ocContractDomain.getContractBillcode()).append("</member>");
        builder.append("<member id=\"CustomerNo\">").append(umUserinfo.getUserinfoOcode()).append("</member>");
        builder.append("<member id=\"ShipToCode\">").append(umUserinfo.getUserinfoMap()).append("</member>");
        builder.append("<member id=\"OrderDate\">").append(sdf.format(ocContractReDomain.getGmtCreate())).append("</member>");
        builder.append("<member id=\"PaymentID\">").append("20191125110929").append("</member>");
        builder.append("<member id=\"PaymentMethod\">").append(1).append("</member>");
        builder.append("<member id=\"PaymentTermField\"/>");
        builder.append("<member id=\"SalespersonCode\">").append(orgEmployee.getEmployeeOcode()).append("</member>");
        builder.append("<member id=\"NetAmount\">").append(ocContractDomain.getContractMoney()).append("</member>");
        builder.append("<member id=\"DelayedDiscountAmount\">").append(ocContractDomain.getContractInmoney()).append("</member>");
        builder.append("</members>");
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        builder.append("<blocks>");
        int lineNo = 1;
        for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
            builder.append("<block id=\"EDISalesLine\" relation=\"EDI Sales Line\">");
            builder.append("<members>");
            builder.append("<member id=\"LineNo\">").append(lineNo).append("</member>");
            builder.append("<member id=\"No\">").append(ocContractGoodsDomain.getSkuNo()).append("</member>");
            builder.append("<member id=\"Quantity\">").append(ocContractGoodsDomain.getGoodsNum()).append("</member>");
            builder.append("<member id=\"DiscountType\">").append("PROMDISC").append("</member>");
            builder.append("<member id=\"DiscountAmount\">").append(ocContractGoodsDomain.getContractGoodsMoney()).append("</member>");
            builder.append("</members>");
            builder.append("</block>");
            ++lineNo;
        }
        builder.append("</blocks>");
        builder.append("</block>");
        builder.append("</blocks>");
        builder.append("</xml>");
        String xml = builder.toString();
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.xml", (Object)xml);
        xmlName = "SO_ORDER_" + ocContractDomain.getContractBillcode() + ".XML";
        String uploadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("uploadpath"));
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("password"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)uploadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.SFTP.null", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + uploadpath));
            return null;
        }
        String[] split = uploadpath.split(";");
        if (split.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.uploadCancelpath", (Object)uploadpath);
            return null;
        }
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + uploadpath));
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.SftpClientUtil.connect.error", (Object)connect);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return null;
        }
        boolean uploadFlag = false;
        for (String path : split) {
            ByteArrayInputStream input = new ByteArrayInputStream(builder.toString().getBytes());
            try {
                uploadFlag = SftpClientUtil.uploadFile(input, path + endPath + "/" + xmlName);
                if (!uploadFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.upload.error", (Object)(xmlName + "=:=" + path));
                    return null;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.upload.success", (Object)(xmlName + "=:=" + path));
            }
            catch (IOException e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.upload.error.e", (Object)(xmlName + "=:=" + path), (Throwable)e);
                return null;
            }
        }
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendOcContractToNavision.success", (Object)"success");
        SftpClientUtil.disconnect();
        return "success";
    }

    private String covertPath(String companyShortname) {
        if ("RC China".equals(companyShortname)) {
            return "Shanghai";
        }
        if ("RC Beijing".equals(companyShortname)) {
            return "Beijing";
        }
        if ("RC Chengdu".equals(companyShortname)) {
            return "Chengdu";
        }
        if ("RC Guangzhou".equals(companyShortname)) {
            return "Guangzhou";
        }
        return null;
    }

    @Override
    public String sendCanncelContractToNavision(OcContractDomain ocContractDomain) throws ApiException {
        if (null == ocContractDomain) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision", (Object)ocContractDomain);
            return "false";
        }
        UmUserinfo umUserinfo = this.queryShopInfo(ocContractDomain.getMemberBcode(), ocContractDomain.getTenantCode());
        if (umUserinfo == null) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.umUserinfo", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01MemberCode:" + ocContractDomain.getMemberCcode() + "-" + ocContractDomain.getContractBillcode()));
            return "false";
        }
        String companyShortname = umUserinfo.getCompanyShortname();
        if (StringUtils.isBlank((String)companyShortname)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.umUserinfo", (Object)(companyShortname + "=:=" + ocContractDomain.getContractBillcode()));
            return null;
        }
        String endPath = this.covertPath(companyShortname);
        if (StringUtils.isBlank((String)endPath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.endPath", (Object)(endPath + "=:=" + companyShortname));
            return "false";
        }
        StringBuilder builder = new StringBuilder();
        builder.append("<?xml version=\"1.0\"?>");
        builder.append("<xml contentnamespace=\"NAV\" xmlns=\"http://www.to-increase.com/data/blocks\">");
        builder.append("<blocks>");
        builder.append("<block id=\"EDISalesHeader\">");
        builder.append("<members>");
        builder.append("<member id=\"OrderNo\">").append(ocContractDomain.getContractBillcode()).append("</member>");
        builder.append("<member id=\"Cancel\">").append(1).append("</member>");
        builder.append("</members>");
        builder.append("</block>");
        builder.append("</blocks>");
        builder.append("</xml>");
        String xml = builder.toString();
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.xml", (Object)xml);
        xmlName = "SO_CANCEL" + sdf.format(new Date()) + ".XML";
        String uploadCancelpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("uploadCancelpath"));
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)ocContractDomain.getTenantCode().concat("-").concat("SFTP").concat("-").concat("password"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)uploadCancelpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + uploadCancelpath));
            return null;
        }
        String[] split = uploadCancelpath.split(";");
        if (split.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.uploadCancelpath", (Object)uploadCancelpath);
            return null;
        }
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + uploadCancelpath));
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.SftpClientUtil.connect.error", (Object)connect);
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return null;
        }
        boolean uploadFlag = false;
        for (String path : split) {
            ByteArrayInputStream input = new ByteArrayInputStream(builder.toString().getBytes());
            try {
                uploadFlag = SftpClientUtil.uploadFile(input, path + endPath + "/" + xmlName);
                if (!uploadFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.upload.error", (Object)(xmlName + "=:=" + path));
                    return null;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.upload.success", (Object)(xmlName + "=:=" + path));
            }
            catch (IOException e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.upload.error.e", (Object)(xmlName + "=:=" + path), (Throwable)e);
                return null;
            }
        }
        this.logger.error("service.adapter.webshop.OrderServiceImpl.sendCanncelContractToNavision.success", (Object)"success");
        SftpClientUtil.disconnect();
        return "success";
    }

    @Override
    public void acceptContractCanncelNavision(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.tenantCode", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String cannceldownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("cannceldownloadpath"));
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)cannceldownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + cannceldownloadpath));
            return;
        }
        String[] canncelPath = cannceldownloadpath.split(";");
        if (canncelPath.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.split", (Object)cannceldownloadpath);
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        for (String downPath : canncelPath) {
            try {
                fileNames = SftpClientUtil.listFileInDir(downPath);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
                return;
            }
            String xml = "";
            for (String fileName : fileNames) {
                try {
                    xml = SftpClientUtil.downloadFile(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                    continue;
                }
                if (StringUtils.isBlank((String)xml)) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                    continue;
                }
                if (xml.startsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                } else if (xml.endsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                }
                JSONObject jsonObject = null;
                try {
                    jsonObject = XmlUtils.xml2Json(xml);
                    if (null == jsonObject) {
                        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.xml2Json", (Object)"\u89e3\u6790\u51fa\u9519\uff01");
                        return;
                    }
                }
                catch (DocumentException e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.xml2Json", (Object)"\u89e3\u6790\u5f02\u5e38\uff01.", (Throwable)e);
                    return;
                }
                Object bloks = jsonObject.get((Object)"blocks");
                Map blockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(bloks), String.class, Object.class);
                Object block = blockMap.get("block");
                List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(block), Map.class);
                if (ListUtil.isEmpty((Collection)mapList)) {
                    Map membersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(block), String.class, Object.class);
                    Object members = membersMap.get("members");
                    Map contentMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                    Object cancel = contentMap.get("Cancel");
                    String orderNo = contentMap.get("OrderNo").toString();
                    this.updateOcContractCanncel(orderNo, tenantCode);
                } else {
                    for (Map stringObjectMap : mapList) {
                        Map membersMapStr = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(stringObjectMap), String.class, Object.class);
                        Object members = membersMapStr.get("members");
                        Map orderMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                        if (null == orderMap.get("OrderNo") || null == orderMap.get("Cancel")) {
                            return;
                        }
                        String orderNo = orderMap.get("OrderNo").toString();
                        String cancel = orderMap.get("Cancel").toString();
                        this.updateOcContractCanncel(orderNo, tenantCode);
                    }
                }
                boolean deleteFlag = false;
                try {
                    deleteFlag = SftpClientUtil.delete(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.delete.error.e", (Throwable)e);
                    continue;
                }
                if (deleteFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                    continue;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptContractCanncelNavision.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        SftpClientUtil.disconnect();
    }

    private void updateOcContractCanncel(String contractBillcode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("dataState", "-1");
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        this.getInternalRouter().inInvoke("oc.contractEngine.sendContractBack", map);
    }

    private void updateOcContractState(String contractBillcode, String state, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("dataState", state);
        map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        this.getInternalRouter().inInvoke("oc.contractEngine.sendContractNext", map);
    }

    @Override
    public void acceptOutWhNavision(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String outdownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("outdownloadpath"));
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)outdownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + outdownloadpath));
            return;
        }
        String[] outdownPath = outdownloadpath.split(";");
        if (outdownPath.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.split", (Object)outdownloadpath);
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        for (String downPath : outdownPath) {
            try {
                fileNames = SftpClientUtil.listFileInDir(downPath);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
                return;
            }
            String xml = "";
            for (String fileName : fileNames) {
                try {
                    xml = SftpClientUtil.downloadFile(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                    continue;
                }
                if (StringUtils.isBlank((String)xml)) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                    continue;
                }
                if (xml.startsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                } else if (xml.endsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                }
                JSONObject jsonObject = null;
                try {
                    jsonObject = XmlUtils.xml2Json(xml);
                    if (null == jsonObject) {
                        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.xml2Json", (Object)"\u89e3\u6790\u51fa\u9519\uff01");
                        return;
                    }
                }
                catch (DocumentException e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.xml2Json", (Object)"\u89e3\u6790\u5f02\u5e38\uff01.", (Throwable)e);
                    return;
                }
                Object outBlocks = jsonObject.get((Object)"blocks");
                Map outBlocksMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(outBlocks), String.class, Object.class);
                Object outBlock = outBlocksMap.get("block");
                Map outBlockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(outBlock), String.class, Object.class);
                Object inblocks = outBlockMap.get("blocks");
                Object outMembers = outBlockMap.get("members");
                Map outMembersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(outMembers), String.class, Object.class);
                Object orderNo = outMembersMap.get("OrderNo");
                System.out.println(orderNo);
                Map inblocksMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(inblocks), String.class, Object.class);
                Object inBlock = inblocksMap.get("block");
                List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(inBlock), Map.class);
                if (ListUtil.isNotEmpty((Collection)mapList)) {
                    for (Map mapStr : mapList) {
                        Object inMembers = mapStr.get("members");
                        Map inMembersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(inMembers), String.class, Object.class);
                        Object itemNo = inMembersMap.get("ItemNo");
                        Object shippedQuantity = inMembersMap.get("ShippedQuantity");
                        this.updateOcContractState(shippedQuantity.toString(), "3", tenantCode);
                    }
                } else {
                    Map inBlockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(inBlock), String.class, Object.class);
                    Object inMembers = inBlockMap.get("members");
                    Map inMembersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(inMembers), String.class, Object.class);
                    Object itemNo = inMembersMap.get("ItemNo");
                    Object shippedQuantity = inMembersMap.get("ShippedQuantity");
                    this.updateOcContractState(shippedQuantity.toString(), "3", tenantCode);
                }
                boolean deleteFlag = false;
                try {
                    deleteFlag = SftpClientUtil.delete(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.delete.error.e", (Throwable)e);
                    continue;
                }
                if (deleteFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                    continue;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptOutWhNavision.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        SftpClientUtil.disconnect();
    }

    @Override
    public void acceptSuccessContractNavision(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        String successdownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("successdownloadpath"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)successdownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + successdownloadpath));
            return;
        }
        String[] successdownPath = successdownloadpath.split(";");
        if (successdownPath.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.split", (Object)successdownloadpath);
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        for (String downPath : successdownPath) {
            try {
                fileNames = SftpClientUtil.listFileInDir(downPath);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
                return;
            }
            String xml = "";
            for (String fileName : fileNames) {
                try {
                    xml = SftpClientUtil.downloadFile(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                    continue;
                }
                if (StringUtils.isBlank((String)xml)) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                    continue;
                }
                if (xml.startsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                } else if (xml.endsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                }
                JSONObject jsonObject = null;
                try {
                    jsonObject = XmlUtils.xml2Json(xml);
                    if (null == jsonObject) {
                        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.xml2Json", (Object)"\u89e3\u6790\u51fa\u9519\uff01");
                        return;
                    }
                }
                catch (DocumentException e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.xml2Json", (Object)"\u89e3\u6790\u5f02\u5e38\uff01.", (Throwable)e);
                    return;
                }
                Object blocks = jsonObject.get((Object)"blocks");
                Map blocksMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(blocks), String.class, Object.class);
                Object block = blocksMap.get("block");
                List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(block), Map.class);
                if (ListUtil.isNotEmpty((Collection)mapList)) {
                    for (Map stringObjectMap : mapList) {
                        Object members = stringObjectMap.get("members");
                        Map membersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                        Object orderNo = membersMap.get("OrderNo");
                        Object PayStatus = membersMap.get("PayStatus");
                        System.out.println(orderNo + "-" + PayStatus);
                        this.updateOcContractState(orderNo.toString(), "4", tenantCode);
                    }
                } else {
                    Map blockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(block), String.class, Object.class);
                    Object members = blockMap.get("members");
                    Map membersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                    Object orderNo = membersMap.get("OrderNo");
                    Object PayStatus = membersMap.get("PayStatus");
                    System.out.println(orderNo + "-" + PayStatus);
                    this.updateOcContractState(orderNo.toString(), "4", tenantCode);
                }
                boolean deleteFlag = false;
                try {
                    deleteFlag = SftpClientUtil.delete(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.delete.error.e", (Throwable)e);
                    continue;
                }
                if (deleteFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                    continue;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        SftpClientUtil.disconnect();
    }

    @Override
    public void acceptInvContractNavision(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        String invdownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("invdownloadpath"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)invdownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + invdownloadpath));
            return;
        }
        String[] invdownPath = invdownloadpath.split(";");
        if (invdownPath.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.split", (Object)invdownloadpath);
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        for (String downPath : invdownPath) {
            try {
                fileNames = SftpClientUtil.listFileInDir(downPath);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
                return;
            }
            String xml = "";
            for (String fileName : fileNames) {
                try {
                    xml = SftpClientUtil.downloadFile(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                    continue;
                }
                if (StringUtils.isBlank((String)xml)) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                    continue;
                }
                if (xml.startsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                } else if (xml.endsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                }
                JSONObject jsonObject = null;
                try {
                    jsonObject = XmlUtils.xml2Json(xml);
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
                String json = JsonUtil.buildNormalBinder().toJson(jsonObject);
                Map mapstr = (Map)JsonUtil.buildNormalBinder().getJsonToMap(json, String.class, Object.class);
                Object item = mapstr.get("Item");
                Map itemMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(item), String.class, Object.class);
                Object documentNo = itemMap.get("DocumentNo");
                Object PDFUrl = itemMap.get("PDFUrl");
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.PDFUrl", (Object)(documentNo + "=:=" + PDFUrl));
                HashMap<String, String> map = new HashMap<String, String>();
                HashMap mapStr = new HashMap();
                mapStr.put("contractBillcode", documentNo);
                mapStr.put("tenantCode", tenantCode);
                mapStr.put("contractInvoice", PDFUrl);
                map.put("map", JsonUtil.buildNormalBinder().toJson(mapStr));
                this.getInternalRouter().inInvoke("oc.contract.updateContractInv", map);
                boolean deleteFlag = false;
                try {
                    deleteFlag = SftpClientUtil.delete(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.delete.error.e", (Throwable)e);
                    continue;
                }
                if (deleteFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                    continue;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptInvContractNavision.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        SftpClientUtil.disconnect();
    }

    @Override
    public void acceptGoodsStork(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        String storkdownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("storkdownloadpath"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)storkdownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + storkdownloadpath));
            return;
        }
        String[] path = storkdownloadpath.split(";");
        if (path.length == 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SFTP.split", (Object)storkdownloadpath);
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        String wareHouse = "";
        for (String downPath : path) {
            wareHouse = this.covertWare(downPath);
            if (StringUtils.isBlank((String)wareHouse)) continue;
            try {
                fileNames = SftpClientUtil.listFileInDir(downPath);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
                return;
            }
            String xml = "";
            boolean stopFlag = false;
            for (String fileName : fileNames) {
                try {
                    xml = SftpClientUtil.downloadFile(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                    continue;
                }
                if (StringUtils.isBlank((String)xml)) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                    continue;
                }
                if (xml.startsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                } else if (xml.endsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                }
                JSONObject jsonObject = null;
                try {
                    jsonObject = XmlUtils.xml2Json(xml);
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
                JSONObject outBlocks = (JSONObject)jsonObject.get((Object)"blocks");
                JSONObject outBlock = (JSONObject)outBlocks.get((Object)"block");
                JSONObject inBlocks = (JSONObject)outBlock.get((Object)"blocks");
                Object inBlock = inBlocks.get((Object)"block");
                List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(inBlock), Map.class);
                HashMap inventoryMap = new HashMap();
                if (ListUtil.isNotEmpty((Collection)mapList)) {
                    for (Map stringObjectMap : mapList) {
                        String availableQty;
                        Object members = stringObjectMap.get("members");
                        Map mapStr = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                        String itemNo = null == mapStr.get("ItemNo") ? "" : mapStr.get("ItemNo").toString();
                        String string = availableQty = null == mapStr.get("AvailableQty") ? "" : mapStr.get("AvailableQty").toString();
                        if (StringUtils.isBlank((String)itemNo) || StringUtils.isBlank((String)availableQty)) {
                            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.null", (Object)(itemNo + "=:=" + availableQty));
                            continue;
                        }
                        this.saveWareHouse(wareHouse, itemNo, availableQty, tenantCode);
                    }
                } else {
                    String availableQty;
                    Map inBlockMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(inBlock), String.class, Object.class);
                    Object members = inBlockMap.get("members");
                    Map mapStr = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                    String itemNo = null == mapStr.get("ItemNo") ? "" : mapStr.get("ItemNo").toString();
                    String string = availableQty = null == mapStr.get("AvailableQty") ? "" : mapStr.get("AvailableQty").toString();
                    if (StringUtils.isBlank((String)itemNo) || StringUtils.isBlank((String)availableQty)) {
                        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.null", (Object)(itemNo + "=:=" + availableQty));
                        continue;
                    }
                    this.saveWareHouse(wareHouse, itemNo, availableQty, tenantCode);
                }
                if (stopFlag) continue;
                boolean deleteFlag = false;
                try {
                    deleteFlag = SftpClientUtil.delete(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.delete.error.e", (Throwable)e);
                    continue;
                }
                if (deleteFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                    continue;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsStork.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        SftpClientUtil.disconnect();
    }

    private String covertWare(String downPath) {
        if (downPath.contains("Shanghai")) {
            return "NW";
        }
        if (downPath.contains("Shenyang")) {
            return "SY";
        }
        if (downPath.contains("Guangzhou")) {
            return "GZ-MAIN";
        }
        if (downPath.contains("Chengdu")) {
            return "CD-MAIN";
        }
        if (downPath.contains("Beijing")) {
            return "BJ-MAIN";
        }
        this.logger.error("service.adapter.webshop.OrderServiceImplacceptGoodsStork.downPath", (Object)downPath);
        return "";
    }

    private void saveWareHouse(String wareHouseCode, String itemNo, String availableQty, String tenantCode) {
        WhWarehouse whWarehouse = this.queryWhWarehouse(wareHouseCode, tenantCode);
        if (null == wareHouseCode) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.saveWareHouse.queryWhWarehouse.null", (Object)wareHouseCode);
            return;
        }
        WhOpstoreDomain whOpstoreDomain = this.creatWhOpstoreParam(itemNo, availableQty, whWarehouse, tenantCode);
        if (null == whOpstoreDomain) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.updateGoodsStockNum.creatWhOpstoreParam", (Object)"whOpstoreDomain is null");
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("whOpstoreDomain", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNonDefaultBinder().toJson((Object)whOpstoreDomain));
        try {
            this.getInternalRouter().inInvoke("wh.whStoreGoodsBase.sendSaveOpstore", map);
        }
        catch (ApiException e) {
            throw new ApiException("service.adapter.webshop.OrderServiceImpl.updateGoodsStockNum.sendSaveOpstore", "\u66f4\u65b0\u5931\u8d25\uff01\uff01\uff01", (Throwable)e);
        }
    }

    private WhOpstoreDomain creatWhOpstoreParam(String itemNo, String availableQty, WhWarehouse whWarehouse, String tenantCode) {
        WhOpstoreDomain whOpstoreDomain = new WhOpstoreDomain();
        whOpstoreDomain.setGoodsNum(new BigDecimal(availableQty));
        whOpstoreDomain.setGoodsWeight(BigDecimal.ONE);
        whOpstoreDomain.setMemberCode(whWarehouse.getMemberCode());
        whOpstoreDomain.setMemberName(whWarehouse.getMemberName());
        whOpstoreDomain.setMemberCcode(whWarehouse.getMemberCode());
        whOpstoreDomain.setMemberCname(whWarehouse.getMemberName());
        whOpstoreDomain.setStoreGoodsType("00");
        whOpstoreDomain.setWarehouseCode(whWarehouse.getWarehouseCode());
        whOpstoreDomain.setWarehouseName(whWarehouse.getWarehouseName());
        whOpstoreDomain.setTenantCode(tenantCode);
        whOpstoreDomain.setWhOpstoreGoodsDomainList(this.creatWhOpstoreGoodsParam(whWarehouse, itemNo, availableQty, whOpstoreDomain));
        return whOpstoreDomain;
    }

    private List<WhOpstoreGoodsDomain> creatWhOpstoreGoodsParam(WhWarehouse whWarehouse, String itemNo, String availableQty, WhOpstoreDomain whOpstoreDomain) {
        ArrayList<WhOpstoreGoodsDomain> whOpstoreGoodsDomainList = new ArrayList<WhOpstoreGoodsDomain>();
        WhOpstoreGoodsDomain whOpstoreGoodsDomain = this.saveWhOpstoreGoods(itemNo, availableQty, whWarehouse, whOpstoreDomain);
        if (null == whOpstoreGoodsDomain) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.creatWhOpstoreGoodsParam.saveWhOpstoreGoods", (Object)"whOpstoreGoodsDomain is null");
            return null;
        }
        whOpstoreGoodsDomainList.add(whOpstoreGoodsDomain);
        return whOpstoreGoodsDomainList;
    }

    private WhOpstoreGoodsDomain saveWhOpstoreGoods(String itemNo, String availableQty, WhWarehouse whWarehouse, WhOpstoreDomain whOpstoreDomain) {
        String apiCode = "rs.resourceGoods.getResourceBySkuNoAndMemberCode";
        GoodsBean rsGoodsBean = (GoodsBean)this.getForObject(apiCode, GoodsBean.class, this.getQueryParamMap("skuNo,memberCode,tenantCode", new Object[]{itemNo, whWarehouse.getMemberCode(), tenantCode}));
        if (null == rsGoodsBean) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.sendSgOccontractPool.rsGoodsBean", (Object)(itemNo + "==:" + "rsGoodsBean is null "));
            return null;
        }
        return this.creatWhOpParam(rsGoodsBean, availableQty, itemNo, whWarehouse, whOpstoreDomain);
    }

    private WhOpstoreGoodsDomain creatWhOpParam(GoodsBean rsGoodsBean, String availableQty, String itemNo, WhWarehouse whWarehouse, WhOpstoreDomain whOpstoreDomain) {
        WhOpstoreGoodsDomain whOpstoreGoodsDomain = new WhOpstoreGoodsDomain();
        String memberCode = SupDisUtil.getMap((String)"tmtenant-user-code", (String)tenantCode);
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreGoodsDomain, (Object)rsGoodsBean.getRsResourceGoods());
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.whStoreGoodsDomain.rsResourceGoods.e", (Throwable)e);
            whOpstoreDomain.setOpstoreRemark("rsResourceGoods.copy\u5f02\u5e38");
            return null;
        }
        RsSkuDomain rsSku = rsGoodsBean.getRsSku();
        whOpstoreGoodsDomain.setGoodsCode(null);
        whOpstoreGoodsDomain.setMemberCcode(null);
        whOpstoreGoodsDomain.setMemberCname(null);
        whOpstoreGoodsDomain.setSpuCode(null);
        whOpstoreGoodsDomain.setChannelCode(null);
        whOpstoreGoodsDomain.setChannelName(null);
        whOpstoreGoodsDomain.setMemberCode(memberCode);
        whOpstoreGoodsDomain.setMemberName("\u5e73\u53f0");
        whOpstoreGoodsDomain.setGoodsNum(new BigDecimal(availableQty));
        whOpstoreGoodsDomain.setGoodsSupplynum(whOpstoreGoodsDomain.getGoodsNum());
        if (rsSku.getGoodsOneweight() == null) {
            rsSku.setGoodsOneweight(BigDecimal.ONE);
        }
        whOpstoreGoodsDomain.setGoodsOneweight(rsSku.getGoodsOneweight());
        BigDecimal multiply = whOpstoreGoodsDomain.getGoodsNum().multiply(rsSku.getGoodsOneweight());
        whOpstoreGoodsDomain.setGoodsWeight(multiply);
        whOpstoreGoodsDomain.setGoodsSupplyweight(multiply);
        whOpstoreGoodsDomain.setPricesetPurrice(rsSku.getPricesetAsprice());
        whOpstoreGoodsDomain.setPartsnameWeightunit(rsSku.getPartsnameWeightunit());
        whOpstoreGoodsDomain.setGoodsEocode(itemNo);
        whOpstoreGoodsDomain.setMemberCode(memberCode);
        whOpstoreGoodsDomain.setMemberName(memberCode);
        whOpstoreGoodsDomain.setGoodsMinnum(new BigDecimal(1));
        ArrayList<WhOpstoreSkuDomain> whOpstoreSkuDomainList = new ArrayList<WhOpstoreSkuDomain>();
        WhOpstoreSkuDomain whOpstoreSkuDomain = new WhOpstoreSkuDomain();
        whOpstoreSkuDomainList.add(whOpstoreSkuDomain);
        whOpstoreGoodsDomain.setWhOpstoreSkuDomainList(whOpstoreSkuDomainList);
        try {
            BeanUtils.copyAllPropertys((Object)whOpstoreSkuDomain, (Object)rsSku);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.whStoreSkuDomain.rsSku.e", (Throwable)e);
            whOpstoreDomain.setOpstoreRemark("rsSku.copy\u5f02\u5e38");
            return null;
        }
        whOpstoreSkuDomain.setGoodsNum(whOpstoreGoodsDomain.getGoodsNum());
        whOpstoreSkuDomain.setGoodsSupplynum(whOpstoreGoodsDomain.getGoodsNum());
        whOpstoreSkuDomain.setGoodsOneweight(whOpstoreGoodsDomain.getGoodsOneweight());
        whOpstoreSkuDomain.setGoodsWeight(whOpstoreGoodsDomain.getGoodsWeight());
        whOpstoreSkuDomain.setGoodsSupplyweight(whOpstoreGoodsDomain.getGoodsSupplyweight());
        whOpstoreSkuDomain.setGoodsMinnum(BigDecimal.ONE);
        whOpstoreSkuDomain.setPricesetPurrice(rsSku.getPricesetAsprice());
        whOpstoreSkuDomain.setPartsnameWeightunit(rsSku.getPartsnameWeightunit());
        whOpstoreSkuDomain.setSkuEocode(itemNo);
        whOpstoreSkuDomain.setGoodsEocode(itemNo);
        whOpstoreSkuDomain.setMemberCode(memberCode);
        whOpstoreSkuDomain.setMemberName("\u5e73\u53f0");
        whOpstoreSkuDomain.setMemberCcode(whWarehouse.getMemberCode());
        whOpstoreSkuDomain.setMemberCname(whWarehouse.getMemberName());
        whOpstoreSkuDomain.setWarehouseCode(whWarehouse.getWarehouseCode());
        whOpstoreSkuDomain.setWarehouseName(whWarehouse.getWarehouseName());
        return whOpstoreGoodsDomain;
    }

    private WhWarehouse queryWhWarehouse(String warehouseCode, String tenantCode) {
        if (StringUtils.isBlank((String)warehouseCode) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.queryWhWarehouse.null", (Object)(warehouseCode + "=:=" + tenantCode));
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> queryWhWarehouseMap = new HashMap<String, String>();
        queryWhWarehouseMap.put("warehouseCode", warehouseCode);
        queryWhWarehouseMap.put("tenantCode", tenantCode);
        map.put("map", JsonUtil.buildNormalBinder().toJson(queryWhWarehouseMap));
        String queryWareHouseJson = "";
        try {
            queryWareHouseJson = (String)this.getInternalRouter().inInvoke("wh.warehouse.getWarehouseByCode", map);
            if (StringUtils.isBlank((String)queryWareHouseJson)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.queryWhWarehouse.", (Object)("\u83b7\u53d6\u95e8\u5e97\u5bf9\u5e94\u4ed3\u5e93\u4e3a\u7a7a\uff01\uff01\uff01map:" + queryWhWarehouseMap));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.queryWhWarehouse.e", (Object)("\u83b7\u53d6\u95e8\u5e97\u5bf9\u5e94\u4ed3\u5e93\u5f02\u5e38\uff01\uff01\uff01map:" + queryWhWarehouseMap), (Throwable)e);
            return null;
        }
        return JsonUtil.buildNormalBinder().getJsonToObject(queryWareHouseJson, WhWarehouse.class);
    }

    @Override
    public void acceptGoodsPrice(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        String pricedownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("pricedownloadpath"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)pricedownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + pricedownloadpath));
            return;
        }
        String[] pricedown = pricedownloadpath.split(";");
        if (pricedown.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SFTP.split", (Object)pricedown);
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        for (String downPath : pricedown) {
            try {
                fileNames = SftpClientUtil.listFileInDir(downPath);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
                return;
            }
            String xml = "";
            boolean stopflag = false;
            for (String fileName : fileNames) {
                try {
                    xml = SftpClientUtil.downloadFile(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                    continue;
                }
                if (StringUtils.isBlank((String)xml)) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                    continue;
                }
                if (xml.startsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                } else if (xml.endsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                }
                JSONObject jsonObject = null;
                try {
                    jsonObject = XmlUtils.xml2Json(xml);
                }
                catch (DocumentException e) {
                    e.printStackTrace();
                }
                JSONObject blocks = (JSONObject)jsonObject.get((Object)"blocks");
                Object block = blocks.get((Object)"block");
                System.out.println(JsonUtil.buildNormalBinder().toJson(block));
                List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(block), Map.class);
                if (ListUtil.isNotEmpty((Collection)mapList)) {
                    for (Map stringObjectMap : mapList) {
                        Object members = stringObjectMap.get("members");
                        Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                        this.saveDisGoodsPrice(map, tenantCode);
                    }
                } else {
                    Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(block), String.class, Object.class);
                    Object members = map.get("members");
                    Map membersMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                    Object price = membersMap.get("Price");
                    Object itemNo = membersMap.get("ItemNo");
                    if (null == price || null == itemNo) {
                        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.members", (Object)JsonUtil.buildNormalBinder().toJson(members));
                        stopflag = true;
                        continue;
                    }
                    this.saveDisGoodsPrice(map, tenantCode);
                }
                if (stopflag) continue;
                boolean deleteFlag = false;
                try {
                    deleteFlag = SftpClientUtil.delete(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.delete.error.e", (Throwable)e);
                    continue;
                }
                if (deleteFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                    continue;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        SftpClientUtil.disconnect();
    }

    private void saveDisGoodsPrice(Map<String, Object> map, String tenantCode) {
        Object price = map.get("Price");
        Object itemNo = map.get("ItemNo");
        Object customerPriceGroup = map.get("CustomerPriceGroup");
        Object unitOfMeasure = map.get("UnitOfMeasure");
        Object priceExclVAT = map.get("PriceExclVAT");
        if (null == price || null == itemNo || null == customerPriceGroup) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.members", (Object)JsonUtil.buildNormalBinder().toJson(map));
            return;
        }
        List<UmUserinfo> umUserinfos = this.queryUmUserInfoByGroup(customerPriceGroup.toString(), tenantCode);
        if (ListUtil.isEmpty(umUserinfos)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptGoodsPrice.umUserinfos", (Object)("\u65e0\u6b64\u4ef7\u683c\u7ec4\u4eba\u5458:" + customerPriceGroup));
            return;
        }
        DisChannel disChannel = null;
        DisDprice disDprice = null;
        DisDpriceConf disDpriceConf = null;
        for (UmUserinfo umUserinfo : umUserinfos) {
            disChannel = this.getChannelCodeByshopId(umUserinfo.getUserinfoOcode(), tenantCode);
            disDprice = this.queryDisDpriceByChannel(disChannel.getChannelCode(), disChannel.getTenantCode());
            if (null == disDprice) {
                String disDpriceCode = this.saveDisDpriceDomain(disChannel, price.toString(), itemNo.toString(), customerPriceGroup.toString());
                if (!StringUtils.isBlank((String)disDpriceCode)) continue;
                this.logger.error("service.adapter.webshop.OrderServiceImpl.saveDisGoodsPrice.saveDisDpriceDomain.error", (Object)(itemNo + "=:=" + price + "=:=" + customerPriceGroup));
                continue;
            }
            disDpriceConf = this.getDisDpriceConfBySkuNo(itemNo.toString(), tenantCode);
            if (null == disDpriceConf) {
                String dipriceconfCode = this.saveDisDpriceConf(disDprice, itemNo.toString(), price.toString());
                if (!StringUtils.isBlank((String)dipriceconfCode)) continue;
                this.logger.error("service.adapter.webshop.OrderServiceImpl.saveDisGoodsPrice.saveDisDpriceConf.error", (Object)(itemNo + "=:=" + price + "=:=" + customerPriceGroup));
                continue;
            }
            BigDecimal newPrice = new BigDecimal(price.toString());
            if (disDpriceConf.getDpriceConfPrice().compareTo(newPrice) == 0) continue;
            disDpriceConf.setDpriceConfPrice(newPrice);
            this.updateDpriceConf(disDpriceConf);
        }
    }

    private void updateDpriceConf(DisDpriceConf disDpriceConf) {
        DisDpriceConfDomain disDpriceConfDomain = new DisDpriceConfDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceConfDomain, (Object)disDpriceConf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getInternalRouter().inInvoke("dis.dprice.updateDpriceConf", this.getQueryParamMap("disDpriceConfDomain", new Object[]{JsonUtil.buildNormalBinder().toJson(disDpriceConfDomain)}));
    }

    private String saveDisDpriceConf(DisDprice disDprice, String skuNo, String price) {
        DisDpriceConfDomain disDpriceConfDomain = new DisDpriceConfDomain();
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceConfDomain, (Object)disDprice);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        disDpriceConfDomain.setDpriceConfType("skuNo");
        disDpriceConfDomain.setDpriceConfTerm("=");
        disDpriceConfDomain.setDpriceConfValue(skuNo);
        disDpriceConfDomain.setDpriceConfPrice(new BigDecimal(price));
        disDpriceConfDomain.setTenantCode(disDprice.getTenantCode());
        return (String)this.getInternalRouter().inInvoke("dis.dprice.saveDpriceConf", this.getQueryParamMap("disDpriceConfDomain", new Object[]{JsonUtil.buildNormalBinder().toJson(disDpriceConfDomain)}));
    }

    private DisDpriceConf getDisDpriceConfBySkuNo(String skuNo, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("dpriceConfType", "skuNo");
        map.put("dpriceConfTerm", "=");
        map.put("dpriceConfValue", skuNo);
        map.put("tenantCode", tenantCode);
        String umUserinfoJson = (String)this.getInternalRouter().inInvoke("dis.dprice.queryDpriceConfPage", this.getQueryParamMap("map", new Object[]{JsonUtil.buildNormalBinder().toJson(map)}));
        SupQueryResult supQueryResult = JsonUtil.buildNormalBinder().getJsonToObject(umUserinfoJson, SupQueryResult.class);
        List disDpriceConfList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(supQueryResult.getList()), DisDpriceConf.class);
        if (ListUtil.isEmpty((Collection)disDpriceConfList)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.queryDisDpriceByChannel.queryDpricePage", map);
            return null;
        }
        return (DisDpriceConf)disDpriceConfList.get(0);
    }

    private String saveDisDpriceDomain(DisChannel disChannel, String price, String itemNo, String customerPriceGroup) {
        DisDpriceReDomain disDpriceDomain = new DisDpriceReDomain();
        disDpriceDomain.setDpriceName(customerPriceGroup);
        try {
            BeanUtils.copyAllPropertys((Object)disDpriceDomain, (Object)disChannel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        disDpriceDomain.setDpriceSync("1");
        disDpriceDomain.setDpricePro("1");
        disDpriceDomain.setDpricePrice(new BigDecimal(price));
        DisDpriceConf disDpriceConf = new DisDpriceConf();
        disDpriceConf.setDpriceConfType("skuNo");
        disDpriceConf.setDpriceConfTerm("=");
        disDpriceConf.setDpriceConfValue(itemNo);
        disDpriceConf.setDpriceConfPrice(new BigDecimal(price));
        disDpriceConf.setTenantCode(disChannel.getTenantCode());
        ArrayList<DisDpriceConf> disDpriceConfList = new ArrayList<DisDpriceConf>();
        disDpriceConfList.add(disDpriceConf);
        disDpriceDomain.setDisDpriceConfList(disDpriceConfList);
        return (String)this.getInternalRouter().inInvoke("dis.dprice.saveDprice", this.getQueryParamMap("disDpriceDomain", new Object[]{JsonUtil.buildNormalBinder().toJson(disDpriceDomain)}));
    }

    public DisDprice queryDisDpriceByChannel(String channelCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("channelCode", channelCode);
        map.put("tenantCode", tenantCode);
        String disDpriceJson = (String)this.getInternalRouter().inInvoke("dis.dprice.queryDpricePage", this.getQueryParamMap("map", new Object[]{JsonUtil.buildNormalBinder().toJson(map)}));
        SupQueryResult supQueryResult = JsonUtil.buildNormalBinder().getJsonToObject(disDpriceJson, SupQueryResult.class);
        List disDpriceList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(supQueryResult.getList()), DisDprice.class);
        if (ListUtil.isEmpty((Collection)disDpriceList)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.queryDisDpriceByChannel.queryDpricePage", map);
            return null;
        }
        return (DisDprice)disDpriceList.get(0);
    }

    public List<UmUserinfo> queryUmUserInfoByGroup(String customerPriceGroup, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoGroup", customerPriceGroup);
        map.put("tenantCode", tenantCode);
        String umUserinfoJson = (String)this.getInternalRouter().inInvoke("um.user.queryUserinfoPage", this.getQueryParamMap("map", new Object[]{JsonUtil.buildNormalBinder().toJson(map)}));
        SupQueryResult supQueryResult = JsonUtil.buildNormalBinder().getJsonToObject(umUserinfoJson, SupQueryResult.class);
        return (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(supQueryResult.getList()), UmUserinfo.class);
    }

    private DisChannel getChannelCodeByshopId(String userinfoOcode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapStr = new HashMap<String, String>();
        mapStr.put("memberCcode", userinfoOcode);
        mapStr.put("tenantCode", tenantCode);
        mapStr.put("channelType", "1");
        map.put("map", com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson(mapStr));
        String disChannelJson = null;
        try {
            disChannelJson = (String)this.getInternalRouter().inInvoke("dis.channel.queryChannelPage", map);
            if (StringUtils.isBlank((String)disChannelJson)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.inertGoodsshopByPage.queryChannelPage", (Object)("\u67e5\u8be2\u4e3a\u7a7a\uff01\uff01\uff01map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.inertGoodsshopByPage.queryChannelPage.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map));
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(disChannelJson, SupQueryResult.class);
        List disChannelList = (List)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToList(com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), DisChannel.class);
        if (ListUtil.isEmpty((Collection)disChannelList)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.inertGoodsshopByPage.queryDictionaryPage", (Object)("\u95e8\u5e97\u672a\u7ed1\u5b9a\u6e20\u9053,\u8bf7\u524d\u5f80\u7ed1\u5b9a\uff01\uff01\uff01map:" + mapStr));
            return null;
        }
        return (DisChannel)disChannelList.get(0);
    }

    @Override
    public void acceptDelayedDiscountRemaining(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String url = "40.73.99.43";
        int port = 22;
        String username = "azureuser";
        String password = "tE1!xq[41wwA";
        String remainingdownloadpath = "/home/azureuser/rck/ERP/Down/Delayed-Discount";
        String[] remainingdownlPath = remainingdownloadpath.split(";");
        if (remainingdownlPath.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.split", (Object)remainingdownloadpath);
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        for (String downPath : remainingdownlPath) {
            try {
                fileNames = SftpClientUtil.listFileInDir(downPath);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
                return;
            }
            String xml = "";
            for (String fileName : fileNames) {
                try {
                    xml = SftpClientUtil.downloadFile(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                    continue;
                }
                if (StringUtils.isBlank((String)xml)) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                    continue;
                }
                if (xml.startsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                } else if (xml.endsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                }
                JSONObject jsonObject = null;
                try {
                    jsonObject = XmlUtils.xml2Json(xml);
                    if (null == jsonObject) {
                        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.xml2Json", (Object)"\u89e3\u6790\u51fa\u9519\uff01");
                        return;
                    }
                }
                catch (DocumentException e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.xml2Json", (Object)"\u89e3\u6790\u5f02\u5e38\uff01.", (Throwable)e);
                    return;
                }
                JSONObject blocks = (JSONObject)jsonObject.get((Object)"blocks");
                Object block = blocks.get((Object)"block");
                List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(block), Map.class);
                if (ListUtil.isEmpty((Collection)mapList)) {
                    Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(block), String.class, Object.class);
                    Object members = map.get("members");
                    Map memberMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                    DelayedDiscountRemaining delayedDiscountRemaining = new DelayedDiscountRemaining();
                    delayedDiscountRemaining.setDiscountType(null == memberMap.get("DiscountType") ? "" : memberMap.get("DiscountType").toString());
                    delayedDiscountRemaining.setRealisedAmount(new BigDecimal(null == memberMap.get("RealisedAmount") ? "0" : memberMap.get("RealisedAmount").toString()));
                    delayedDiscountRemaining.setAmountonOrders(new BigDecimal(null == memberMap.get("AmountOnOrders") ? "0" : memberMap.get("AmountOnOrders").toString()));
                    delayedDiscountRemaining.setCustomerName(null == memberMap.get("CustomerName") ? "" : memberMap.get("CustomerName").toString());
                    delayedDiscountRemaining.setCustomerNo(null == memberMap.get("CustomerNo") ? "" : memberMap.get("CustomerNo").toString());
                    delayedDiscountRemaining.setDiscountAmount(new BigDecimal(null == memberMap.get("DiscountAmount") ? "0" : memberMap.get("DiscountAmount").toString()));
                    delayedDiscountRemaining.setRemainingAmount(new BigDecimal(null == memberMap.get("RemainingAmount") ? "0" : memberMap.get("RemainingAmount").toString()));
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.insertDelayedDiscountRemaining1", (Object)JsonUtil.buildNormalBinder().toJson(delayedDiscountRemaining));
                    this.insertDelayedDiscountRemaining(delayedDiscountRemaining);
                } else {
                    for (Map stringObjectMap : mapList) {
                        Object members = stringObjectMap.get("members");
                        Map memberMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                        DelayedDiscountRemaining delayedDiscountRemaining = new DelayedDiscountRemaining();
                        delayedDiscountRemaining.setDiscountType(null == memberMap.get("DiscountType") ? "" : memberMap.get("DiscountType").toString());
                        delayedDiscountRemaining.setRealisedAmount(new BigDecimal(null == memberMap.get("RealisedAmount") ? "0" : memberMap.get("RealisedAmount").toString()));
                        delayedDiscountRemaining.setAmountonOrders(new BigDecimal(null == memberMap.get("AmountOnOrders") ? "0" : memberMap.get("AmountOnOrders").toString()));
                        delayedDiscountRemaining.setCustomerName(null == memberMap.get("CustomerName") ? "" : memberMap.get("CustomerName").toString());
                        delayedDiscountRemaining.setCustomerNo(null == memberMap.get("CustomerNo") ? "" : memberMap.get("CustomerNo").toString());
                        delayedDiscountRemaining.setDiscountAmount(new BigDecimal(null == memberMap.get("DiscountAmount") ? "0" : memberMap.get("DiscountAmount").toString()));
                        delayedDiscountRemaining.setRemainingAmount(new BigDecimal(null == memberMap.get("RemainingAmount") ? "0" : memberMap.get("RemainingAmount").toString()));
                        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.insertDelayedDiscountRemaining2", (Object)JsonUtil.buildNormalBinder().toJson(delayedDiscountRemaining));
                        this.insertDelayedDiscountRemaining(delayedDiscountRemaining);
                    }
                }
                boolean deleteFlag = false;
                try {
                    deleteFlag = SftpClientUtil.delete(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.SftpClientUtil.delete.error.e", (Throwable)e);
                    continue;
                }
                if (deleteFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                    continue;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        SftpClientUtil.disconnect();
        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRemaining.end");
    }

    public void insertDelayedDiscountRemaining(DelayedDiscountRemaining delayedDiscountRemaining) {
        int i = 0;
        try {
            i = this.delayedDiscountRemainingMapper.insert(delayedDiscountRemaining);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.webshop.OrderServiceImpl.insertDelayedDiscountRemaining.insert", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.webshop.OrderServiceImpl.insertDelayedDiscountRemaining.insert====");
        }
    }

    public void insertDelayedDiscountRealised(DelayedDiscountRealised delayedDiscountRealised) {
        int i = 0;
        try {
            i = this.delayedDiscountRealisedMapper.insert(delayedDiscountRealised);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.webshop.OrderServiceImpl.insertDelayedDiscountRealised.insert", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.webshop.OrderServiceImpl.insertDelayedDiscountRealised.insert====");
        }
    }

    @Override
    public void acceptDelayedDiscountRealised(String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised", (Object)"tenantCode is null");
            tenantCode = "2020021700000001";
        }
        String url = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("host"));
        int port = Integer.valueOf(SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("port")));
        String username = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("username"));
        String password = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("password"));
        String realiseddownloadpath = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)tenantCode.concat("-").concat("SFTP").concat("-").concat("realiseddownloadpath"));
        if (StringUtils.isBlank((String)url) || StringUtils.isBlank((String)username) || StringUtils.isBlank((String)password) || StringUtils.isBlank((String)realiseddownloadpath)) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.SFTP", (Object)(url + "=:=" + port + "=:=" + username + "=:=" + password + "=:=" + realiseddownloadpath));
            return;
        }
        String[] realiseddownPath = realiseddownloadpath.split(";");
        if (realiseddownPath.length <= 0) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.split", (Object)realiseddownloadpath);
            return;
        }
        boolean connect = false;
        try {
            connect = SftpClientUtil.connect(url, port, username, password, null);
            if (!connect) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.SftpClientUtil.connect.error", (Object)connect);
                return;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.SftpClientUtil.connect.error.e", (Throwable)e);
            return;
        }
        Vector<String> fileNames = null;
        for (String downPath : realiseddownPath) {
            try {
                fileNames = SftpClientUtil.listFileInDir(downPath);
            }
            catch (Exception e) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.SftpClientUtil.listFileInDir.error.e", (Throwable)e);
                return;
            }
            String xml = "";
            for (String fileName : fileNames) {
                try {
                    xml = SftpClientUtil.downloadFile(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.SftpClientUtil.downloadFile.error.e", (Throwable)e);
                    continue;
                }
                if (StringUtils.isBlank((String)xml)) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.xml", (Object)(fileName + ",\u6570\u636e\u6e90\u4e3a\u7a7a\uff01"));
                    continue;
                }
                if (xml.startsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                } else if (xml.endsWith("\ufeff")) {
                    xml = xml.replace("\ufeff", "");
                }
                JSONObject jsonObject = null;
                try {
                    jsonObject = XmlUtils.xml2Json(xml);
                    if (null == jsonObject) {
                        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.xml2Json", (Object)"\u89e3\u6790\u51fa\u9519\uff01");
                        return;
                    }
                }
                catch (DocumentException e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptSuccessContractNavision.xml2Json", (Object)"\u89e3\u6790\u5f02\u5e38\uff01.", (Throwable)e);
                    return;
                }
                JSONObject blocks = (JSONObject)jsonObject.get((Object)"blocks");
                Object block = blocks.get((Object)"block");
                List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson(block), Map.class);
                if (ListUtil.isEmpty((Collection)mapList)) {
                    String postingDate;
                    Map map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(block), String.class, Object.class);
                    Object members = map.get("members");
                    Map memberMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                    DelayedDiscountRealised delayedDiscountRealised = new DelayedDiscountRealised();
                    delayedDiscountRealised.setDocumentNo(null == memberMap.get("DocumentNo") ? "" : memberMap.get("DocumentNo").toString());
                    delayedDiscountRealised.setDescription(null == memberMap.get("Description") ? "" : memberMap.get("Description").toString());
                    delayedDiscountRealised.setDelayedDiscountNo(null == memberMap.get("DelayedDiscountNo") ? "" : memberMap.get("DelayedDiscountNo").toString());
                    String string = postingDate = null == memberMap.get("PostingDate") ? "" : memberMap.get("PostingDate").toString();
                    if (StringUtils.isNotBlank((String)postingDate)) {
                        Date parse = null;
                        try {
                            parse = sdf.parse(postingDate);
                        }
                        catch (ParseException e) {
                            e.printStackTrace();
                        }
                        delayedDiscountRealised.setPostingDate(parse);
                    }
                    delayedDiscountRealised.setDiscountType(null == memberMap.get("DiscountType") ? "" : memberMap.get("DiscountType").toString());
                    delayedDiscountRealised.setOrderNo(null == memberMap.get("OrderNo") ? "" : memberMap.get("OrderNo").toString());
                    delayedDiscountRealised.setCustomerNo(null == memberMap.get("CustomerNo") ? "" : memberMap.get("CustomerNo").toString());
                    delayedDiscountRealised.setDiscountAmount(new BigDecimal(null == memberMap.get("DiscountAmount") ? "" : memberMap.get("DiscountAmount").toString()));
                    this.insertDelayedDiscountRealised(delayedDiscountRealised);
                } else {
                    for (Map stringObjectMap : mapList) {
                        String postingDate;
                        Object members = stringObjectMap.get("members");
                        Map memberMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(JsonUtil.buildNormalBinder().toJson(members), String.class, Object.class);
                        DelayedDiscountRealised delayedDiscountRealised = new DelayedDiscountRealised();
                        delayedDiscountRealised.setDocumentNo(null == memberMap.get("DocumentNo") ? "" : memberMap.get("DocumentNo").toString());
                        delayedDiscountRealised.setDescription(null == memberMap.get("Description") ? "" : memberMap.get("Description").toString());
                        delayedDiscountRealised.setDelayedDiscountNo(null == memberMap.get("DelayedDiscountNo") ? "" : memberMap.get("DelayedDiscountNo").toString());
                        String string = postingDate = null == memberMap.get("PostingDate") ? "" : memberMap.get("PostingDate").toString();
                        if (StringUtils.isNotBlank((String)postingDate)) {
                            Date parse = null;
                            try {
                                parse = sdf.parse(postingDate);
                            }
                            catch (ParseException e) {
                                e.printStackTrace();
                            }
                            delayedDiscountRealised.setPostingDate(parse);
                        }
                        delayedDiscountRealised.setDiscountType(null == memberMap.get("DiscountType") ? "" : memberMap.get("DiscountType").toString());
                        delayedDiscountRealised.setOrderNo(null == memberMap.get("OrderNo") ? "" : memberMap.get("OrderNo").toString());
                        delayedDiscountRealised.setCustomerNo(null == memberMap.get("CustomerNo") ? "" : memberMap.get("CustomerNo").toString());
                        delayedDiscountRealised.setDiscountAmount(new BigDecimal(null == memberMap.get("DiscountAmount") ? "" : memberMap.get("DiscountAmount").toString()));
                        this.insertDelayedDiscountRealised(delayedDiscountRealised);
                    }
                }
                boolean deleteFlag = false;
                try {
                    deleteFlag = SftpClientUtil.delete(downPath, fileName);
                }
                catch (Exception e) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.SftpClientUtil.delete.error.e", (Throwable)e);
                    continue;
                }
                if (deleteFlag) {
                    this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.SftpClientUtil.delete.success", (Object)"\u5220\u9664\u6210\u529f\uff01\uff01\uff01");
                    continue;
                }
                this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.SftpClientUtil.delete.error", (Object)"\u5220\u9664\u5931\u8d25\uff01\uff01\uff01");
            }
        }
        SftpClientUtil.disconnect();
        this.logger.error("service.adapter.webshop.OrderServiceImpl.acceptDelayedDiscountRealised.end");
    }

    @Override
    public QueryResult<DelayedDiscountRealised> queryDelayedDiscountRealised(Map<String, Object> map) throws ApiException {
        List<DelayedDiscountRealised> infBrandList = this.queryDelayedDiscountRealisedModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRealised(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infBrandList);
        return queryResult;
    }

    private int countRealised(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.delayedDiscountRealisedMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.countRealised", (Throwable)e);
        }
        return i;
    }

    private List<DelayedDiscountRealised> queryDelayedDiscountRealisedModelPage(Map<String, Object> map) {
        try {
            return this.delayedDiscountRealisedMapper.query(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.queryDelayedDiscountRealisedModelPage", (Throwable)e);
            return null;
        }
    }

    @Override
    public QueryResult<DelayedDiscountRemaining> queryDelayedDiscountRemaining(Map<String, Object> map) throws ApiException {
        List<DelayedDiscountRemaining> infBrandList = this.queryDelayedDiscountRemainingModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRemaining(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(infBrandList);
        return queryResult;
    }

    private int countRemaining(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.delayedDiscountRemainingMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.countRemaining", (Throwable)e);
        }
        return i;
    }

    private List<DelayedDiscountRemaining> queryDelayedDiscountRemainingModelPage(Map<String, Object> map) {
        try {
            return this.delayedDiscountRemainingMapper.query(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.queryDelayedDiscountRemainingModelPage", (Throwable)e);
            return null;
        }
    }

    private void updateGoodsPrice(BigDecimal price, String skuNo, String memberCode, String channelCode, String tenantCode) {
        HashMap<String, String> querySkuMap = new HashMap<String, String>();
        querySkuMap.put("skuNo", skuNo);
        querySkuMap.put("memberCode", memberCode);
        querySkuMap.put("channelCode", channelCode);
        querySkuMap.put("tenantCode", tenantCode);
        String rsSkuJson = "";
        try {
            rsSkuJson = (String)this.getInternalRouter().inInvoke("rs.sku.getSkuBySkuNo", querySkuMap);
            if (StringUtils.isBlank((String)rsSkuJson)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.updateGoodsPrice.getSkuBySkuNo", (Object)("\u67e5\u8be2\u5546\u54c1\u4e3a\u7a7a\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570:" + querySkuMap));
                return;
            }
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.webshop.OrderServiceImpl.updateGoodsPrice.getSkuBySkuNo.e", "\u67e5\u8be2\u5546\u54c1\u5f02\u5e38\uff01\uff01\uff01\u4f20\u5165\u53c2\u6570:" + querySkuMap, (Throwable)e);
        }
        RsSku rsSku = (RsSku)com.yqbsoft.laser.service.tool.util.JsonUtil.buildNormalBinder().getJsonToObject(rsSkuJson, RsSku.class);
        EditSkuDomain editSkuDomain = new EditSkuDomain();
        editSkuDomain.setSkuId(rsSku.getSkuId());
        editSkuDomain.setSkuCode(rsSku.getSkuCode());
        editSkuDomain.setGoodsCode(rsSku.getGoodsCode());
        editSkuDomain.setTenantCode(tenantCode);
        if (price == null) {
            return;
        }
        editSkuDomain.setPricesetNprice(price.setScale(2, 4));
        HashMap<String, String> updateMap = new HashMap<String, String>();
        updateMap.put("editSkuDomain", JsonUtil.buildNormalBinder().toJson(editSkuDomain));
        this.getInternalRouter().inInvoke("rs.sku.updateSkuEditOne", updateMap);
    }

    public OrgEmployee queryOrgEmployeeInfo(String employeeCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("employeeCode", employeeCode);
        map.put("tenantCode", tenantCode);
        String uorgEmployeeJson = "";
        try {
            uorgEmployeeJson = (String)this.getInternalRouter().inInvoke("org.employee.getEmployeeByCode", map);
            if (StringUtils.isBlank((String)uorgEmployeeJson)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.queryOrgEmployeeInfo", (Object)("\u67e5\u8be2\u4e1a\u52a1\u5458\u4e3a\u7a7a\uff01\uff01\uff01map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.queryOrgEmployeeInfo.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map), (Throwable)e);
            return null;
        }
        return JsonUtil.buildNonEmptyBinder().getJsonToObject(uorgEmployeeJson, OrgEmployee.class);
    }

    public UmUserinfo queryShopInfo(String memberCode, String tenantCode) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("userinfoCode", memberCode);
        map.put("tenantCode", tenantCode);
        String umUserInfoJson = "";
        try {
            umUserInfoJson = (String)this.getInternalRouter().inInvoke("um.user.getUserinfoByUserCode", map);
            if (StringUtils.isBlank((String)umUserInfoJson)) {
                this.logger.error("service.adapter.webshop.OrderServiceImpl.queryShopInfo", (Object)("\u67e5\u8be2\u95e8\u5e97\u4e3a\u7a7a\uff01\uff01\uff01map:" + map));
                return null;
            }
        }
        catch (Exception e) {
            this.logger.error("service.adapter.webshop.OrderServiceImpl.queryShopInfo.e", (Object)("\u67e5\u8be2\u5f02\u5e38\uff01\uff01\uff01map:" + map), (Throwable)e);
            return null;
        }
        return JsonUtil.buildNonEmptyBinder().getJsonToObject(umUserInfoJson, UmUserinfo.class);
    }
}

