/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.adapter.zq.service.impl;

import com.yqbsoft.laser.service.adapter.zq.domain.OcRefundDomain;
import com.yqbsoft.laser.service.adapter.zq.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.adapter.zq.service.ZqSendrefundService;
import com.yqbsoft.laser.service.adapter.zq.utils.DateUtils;
import com.yqbsoft.laser.service.adapter.zq.utils.DmUtil;
import com.yqbsoft.laser.service.adapter.zq.utils.WdtClient;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ZqSendrefundServicelmpl
extends BaseServiceImpl
implements ZqSendrefundService {
    private static final String SYS_CODE = "dm.ZqSendrefundService";
    private static final String OC_REFUND_UPDATE_DATE = "oc.refundEngine.sendRefundNext";

    @Override
    public String saveSendrefund(OcRefundDomain ocRefundDomain) throws ApiException {
        this.logger.error("dm.ZqSendrefundService.saveSendrefund:ocRefundDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocRefundDomain));
        if (null == ocRefundDomain) {
            this.logger.error("dm.ZqSendrefundService.saveSendrefund", (Object)"is null");
            return "error";
        }
        String url = "";
        url = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "zqUrl", "url");
        String sid = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "zqSid", "app_id");
        String appkey = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "zqAppkey", "appkey");
        String appsecret = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "zqAppsecret", "appsecret");
        String shop_no = DmUtil.getUrl(ocRefundDomain.getTenantCode(), "zsSendgoodsShop_no", "shop_no");
        this.logger.error("dm.ZqSendrefundService.saveSendrefund:url" + url + "sid" + sid + "appkey" + appkey + "appsecret" + appsecret + "shop_no" + shop_no);
        WdtClient client = new WdtClient(sid, appkey, appsecret, url);
        ArrayList api_refund_list = new ArrayList();
        ArrayList order_list = new ArrayList();
        HashMap<String, Object> order_1 = new HashMap<String, Object>();
        if (ListUtil.isEmpty(ocRefundDomain.getOcRefundGoodsDomainList())) {
            this.logger.error("dm.ZqSendrefundService.saveSendrefund:OcRefundGoodsDomainisnull");
            return "error";
        }
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundDomain.getOcRefundGoodsDomainList()) {
            order_1.put("oid", ocRefundGoodsDomain.getContractBillcode());
            order_1.put("num", ocRefundGoodsDomain.getRefundGoodsNum());
            order_list.add(order_1);
        }
        HashMap<String, Object> api_refund_1 = new HashMap<String, Object>();
        api_refund_1.put("tid", ocRefundDomain.getContractBillcode());
        api_refund_1.put("platform_id", "127");
        api_refund_1.put("shop_no", shop_no);
        api_refund_1.put("refund_no", ocRefundDomain.getRefundCode());
        String type = ocRefundDomain.getRefundType();
        String status = "";
        if (StringUtils.isNotBlank((String)ocRefundDomain.getRefundType())) {
            if (type.equals("B02")) {
                type = "3";
                status = "goods_returning";
                api_refund_1.put("logistics_no", ocRefundDomain.getPackageBillno());
                api_refund_1.put("logistics_name", ocRefundDomain.getPackageName());
            } else if (type.equals("B01")) {
                type = "1";
                status = "success";
            }
        }
        api_refund_1.put("type", new BigDecimal(type));
        api_refund_1.put("status", status);
        api_refund_1.put("buyer_nick", ocRefundDomain.getMemberBname());
        api_refund_1.put("refund_fee", ocRefundDomain.getRefundMoney());
        api_refund_1.put("refund_time", DateUtils.getCurrentTime());
        api_refund_1.put("reason", ocRefundDomain.getContractRemark());
        api_refund_1.put("order_list", order_list);
        api_refund_list.add(api_refund_1);
        String api_refund_list_json = JsonUtil.buildNonNullBinder().toJson(api_refund_list);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("api_refund_list", api_refund_list_json);
        try {
            String response = client.execute("sales_refund_push.php", params);
            this.logger.error("dm.ZqSendrefundService.sales_refund_push.php", (Object)("response" + JsonUtil.buildNonDefaultBinder().toJson(params)));
            if (StringUtils.isNotBlank((String)response)) {
                Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, String.class);
                if (MapUtil.isEmpty((Map)jsonToMap)) {
                    this.logger.error("dm.ZqSendrefundService.saveSendgoods.jsonToMap", (Object)("response" + JsonUtil.buildNonDefaultBinder().toJson((Object)response)));
                    return "error";
                }
                if ("0".equals(jsonToMap.get("code"))) {
                    return "success";
                }
                this.logger.error("dm.ZqSendrefundService.saveSendgoods.jsonToMapStr", (Object)("jsonToMap" + JsonUtil.buildNonDefaultBinder().toJson((Object)jsonToMap)));
                return "error";
            }
            this.logger.error("dm.ZqSendrefundService.saveSendgoods.responseStr", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params)));
            return "error";
        }
        catch (IOException e) {
            this.logger.error("dm.ZqSendrefundService.saveSendgoods.responseStr1", (Object)("params" + JsonUtil.buildNonDefaultBinder().toJson(params) + "e" + e));
            return "error";
        }
    }

    @Override
    public String querySendrefund(String tenantCode) throws ApiException {
        String url = "";
        url = DmUtil.getUrl(tenantCode, "zqUrl", "url");
        String sid = DmUtil.getUrl(tenantCode, "zqSid", "app_id");
        String appkey = DmUtil.getUrl(tenantCode, "zqAppkey", "appkey");
        String appsecret = DmUtil.getUrl(tenantCode, "zqAppsecret", "appsecret");
        WdtClient client = new WdtClient(sid, appkey, appsecret, url);
        HashMap<String, String> params = new HashMap<String, String>();
        String start_time = DmUtil.getUrl(tenantCode, "start_time", "start_time");
        if (StringUtils.isNotBlank((String)start_time)) {
            params.put("start_time", start_time);
        } else {
            params.put("start_time", DateUtils.getYesterHourse());
        }
        try {
            String response = client.execute("refund_query.php", params);
            if (StringUtils.isNotBlank((String)response)) {
                Map jsonToMap = (Map)JsonUtil.buildNonDefaultBinder().getJsonToMap(response, String.class, Object.class);
                String refund_no = jsonToMap.get("refund_no").toString();
                String process_status = jsonToMap.get("process_status").toString();
                BigDecimal data = new BigDecimal("process_status");
                if (data.compareTo(new BigDecimal("30")) == 1 || data.compareTo(new BigDecimal("30")) == 0) {
                    HashMap<String, String> parmra = new HashMap<String, String>();
                    HashMap<String, String> map = new HashMap<String, String>();
                    parmra.put("refundCode", refund_no);
                    parmra.put("tenantCode", process_status);
                    map.put("newDataStatestr", "4");
                    parmra.put("map", JsonUtil.buildNonNullBinder().toJson(map));
                    this.getInternalRouter().inInvoke(OC_REFUND_UPDATE_DATE, parmra);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

