/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.miniprogramservice.service.impl;

import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.miniprogramservice.dao.AiCtemlpMapper;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCtemlpDomain;
import com.yqbsoft.laser.service.miniprogramservice.domain.AiCtemlpReDomain;
import com.yqbsoft.laser.service.miniprogramservice.model.AiCtemlp;
import com.yqbsoft.laser.service.miniprogramservice.service.AiCtemlpService;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import com.yqbsoft.laser.service.tool.util.WebUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AiCtemlpServiceImpl
extends BaseServiceImpl
implements AiCtemlpService {
    private static final String SYS_CODE = "mini.AiCtemlpServiceImpl";
    private AiCtemlpMapper aiCtemlpMapper;

    public void setAiCtemlpMapper(AiCtemlpMapper aiCtemlpMapper) {
        this.aiCtemlpMapper = aiCtemlpMapper;
    }

    @Override
    public String deletetemplate(String token, String template_id) throws Exception {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)template_id)) {
            throw new ApiException("mini.AiCtemlpServiceImpl.deletetemplate.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/deletetemplate?access_token=" + token;
        String json = this.microMessengerDeletetemplate(url, template_id);
        return json;
    }

    private String microMessengerDeletetemplate(String url, String template_id) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("template_id", template_id);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String gettemplatelist(String token) throws Exception {
        if (StringUtils.isBlank((String)token)) {
            throw new ApiException("mini.AiCtemlpServiceImpl.gettemplatelist.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/gettemplatelist?access_token=" + token;
        url = url.replace("\"", "");
        String json = this.microMessengerGetInformation(url);
        return json;
    }

    public static void main(String[] args) {
        String url = "https://api.weixin.qq.com/wxa/gettemplatelist?access_token=34_cGexE-31BNoVZD9Axfki9PreYj2nElTbhstKp97v7Gt7UAQD1QONLCBZj22D34MuFGxIfUyZLhBJobK5tLEtmRC1WAsC5qVbkj_oNXyTNlSHVuVzeu7TkCW6Fs2dkH6RXDXLTt_8YBGK6ad0OHBcAHAHAU";
        HashMap map = new HashMap();
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(res);
    }

    @Override
    public String addtotemplate(String token, String draft_id) throws Exception {
        if (StringUtils.isBlank((String)token) || StringUtils.isBlank((String)draft_id)) {
            throw new ApiException("mini.AiCtemlpServiceImpl.addtotemplate.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/addtotemplate?access_token=" + token;
        String json = this.microMessengerAddtotemplate(url, draft_id);
        return json;
    }

    private String microMessengerAddtotemplate(String url, String draft_id) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("draft_id", draft_id);
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    @Override
    public String gettemplatedraftlist(String token) throws Exception {
        if (StringUtils.isBlank((String)token)) {
            throw new ApiException("mini.AiCtemlpServiceImpl.gettemplatedraftlist.null", "param is null");
        }
        String url = "https://api.weixin.qq.com/wxa/gettemplatedraftlist?access_token=" + token;
        String json = this.microMessengerGetInformation(url);
        return json;
    }

    private String microMessengerGetInformation(String url) {
        HashMap map = new HashMap();
        String res = "";
        try {
            res = WebUtils.doPostJson((String)url, map, (int)10000, (int)10000, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return res;
    }

    private Date getSysDate() {
        try {
            return this.aiCtemlpMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCtemlpServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAiCtemlp(AiCtemlpDomain aiCtemlpDomain) {
        if (null == aiCtemlpDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)aiCtemlpDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setAiCtemlpDefault(AiCtemlp aiCtemlp) {
        if (null == aiCtemlp) {
            return;
        }
        if (null == aiCtemlp.getDataState()) {
            aiCtemlp.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == aiCtemlp.getGmtCreate()) {
            aiCtemlp.setGmtCreate(date);
        }
        aiCtemlp.setGmtModified(date);
        if (StringUtils.isBlank((String)aiCtemlp.getCtemlpCode())) {
            aiCtemlp.setCtemlpCode(this.getNo(null, "AiCtemlp", "aiCtemlp", aiCtemlp.getTenantCode()));
        }
    }

    private int getAiCtemlpMaxCode() {
        int code = 0;
        try {
            return this.aiCtemlpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("mini.AiCtemlpServiceImpl.getAiCtemlpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAiCtemlpUpdataDefault(AiCtemlp aiCtemlp) {
        if (null == aiCtemlp) {
            return;
        }
        aiCtemlp.setGmtModified(this.getSysDate());
    }

    private void saveAiCtemlpModel(AiCtemlp aiCtemlp) throws ApiException {
        if (null == aiCtemlp) {
            return;
        }
        try {
            this.aiCtemlpMapper.insert(aiCtemlp);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCtemlpServiceImpl.saveAiCtemlpModel.ex", (Throwable)e);
        }
    }

    private void saveAiCtemlpBatchModel(List<AiCtemlp> aiCtemlpList) throws ApiException {
        if (null == aiCtemlpList || aiCtemlpList.isEmpty()) {
            return;
        }
        try {
            this.aiCtemlpMapper.insertBatch(aiCtemlpList);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCtemlpServiceImpl.saveAiCtemlpBatchModel.ex", (Throwable)e);
        }
    }

    private AiCtemlp getAiCtemlpModelById(Integer ctemlpId) {
        if (null == ctemlpId) {
            return null;
        }
        try {
            return this.aiCtemlpMapper.selectByPrimaryKey(ctemlpId);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCtemlpServiceImpl.getAiCtemlpModelById", (Throwable)e);
            return null;
        }
    }

    private AiCtemlp getAiCtemlpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.aiCtemlpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCtemlpServiceImpl.getAiCtemlpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delAiCtemlpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCtemlpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCtemlpServiceImpl.delAiCtemlpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCtemlpServiceImpl.delAiCtemlpModelByCode.num");
        }
    }

    private void deleteAiCtemlpModel(Integer ctemlpId) throws ApiException {
        if (null == ctemlpId) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCtemlpMapper.deleteByPrimaryKey(ctemlpId);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCtemlpServiceImpl.deleteAiCtemlpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCtemlpServiceImpl.deleteAiCtemlpModel.num");
        }
    }

    private void updateAiCtemlpModel(AiCtemlp aiCtemlp) throws ApiException {
        if (null == aiCtemlp) {
            return;
        }
        int i = 0;
        try {
            i = this.aiCtemlpMapper.updateByPrimaryKey(aiCtemlp);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCtemlpServiceImpl.updateAiCtemlpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("mini.AiCtemlpServiceImpl.updateAiCtemlpModel.num");
        }
    }

    private void updateStateAiCtemlpModel(Integer ctemlpId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ctemlpId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ctemlpId", ctemlpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCtemlpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCtemlpServiceImpl.updateStateAiCtemlpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCtemlpServiceImpl.updateStateAiCtemlpModel.null");
        }
    }

    private void updateStateAiCtemlpModelByCode(String tenantCode, String ctemlpCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ctemlpCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ctemlpCode", ctemlpCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.aiCtemlpMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("mini.AiCtemlpServiceImpl.updateStateAiCtemlpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("mini.AiCtemlpServiceImpl.updateStateAiCtemlpModelByCode.null");
        }
    }

    private AiCtemlp makeAiCtemlp(AiCtemlpDomain aiCtemlpDomain, AiCtemlp aiCtemlp) {
        if (null == aiCtemlpDomain) {
            return null;
        }
        if (null == aiCtemlp) {
            aiCtemlp = new AiCtemlp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)aiCtemlp, (Object)aiCtemlpDomain);
            return aiCtemlp;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCtemlpServiceImpl.makeAiCtemlp", (Throwable)e);
            return null;
        }
    }

    private AiCtemlpReDomain makeAiCtemlpReDomain(AiCtemlp aiCtemlp) {
        if (null == aiCtemlp) {
            return null;
        }
        AiCtemlpReDomain aiCtemlpReDomain = new AiCtemlpReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)aiCtemlpReDomain, (Object)aiCtemlp);
            return aiCtemlpReDomain;
        }
        catch (Exception e) {
            this.logger.error("mini.AiCtemlpServiceImpl.makeAiCtemlpReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AiCtemlp> queryAiCtemlpModelPage(Map<String, Object> parammap) {
        try {
            return this.aiCtemlpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCtemlpServiceImpl.queryAiCtemlpModel", (Throwable)e);
            return null;
        }
    }

    private int countAiCtemlp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.aiCtemlpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("mini.AiCtemlpServiceImpl.countAiCtemlp", (Throwable)e);
        }
        return i;
    }

    private AiCtemlp createAiCtemlp(AiCtemlpDomain aiCtemlpDomain) {
        String msg = this.checkAiCtemlp(aiCtemlpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCtemlpServiceImpl.saveAiCtemlp.checkAiCtemlp", msg);
        }
        AiCtemlp aiCtemlp = this.makeAiCtemlp(aiCtemlpDomain, null);
        this.setAiCtemlpDefault(aiCtemlp);
        return aiCtemlp;
    }

    @Override
    public String saveAiCtemlp(AiCtemlpDomain aiCtemlpDomain) throws ApiException {
        AiCtemlp aiCtemlp = this.createAiCtemlp(aiCtemlpDomain);
        this.saveAiCtemlpModel(aiCtemlp);
        return aiCtemlp.getCtemlpCode();
    }

    @Override
    public String saveAiCtemlpBatch(List<AiCtemlpDomain> aiCtemlpDomainList) throws ApiException {
        if (null == aiCtemlpDomainList || aiCtemlpDomainList.isEmpty()) {
            return null;
        }
        ArrayList<AiCtemlp> aiCtemlpList = new ArrayList<AiCtemlp>();
        String code = "";
        for (AiCtemlpDomain aiCtemlpDomain : aiCtemlpDomainList) {
            AiCtemlp aiCtemlp = this.createAiCtemlp(aiCtemlpDomain);
            code = aiCtemlp.getCtemlpCode();
            aiCtemlpList.add(aiCtemlp);
        }
        this.saveAiCtemlpBatchModel(aiCtemlpList);
        return code;
    }

    @Override
    public void updateAiCtemlpState(Integer ctemlpId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ctemlpId) {
            return;
        }
        this.updateStateAiCtemlpModel(ctemlpId, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCtemlpStateByCode(String tenantCode, String ctemlpCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ctemlpCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateAiCtemlpModelByCode(tenantCode, ctemlpCode, dataState, oldDataState, map);
    }

    @Override
    public void updateAiCtemlp(AiCtemlpDomain aiCtemlpDomain) throws ApiException {
        String msg = this.checkAiCtemlp(aiCtemlpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("mini.AiCtemlpServiceImpl.updateAiCtemlp.checkAiCtemlp", msg);
        }
        AiCtemlp oldAiCtemlp = this.getAiCtemlpModelById(aiCtemlpDomain.getCtemlpId());
        if (null == oldAiCtemlp) {
            throw new ApiException("mini.AiCtemlpServiceImpl.updateAiCtemlp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AiCtemlp aiCtemlp = this.makeAiCtemlp(aiCtemlpDomain, oldAiCtemlp);
        this.setAiCtemlpUpdataDefault(aiCtemlp);
        this.updateAiCtemlpModel(aiCtemlp);
    }

    @Override
    public AiCtemlp getAiCtemlp(Integer ctemlpId) {
        if (null == ctemlpId) {
            return null;
        }
        return this.getAiCtemlpModelById(ctemlpId);
    }

    @Override
    public void deleteAiCtemlp(Integer ctemlpId) throws ApiException {
        if (null == ctemlpId) {
            return;
        }
        this.deleteAiCtemlpModel(ctemlpId);
    }

    @Override
    public QueryResult<AiCtemlp> queryAiCtemlpPage(Map<String, Object> map) {
        List<AiCtemlp> aiCtemlpList = this.queryAiCtemlpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAiCtemlp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(aiCtemlpList);
        return queryResult;
    }

    @Override
    public AiCtemlp getAiCtemlpByCode(String tenantCode, String ctemlpCode) throws ApiException {
        if (StringUtils.isBlank((String)ctemlpCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ctemlpCode", ctemlpCode);
        return this.getAiCtemlpModelByCode(map);
    }

    @Override
    public void deleteAiCtemlpByCode(String tenantCode, String ctemlpCode) throws ApiException {
        if (StringUtils.isBlank((String)ctemlpCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ctemlpCode", ctemlpCode);
        this.delAiCtemlpModelByCode(map);
    }
}

