/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.auction.cleaning.queue;

import com.yqbsoft.laser.service.auction.cleaning.domain.AtAuctionWinDomain;
import com.yqbsoft.laser.service.auction.cleaning.service.CtAuctionWinService;
import com.yqbsoft.laser.service.auction.cleaning.thread.ThreadFactoryImpl;
import com.yqbsoft.laser.service.suppercore.log.SupperLogUtil;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingDeque;

public class CleaningQueue
implements Runnable {
    private CtAuctionWinService ctAuctionWinService;
    private final SupperLogUtil logger = new SupperLogUtil(this.getClass());
    private BlockingQueue<AtAuctionWinDomain> cleaningQueue;
    private ExecutorService exService;
    private final int poolSize;

    public CleaningQueue(CtAuctionWinService ctAuctionWinService) {
        this.poolSize = 1;
        this.ctAuctionWinService = ctAuctionWinService;
        this.cleaningQueue = new LinkedBlockingDeque<AtAuctionWinDomain>();
        this.exService = Executors.newFixedThreadPool(this.poolSize, new ThreadFactoryImpl("AUCTION_CLEANING_WORKER_", true));
    }

    public void start() throws Exception {
        new Thread(this).start();
    }

    public void addAuction(AtAuctionWinDomain atAuctionWin) {
        this.cleaningQueue.add(atAuctionWin);
    }

    public void removeAuction(AtAuctionWinDomain atAuctionWin) {
        this.cleaningQueue.remove(atAuctionWin);
    }

    public int getQueueSize() {
        return this.cleaningQueue.size();
    }

    @Override
    public void run() {
        this.exService.execute(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            CleaningQueue.this.logger.error("===========\u4fdd\u5b58\u8bb0\u5f55\u961f\u5217\uff1a ===================\u53d6\u51fa\u524d===============", (Object)("\u961f\u5217\u957f\u5ea6\u3010" + CleaningQueue.this.cleaningQueue.size() + "\u3011"));
                            AtAuctionWinDomain atAuctionWin = (AtAuctionWinDomain)CleaningQueue.this.cleaningQueue.take();
                            if (null == atAuctionWin) {
                                Thread.sleep(100L);
                                continue;
                            }
                            CleaningQueue.this.ctAuctionWinService.saveatAuctionWin(atAuctionWin);
                            CleaningQueue.this.logger.error("===========\u4fdd\u5b58\u8bb0\u5f55\u961f\u5217\uff1a ===================\u53d6\u51fa\u540e===============", (Object)("\u961f\u5217\u957f\u5ea6\u3010" + CleaningQueue.this.cleaningQueue.size() + "\u3011"));
                        }
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
    }
}

