/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.auction.cleaning.service.impl;

import com.yqbsoft.laser.service.auction.cleaning.dao.AtAuctionUserginfoMapper;
import com.yqbsoft.laser.service.auction.cleaning.dao.AtAuctiondtMapper;
import com.yqbsoft.laser.service.auction.cleaning.domain.AtAuctiondtDomain;
import com.yqbsoft.laser.service.auction.cleaning.domain.AtAuctiondtReDomain;
import com.yqbsoft.laser.service.auction.cleaning.model.AtAuctiondt;
import com.yqbsoft.laser.service.auction.cleaning.service.CtAuctiondtService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CtAuctiondtServiceImpl
extends BaseServiceImpl
implements CtAuctiondtService {
    private static final String SYS_CODE = SYS_CODE + ".AtAuctiondtServiceImpl";
    private AtAuctiondtMapper atAuctiondtMapper;
    private AtAuctionUserginfoMapper atAuctionUserginfoMapper;

    public void setAtAuctiondtMapper(AtAuctiondtMapper atAuctiondtMapper) {
        this.atAuctiondtMapper = atAuctiondtMapper;
    }

    public void setAtAuctionUserginfoMapper(AtAuctionUserginfoMapper atAuctionUserginfoMapper) {
        this.atAuctionUserginfoMapper = atAuctionUserginfoMapper;
    }

    private Date getSysDate() {
        try {
            return this.atAuctiondtMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkAuctiondt(AtAuctiondtDomain atAuctiondtDomain) {
        if (null == atAuctiondtDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)atAuctiondtDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private int getAuctiondtMaxCode() {
        int code = 0;
        try {
            return this.atAuctiondtMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getAuctiondtMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setAuctiondtUpdataDefault(AtAuctiondt atAuctiondt) {
        if (null == atAuctiondt) {
            return;
        }
        atAuctiondt.setGmtModified(this.getSysDate());
    }

    private AtAuctiondt getAuctiondtModelById(Integer auctionDtId) {
        if (null == auctionDtId) {
            return null;
        }
        try {
            return this.atAuctiondtMapper.selectByPrimaryKey(auctionDtId);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getAuctiondtModelById", (Throwable)e);
            return null;
        }
    }

    private void updateAuctiondtModel(AtAuctiondt atAuctiondt) throws ApiException {
        if (null == atAuctiondt) {
            return;
        }
        int i = 0;
        try {
            i = this.atAuctiondtMapper.updateByPrimaryKey(atAuctiondt);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException(SYS_CODE + ".updateAuctiondtModel.num");
        }
    }

    private AtAuctiondt makeAuctiondt(AtAuctiondtDomain atAuctiondtDomain, AtAuctiondt atAuctiondt) {
        if (null == atAuctiondtDomain) {
            return null;
        }
        if (null == atAuctiondt) {
            atAuctiondt = new AtAuctiondt();
        }
        try {
            BeanUtils.copyAllPropertys((Object)atAuctiondt, (Object)atAuctiondtDomain);
            return atAuctiondt;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeAuctiondt", (Throwable)e);
            return null;
        }
    }

    private AtAuctiondtReDomain makeAtAuctiondtReDomain(AtAuctiondt atAuctiondt) {
        if (null == atAuctiondt) {
            return null;
        }
        AtAuctiondtReDomain atAuctiondtReDomain = new AtAuctiondtReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)atAuctiondtReDomain, (Object)atAuctiondt);
            return atAuctiondtReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeAtAuctiondtReDomain", (Throwable)e);
            return null;
        }
    }

    private List<AtAuctiondt> queryAuctiondtModelPage(Map<String, Object> parammap) {
        List<AtAuctiondt> atAuctiondtList = null;
        try {
            atAuctiondtList = this.atAuctiondtMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".queryAuctiondtModel", (Object)parammap.toString(), (Throwable)e);
        }
        return atAuctiondtList;
    }

    private int countAuctiondt(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.atAuctiondtMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".countAuctiondt", (Throwable)e);
        }
        return i;
    }

    @Override
    public void updateAuctiondt(AtAuctiondtDomain atAuctiondtDomain) throws ApiException {
        String msg = this.checkAuctiondt(atAuctiondtDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".updateAuctiondt.checkAuctiondt", msg);
        }
        AtAuctiondt oldAtAuctiondt = this.getAuctiondtModelById(atAuctiondtDomain.getAuctionDtId());
        if (null == oldAtAuctiondt) {
            throw new ApiException(SYS_CODE + ".updateAuctiondt.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        AtAuctiondt atAuctiondt = this.makeAuctiondt(atAuctiondtDomain, oldAtAuctiondt);
        if (StringUtils.isBlank((String)atAuctiondtDomain.getUserName())) {
            atAuctiondt.setUserName(null);
        }
        if (StringUtils.isBlank((String)atAuctiondtDomain.getUserCode())) {
            atAuctiondt.setUserCode(null);
        }
        this.setAuctiondtUpdataDefault(atAuctiondt);
        this.updateAuctiondtModel(atAuctiondt);
    }

    @Override
    public AtAuctiondt getAuctiondt(Integer auctionDtId) {
        return this.getAuctiondtModelById(auctionDtId);
    }

    @Override
    public QueryResult<AtAuctiondt> queryAuctiondtPage(Map<String, Object> map) {
        List<AtAuctiondt> atAuctiondtList = this.queryAuctiondtModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countAuctiondt(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(atAuctiondtList);
        return queryResult;
    }

    @Override
    public void updateAuctiondtStateForCheck(Integer auctionDtId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateAuctiondtModelForCheck(auctionDtId, dataState, oldDataState, map);
    }

    private void updateStateAuctiondtModelForCheck(Integer auctionDtId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionDtId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionDtId", auctionDtId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.atAuctiondtMapper.updateStateByPrimaryKeyForCheck(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateAuctiondtModelForCheck.ex", (Throwable)e);
        }
        if (i < 1) {
            throw new ApiException(SYS_CODE + ".updateStateAuctiondtModelForCheck.ex", "\u4fee\u6539\u5931\u8d25" + map);
        }
    }
}

