/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.auction.cleaning.service.impl;

import com.yqbsoft.laser.service.auction.cleaning.dao.AtAuctionWinMapper;
import com.yqbsoft.laser.service.auction.cleaning.domain.AtAuctionWinDomain;
import com.yqbsoft.laser.service.auction.cleaning.domain.AtAuctionWinReDomain;
import com.yqbsoft.laser.service.auction.cleaning.model.AtAuctionWin;
import com.yqbsoft.laser.service.auction.cleaning.service.CtAuctionWinService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CtAuctionWinServiceImpl
extends BaseServiceImpl
implements CtAuctionWinService {
    private static final String SYS_CODE = SYS_CODE + ".AtAuctionWinServiceImpl";
    private AtAuctionWinMapper atAuctionWinMapper;

    public void setAtAuctionWinMapper(AtAuctionWinMapper atAuctionWinMapper) {
        this.atAuctionWinMapper = atAuctionWinMapper;
    }

    private Date getSysDate() {
        try {
            return this.atAuctionWinMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkatAuctionWin(AtAuctionWinDomain atAuctionWinDomain) {
        if (null == atAuctionWinDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)atAuctionWinDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setatAuctionWinDefault(AtAuctionWin atAuctionWin) {
        if (null == atAuctionWin) {
            return;
        }
        if (null == atAuctionWin.getDataState()) {
            atAuctionWin.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == atAuctionWin.getGmtCreate()) {
            atAuctionWin.setGmtCreate(date);
        }
        atAuctionWin.setGmtModified(date);
        if (StringUtils.isBlank((String)atAuctionWin.getAuctionWinCode())) {
            atAuctionWin.setAuctionWinCode(this.getNo(null, "AtAuctionWin", "atAuctionWin", atAuctionWin.getTenantCode()));
        }
    }

    private int getatAuctionWinMaxCode() {
        int code = 0;
        try {
            return this.atAuctionWinMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".getatAuctionWinMaxCode", (Throwable)e);
            return code;
        }
    }

    private void saveatAuctionWinModel(AtAuctionWin atAuctionWin) throws ApiException {
        if (null == atAuctionWin) {
            return;
        }
        try {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("auctionCode", atAuctionWin.getAuctionCode());
            paramMap.put("memberBcode", atAuctionWin.getMemberBcode());
            List<AtAuctionWin> auctionWins = this.atAuctionWinMapper.query(paramMap);
            this.logger.error("============saveatAuctionWinModel==========", (Object)("auctionWins size=" + auctionWins.size()));
            if (null == auctionWins || auctionWins.size() <= 0) {
                this.atAuctionWinMapper.insert(atAuctionWin);
            } else {
                AtAuctionWin atAuctionWinInfo = auctionWins.get(0);
                this.logger.error("============atAuctionWinInfo==========", (Object)("atAuctionWinInfo=" + JsonUtil.buildNormalBinder().toJson((Object)atAuctionWinInfo)));
                BigDecimal amount = atAuctionWinInfo.getAuctionWinAmount().add(atAuctionWin.getAuctionWinAmount()).setScale(2, 0);
                atAuctionWinInfo.setAuctionWinNow(new BigDecimal("0"));
                atAuctionWinInfo.setAuctionWinAmount(amount);
                this.atAuctionWinMapper.updateByPrimaryKeySelective(atAuctionWinInfo);
            }
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".saveatAuctionWinModel.ex", (Throwable)e);
        }
    }

    private void updateStateatAuctionWinModel(Integer auctionWinId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == auctionWinId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("auctionWinId", auctionWinId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.atAuctionWinMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionWinModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException(SYS_CODE + ".updateStateatAuctionWinModel.null");
        }
    }

    private AtAuctionWin makeatAuctionWin(AtAuctionWinDomain atAuctionWinDomain, AtAuctionWin atAuctionWin) {
        if (null == atAuctionWinDomain) {
            return null;
        }
        if (null == atAuctionWin) {
            atAuctionWin = new AtAuctionWin();
        }
        try {
            BeanUtils.copyAllPropertys((Object)atAuctionWin, (Object)atAuctionWinDomain);
            return atAuctionWin;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeatAuctionWin", (Throwable)e);
            return null;
        }
    }

    private AtAuctionWinReDomain makeAtAuctionWinReDomain(AtAuctionWin atAuctionWin) {
        if (null == atAuctionWin) {
            return null;
        }
        AtAuctionWinReDomain atAuctionWinReDomain = new AtAuctionWinReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)atAuctionWinReDomain, (Object)atAuctionWin);
            return atAuctionWinReDomain;
        }
        catch (Exception e) {
            this.logger.error(SYS_CODE + ".makeAtAuctionWinReDomain", (Throwable)e);
            return null;
        }
    }

    private AtAuctionWin createAtAuctionWin(AtAuctionWinDomain atAuctionWinDomain) {
        String msg = this.checkatAuctionWin(atAuctionWinDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException(SYS_CODE + ".saveatAuctionWin.checkatAuctionWin", msg);
        }
        AtAuctionWin atAuctionWin = this.makeatAuctionWin(atAuctionWinDomain, null);
        this.setatAuctionWinDefault(atAuctionWin);
        return atAuctionWin;
    }

    @Override
    public String saveatAuctionWin(AtAuctionWinDomain atAuctionWinDomain) throws ApiException {
        AtAuctionWin atAuctionWin = this.createAtAuctionWin(atAuctionWinDomain);
        this.saveatAuctionWinModel(atAuctionWin);
        return atAuctionWin.getAuctionWinCode();
    }
}

