/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.auction.job.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.yqbsoft.laser.service.auction.job.dao.TtAuctionTimerMapper;
import com.yqbsoft.laser.service.auction.job.listener.AuctionEndListener;
import com.yqbsoft.laser.service.auction.job.model.AtAuction;
import com.yqbsoft.laser.service.auction.job.model.TtAuctionTimer;
import com.yqbsoft.laser.service.auction.job.queue.AtAuctionQueue;
import com.yqbsoft.laser.service.auction.job.service.TtAuctionTimerService;
import com.yqbsoft.laser.service.auction.job.timer.AuctionTimerExeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class TtAuctionTimerServiceImpl
extends BaseServiceImpl
implements TtAuctionTimerService,
AuctionEndListener {
    private static final String AUCTION_ID = "AUCTION_ID_";
    private static final String AUCTION_GINFO_ID = "AUCTION_GINFO_ID_";
    private AtAuctionQueue atAuctionQueue;
    private TtAuctionTimerMapper ttAuctionTimerMapper;

    @Override
    public String addAuctionTimer(String atAuctionStr) throws ApiException {
        AtAuction atAuction = (AtAuction)JsonUtil.buildNonNullBinder().getJsonToObject(atAuctionStr, AtAuction.class);
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(atAuction.getAuctionId().toString());
        if (null == tt) {
            DateTime date = DateUtil.date();
            tt = new TtAuctionTimer();
            tt.setTimerCode(this.getNo(null, "AtAuction", "atAuction", atAuction.getTenantCode()));
            tt.setTimerAuctionId(atAuction.getAuctionId().toString());
            tt.setTimerGoodsInfoId("0");
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            tt.setTimerState(0);
            tt.setGmtCreate((Date)date);
            tt.setGmtModified((Date)date);
            tt.setTenantCode(atAuction.getMemberCode());
            int result = this.ttAuctionTimerMapper.insert(tt);
            this.logger.error("==================addAuctionTimer=", (Object)("\u4fdd\u5b58\u7ed3\u679c\uff1a" + result));
            this.atAuctionQueue.addAuction(tt);
            this.logger.error("==================addAuctionTimer=", (Object)("\u653e\u5165\u7f13\u5b58 id:" + atAuction.getAuctionId()));
        } else {
            this.updateAuctionTimer(atAuction);
        }
        return "SUCCESS";
    }

    @Override
    public String updateAuctionTimer(AtAuction atAuction) throws ApiException {
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(atAuction.getAuctionId().toString());
        if (tt.getTimerStartDatetime().getTime() - atAuction.getAuctionSdate().getTime() != 0L || tt.getTimerEndDatetime().getTime() - atAuction.getAuctionEdate().getTime() != 0L) {
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
            AuctionTimerExeService.getInstance().stopTimer(AUCTION_ID + tt.getTimerAuctionId());
            this.atAuctionQueue.removeAuction(tt);
            this.atAuctionQueue.addAuction(tt);
        }
        return "SUCCESS";
    }

    @Override
    public String addGoodsInfoTimers(String atAuctionStr, String goodsInfoIdListStr) throws ApiException {
        AtAuction atAuction = (AtAuction)JsonUtil.buildNonNullBinder().getJsonToObject(atAuctionStr, AtAuction.class);
        List goodsInfoIds = JsonUtil.buildNonNullBinder().getList(atAuctionStr, List.class, String.class);
        DateTime date = DateUtil.date();
        ArrayList<TtAuctionTimer> timerList = new ArrayList<TtAuctionTimer>();
        for (String id : goodsInfoIds) {
            TtAuctionTimer tt = new TtAuctionTimer();
            tt.setTimerCode(this.getNo(null, "AtAuction", "atAuction", atAuction.getTenantCode()));
            tt.setTimerAuctionId(atAuction.getAuctionId().toString());
            tt.setTimerGoodsInfoId(id);
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            tt.setGmtCreate((Date)date);
            tt.setGmtModified((Date)date);
            tt.setTenantCode(atAuction.getMemberCode());
            timerList.add(tt);
        }
        this.ttAuctionTimerMapper.insertBatch(timerList);
        for (TtAuctionTimer tt : timerList) {
            AuctionTimerExeService.getInstance().auctionEndTimer(AUCTION_GINFO_ID + tt.getTimerGoodsInfoId(), tt.getTimerEndDatetime(), tt, this);
        }
        return "SUCCESS";
    }

    @Override
    public String updateGoodsInfoTimer(String goodsInfoId, String endDatetimeStr) throws ApiException {
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(goodsInfoId);
        if (null != tt) {
            DateTime date = DateUtil.parseDate((String)endDatetimeStr);
            tt.setTimerEndDatetime((Date)date);
            this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
            AuctionTimerExeService.getInstance().stopTimer(AUCTION_GINFO_ID + tt.getTimerGoodsInfoId());
            AuctionTimerExeService.getInstance().auctionEndTimer(AUCTION_GINFO_ID + tt.getTimerGoodsInfoId(), tt.getTimerEndDatetime(), tt, this);
        }
        return "SUCCESS";
    }

    @Override
    public String initAuctionTimer() throws ApiException {
        this.logger.error("======================\u7ade\u4ef7\u573a\u6b21\u521d\u59cb\u5316\u5f00\u59cb===========");
        this.atAuctionQueue = new AtAuctionQueue();
        try {
            this.atAuctionQueue.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AuctionTimerExeService.getInstance().start();
        DateTime date = DateUtil.date();
        List<TtAuctionTimer> list = this.ttAuctionTimerMapper.selectUnfinishedTimer();
        for (TtAuctionTimer tt : list) {
            if (tt.getTimerState() == 0) {
                this.atAuctionQueue.addAuction(tt);
                this.logger.error("==================addAuctionTimer=", (Object)("\u653e\u5165\u7f13\u5b58 id:" + tt.getTimerAuctionId()));
                continue;
            }
            if (tt.getTimerEndDatetime().getTime() - date.getTime() <= 0L) {
                tt.setTimerState(2);
                this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
                if (!tt.getTimerGoodsInfoId().equals("0")) continue;
                String result = this.noticeAtAuctionEnd(tt.getTimerAuctionId(), tt.getTimerEndDatetime());
                this.logger.error("=================\u901a\u77e5\u7ade\u4ef7\u4e1a\u52a1\u670d\u52a1=", (Object)("\u7ed3\u679c:" + result));
                continue;
            }
            if (tt.getTimerGoodsInfoId().equals("0")) continue;
            AuctionTimerExeService.getInstance().auctionEndTimer(AUCTION_GINFO_ID + tt.getTimerGoodsInfoId(), tt.getTimerEndDatetime(), tt, this);
        }
        this.logger.error("======================\u7ade\u4ef7\u573a\u6b21\u521d\u59cb\u5316\u7ed3\u675f===========");
        return "SUCCESS";
    }

    private String noticeAtAuctionEnd(String auctionId, Date datetime) {
        String apiCode = "at.atAuction.auctionEndWithTimer";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("auctionId", auctionId);
        paramMap.put("endTime", DateUtil.formatDate((Date)datetime));
        return this.internalInvoke(apiCode, paramMap);
    }

    @Override
    public void auctionEnd(String auctionId, String goodsInfoId) {
        String apiCode = "cct.cleaning.auctionGoodsInfoCleaning";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("auctionId", auctionId);
        paramMap.put("goodsInfoId", goodsInfoId);
        String result = this.internalInvoke(apiCode, paramMap);
        this.logger.error("===========\u573a\u6b21id\uff1a" + auctionId + " \u7ade\u4ef7\u5546\u54c1\uff1a" + goodsInfoId + " \u8bc4\u6807\u7ed3\u7b97\uff1a" + result);
        this.ttAuctionTimerMapper.updateAuctionGoodsInfoTimerFinish(goodsInfoId);
        int count = this.ttAuctionTimerMapper.findAuctionTimerUnfinished(auctionId);
        if (count <= 0) {
            TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(goodsInfoId);
            String noticeResult = this.noticeAtAuctionEnd(auctionId, tt.getTimerEndDatetime());
            this.logger.error("===========\u573a\u6b21id\uff1a" + auctionId + " \u901a\u77e5\u7ed3\u679c\uff1a" + result);
            this.ttAuctionTimerMapper.updateAuctionTimerFinish(auctionId);
        }
    }

    public void setTtAuctionTimerMapper(TtAuctionTimerMapper ttAuctionTimerMapper) {
        this.ttAuctionTimerMapper = ttAuctionTimerMapper;
    }
}

