/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.auction.job.service.impl;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.lang.UUID;
import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.json.JSONUtil;
import com.yqbsoft.laser.service.auction.job.constants.TimerConstants;
import com.yqbsoft.laser.service.auction.job.dao.TtAuctionTimerMapper;
import com.yqbsoft.laser.service.auction.job.listener.AuctionCleaningListener;
import com.yqbsoft.laser.service.auction.job.listener.AuctionStartListener;
import com.yqbsoft.laser.service.auction.job.model.AtAuction;
import com.yqbsoft.laser.service.auction.job.model.AtAuctionWin;
import com.yqbsoft.laser.service.auction.job.model.TtAuctionTimer;
import com.yqbsoft.laser.service.auction.job.queue.AtAuctionQueue;
import com.yqbsoft.laser.service.auction.job.service.TtAuctionTimerService;
import com.yqbsoft.laser.service.auction.job.timer.AuctionTimerExeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class TtAuctionTimerServiceImpl
extends BaseServiceImpl
implements TtAuctionTimerService,
AuctionStartListener,
AuctionCleaningListener {
    private Map<String, String> cleanMap = new HashMap<String, String>();
    private int checkNumError = 0;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private static ExecutorService executor = ThreadUtil.newExecutor((int)5);
    private static final String AUCTION_ID = "AUCTION_ID_";
    private AtAuctionQueue atAuctionQueue;
    private TtAuctionTimerMapper ttAuctionTimerMapper;

    @Override
    public String addAuctionTimer(String atAuctionStr) throws ApiException {
        AtAuction atAuction = (AtAuction)JsonUtil.buildNonNullBinder().getJsonToObject(atAuctionStr, AtAuction.class);
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(atAuction.getAuctionCode());
        DateTime date = DateUtil.date();
        if (null == tt) {
            tt = new TtAuctionTimer();
            tt.setTimerCode(UUID.randomUUID().toString());
            tt.setTimerAuctionId(atAuction.getAuctionCode());
            tt.setTimerGoodsInfoId("0");
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            tt.setTimerState(0);
            tt.setGmtCreate((Date)date);
            tt.setGmtModified((Date)date);
            tt.setTenantCode(atAuction.getTenantCode());
            int result = this.ttAuctionTimerMapper.insert(tt);
            this.logger.error("==================addAuctionTimer=", (Object)("\u4fdd\u5b58\u7ed3\u679c\uff1a" + result));
        } else {
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
            AuctionTimerExeService.getInstance().stopTimer(AUCTION_ID + tt.getTimerAuctionId());
        }
        if (tt.getTimerStartDatetime().getTime() - date.getTime() <= 0L) {
            final TtAuctionTimer finalTt = tt;
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    TtAuctionTimerServiceImpl.this.noticeAuctionStart(finalTt);
                }
            });
        } else {
            AuctionTimerExeService.getInstance().auctionStartTimer(AUCTION_ID + tt.getTimerAuctionId(), tt.getTimerStartDatetime(), tt, this);
            this.logger.error("addAuctionTimer =====\u65b0\u589e\u7ade\u62cd.\u52a0\u5165\u5b9a\u65f6=====", (Object)("\u573a\u6b21code:" + atAuction.getAuctionCode() + ",taskId:" + AUCTION_ID + tt.getTimerAuctionId()));
        }
        return "SUCCESS";
    }

    @Override
    public void initReuseAuctionTimer() throws ApiException {
        this.logger.error("initRepeatListedAuction", (Object)("====================\u521d\u59cb\u5316\u91cd\u590d\u5355\u54c1\u5f00\u59cb==================\u6267\u884c\u65f6\u95f4\uff1a" + DateUtil.now()));
        long start = System.currentTimeMillis();
        List<AtAuction> list = this.getAuctions();
        this.logger.error("list============" + JsonUtil.buildNormalBinder().toJson(list));
        Date date = new Date();
        if (null != list && list.size() > 0) {
            block0: for (AtAuction la : list) {
                HashMap<String, String> queryMap1 = new HashMap<String, String>();
                queryMap1.put("tenantCode", "2019110100000001");
                queryMap1.put("auctionCode", la.getAuctionCode());
                queryMap1.put("auctionType", "09");
                HashMap<String, String> auctionWinMap = new HashMap<String, String>();
                auctionWinMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(queryMap1));
                QueryResult quresultConf = this.getQueryResutl("at.atAuctionWin.queryatAuctionWinPage", auctionWinMap, AtAuctionWin.class);
                this.logger.error("quresultConf================" + JsonUtil.buildNormalBinder().toJson((Object)quresultConf.getList()));
                if (quresultConf.getList().size() > 0) continue;
                this.logger.error("\u6d41\u6807======================");
                String wStr = la.getAuctionOcode();
                List weeks = JsonUtil.buildNonDefaultBinder().getList(wStr, List.class, String.class);
                for (String w : weeks) {
                    String t = TtAuctionTimerServiceImpl.dayOfWeek(date);
                    if (!w.equals(t)) continue;
                    String nowDate = DateUtil.formatDate((Date)date);
                    String startTime = DateUtil.formatTime((Date)la.getAuctionSdate());
                    StringBuilder startSb = new StringBuilder();
                    startSb.append(nowDate);
                    startSb.append(" ");
                    startSb.append(startTime);
                    la.setAuctionSdate((Date)DateUtil.parseDateTime((String)startSb.toString()));
                    if (TimerConstants.AUCTION_STATE_2.equals(la.getDataState())) {
                        la.setDataState(TimerConstants.AUCTION_STATE_0);
                    }
                    String endTime = DateUtil.formatTime((Date)la.getAuctionEdate());
                    StringBuilder endSb = new StringBuilder();
                    endSb.append(nowDate);
                    endSb.append(" ");
                    endSb.append(endTime);
                    la.setAuctionEdate((Date)DateUtil.parseDateTime((String)endSb.toString()));
                    this.logger.error("-------------------");
                    String apiCode = "at.atAuction.updateAuction";
                    HashMap<String, String> queryMap = new HashMap<String, String>();
                    queryMap.put("atAuction", JsonUtil.buildNonDefaultBinder().toJson((Object)la));
                    String s = this.internalInvoke(apiCode, queryMap);
                    this.logger.error("s-------------------" + s);
                    this.addAuctionTimer(JsonUtil.buildNonDefaultBinder().toJson((Object)la));
                    continue block0;
                }
            }
        }
        this.logger.error(".initRepeatListedAuction", (Object)("====================\u521d\u59cb\u5316\u91cd\u590d\u5355\u54c1\u7ed3\u675f==================time:" + (System.currentTimeMillis() - start)));
    }

    private String noticeAuctionStart(TtAuctionTimer timer) throws ApiException {
        String apiCode = "at.atAuction.auctionStartWithTimer";
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("auctionId", timer.getTimerAuctionId());
        String respStr = this.internalInvoke(apiCode, queryMap);
        timer.setTimerState(1);
        this.logger.error("=======noticeAuctionStart====\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + "\u63d0\u4ea4\u5b9a\u65f6\u4efb\u52a1\u670d\u52a1\u8fd4\u56de============" + respStr);
        this.ttAuctionTimerMapper.updateByPrimaryKey(timer);
        Map resp = (Map)JsonUtil.buildNormalBinder().getJsonToObject(respStr, Map.class);
        if (null == resp) {
            return "ERROR";
        }
        this.logger.error("=======resp\uff1a", (Object)resp);
        String atAuctionStr = (String)resp.get("atAuctionStr");
        String goodsInfoIdListStr = (String)resp.get("goodsInfoIdListStr");
        if (null == atAuctionStr || null == goodsInfoIdListStr) {
            throw new ApiException("\u8fd4\u56de\u503c atAuctionStr \u4e3a\u7a7a \u6216\u8005 goodsInfoIdListStr\u4e3a\u7a7a");
        }
        this.addGoodsInfoTimers(atAuctionStr, goodsInfoIdListStr);
        this.logger.error("=======noticeAuctionStart====\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + "\u63d0\u4ea4\u5b9a\u65f6\u4efb\u52a1\u670d\u52a1\u8fd4\u56de============" + respStr);
        return "SUCCESS";
    }

    @Override
    public String updateAuctionTimer(AtAuction atAuction) throws ApiException {
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(atAuction.getAuctionCode());
        if (tt.getTimerStartDatetime().getTime() - atAuction.getAuctionSdate().getTime() != 0L || tt.getTimerEndDatetime().getTime() - atAuction.getAuctionEdate().getTime() != 0L) {
            tt.setTimerStartDatetime(atAuction.getAuctionSdate());
            tt.setTimerEndDatetime(atAuction.getAuctionEdate());
            this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
            AuctionTimerExeService.getInstance().stopTimer(AUCTION_ID + tt.getTimerAuctionId());
        }
        return "SUCCESS";
    }

    @Override
    public String addGoodsInfoTimers(String atAuctionStr, String goodsInfoIdListStr) throws ApiException {
        this.logger.error("===========atAuctionStr\uff1a" + atAuctionStr + " goodsInfoIdListStr============" + goodsInfoIdListStr);
        AtAuction atAuction = (AtAuction)JsonUtil.buildNonNullBinder().getJsonToObject(atAuctionStr, AtAuction.class);
        this.logger.error("===========atAuction\uff1a" + JSONUtil.toJsonStr((Object)atAuction));
        List goodsInfoIds = JSONUtil.parseArray((String)goodsInfoIdListStr).toList(String.class);
        this.logger.error(" goodsInfoIdListStr============" + JsonUtil.buildNormalBinder().toJson((Object)goodsInfoIds));
        DateTime date = DateUtil.date();
        for (String id : goodsInfoIds) {
            TtAuctionTimer tt1;
            TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(id);
            if (null == tt) {
                tt = new TtAuctionTimer();
                tt.setTimerCode(UUID.randomUUID().toString());
                tt.setTimerAuctionId(atAuction.getAuctionCode());
                tt.setTimerGoodsInfoId(id);
                tt.setTimerState(1);
                tt.setTimerStartDatetime(atAuction.getAuctionSdate());
                tt.setTimerEndDatetime(atAuction.getAuctionEdate());
                tt.setGmtCreate((Date)date);
                tt.setGmtModified((Date)date);
                tt.setTenantCode(atAuction.getTenantCode());
                this.ttAuctionTimerMapper.insert(tt);
            } else {
                tt.setTimerStartDatetime(atAuction.getAuctionSdate());
                tt.setTimerEndDatetime(atAuction.getAuctionEdate());
                this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
            }
            if ((tt1 = this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(id)).getTimerEndDatetime().getTime() - date.getTime() > 0L) continue;
            this.auctionGoodsInfoCleaning(tt1, new HashMap<String, String>());
        }
        return "SUCCESS";
    }

    @Override
    public String updateGoodsInfoTimer(String goodsInfoId, String endDatetimeStr) throws ApiException {
        this.logger.error("======================\u7ade\u4ef7\u5ef6\u65f6===========", (Object)(" ==========\u5ef6\u65f6\u5546\u54c1ID=" + goodsInfoId + " \u5ef6\u65f6\u65f6\u95f4\uff1a" + endDatetimeStr));
        TtAuctionTimer tt = this.ttAuctionTimerMapper.findAuctionTimerByGoodsInfoId(goodsInfoId);
        if (null != tt) {
            DateTime date = DateUtil.parseDateTime((String)endDatetimeStr);
            tt.setTimerEndDatetime((Date)date);
            int res = this.ttAuctionTimerMapper.updateByPrimaryKey(tt);
            this.logger.error("======================\u66f4\u65b0\u5ef6\u65f6===========", (Object)(" ==========\u6570\u636e\u5e93\u66f4\u65b0\u8fd4\u56de=" + res));
            TtAuctionTimer auctionTimer = this.ttAuctionTimerMapper.findAuctionTimerByAuctionId(tt.getTimerAuctionId());
            if (auctionTimer.getTimerEndDatetime().getTime() < tt.getTimerEndDatetime().getTime()) {
                auctionTimer.setTimerEndDatetime(tt.getTimerEndDatetime());
                res = this.ttAuctionTimerMapper.updateByPrimaryKey(auctionTimer);
                this.logger.error("======================\u66f4\u65b0\u66f4\u65b0\u573a\u6b21\u7ed3\u675f\u65f6\u95f4===========", (Object)(" ==========\u6570\u636e\u5e93\u66f4\u65b0\u8fd4\u56de=" + res));
            }
        }
        return "SUCCESS";
    }

    @Override
    public String initAuctionTimer() throws ApiException {
        this.logger.error("======================\u7ade\u4ef7\u573a\u6b21\u521d\u59cb\u5316\u5f00\u59cb===========");
        this.atAuctionQueue = new AtAuctionQueue(this);
        try {
            this.atAuctionQueue.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        AuctionTimerExeService.getInstance().start();
        List<TtAuctionTimer> list = this.ttAuctionTimerMapper.selectUnfinishedAuctionTimer();
        Date date = new Date();
        for (TtAuctionTimer auctionTimer : list) {
            if (auctionTimer.getTimerStartDatetime() == null) continue;
            this.logger.error("initAuctionTimer =====\u7ade\u4ef7\u521d\u59cb\u5316.\u5f00\u59cb\u65f6\u95f4=====", (Object)("\u7ade\u62cdcode:" + auctionTimer.getTimerAuctionId() + ",time:" + (auctionTimer.getTimerStartDatetime().getTime() - date.getTime())));
            if (auctionTimer.getTimerStartDatetime().getTime() - date.getTime() <= 0L) {
                this.atAuctionQueue.addAuction(auctionTimer);
                this.logger.error("initAuctionTimer =====\u7ade\u4ef7\u521d\u59cb\u5316.\u52a0\u5165\u961f\u5217=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)auctionTimer));
                continue;
            }
            this.logger.error("initAuctionTimer =====\u7ade\u4ef7\u521d\u59cb\u5316.\u52a0\u5165\u5b9a\u65f6=====", (Object)("taskId:AUCTION_ID_" + auctionTimer.getTimerAuctionId()));
            AuctionTimerExeService.getInstance().auctionStartTimer(AUCTION_ID + auctionTimer.getTimerAuctionId(), auctionTimer.getTimerStartDatetime(), auctionTimer, this);
        }
        this.logger.error("======================\u7ade\u4ef7\u573a\u6b21\u521d\u59cb\u5316\u7ed3\u675f===========");
        return "SUCCESS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revealAllTimer() {
        if (StringUtils.isBlank((String)SupDisUtil.get((String)"revealAllTimerFlag"))) {
            if (!this.checkTaskHandelFull()) {
                return;
            }
            SupDisUtil.set((String)"revealAllTimerFlag", (String)"true", (int)5);
            Date date = new Date();
            try {
                List<TtAuctionTimer> list = this.ttAuctionTimerMapper.selectUnfinishedGoodsTimer();
                for (TtAuctionTimer tt : list) {
                    if (tt.getTimerEndDatetime() == null || date.getTime() - tt.getTimerEndDatetime().getTime() <= 500L) continue;
                    this.cleanMap.put(tt.getTimerCode(), tt.getTimerCode());
                    this.auctionGoodsInfoCleaning(tt, this.cleanMap);
                }
            }
            catch (Exception e) {
                this.logger.error("======================\u62fc\u76d8\u5b9a\u65f6\u4efb\u52a1\u5f02\u5e38===========", (Object)e.getMessage());
            }
            finally {
                SupDisUtil.del((String)"revealAllTimerFlag");
            }
        }
    }

    private boolean checkTaskHandelFull() {
        if (this.cleanMap.size() > 0) {
            ++this.checkNumError;
            this.logger.error("=====\u5b9a\u65f6\u4efb\u52a1\u7ed3\u7b97.\u672a\u5168\u90e8\u5904\u7406=====\u5269\u4f59\u6570\u91cf\uff1a" + this.cleanMap.size() + ",\u5f02\u5e38\u6b21\u6570\uff1a" + this.checkNumError);
            if (this.checkNumError > 3) {
                this.checkNumError = 0;
                this.cleanMap.clear();
            }
            return false;
        }
        return true;
    }

    private String noticeAtAuctionEnd(String auctionId, Date datetime) {
        String apiCode = "at.atAuction.auctionEndWithTimer";
        String temp = DateUtil.formatDateTime((Date)datetime);
        this.logger.error("========\u901a\u77e5\u7ade\u4ef7\u670d\u52a1\uff0c\u573a\u6b21\u7ed3\u675f=====noticeAtAuctionEnd" + temp);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("auctionId", auctionId);
        paramMap.put("endTime", temp);
        return this.internalInvoke(apiCode, paramMap);
    }

    public static void main(String[] args) {
    }

    @Override
    public void auctionStart(TtAuctionTimer auction) {
        this.noticeAuctionStart(auction);
    }

    @Override
    public void auctionGoodsInfoCleaning(final TtAuctionTimer timer, final Map<String, String> cleanMapT) {
        this.logger.error("===========\u7ade\u4ef7\u5546\u54c1id\uff1a" + timer.getTimerGoodsInfoId() + " ===================\u5f00\u59cb\u7ed3\u7b97===============");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                String apiCode = "cct.cleaning.auctionGoodsInfoCleaning";
                HashMap<String, String> paramMap = new HashMap<String, String>();
                paramMap.put("auctionId", timer.getTimerAuctionId());
                paramMap.put("goodsInfoId", timer.getTimerGoodsInfoId());
                String result = TtAuctionTimerServiceImpl.this.internalInvoke(apiCode, paramMap);
                TtAuctionTimerServiceImpl.this.logger.error("===========\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + " \u7ade\u4ef7\u5546\u54c1\uff1a" + timer.getTimerGoodsInfoId() + " \u8bc4\u6807\u7ed3\u7b97\uff1a" + result);
                TtAuctionTimerServiceImpl.this.ttAuctionTimerMapper.updateAuctionGoodsInfoTimerFinish(timer.getTimerGoodsInfoId());
                int count = TtAuctionTimerServiceImpl.this.ttAuctionTimerMapper.findAuctionTimerUnfinished(timer.getTimerAuctionId());
                TtAuctionTimerServiceImpl.this.logger.error("==========\u8fd8\u5269 \u3010" + count + "\u3011\u4e2a\u5546\u54c1\u672a\u7ed3\u7b97");
                if (count <= 0) {
                    String noticeResult = TtAuctionTimerServiceImpl.this.noticeAtAuctionEnd(timer.getTimerAuctionId(), timer.getTimerEndDatetime());
                    TtAuctionTimerServiceImpl.this.logger.error("===========\u573a\u6b21id\uff1a" + timer.getTimerAuctionId() + " \u901a\u77e5\u7ed3\u679c\uff1a" + noticeResult);
                    TtAuctionTimerServiceImpl.this.ttAuctionTimerMapper.updateAuctionTimerFinish(timer.getTimerAuctionId());
                }
                try {
                    if (cleanMapT != null) {
                        cleanMapT.remove(timer.getTimerCode());
                    }
                }
                catch (Exception e) {
                    TtAuctionTimerServiceImpl.this.logger.error("===========\u79fb\u9664\u5b9a\u65f6\u4efb\u52a1\u6e05\u9664\u5f02\u5e38=====");
                }
                TtAuctionTimerServiceImpl.this.logger.error("===========\u7ade\u4ef7\u5546\u54c1id\uff1a" + timer.getTimerGoodsInfoId() + " ===================\u7ed3\u7b97\u5b8c\u6210===============");
            }
        });
    }

    public void setTtAuctionTimerMapper(TtAuctionTimerMapper ttAuctionTimerMapper) {
        this.ttAuctionTimerMapper = ttAuctionTimerMapper;
    }

    @Override
    public void testOutTimer() {
        this.logger.error("===========\u5b9a\u65f6\u4efb\u52a1\u8f93\u51fa\u6d4b\u8bd5===========");
    }

    private List<AtAuction> getAuctions() {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("auctionEocode", "1");
        param.put("auctionType", "09");
        HashMap<String, String> auctionMap = new HashMap<String, String>();
        auctionMap.put("map", JsonUtil.buildNonDefaultBinder().toJson(param));
        QueryResult quresultConf = this.getQueryResutl("at.atAuction.queryatAuctionPage", auctionMap, AtAuction.class);
        return quresultConf.getList();
    }

    private List<AtAuction> queryAuctionModel(Map<String, Object> parammap) {
        try {
            return this.ttAuctionTimerMapper.queryAuction(parammap);
        }
        catch (Exception e) {
            this.logger.error(".queryListedAuctionModel", (Throwable)e);
            return null;
        }
    }

    public static String dayOfWeek(Date date) {
        int day = DateUtil.dayOfWeek((Date)date);
        switch (day) {
            case 1: {
                return "\u5468\u65e5";
            }
            case 2: {
                return "\u5468\u4e00";
            }
            case 3: {
                return "\u5468\u4e8c";
            }
            case 4: {
                return "\u5468\u4e09";
            }
            case 5: {
                return "\u5468\u56db";
            }
            case 6: {
                return "\u5468\u4e94";
            }
            case 7: {
                return "\u5468\u516d";
            }
        }
        return null;
    }
}

