/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.bug.service.impl;

import com.yqbsoft.laser.service.bug.dao.QaBugMapper;
import com.yqbsoft.laser.service.bug.dao.QaBuglistMapper;
import com.yqbsoft.laser.service.bug.domain.QaBugDomainBean;
import com.yqbsoft.laser.service.bug.domain.QaBuglistDomainBean;
import com.yqbsoft.laser.service.bug.model.QaBug;
import com.yqbsoft.laser.service.bug.model.QaBuglist;
import com.yqbsoft.laser.service.bug.service.BugService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.SupperApiException;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BugServiceImpl
extends BaseServiceImpl
implements BugService {
    public static final String SYS_CODE = "qa.BUG.BugServiceImpl";
    private QaBugMapper qaBugMapper;
    private QaBuglistMapper qaBuglistMapper;

    public void setQaBugMapper(QaBugMapper qaBugMapper) {
        this.qaBugMapper = qaBugMapper;
    }

    public void setQaBuglistMapper(QaBuglistMapper qaBuglistMapper) {
        this.qaBuglistMapper = qaBuglistMapper;
    }

    private String check(QaBugDomainBean qaBugDomainBean) {
        if (null == qaBugDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)qaBugDomainBean.getUserCode())) {
            msg = msg + "UserCode\u4e3a\u7a7a;";
        }
        if (null == qaBugDomainBean.getBugDir()) {
            msg = msg + "BugDir\u4e3a\u7a7a;";
        }
        if (null == qaBugDomainBean.getBugSort()) {
            msg = msg + "BugSort\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(QaBug qaBug) {
        if (null == qaBug) {
            return;
        }
        if (null == qaBug.getDataState()) {
            qaBug.setDataState(0);
        }
        if (null == qaBug.getGmtCreate()) {
            qaBug.setGmtCreate(this.getSysDate());
        }
    }

    private void setAppUDefault(QaBug qaBug) {
        if (null == qaBug) {
            return;
        }
        if (null == qaBug.getDataState()) {
            qaBug.setDataState(0);
        }
        if (null == qaBug.getGmtCreate()) {
            qaBug.setGmtCreate(this.getSysDate());
        }
    }

    private void saveBugModel(QaBug qaBug) throws SupperApiException {
        if (null == qaBug) {
            return;
        }
        try {
            qaBug.setBugId(this.qaBugMapper.insert(qaBug));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new SupperApiException("qa.BUG.BugServiceImpl.saveBugMode.ex");
        }
    }

    private QaBug getBugModelById(Integer bugId) {
        if (null == bugId) {
            return null;
        }
        try {
            return this.qaBugMapper.selectByPrimaryKey(bugId);
        }
        catch (Exception e) {
            this.logger.error("qa.BUG.BugServiceImpl.getBugModeById", (Throwable)e);
            return null;
        }
    }

    private void updateBugModel(QaBug qaBug) throws SupperApiException {
        if (null == qaBug) {
            return;
        }
        try {
            this.qaBugMapper.updateByPrimaryKeyWithBLOBs(qaBug);
        }
        catch (Exception e) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.saveBugMode.ex");
        }
    }

    private void deleteBugModel(Integer bugId) throws SupperApiException {
        if (null == bugId) {
            return;
        }
        int i = 0;
        try {
            i = this.qaBugMapper.deleteByPrimaryKey(bugId);
        }
        catch (Exception e) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.deleteBugModel.ex");
        }
        if (1 != i) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.deleteBugModel.num");
        }
    }

    private String check(QaBuglistDomainBean qaBuglistDomainBean) {
        if (null == qaBuglistDomainBean) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)qaBuglistDomainBean.getUserCode())) {
            msg = msg + "UserCode\u4e3a\u7a7a;";
        }
        if (null == qaBuglistDomainBean.getBugId()) {
            msg = msg + "BugId\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setDefault(QaBuglist qaBuglist) {
        if (null == qaBuglist) {
            return;
        }
        if (null == qaBuglist.getDataState()) {
            qaBuglist.setDataState(0);
        }
        if (null == qaBuglist.getGmtCreate()) {
            qaBuglist.setGmtCreate(this.getSysDate());
        }
    }

    private void saveBuglistModel(QaBuglist qaBuglist) throws SupperApiException {
        if (null == qaBuglist) {
            return;
        }
        try {
            this.qaBuglistMapper.insert(qaBuglist);
        }
        catch (Exception e) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.saveBuglistMode.ex");
        }
    }

    private QaBuglist getBuglistModelById(Integer buglistId) {
        if (null == buglistId) {
            return null;
        }
        try {
            return this.qaBuglistMapper.selectByPrimaryKey(buglistId);
        }
        catch (Exception e) {
            this.logger.error("qa.BUG.BugServiceImpl.getBuglistModeById", (Throwable)e);
            return null;
        }
    }

    private void updateBuglistModel(QaBuglist qaBuglist) throws SupperApiException {
        if (null == qaBuglist) {
            return;
        }
        try {
            this.qaBuglistMapper.updateByPrimaryKeyWithBLOBs(qaBuglist);
        }
        catch (Exception e) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.saveBuglistMode.ex");
        }
    }

    private void deleteBuglistModel(Integer buglistId) throws SupperApiException {
        if (null == buglistId) {
            return;
        }
        int i = 0;
        try {
            i = this.qaBuglistMapper.deleteByPrimaryKey(buglistId);
        }
        catch (Exception e) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.deleteBuglistModel.ex");
        }
        if (1 != i) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.deleteBuglistModel.num");
        }
    }

    private void deleteByBugId(Integer bugId) throws SupperApiException {
        if (null == bugId) {
            return;
        }
        try {
            this.qaBuglistMapper.deleteByBugId(bugId);
        }
        catch (Exception e) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.deleteBuglistModel.ex");
        }
    }

    private Date getSysDate() {
        try {
            return this.qaBugMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("qa.BUG.BugServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private void updateStateBugMode(Integer bugId, Integer dataState, Integer oldDataState) throws SupperApiException {
        if (null == bugId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("bugId", bugId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        try {
            this.qaBugMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.updateStateBugMode.ex");
        }
    }

    private void updateStateBuglistMode(Integer buglistId, Integer dataState, Integer oldDataState) throws SupperApiException {
        if (null == buglistId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("buglistId", buglistId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.qaBuglistMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.updateStateBuglistMode.ex");
        }
        if (i <= 0) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.updateStateBuglistMode.null");
        }
    }

    private List<QaBug> queryBugModel(Map<String, Object> parammap) {
        try {
            return this.qaBugMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("qa.BUG.BugServiceImpl.queryBug", (Throwable)e);
            return null;
        }
    }

    private List<QaBug> queryBugModelFuzzy(Map<String, Object> parammap) {
        try {
            return this.qaBugMapper.queryFuzzy(parammap);
        }
        catch (Exception e) {
            this.logger.error("qa.BUG.BugServiceImpl.queryBug", (Throwable)e);
            return null;
        }
    }

    private List<QaBuglist> queryBuglistModel(Map<String, Object> parammap) {
        try {
            return this.qaBuglistMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("qa.BUG.BugServiceImpl.queryBuglist", (Throwable)e);
            return null;
        }
    }

    private QaBug makeBug(QaBugDomainBean qaBugDomainBean, QaBug qaBug) {
        if (null == qaBugDomainBean) {
            return null;
        }
        if (null == qaBug) {
            qaBug = new QaBug();
        }
        try {
            BeanUtils.copyAllPropertys((Object)qaBug, (Object)qaBugDomainBean);
        }
        catch (Exception e) {
            this.logger.error("qa.BUG.BugServiceImpl.makeBug", (Throwable)e);
        }
        return qaBug;
    }

    private QaBuglist makeBuglist(QaBuglistDomainBean qaBuglistDomainBean, QaBuglist qaBuglist) {
        if (null == qaBuglistDomainBean) {
            return null;
        }
        if (null == qaBuglist) {
            qaBuglist = new QaBuglist();
        }
        try {
            BeanUtils.copyAllPropertys((Object)qaBuglist, (Object)qaBuglistDomainBean);
        }
        catch (Exception e) {
            this.logger.error("qa.BUG.BugServiceImpl.makeBuglist", (Throwable)e);
        }
        return qaBuglist;
    }

    private int countBug(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.qaBugMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("qa.BUG.BugServiceImpl.countBug", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveBug(QaBugDomainBean qaBugDomainBean) throws SupperApiException {
        String msg = this.check(qaBugDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.saveBug.check", msg);
        }
        QaBug qaBug = this.makeBug(qaBugDomainBean, null);
        this.setDefault(qaBug);
        this.saveBugModel(qaBug);
        return qaBug.getBugId().toString();
    }

    @Override
    public void updateBugState(Integer bugId, Integer dataState, Integer oldDataState) throws SupperApiException {
        this.updateStateBugMode(bugId, dataState, oldDataState);
    }

    @Override
    public void updateBug(QaBugDomainBean qaBugDomainBean) throws SupperApiException {
        String msg = this.check(qaBugDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.updateBug.check", msg);
        }
        QaBug oldQaBug = this.getBugModelById(qaBugDomainBean.getBugId());
        if (null == oldQaBug) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.updateBug.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        QaBug qaBug = this.makeBug(qaBugDomainBean, oldQaBug);
        this.setDefault(qaBug);
        this.updateBugModel(qaBug);
    }

    @Override
    public QaBug getBug(Integer bugId) {
        return this.getBugModelById(bugId);
    }

    @Override
    public void deleteBug(Integer bugId) throws SupperApiException {
        this.deleteBugModel(bugId);
        this.deleteByBugId(bugId);
    }

    @Override
    public QueryResult<QaBug> queryBugPage(Map<String, Object> map) {
        List<QaBug> qaBugList = this.queryBugModel(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBug(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(qaBugList);
        return queryResult;
    }

    @Override
    public QueryResult<QaBug> queryBugPageFuzzy(Map<String, Object> map) {
        List<QaBug> qaBugList = this.queryBugModelFuzzy(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBug(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(qaBugList);
        return queryResult;
    }

    @Override
    public List<QaBug> queryBugListNew(Map<String, Object> map) {
        List<QaBug> qaBugList = this.queryBugModelFuzzy(map);
        return qaBugList;
    }

    @Override
    public void saveBuglist(QaBuglistDomainBean qaBuglistDomainBean) throws SupperApiException {
        String msg = this.check(qaBuglistDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.saveBuglist.check", msg);
        }
        QaBuglist qaBuglist = this.makeBuglist(qaBuglistDomainBean, null);
        this.setDefault(qaBuglist);
        this.saveBuglistModel(qaBuglist);
    }

    @Override
    public void updateBuglistState(Integer buglistId, Integer dataState, Integer oldDataState) throws SupperApiException {
        this.updateStateBuglistMode(buglistId, dataState, oldDataState);
    }

    @Override
    public void updateBuglist(QaBuglistDomainBean qaBuglistDomainBean) throws SupperApiException {
        String msg = this.check(qaBuglistDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.updateBuglist.check", msg);
        }
        QaBuglist oldQaBuglist = this.getBuglistModelById(qaBuglistDomainBean.getBuglistId());
        if (null == oldQaBuglist) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.updateBuglist.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        QaBuglist qaBuglist = this.makeBuglist(qaBuglistDomainBean, oldQaBuglist);
        this.setDefault(qaBuglist);
        this.updateBuglistModel(qaBuglist);
    }

    @Override
    public QaBuglist getBuglist(Integer buglistId) {
        return this.getBuglistModelById(buglistId);
    }

    @Override
    public void deleteBuglist(Integer buglistId) throws SupperApiException {
        this.deleteBuglistModel(buglistId);
    }

    @Override
    public List<QaBuglist> queryBuglist(Map<String, Object> map) {
        return this.queryBuglistModel(map);
    }

    @Override
    public void replyBug(QaBuglistDomainBean qaBuglistDomainBean, Integer dataState, Integer oldDataState) throws SupperApiException {
        this.saveBuglist(qaBuglistDomainBean);
        this.updateStateBugMode(qaBuglistDomainBean.getBugId(), dataState, oldDataState);
    }

    @Override
    public QaBuglist selectOneRecord(Map<String, Object> map) {
        QaBuglist bugList = null;
        try {
            bugList = this.qaBuglistMapper.selectOneRecord(map);
        }
        catch (Exception e) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.selectOneRecord.error", "\u5ba1\u6838\u516c\u544a\u5f02\u5e38");
        }
        return bugList;
    }

    @Override
    public void updateForCheckBuglist(Map<String, Object> map) throws SupperApiException {
        String checkFlag = map.get("checkFlag").toString();
        String bugId = map.get("bugId").toString();
        String buglistId = map.get("buglistId").toString();
        String memo = map.get("memo").toString();
        if (StringUtils.isBlank((String)checkFlag) || StringUtils.isBlank((String)bugId) || StringUtils.isBlank((String)buglistId)) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.checkBugListPost.check", "\u5ba1\u6838\u95ee\u9898\u56de\u590d\u5931\u8d25-\u8981\u7d20\u4e3a\u7a7a");
        }
        if ("0".equals(checkFlag)) {
            if (StringUtils.isBlank((String)memo)) {
                throw new SupperApiException("qa.BUG.BugServiceImpl.checkBugListPost.check", "\u5ba1\u6838\u95ee\u9898\u56de\u590d\u5931\u8d25-\u5ba1\u6838\u9644\u8a00\u4e3a\u7a7a");
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("buglistId", buglistId);
            params.put("memo", memo);
            params.put("dataState", "1");
            params.put("oldDataState", "0");
            int buglistResult = this.qaBuglistMapper.updateForCheckBuglist(params);
            if (1 == buglistResult) {
                this.updateStateBugMode(Integer.parseInt(bugId), 0, 1);
            }
            return;
        }
        if ("1".equals(checkFlag)) {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("buglistId", buglistId);
            params.put("memo", memo);
            params.put("dataState", "2");
            params.put("oldDataState", "0");
            int buglistResult = this.qaBuglistMapper.updateForCheckBuglist(params);
            if (1 == buglistResult) {
                this.updateStateBugMode(Integer.parseInt(bugId), 4, 1);
            }
            return;
        }
    }

    @Override
    public void updateForCheckNotice(Map<String, Object> map) throws SupperApiException {
        String checkFlag = map.get("checkFlag").toString();
        String bugId = map.get("bugId").toString();
        String memo = map.get("memo").toString();
        if (StringUtils.isBlank((String)checkFlag) || StringUtils.isBlank((String)bugId)) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.checkBugListPost.check", "\u5ba1\u6838\u516c\u544a\u5931\u8d25-\u8981\u7d20\u4e3a\u7a7a");
        }
        QaBug oldqaBug = this.getBug(Integer.parseInt(bugId));
        if (null == oldqaBug || 1 != oldqaBug.getDataState()) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.updateForCheckNotice.null", "\u6570\u636e\u4e3a\u7a7a\u6216\u72b6\u6001\u975e\u6cd5");
        }
        if ("0".equals(checkFlag)) {
            if (StringUtils.isBlank((String)memo)) {
                throw new SupperApiException("qa.BUG.BugServiceImpl.checkBugListPost.check", "\u5ba1\u6838\u516c\u544a\u5931\u8d25-\u5ba1\u6838\u9644\u8a00\u4e3a\u7a7a");
            }
            oldqaBug.setMemo(memo);
            oldqaBug.setDataState(3);
            int bugResult = this.qaBugMapper.updateByPrimaryKey(oldqaBug);
            if (1 != bugResult) {
                throw new SupperApiException("qa.BUG.BugServiceImpl.updateForCheckNotice.error", "\u5ba1\u6838\u516c\u544a\u5f02\u5e38");
            }
            return;
        }
        if ("1".equals(checkFlag)) {
            if (!StringUtils.isBlank((String)memo)) {
                oldqaBug.setMemo(memo);
            }
            oldqaBug.setDataState(2);
            int bugResult = this.qaBugMapper.updateByPrimaryKey(oldqaBug);
            if (1 != bugResult) {
                throw new SupperApiException("qa.BUG.BugServiceImpl.updateForCheckNotice.error", "\u5ba1\u6838\u516c\u544a\u5f02\u5e38");
            }
            return;
        }
    }

    @Override
    public void userAppraise(Map<String, Object> map) throws SupperApiException {
        String checkFlag = map.get("checkFlag").toString();
        String bugId = map.get("bugId").toString();
        String buglistId = map.get("buglistId").toString();
        if (StringUtils.isBlank((String)checkFlag) || StringUtils.isBlank((String)bugId) || StringUtils.isBlank((String)buglistId)) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.checkBugListPost.check", "\u8bc4\u4ef7\u5931\u8d25-\u8981\u7d20\u4e3a\u7a7a");
        }
        QaBug qaBug = new QaBug();
        qaBug.setBugId(Integer.parseInt(bugId));
        qaBug.setDataState(2);
        if (1 == this.qaBugMapper.updateByPrimaryKeySelective(qaBug)) {
            if ("0".equals(checkFlag)) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("buglistId", buglistId);
                params.put("dataState", "1");
                params.put("oldDataState", "2");
                this.qaBuglistMapper.updateForCheckBuglist(params);
                this.updateStateBugMode(Integer.parseInt(bugId), 5, 2);
            }
            return;
        }
        throw new SupperApiException("qa.BUG.BugServiceImpl.userAppraise.error", "\u8bc4\u4ef7\u5f02\u5e38");
    }

    @Override
    public void saveAppUBug(QaBugDomainBean qaBugDomainBean) throws SupperApiException {
        String msg = this.check(qaBugDomainBean);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new SupperApiException("qa.BUG.BugServiceImpl.saveBug.check", msg);
        }
        QaBug qaBug = this.makeBug(qaBugDomainBean, null);
        this.setAppUDefault(qaBug);
        this.saveBugModel(qaBug);
    }
}

