/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.cd;

import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

public class AESUtil {
    private static final String defaultCharset = "UTF-8";
    private static final String KEY_AES = "AES";

    public static String encrypt(String data, String key) {
        return AESUtil.doAES(data, key, 1);
    }

    public static String decrypt(String data, String key) {
        return AESUtil.doAES(data, key, 2);
    }

    private static String doAES(String data, String key, int mode) {
        try {
            if (StringUtils.isBlank((String)data) || StringUtils.isBlank((String)key)) {
                return null;
            }
            boolean encrypt = mode == 1;
            byte[] content = encrypt ? data.getBytes(defaultCharset) : AESUtil.parseHexStr2Byte(data);
            KeyGenerator kgen = KeyGenerator.getInstance(KEY_AES);
            kgen.init(128, new SecureRandom(key.getBytes()));
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec keySpec = new SecretKeySpec(enCodeFormat, KEY_AES);
            Cipher cipher = Cipher.getInstance(KEY_AES);
            cipher.init(mode, keySpec);
            byte[] result = cipher.doFinal(content);
            if (encrypt) {
                return AESUtil.parseByte2HexStr(result);
            }
            return new String(result, defaultCharset);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String parseByte2HexStr(byte[] buf) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public static byte[] parseHexStr2Byte(String hexStr) {
        if (hexStr.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexStr.length() / 2];
        for (int i = 0; i < hexStr.length() / 2; ++i) {
            int high = Integer.parseInt(hexStr.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexStr.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
        }
        return result;
    }

    public static void main(String[] args) throws Exception {
    }
}

