/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.channelmanage.service.impl;

import com.yqbsoft.laser.service.channelmanage.dao.CmChannelRefMapper;
import com.yqbsoft.laser.service.channelmanage.domain.CmChannelRefDomain;
import com.yqbsoft.laser.service.channelmanage.model.CmChannelRef;
import com.yqbsoft.laser.service.channelmanage.service.CmChannelRefService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CmChannelRefServiceImpl
extends BaseServiceImpl
implements CmChannelRefService {
    public static final String SYS_CODE = "cm.CmChannelRefServiceImpl";
    private CmChannelRefMapper cmChannelRefMapper;

    public void setCmChannelRefMapper(CmChannelRefMapper cmChannelRefMapper) {
        this.cmChannelRefMapper = cmChannelRefMapper;
    }

    private Date getSysDate() {
        try {
            return this.cmChannelRefMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelRefServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkChannelRef(CmChannelRefDomain cmChannelRefDomain) {
        if (null == cmChannelRefDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setChannelRefDefault(CmChannelRef cmChannelRef) {
        if (null == cmChannelRef) {
            return;
        }
        if (null == cmChannelRef.getDataState()) {
            cmChannelRef.setDataState(0);
        }
        if (null == cmChannelRef.getGmtCreate()) {
            cmChannelRef.setGmtCreate(this.getSysDate());
        }
        cmChannelRef.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cmChannelRef.getChannelRefSeqno())) {
            cmChannelRef.setChannelRefSeqno(this.createUUIDString());
        }
    }

    private int getChannelRefMaxCode() {
        int code = 0;
        try {
            return this.cmChannelRefMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelRefServiceImpl.getChannelRefMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setChannelRefUpdataDefault(CmChannelRef cmChannelRef) {
        if (null == cmChannelRef) {
            return;
        }
        cmChannelRef.setGmtModified(this.getSysDate());
    }

    private void saveChannelRefModel(CmChannelRef cmChannelRef) throws ApiException {
        if (null == cmChannelRef) {
            return;
        }
        try {
            this.cmChannelRefMapper.insert(cmChannelRef);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelRefServiceImpl.saveChannelRefModel.ex", (Throwable)e);
        }
    }

    private CmChannelRef getChannelRefModelById(Integer channelRefId) {
        if (null == channelRefId) {
            return null;
        }
        try {
            return this.cmChannelRefMapper.selectByPrimaryKey(channelRefId);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelRefServiceImpl.getChannelRefModelById", (Throwable)e);
            return null;
        }
    }

    public CmChannelRef getChannelRefModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cmChannelRefMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelRefServiceImpl.getChannelRefModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delChannelRefModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cmChannelRefMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelRefServiceImpl.delChannelRefModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cm.CmChannelRefServiceImpl.delChannelRefModelByCode.num");
        }
    }

    private void deleteChannelRefModel(Integer channelRefId) throws ApiException {
        if (null == channelRefId) {
            return;
        }
        int i = 0;
        try {
            i = this.cmChannelRefMapper.deleteByPrimaryKey(channelRefId);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelRefServiceImpl.deleteChannelRefModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cm.CmChannelRefServiceImpl.deleteChannelRefModel.num");
        }
    }

    private void updateChannelRefModel(CmChannelRef cmChannelRef) throws ApiException {
        if (null == cmChannelRef) {
            return;
        }
        try {
            this.cmChannelRefMapper.updateByPrimaryKeySelective(cmChannelRef);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelRefServiceImpl.updateChannelRefModel.ex", (Throwable)e);
        }
    }

    private void updateStateChannelRefModel(Integer channelRefId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == channelRefId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelRefId", channelRefId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cmChannelRefMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelRefServiceImpl.updateStateChannelRefModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cm.CmChannelRefServiceImpl.updateStateChannelRefModel.null");
        }
    }

    private CmChannelRef makeChannelRef(CmChannelRefDomain cmChannelRefDomain, CmChannelRef cmChannelRef) {
        if (null == cmChannelRefDomain) {
            return null;
        }
        if (null == cmChannelRef) {
            cmChannelRef = new CmChannelRef();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cmChannelRef, (Object)cmChannelRefDomain);
            return cmChannelRef;
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelRefServiceImpl.makeChannelRef", (Throwable)e);
            return null;
        }
    }

    private List<CmChannelRef> queryChannelRefModelPage(Map<String, Object> parammap) {
        try {
            return this.cmChannelRefMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelRefServiceImpl.queryChannelRefModel", (Throwable)e);
            return null;
        }
    }

    private int countChannelRef(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cmChannelRefMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cm.CmChannelRefServiceImpl.countChannelRef", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveChannelRef(CmChannelRefDomain cmChannelRefDomain) throws ApiException {
        String msg = this.checkChannelRef(cmChannelRefDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cm.CmChannelRefServiceImpl.saveChannelRef.checkChannelRef", msg);
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("channelClearSeqno", cmChannelRefDomain.getChannelClearSeqno());
        map.put("tenantCode", cmChannelRefDomain.getTenantCode());
        List<CmChannelRef> list = this.queryChannelRefModelPage(map);
        if (null != list && !list.isEmpty()) {
            this.logger.error("cm.CmChannelRefServiceImpl.saveChannelRef.list", (Object)((Object)map).toString());
            return;
        }
        CmChannelRef cmChannelRef = this.makeChannelRef(cmChannelRefDomain, null);
        this.setChannelRefDefault(cmChannelRef);
        this.saveChannelRefModel(cmChannelRef);
    }

    @Override
    public void updateChannelRefState(Integer channelRefId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateChannelRefModel(channelRefId, dataState, oldDataState);
    }

    @Override
    public void updateChannelRef(CmChannelRefDomain cmChannelRefDomain) throws ApiException {
        String msg = this.checkChannelRef(cmChannelRefDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cm.CmChannelRefServiceImpl.updateChannelRef.checkChannelRef", msg);
        }
        CmChannelRef oldCmChannelRef = this.getChannelRefModelById(cmChannelRefDomain.getChannelRefId());
        if (null == oldCmChannelRef) {
            throw new ApiException("cm.CmChannelRefServiceImpl.updateChannelRef.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CmChannelRef cmChannelRef = this.makeChannelRef(cmChannelRefDomain, oldCmChannelRef);
        this.setChannelRefUpdataDefault(cmChannelRef);
        this.updateChannelRefModel(cmChannelRef);
    }

    @Override
    public CmChannelRef getChannelRef(Integer channelRefId) {
        return this.getChannelRefModelById(channelRefId);
    }

    @Override
    public void deleteChannelRef(Integer channelRefId) throws ApiException {
        this.deleteChannelRefModel(channelRefId);
    }

    @Override
    public QueryResult<CmChannelRef> queryChannelRefPage(Map<String, Object> map) {
        List<CmChannelRef> cmChannelRefList = this.queryChannelRefModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countChannelRef(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cmChannelRefList);
        return queryResult;
    }

    @Override
    public CmChannelRef getChannelRefByCode(Map<String, Object> map) {
        return this.getChannelRefModelByCode(map);
    }

    @Override
    public void delChannelRefByCode(Map<String, Object> map) throws ApiException {
        this.delChannelRefModelByCode(map);
    }
}

