/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.channelmanage.service.impl;

import com.yqbsoft.laser.service.channelmanage.domain.ChannelRest;
import com.yqbsoft.laser.service.channelmanage.domain.CmChannelBarDomain;
import com.yqbsoft.laser.service.channelmanage.domain.CmChannelBarReDomain;
import com.yqbsoft.laser.service.channelmanage.domain.CmChannelClearDomain;
import com.yqbsoft.laser.service.channelmanage.enumc.ChannelBarStateEnum;
import com.yqbsoft.laser.service.channelmanage.model.CmChannelBar;
import com.yqbsoft.laser.service.channelmanage.model.CmChannelClear;
import com.yqbsoft.laser.service.channelmanage.model.CmChannelReorder;
import com.yqbsoft.laser.service.channelmanage.model.CmFBillChannel;
import com.yqbsoft.laser.service.channelmanage.model.ExtFmFile;
import com.yqbsoft.laser.service.channelmanage.service.CmChannelBarService;
import com.yqbsoft.laser.service.channelmanage.service.CmChannelClearService;
import com.yqbsoft.laser.service.channelmanage.service.CmChannelService;
import com.yqbsoft.laser.service.channelmanage.service.CmFchannelService;
import com.yqbsoft.laser.service.channelmanage.service.impl.ClearCallPollThread;
import com.yqbsoft.laser.service.channelmanage.service.impl.ClearCallService;
import com.yqbsoft.laser.service.channelmanage.service.impl.ClearPollThread;
import com.yqbsoft.laser.service.channelmanage.service.impl.ClearService;
import com.yqbsoft.laser.service.channelmanage.service.impl.RetryQueryPollThread;
import com.yqbsoft.laser.service.channelmanage.service.impl.RetryQueryService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.util.CollectionUtils;

public class CmChannelServiceImpl
extends BaseServiceImpl
implements CmChannelService {
    public static final String SYS_CODE = "cm.CmChannelServiceImpl";
    private CmChannelClearService cmChannelClearService;
    private CmFchannelService cmFchannelService;
    private CmChannelBarService cmChannelBarService;
    private static ClearService clearService;
    private static Object lock;
    private static ClearCallService clearCallService;
    private static Object lockCall;
    private static RetryQueryService retryQueryService;
    private static Object rlock;

    public CmChannelBarService getCmChannelBarService() {
        return this.cmChannelBarService;
    }

    public void setCmChannelBarService(CmChannelBarService cmChannelBarService) {
        this.cmChannelBarService = cmChannelBarService;
    }

    public CmFchannelService getCmFchannelService() {
        return this.cmFchannelService;
    }

    public void setCmFchannelService(CmFchannelService cmFchannelService) {
        this.cmFchannelService = cmFchannelService;
    }

    public CmChannelClearService getCmChannelClearService() {
        return this.cmChannelClearService;
    }

    public void setCmChannelClearService(CmChannelClearService cmChannelClearService) {
        this.cmChannelClearService = cmChannelClearService;
    }

    @Override
    public void sendBalance(List<CmChannelClearDomain> vdFaccountDoDomainList) throws ApiException {
        if (null == vdFaccountDoDomainList || vdFaccountDoDomainList.isEmpty()) {
            return;
        }
        List<CmChannelClear> list = this.cmChannelClearService.savechannelClearBatch(vdFaccountDoDomainList);
        if (null == list || list.isEmpty()) {
            return;
        }
        for (CmChannelClear cmChannelClear : list) {
            this.getClearService().putQueue(cmChannelClear);
        }
    }

    @Override
    public void sendEx(CmChannelClear cmChannelClear) throws ApiException {
        CmChannelReorder cmChannelReorder = this.cmChannelClearService.updateExchannelClear(cmChannelClear);
        if (null != cmChannelReorder) {
            this.getClearCallService().putQueue(cmChannelReorder);
        }
    }

    @Override
    public void sendExCall(CmChannelReorder cmChannelReorder) throws ApiException {
        this.cmChannelClearService.updateCallchannelClear(cmChannelReorder);
    }

    @Override
    public void sendBackCall(ChannelRest channelRest) throws ApiException {
        CmChannelReorder cmChannelReorder = this.cmChannelClearService.saveBackCallchannelClear(channelRest);
        if (null != cmChannelReorder) {
            this.getClearCallService().putQueue(cmChannelReorder);
        }
    }

    @Override
    public void sendBack(ChannelRest channelRest) throws ApiException {
        CmChannelReorder cmChannelReorder = this.cmChannelClearService.saveBack(channelRest);
        if (null != cmChannelReorder) {
            this.getClearCallService().putQueue(cmChannelReorder);
        }
    }

    @Override
    public void loadProcess() {
        this.loadDb();
        this.loadCallDb();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClearService getClearService() {
        Object object = lock;
        synchronized (object) {
            if (null == clearService) {
                clearService = new ClearService((CmChannelService)SpringApplicationContextUtil.getBean((String)"cmChannelService"));
                clearService.addPollPool(new ClearPollThread(clearService));
                clearService.addPollPool(new ClearPollThread(clearService));
                clearService.addPollPool(new ClearPollThread(clearService));
                clearService.addPollPool(new ClearPollThread(clearService));
                clearService.addPollPool(new ClearPollThread(clearService));
                clearService.addPollPool(new ClearPollThread(clearService));
                clearService.addPollPool(new ClearPollThread(clearService));
            }
            return clearService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClearCallService getClearCallService() {
        Object object = lockCall;
        synchronized (object) {
            if (null == clearCallService) {
                clearCallService = new ClearCallService((CmChannelService)SpringApplicationContextUtil.getBean((String)"cmChannelService"));
                clearCallService.addPollPool(new ClearCallPollThread(clearCallService));
                clearCallService.addPollPool(new ClearCallPollThread(clearCallService));
                clearCallService.addPollPool(new ClearCallPollThread(clearCallService));
                clearCallService.addPollPool(new ClearCallPollThread(clearCallService));
                clearCallService.addPollPool(new ClearCallPollThread(clearCallService));
                clearCallService.addPollPool(new ClearCallPollThread(clearCallService));
                clearCallService.addPollPool(new ClearCallPollThread(clearCallService));
            }
            return clearCallService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RetryQueryService getRetryQueryService() {
        Object object = rlock;
        synchronized (object) {
            if (null == retryQueryService) {
                retryQueryService = new RetryQueryService((CmChannelService)SpringApplicationContextUtil.getBean((String)"cmChannelService"));
                retryQueryService.addPollPool(new RetryQueryPollThread(retryQueryService));
                retryQueryService.addPollPool(new RetryQueryPollThread(retryQueryService));
                retryQueryService.addPollPool(new RetryQueryPollThread(retryQueryService));
                retryQueryService.addPollPool(new RetryQueryPollThread(retryQueryService));
                retryQueryService.addPollPool(new RetryQueryPollThread(retryQueryService));
            }
            return retryQueryService;
        }
    }

    private void loadCallDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("channelReorderState", 0);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<CmChannelReorder> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getClearCallService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getClearCallService().getPage());
                result = this.cmChannelClearService.querychannelReorderPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    for (CmChannelReorder cmChannelReorder : result.getRows()) {
                        this.getClearCallService().putQueue(cmChannelReorder);
                    }
                    if (result.getRows().size() == this.getClearCallService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getClearCallService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelServiceImpl.loadDb.e", (Throwable)e);
        }
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<CmChannelClear> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getClearService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getClearService().getPage());
                result = this.cmChannelClearService.querychannelClearPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    for (CmChannelClear cmChannelClear : result.getRows()) {
                        this.getClearService().putQueue(cmChannelClear);
                    }
                    if (result.getRows().size() == this.getClearService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getClearService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelServiceImpl.loadDb.e", (Throwable)e);
        }
    }

    @Override
    public synchronized void retryQuery() throws ApiException {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "1");
            map.put("channelClearCallstate", "1");
            map.put("beforeDay", true);
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            map.put("dicClearCode", "PAY");
            map.put("dicClearreqCode", "APPLY");
            QueryResult<CmChannelClear> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getRetryQueryService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getRetryQueryService().getPage());
                result = this.cmChannelClearService.querychannelClearPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    for (CmChannelClear cmChannelClear : result.getRows()) {
                        this.getRetryQueryService().putQueue(cmChannelClear);
                    }
                    if (result.getRows().size() == this.getRetryQueryService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getRetryQueryService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("cm.CmChannelServiceImpl.loadDb.e", (Throwable)e);
        }
    }

    @Override
    public void retryNext(CmChannelClear cmChannelClear) throws ApiException {
        CmChannelReorder cmChannelReorder = this.cmChannelClearService.updateRetryClear(cmChannelClear);
        if (null != cmChannelReorder) {
            this.getClearCallService().putQueue(cmChannelReorder);
        }
    }

    @Override
    public void billChannels(String fchannelType) throws ApiException {
        this.logger.info("cm.channel.billChannels." + fchannelType, (Object)"start bill download");
        this.downloadBillFileByChannelAndfBackfillState(Calendar.getInstance().getTime(), fchannelType);
    }

    @Override
    public void retryBill(String billDate) throws ApiException {
        Date billingDate;
        try {
            billingDate = DateUtils.parseDateStrictly((String)billDate, (String[])new String[]{"yyyy-MM-dd", "yyyyMMdd"});
        }
        catch (ParseException e) {
            this.logger.error("cm.channel.retryBill.param.error", (Object)e.getMessage());
            throw new ApiException("DATE FORMAT EXCEPTION", (Throwable)e);
        }
        this.downloadBillFileByChannelAndfBackfillState(billingDate, null);
        this.logger.info("\u91cd\u8bd5" + billDate + "\u4e0b\u8f7d\u8d26\u5355\u6240\u6709\u6e20\u9053\u5b8c\u6bd5");
    }

    private void downloadBillFileByChannelAndfBackfillState(Date billFileDate, String fchannelType) {
        List<CmFBillChannel> cmFBillChannels = this.getBillChannels(fchannelType);
        if (CollectionUtils.isEmpty(cmFBillChannels)) {
            this.logger.info("\u5f53\u524d\u8d26\u5355\u6e20\u9053\u4e3a\u7a7a");
            return;
        }
        for (CmFBillChannel cmFBillChannel : cmFBillChannels) {
            CmChannelBar ccb = this.getCmChannelBar(cmFBillChannel.getFchannelType(), billFileDate, cmFBillChannel.getTenantCode());
            if (ccb != null && ccb.getDataState() == ChannelBarStateEnum.CHANNEL_BAR_DOWNLOAD_SUCCESS.getCode() && ccb.getChannelBarFilecode() != null) continue;
            CmChannelBarReDomain cmChannelBarDomain = this.getCmChannelBarDomain(billFileDate, ccb, cmFBillChannel);
            if (DateUtils.isSameDay((Date)Calendar.getInstance().getTime(), (Date)billFileDate)) {
                this.updateCmChannelBar(cmChannelBarDomain, this.downloadTheBill(cmFBillChannel));
                continue;
            }
            this.updateCmChannelBar(cmChannelBarDomain, this.retryDownloadTheBill(cmFBillChannel, billFileDate));
        }
    }

    private List<CmFBillChannel> getBillChannels() {
        return this.getBillChannels(new HashMap<String, Object>());
    }

    private List<CmFBillChannel> getBillChannels(String fchannelType) {
        HashMap<String, Object> outerParams = new HashMap<String, Object>();
        if (fchannelType != null) {
            HashMap<String, String> innerParams = new HashMap<String, String>();
            innerParams.put("fchannelType", fchannelType);
            outerParams.put("parameters", JsonUtil.buildNormalBinder().toJson(innerParams));
        }
        return this.getBillChannels(outerParams);
    }

    private List<CmFBillChannel> getBillChannels(Map<String, Object> params) {
        String json = this.internalInvoke("pte.ptfchannel.getBillChannels", params);
        return (List)JsonUtil.buildNormalBinder().getJsonToList(json, CmFBillChannel.class);
    }

    @Override
    public void reloadBill() {
        List<CmFBillChannel> cmFBillChannels = this.getBillChannels();
        for (CmFBillChannel cmFBillChannel : cmFBillChannels) {
            CmChannelBar ccb = this.getCmChannelBar(cmFBillChannel.getFchannelType(), Calendar.getInstance().getTime(), cmFBillChannel.getTenantCode());
            if (ccb != null) continue;
            HashMap<String, String> paramsMap = new HashMap<String, String>();
            paramsMap.put("extPtfchannel", JsonUtil.buildNormalBinder().toJson((Object)cmFBillChannel));
            String cr = this.internalInvoke("cmc.channelIn.channelSDownload", paramsMap);
            ChannelRest channelRest = (ChannelRest)JsonUtil.buildNormalBinder().getJsonToObject(cr, ChannelRest.class);
            if (StringUtils.isEmpty((CharSequence)channelRest.getChannelSubStr())) {
                this.logger.error("\u68c0\u67e5\u8d26\u5355checkBill:" + cmFBillChannel.getTenantCode() + "_" + cmFBillChannel.getFchannelType() + "\u91cd\u65b0\u4e0b\u8f7d\u8d26\u5355\u5931\u8d25");
                continue;
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("fchannelType", cmFBillChannel.getFchannelType());
            paramMap.put("tenantCode", cmFBillChannel.getTenantCode());
            paramMap.put("channelBarDate", DateUtil.getDateStr((String)"yyyy-MM-dd"));
            QueryResult<CmChannelBar> result = this.cmChannelBarService.queryChannelBarPage(paramMap);
            CmChannelBarDomain cmChannelBarDomain = new CmChannelBarDomain();
            if (result.getList().isEmpty()) continue;
            CmChannelBar bar = (CmChannelBar)result.getList().get(0);
            cmChannelBarDomain.setChannelBarSeqno(bar.getChannelBarSeqno());
            String fileJson = channelRest.getChannelSubStr();
            ExtFmFile ff = (ExtFmFile)JsonUtil.buildNormalBinder().getJsonToObject(fileJson, ExtFmFile.class);
            cmChannelBarDomain.setChannelBarFilecode(ff.getFileCode());
            cmChannelBarDomain.setChannelBarFilename(ff.getFileName());
            cmChannelBarDomain.setChannelBarFilepath(ff.getFileUrl());
            this.cmChannelBarService.updateChannelBar(cmChannelBarDomain);
        }
    }

    private void updateCmChannelBar(CmChannelBarReDomain cmChannelBarDomain, ChannelRest channelRest) {
        if (null == channelRest) {
            this.logger.error("BILL_DOWNLOAD_FAIL", (Object)String.format("tenantCode:%s, fchannelCode: %s errMsg:%s", cmChannelBarDomain.getTenantCode(), cmChannelBarDomain.getFchannelType(), ""));
            if (ChannelBarStateEnum.CHANNEL_BAR_DOWNLOAD_DNS.getCode().equals(cmChannelBarDomain.getDataState())) {
                this.cmChannelBarService.updateBarState(cmChannelBarDomain, ChannelBarStateEnum.CHANNEL_BAR_DOWNLOAD_ERROR.getCode(), cmChannelBarDomain.getDataState());
            }
            return;
        }
        ExtFmFile extFmFile = (ExtFmFile)JsonUtil.buildNormalBinder().getJsonToObject(channelRest.getChannelSubStr(), ExtFmFile.class);
        if (null != extFmFile && StringUtils.isNotBlank((CharSequence)extFmFile.getFileCode())) {
            cmChannelBarDomain.setChannelBarFilecode(extFmFile.getFileCode());
            cmChannelBarDomain.setChannelBarFilename(extFmFile.getFileName());
            cmChannelBarDomain.setChannelBarFilepath(extFmFile.getFileUrl());
            this.cmChannelBarService.updateChannelBar(cmChannelBarDomain);
        } else if ("No Bill Exist".equals(channelRest.getRestMemo())) {
            this.cmChannelBarService.updateBarState(cmChannelBarDomain, ChannelBarStateEnum.CHANNEL_BAR_NO_BILL_EXIST.getCode(), cmChannelBarDomain.getDataState());
        } else {
            this.logger.error("BILL_DOWNLOAD_FAIL", (Object)String.format("tenantCode:%s, fchannelCode: %s errMsg:%s", cmChannelBarDomain.getTenantCode(), cmChannelBarDomain.getFchannelType(), channelRest.getRestMemo()));
            this.cmChannelBarService.updateBarState(cmChannelBarDomain, ChannelBarStateEnum.CHANNEL_BAR_DOWNLOAD_ERROR.getCode(), cmChannelBarDomain.getDataState());
        }
    }

    private CmChannelBar getCmChannelBar(String fchannelType, Date barDate, String tenantCode) {
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        stateMap.put("fchannelType", fchannelType);
        stateMap.put("barDate", DateUtil.getDateString((Date)barDate, (String)"yyyy-MM-dd"));
        stateMap.put("tenantCode", tenantCode);
        return this.cmChannelBarService.getCmChannelBarByState(stateMap);
    }

    private ChannelRest retryDownloadTheBill(CmFBillChannel cmFBillChannel, Date billDate) {
        cmFBillChannel.setGmtCreate(billDate);
        cmFBillChannel.setMemo("retry");
        return this.downloadTheBill(cmFBillChannel);
    }

    private ChannelRest downloadTheBill(CmFBillChannel cmFBillChannel) {
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("extPtfchannel", JsonUtil.buildNormalBinder().toJson((Object)cmFBillChannel));
        try {
            String cr = this.internalInvoke("cmc.channelIn.channelSDownload", paramsMap);
            this.logger.debug(cr);
            return (ChannelRest)JsonUtil.buildNormalBinder().getJsonToObject(cr, ChannelRest.class);
        }
        catch (Exception e) {
            this.logger.error(cmFBillChannel.getFchannelType(), (Throwable)e);
            return null;
        }
    }

    private CmChannelBarReDomain getCmChannelBarDomain(Date channelBarDate, CmChannelBar ccb, CmFBillChannel cmFBillChannel) {
        CmChannelBarReDomain cmChannelBarDomain = new CmChannelBarReDomain();
        cmChannelBarDomain.setChannelBarDate(DateUtil.getDateString((Date)channelBarDate, (String)"yyyy-MM-dd HH:mm:ss"));
        cmChannelBarDomain.setChannelBarType(cmFBillChannel.getFchannelDr());
        cmChannelBarDomain.setFchannelType(cmFBillChannel.getFchannelType());
        cmChannelBarDomain.setTenantCode(cmFBillChannel.getTenantCode());
        if (null == ccb) {
            cmChannelBarDomain.setChannelBarSeqno(this.createUUIDString());
            cmChannelBarDomain.setDataState(ChannelBarStateEnum.CHANNEL_BAR_DOWNLOAD_DNS.getCode());
            this.cmChannelBarService.saveChannelBar(cmChannelBarDomain);
        } else {
            cmChannelBarDomain.setChannelBarSeqno(ccb.getChannelBarSeqno());
            cmChannelBarDomain.setDataState(ccb.getDataState());
        }
        return cmChannelBarDomain;
    }

    static {
        lock = new Object();
        lockCall = new Object();
        rlock = new Object();
    }
}

