/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.chargeProvided.recharge.service.impl;

import com.yqbsoft.laser.service.chargeProvided.recharge.dao.CpRechargeMapper;
import com.yqbsoft.laser.service.chargeProvided.recharge.domain.CpRechargeDomain;
import com.yqbsoft.laser.service.chargeProvided.recharge.model.CpRecharge;
import com.yqbsoft.laser.service.chargeProvided.recharge.service.CpRechargeService;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtePtradeDomain;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtradeBean;
import com.yqbsoft.laser.service.chargeProvided.trade.enumc.PtradpdeEnum;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CpRechargeServiceImpl
extends BaseServiceImpl
implements CpRechargeService {
    public static final String SYS_CODE = "cp.CpRechargeServiceImpl";
    private CpRechargeMapper cpRechargeMapper;

    public void setCpRechargeMapper(CpRechargeMapper cpRechargeMapper) {
        this.cpRechargeMapper = cpRechargeMapper;
    }

    private Date getSysDate() {
        try {
            return this.cpRechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecharge(CpRechargeDomain cpRechargeDomain) {
        if (null == cpRechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (null == cpRechargeDomain.getRechargeMoney()) {
            msg = msg + "RechargeMoney\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getFchannelCode())) {
            msg = msg + "FchannelCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getFaccountId())) {
            msg = msg + "FaccountId\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpRechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRechargeDefault(CpRecharge cpRecharge) {
        if (null == cpRecharge) {
            return;
        }
        if (null == cpRecharge.getDataState()) {
            cpRecharge.setDataState(0);
        }
        if (null == cpRecharge.getGmtCreate()) {
            cpRecharge.setGmtCreate(this.getSysDate());
        }
        cpRecharge.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cpRecharge.getRechargeCode())) {
            cpRecharge.setRechargeCode(this.createUUIDString());
        }
    }

    private void setRechargeUpdataDefault(CpRecharge cpRecharge) {
        if (null == cpRecharge) {
            return;
        }
        cpRecharge.setGmtModified(this.getSysDate());
    }

    private void saveRechargeModel(CpRecharge cpRecharge) throws ApiException {
        if (null == cpRecharge) {
            return;
        }
        try {
            this.cpRechargeMapper.insert(cpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.saveRechargeModel.ex", (Throwable)e);
        }
    }

    private CpRecharge getRechargeModelById(Integer rechargeId) {
        if (null == rechargeId) {
            return null;
        }
        try {
            return this.cpRechargeMapper.selectByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.getRechargeModelById", (Throwable)e);
            return null;
        }
    }

    public CpRecharge getRechargeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cpRechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.getRechargeModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRechargeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cpRechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.delRechargeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cp.CpRechargeServiceImpl.delRechargeModelByCode.num");
        }
    }

    private void deleteRechargeModel(Integer rechargeId) throws ApiException {
        if (null == rechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.cpRechargeMapper.deleteByPrimaryKey(rechargeId);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.deleteRechargeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cp.CpRechargeServiceImpl.deleteRechargeModel.num");
        }
    }

    private void updateRechargeModel(CpRecharge cpRecharge) throws ApiException {
        if (null == cpRecharge) {
            return;
        }
        try {
            this.cpRechargeMapper.updateByPrimaryKeySelective(cpRecharge);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRechargeModel.ex", (Throwable)e);
        }
    }

    private void updateStateRechargeModel(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == rechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeId", rechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.cpRechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateStateRechargeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateStateRechargeModel.null");
        }
    }

    private CpRecharge makeRecharge(CpRechargeDomain cpRechargeDomain, CpRecharge cpRecharge) {
        if (null == cpRechargeDomain) {
            return null;
        }
        if (null == cpRecharge) {
            cpRecharge = new CpRecharge();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cpRecharge, (Object)cpRechargeDomain);
            return cpRecharge;
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.makeRecharge", (Throwable)e);
            return null;
        }
    }

    private List<CpRecharge> queryRechargeModelPage(Map<String, Object> parammap) {
        try {
            return this.cpRechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.queryRechargeModel", (Throwable)e);
            return null;
        }
    }

    private int countRecharge(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cpRechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpRechargeServiceImpl.countRecharge", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveSendTrade(CpRechargeDomain cpRechargeDomain) {
        String rechargeCode = this.saveRecharge(cpRechargeDomain);
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setTenantCode(cpRechargeDomain.getTenantCode());
        ptePtradeDomain.setPartnerCode(cpRechargeDomain.getPartnerCode());
        ptePtradeDomain.setMerchantCode(cpRechargeDomain.getUserinfoCode());
        ptePtradeDomain.setFchannelPmodeCode(cpRechargeDomain.getFchannelPmodeCode());
        ptePtradeDomain.setOrderAmount(cpRechargeDomain.getRechargeMoney());
        ptePtradeDomain.setOpuserCode(cpRechargeDomain.getUserinfoCode());
        ptePtradeDomain.setOpuserName(cpRechargeDomain.getUserinfoName());
        ptePtradeDomain.setBusinessOrderno(rechargeCode);
        ptePtradeDomain.setAcquireSeqno(rechargeCode);
        ptePtradeDomain.setPtradeType("01");
        ptePtradeDomain.setBusinessOrder(rechargeCode);
        ptePtradeDomain.setPaymentMemo("\u5145\u503c");
        ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.RECHARGE.getCode());
        ptePtradeDomain.settPaymentInfoOperator(cpRechargeDomain.getUserName());
        ptePtradeDomain.setPaymentTecode("");
        ptePtradeDomain.setPaymentReturnurl("cp.recharge.updateRechargeStatubyTrade");
        ptePtradeDomain.setPaymentNotifyurl("cp.recharge.updateRechargeStatubyTrade");
        ConcurrentHashMap<String, String> queryMap = new ConcurrentHashMap<String, String>();
        queryMap.put("ptePtradeDomain", JsonUtil.buildNormalBinder().toJson((Object)ptePtradeDomain));
        String result = this.internalInvoke("pte.ptrade.sendSavePtrade", queryMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("cp.CpRechargeServiceImpl.saveRecharge.checkRecharge", "\u8c03\u7528\u4ea4\u6613\u5f15\u64ce\u5931\u8d25\uff01");
        }
        return result;
    }

    @Override
    public String saveRecharge(CpRechargeDomain cpRechargeDomain) throws ApiException {
        String msg = this.checkRecharge(cpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cp.CpRechargeServiceImpl.saveRecharge.checkRecharge", msg);
        }
        CpRecharge cpRecharge = this.makeRecharge(cpRechargeDomain, null);
        this.setRechargeDefault(cpRecharge);
        this.saveRechargeModel(cpRecharge);
        return cpRecharge.getRechargeCode();
    }

    @Override
    public void updateRechargeState(Integer rechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateRechargeModel(rechargeId, dataState, oldDataState, map);
        if (2 == dataState) {
            CpRecharge cpRecharge = this.getRecharge(rechargeId);
            if (null == cpRecharge) {
                throw new ApiException("cp.CpRechargeServiceImpl.updateRechargeState.null");
            }
            this.sendPay(cpRecharge, map);
        }
    }

    private PtradeBean makeParticipant(CpRecharge cpRecharge) {
        if (null == cpRecharge) {
            return null;
        }
        PtradeBean pb = new PtradeBean();
        String fundType = cpRecharge.getFundType();
        if (StringUtils.isBlank((String)fundType)) {
            fundType = "01";
        }
        pb.setTenantCode(cpRecharge.getTenantCode());
        pb.setFchannelPmodeCode(cpRecharge.getFchannelPmodeCode());
        pb.setFchannelMode("0");
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        String code = cpRecharge.getUserinfoCode().substring(0, 1);
        PtePtradeParticipantDomain pd1 = new PtePtradeParticipantDomain();
        pd1.setDicActorCode("BUY_B");
        pd1.setFaccountId(cpRecharge.getFaccountId());
        pd1.setFchannelCode("0" + code);
        pd1.setFchannelClassifyCode(code + fundType);
        pd1.setOrderAmount(cpRecharge.getRechargeMoney());
        pd1.setFundType(fundType);
        partList.add(pd1);
        pb.setPartList(partList);
        if (StringUtils.isNotBlank((String)cpRecharge.getFchannelCode())) {
            PtePtradeParticipantDomain pd2 = new PtePtradeParticipantDomain();
            pd2.setDicActorCode("BANK");
            pd2.setFundType(fundType);
            pd2.setFchannelCode(cpRecharge.getFchannelCode());
            pd2.setFchannelClassifyCode(cpRecharge.getFchannelClassifyCode());
            pd2.setOrderAmount(cpRecharge.getRechargeMoney());
            partList.add(pd2);
        }
        return pb;
    }

    private void sendPay(CpRecharge cpRecharge, Map<String, Object> map) {
        if (null == cpRecharge) {
            return;
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        ptePtradeDomain.setOrderOamount(cpRecharge.getRechargeMoney());
        ptePtradeDomain.setOrderAmount(cpRecharge.getRechargeMoney());
        ptePtradeDomain.setPtradeType(cpRecharge.getRechargeType());
        ptePtradeDomain.setAcquireSeqno(cpRecharge.getRechargeCode());
        ptePtradeDomain.setPartnerCode(cpRecharge.getUserinfoCode());
        ptePtradeDomain.setBusinessOrderno(cpRecharge.getRechargeCode());
        ptePtradeDomain.setBusinessOrder(cpRecharge.getRechargeCode());
        ptePtradeDomain.setPaymentMemo((null == cpRecharge.getRechargeOpcode() ? "" : cpRecharge.getRechargeOpcode()) + (null == cpRecharge.getRechargeName() ? "\u5145\u503c" : cpRecharge.getRechargeName()));
        ptePtradeDomain.setOpuserCode(cpRecharge.getUserinfoCode());
        ptePtradeDomain.setOpuserName(cpRecharge.getUserinfoName());
        if ("0".equals(cpRecharge.getRechargeMode())) {
            ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.RECHARGE.getCode());
        } else {
            ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.RECHARGEULINE.getCode());
        }
        ptePtradeDomain.setTenantCode(cpRecharge.getTenantCode());
        ptePtradeDomain.setMerchantCode(cpRecharge.getUserinfoCode());
        ptePtradeDomain.setFchannelPmodeCode(cpRecharge.getFchannelPmodeCode());
        if (null != map && !map.isEmpty()) {
            ptePtradeDomain.setExtension(JsonUtil.buildNormalBinder().toJson(map));
        }
        ptePtradeDomain.setPaymentNotifyurl("cp.recharge.updateRechargeStatubyTrade");
        PtradeBean ptradeBean = this.makeParticipant(cpRecharge);
        ptePtradeDomain.setPtradeBean(ptradeBean);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("ptePtradeDomain", JsonUtil.buildNormalBinder().toJson((Object)ptePtradeDomain));
        String result = this.internalInvoke("pte.ptrade.sendSavePtrade", queryMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("cp.CpRechargeServiceImpl.sendPay.send", "\u8c03\u7528\u4ea4\u6613\u5f15\u64ce\u5931\u8d25\uff01");
        }
    }

    @Override
    public void updateRecharge(CpRechargeDomain cpRechargeDomain) throws ApiException {
        String msg = this.checkRecharge(cpRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRecharge.checkRecharge", msg);
        }
        CpRecharge oldCpRecharge = this.getRechargeModelById(cpRechargeDomain.getRechargeId());
        if (null == oldCpRecharge) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRecharge.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CpRecharge cpRecharge = this.makeRecharge(cpRechargeDomain, oldCpRecharge);
        this.setRechargeUpdataDefault(cpRecharge);
        this.updateRechargeModel(cpRecharge);
    }

    @Override
    public CpRecharge getRecharge(Integer rechargeId) {
        return this.getRechargeModelById(rechargeId);
    }

    @Override
    public void deleteRecharge(Integer rechargeId) throws ApiException {
        CpRecharge cpRecharge = this.getRechargeModelById(rechargeId);
        if (null == cpRecharge) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRecharge.null", "\u6570\u636e\u4e0d\u5b58\u5728\uff01");
        }
        if (cpRecharge.getRechargeMode().equals("0") || cpRecharge.getDataState() == 2) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRecharge.null", "\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
        }
        this.deleteRechargeModel(rechargeId);
    }

    @Override
    public QueryResult<CpRecharge> queryRechargePage(Map<String, Object> map) {
        List<CpRecharge> cpRechargeList = this.queryRechargeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecharge(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cpRechargeList);
        return queryResult;
    }

    @Override
    public CpRecharge getRechargeByCode(Map<String, Object> map) {
        return this.getRechargeModelByCode(map);
    }

    @Override
    public void delRechargeByCode(Map<String, Object> map) throws ApiException {
        this.delRechargeModelByCode(map);
    }

    @Override
    public boolean updateRechargeStatubyTrade(Map<String, Object> map) {
        Integer dataState;
        if (map == null) {
            this.logger.error("cp.CpRechargeServiceImpl.updateRechargeStatubyTrade.null", (Object)"\u53c2\u6570\u4e3a\u7a7a\uff01");
            return false;
        }
        String rechargeCode = map.get("businessOrderno") != null ? (String)map.get("businessOrderno") : null;
        String tenantCode = map.get("tenantCode") != null ? (String)map.get("tenantCode") : null;
        Integer n = dataState = map.get("dataState") != null ? (Integer)map.get("dataState") : null;
        if (StringUtils.isBlank((String)rechargeCode) || dataState == null) {
            this.logger.error("cp.CpRechargeServiceImpl.updateRechargeStatubyTrade.null", (Object)"rechargeCode or dataState is null\uff01");
            return false;
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("rechargeCode", rechargeCode);
        pmap.put("tenantCode", tenantCode);
        CpRecharge cpRecharge = this.getRechargeByCode(pmap);
        if (cpRecharge == null) {
            throw new ApiException("cp.CpRechargeServiceImpl.updateRechargeStatubyTrade.null", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (dataState == cpRecharge.getDataState()) {
            return true;
        }
        this.updateRechargeState(cpRecharge.getRechargeId(), dataState, cpRecharge.getDataState(), null);
        if (StringUtils.isNotBlank((String)cpRecharge.getRechargeName()) && cpRecharge.getRechargeName().equals("UCC") && dataState.equals("5")) {
            this.logger.debug("cp.CpRechargeServiceImpl.updateRechargeStatubyTrade", (Object)("cpRecharge" + JsonUtil.buildNormalBinder().toJson((Object)cpRecharge)));
            ConcurrentHashMap<String, String> queryMap = new ConcurrentHashMap<String, String>();
            queryMap.put("map", JsonUtil.buildNormalBinder().toJson((Object)cpRecharge));
            String str = this.internalInvoke("omns.ucc.saveUserRechargeCardSynchronization", queryMap);
        }
        return true;
    }

    @Override
    public void saveRechargeTradeBack(String rechargeCode, String tenantCode) {
        if (StringUtils.isBlank((String)rechargeCode)) {
            throw new ApiException("cp.CpRechargeServiceImpl.saveRechargeTradeBack.null", "\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("rechargeCode", rechargeCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", 2);
        CpRecharge recharge = this.getRechargeByCode(map);
        if (recharge == null) {
            throw new ApiException("cp.CpRechargeServiceImpl.saveRechargeTradeBack.null", "\u6570\u636e\u4e0d\u80fd\u5220\u9664\uff01");
        }
        ConcurrentHashMap<String, String> queryMap = new ConcurrentHashMap<String, String>();
        queryMap.put("tenantCode", tenantCode);
        queryMap.put("acquireSeqno", rechargeCode);
        queryMap.put("ptradpdeCode", "CHARGEBACK");
        this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", queryMap);
        recharge.setDataState(3);
        this.updateRechargeModel(recharge);
    }
}

