/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.chargeProvided.withdraw.service.impl;

import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtePtradeDomain;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtePtradeParticipantDomain;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.PtradeBean;
import com.yqbsoft.laser.service.chargeProvided.trade.domain.UserbankBean;
import com.yqbsoft.laser.service.chargeProvided.trade.enumc.PtradpdeEnum;
import com.yqbsoft.laser.service.chargeProvided.withdraw.dao.CpWithdrawMapper;
import com.yqbsoft.laser.service.chargeProvided.withdraw.domain.CpWithdrawDomain;
import com.yqbsoft.laser.service.chargeProvided.withdraw.domain.MnsMnslistDomainBean;
import com.yqbsoft.laser.service.chargeProvided.withdraw.model.CpWithdraw;
import com.yqbsoft.laser.service.chargeProvided.withdraw.service.CpWithdrawService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CpWithdrawServiceImpl
extends BaseServiceImpl
implements CpWithdrawService {
    public static final String SYS_CODE = "cp.CpWithdrawServiceImpl";
    private CpWithdrawMapper cpWithdrawMapper;

    public void setCpWithdrawMapper(CpWithdrawMapper cpWithdrawMapper) {
        this.cpWithdrawMapper = cpWithdrawMapper;
    }

    private Date getSysDate() {
        try {
            return this.cpWithdrawMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkWithdraw(CpWithdrawDomain cpWithdrawDomain) {
        if (null == cpWithdrawDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)cpWithdrawDomain.getTenantCode())) {
            msg = msg + "\u79df\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpWithdrawDomain.getFaccountId())) {
            msg = msg + "\u8d26\u6237ID\u4e3a\u7a7a;";
        }
        if (cpWithdrawDomain.getWithdrawMoney() == null) {
            msg = msg + "\u91d1\u989d\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpWithdrawDomain.getUserCode())) {
            msg = msg + "\u7528\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpWithdrawDomain.getUserbankNo())) {
            msg = msg + "\u63d0\u73b0\u8d26\u53f7\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)cpWithdrawDomain.getFchannelPmodeCode())) {
            msg = msg + "\u6e20\u9053\u7ec8\u7aef\u7f16\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setWithdrawDefault(CpWithdraw cpWithdraw) {
        if (null == cpWithdraw) {
            return;
        }
        if (null == cpWithdraw.getDataState()) {
            cpWithdraw.setDataState(0);
        }
        if (null == cpWithdraw.getGmtCreate()) {
            cpWithdraw.setGmtCreate(this.getSysDate());
        }
        cpWithdraw.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)cpWithdraw.getWithdrawCode())) {
            cpWithdraw.setWithdrawCode(this.createUUIDString());
        }
    }

    private int getWithdrawMaxCode() {
        int code = 0;
        try {
            return this.cpWithdrawMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.getWithdrawMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setWithdrawUpdataDefault(CpWithdraw cpWithdraw) {
        if (null == cpWithdraw) {
            return;
        }
        cpWithdraw.setGmtModified(this.getSysDate());
    }

    private void saveWithdrawModel(CpWithdraw cpWithdraw) throws ApiException {
        if (null == cpWithdraw) {
            return;
        }
        try {
            this.cpWithdrawMapper.insert(cpWithdraw);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.saveWithdrawModel.ex", (Throwable)e);
        }
    }

    private CpWithdraw getWithdrawModelById(Integer withdrawId) {
        if (null == withdrawId) {
            return null;
        }
        try {
            return this.cpWithdrawMapper.selectByPrimaryKey(withdrawId);
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.getWithdrawModelById", (Throwable)e);
            return null;
        }
    }

    public CpWithdraw getWithdrawModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.cpWithdrawMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.getWithdrawModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delWithdrawModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.cpWithdrawMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.delWithdrawModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cp.CpWithdrawServiceImpl.delWithdrawModelByCode.num");
        }
    }

    private void deleteWithdrawModel(Integer withdrawId) throws ApiException {
        if (null == withdrawId) {
            return;
        }
        int i = 0;
        try {
            i = this.cpWithdrawMapper.deleteByPrimaryKey(withdrawId);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.deleteWithdrawModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cp.CpWithdrawServiceImpl.deleteWithdrawModel.num");
        }
    }

    private void updateWithdrawModel(CpWithdraw cpWithdraw) throws ApiException {
        if (null == cpWithdraw) {
            return;
        }
        try {
            this.cpWithdrawMapper.updateByPrimaryKeySelective(cpWithdraw);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdrawModel.ex", (Throwable)e);
        }
    }

    private void updateStateWithdrawModel(Integer withdrawId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == withdrawId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("withdrawId", withdrawId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.cpWithdrawMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateStateWithdrawModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateStateWithdrawModel.null");
        }
    }

    private CpWithdraw makeWithdraw(CpWithdrawDomain cpWithdrawDomain, CpWithdraw cpWithdraw) {
        if (null == cpWithdrawDomain) {
            return null;
        }
        if (null == cpWithdraw) {
            cpWithdraw = new CpWithdraw();
        }
        try {
            BeanUtils.copyAllPropertys((Object)cpWithdraw, (Object)cpWithdrawDomain);
            return cpWithdraw;
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.makeWithdraw", (Throwable)e);
            return null;
        }
    }

    private List<CpWithdraw> queryWithdrawModelPage(Map<String, Object> parammap) {
        try {
            return this.cpWithdrawMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.queryWithdrawModel", (Throwable)e);
            return null;
        }
    }

    private int countWithdraw(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.cpWithdrawMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cp.CpWithdrawServiceImpl.countWithdraw", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveWithdraw(CpWithdrawDomain cpWithdrawDomain) throws ApiException {
        CpWithdraw cpWithdraw = this.saveModle(cpWithdrawDomain);
        return cpWithdraw.getWithdrawCode();
    }

    private CpWithdraw saveModle(CpWithdrawDomain cpWithdrawDomain) {
        String msg = this.checkWithdraw(cpWithdrawDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cp.CpWithdrawServiceImpl.saveWithdraw.checkWithdraw", msg);
        }
        CpWithdraw cpWithdraw = this.makeWithdraw(cpWithdrawDomain, null);
        this.setWithdrawDefault(cpWithdraw);
        this.saveWithdrawModel(cpWithdraw);
        return cpWithdraw;
    }

    @Override
    public void updateWithdrawState(Integer withdrawId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateWithdrawModel(withdrawId, dataState, oldDataState);
        if (1 == dataState) {
            CpWithdraw cpWithdraw = this.getWithdraw(withdrawId);
            this.sendPay(cpWithdraw);
        }
    }

    @Override
    public void updateWithdraw(CpWithdrawDomain cpWithdrawDomain) throws ApiException {
        this.logger.error("cp.CpWithdrawServiceImpl.updateWithdraw s=====\u63d0\u73b0.\u4fee\u6539=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpWithdrawDomain));
        String msg = this.checkWithdraw(cpWithdrawDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdraw.checkWithdraw", msg);
        }
        CpWithdraw oldCpWithdraw = this.getWithdrawModelById(cpWithdrawDomain.getWithdrawId());
        if (null == oldCpWithdraw) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdraw.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CpWithdraw cpWithdraw = this.makeWithdraw(cpWithdrawDomain, oldCpWithdraw);
        this.setWithdrawUpdataDefault(cpWithdraw);
        this.updateWithdrawModel(cpWithdraw);
        this.logger.error("cp.CpWithdrawServiceImpl.updateWithdraw e=====\u63d0\u73b0.\u4fee\u6539=====", (Object)JsonUtil.buildNormalBinder().toJson((Object)cpWithdraw));
    }

    @Override
    public CpWithdraw getWithdraw(Integer withdrawId) {
        return this.getWithdrawModelById(withdrawId);
    }

    @Override
    public void deleteWithdraw(Integer withdrawId) throws ApiException {
        this.deleteWithdrawModel(withdrawId);
    }

    @Override
    public QueryResult<CpWithdraw> queryWithdrawPage(Map<String, Object> map) {
        List<CpWithdraw> cpWithdrawList = this.queryWithdrawModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countWithdraw(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(cpWithdrawList);
        return queryResult;
    }

    @Override
    public CpWithdraw getWithdrawByCode(Map<String, Object> map) {
        return this.getWithdrawModelByCode(map);
    }

    @Override
    public void delWithdrawByCode(Map<String, Object> map) throws ApiException {
        this.delWithdrawModelByCode(map);
    }

    @Override
    public String saveWithdrawToPte(CpWithdrawDomain cpWithdrawDomain) throws ApiException {
        CpWithdraw cpWithdraw = this.saveModle(cpWithdrawDomain);
        return this.sendPay(cpWithdraw);
    }

    private String sendPay(CpWithdraw cpWithdraw) {
        if (null == cpWithdraw) {
            return "";
        }
        PtePtradeDomain ptePtradeDomain = new PtePtradeDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ptePtradeDomain, (Object)cpWithdraw);
        }
        catch (Exception e) {
            throw new ApiException("cp.CpWithdrawServiceImpl.copyAllPropertys");
        }
        ptePtradeDomain.setOpuserCode(cpWithdraw.getUserCode());
        ptePtradeDomain.setOpuserName(cpWithdraw.getUserName());
        UserbankBean userBankBean = new UserbankBean();
        userBankBean.setFaccountId(cpWithdraw.getUserbankNo());
        userBankBean.setFaccountName(cpWithdraw.getUserbankName());
        userBankBean.setFaccountBranch(cpWithdraw.getFchannelBankCode());
        ptePtradeDomain.setMerchantCode(cpWithdraw.getUserCode());
        ptePtradeDomain.setAcquireSeqno(cpWithdraw.getWithdrawCode());
        ptePtradeDomain.setBusinessOrderno(cpWithdraw.getWithdrawCode());
        ptePtradeDomain.setBusinessOrder(cpWithdraw.getWithdrawCode());
        ptePtradeDomain.setPaymentMemo(null == cpWithdraw.getWithdrawRemark() ? "\u63d0\u73b0" : cpWithdraw.getWithdrawRemark());
        ptePtradeDomain.setPtradeType(null == cpWithdraw.getWithdrawType() ? "02" : cpWithdraw.getWithdrawType());
        ptePtradeDomain.setOrderAmount(cpWithdraw.getWithdrawMoney());
        ptePtradeDomain.setBusinessType("C02");
        ptePtradeDomain.setFchannelPmodeCode(cpWithdraw.getFchannelPmodeCode());
        HashMap<String, UserbankBean> map = new HashMap<String, UserbankBean>();
        map.put("BANK", userBankBean);
        ptePtradeDomain.setExtension(JsonUtil.buildNormalBinder().toJson(map));
        ptePtradeDomain.setPtradeExtension(JsonUtil.buildNormalBinder().toJson(map));
        ptePtradeDomain.setPtradpdeCode(PtradpdeEnum.WITHDRAW.getCode());
        ptePtradeDomain.setPaymentNotifyurl("cp.withdraw.updateWithdrawToPteBack");
        PtradeBean ptradeBean = this.makeParticipant(cpWithdraw);
        ptePtradeDomain.setPtradeBean(ptradeBean);
        HashMap<String, String> queryMap = new HashMap<String, String>();
        queryMap.put("ptePtradeDomain", JsonUtil.buildNormalBinder().toJson((Object)ptePtradeDomain));
        String result = this.internalInvoke("pte.ptrade.sendSavePtrade", queryMap);
        if (StringUtils.isBlank((String)result)) {
            throw new ApiException("cp.CpWithdrawServiceImpl.saveWithdrawToPte.pte.ptrade.sendSavePtrade", "\u8c03\u7528\u4ea4\u6613\u5f15\u64ce\u5931\u8d25\uff01");
        }
        return result;
    }

    private PtradeBean makeParticipant(CpWithdraw cpWithdraw) {
        PtePtradeParticipantDomain pd2;
        if (null == cpWithdraw) {
            return null;
        }
        if (null == cpWithdraw.getWithdrawFee()) {
            cpWithdraw.setWithdrawFee(BigDecimal.ZERO);
        }
        PtradeBean pb = new PtradeBean();
        pb.setTenantCode(cpWithdraw.getTenantCode());
        pb.setFchannelPmodeCode(cpWithdraw.getFchannelPmodeCode());
        pb.setFchannelMode("0");
        ArrayList<PtePtradeParticipantDomain> partList = new ArrayList<PtePtradeParticipantDomain>();
        String code = cpWithdraw.getUserCode().substring(0, 1);
        PtePtradeParticipantDomain pd1 = new PtePtradeParticipantDomain();
        pd1.setDicActorCode("BUY_B");
        pd1.setFaccountId(cpWithdraw.getFaccountId());
        pd1.setFchannelCode("0" + code);
        pd1.setFchannelClassifyCode(code + "01");
        pd1.setOrderAmount(cpWithdraw.getWithdrawMoney().add(cpWithdraw.getWithdrawFee()));
        partList.add(pd1);
        pb.setPartList(partList);
        if (StringUtils.isNotBlank((String)cpWithdraw.getFchannelCode())) {
            pd2 = new PtePtradeParticipantDomain();
            pd2.setDicActorCode("BANK");
            pd2.setFundType(cpWithdraw.getFundType());
            pd2.setFchannelCode(cpWithdraw.getFchannelCode());
            pd2.setFchannelClassifyCode(cpWithdraw.getFchannelClassifyCode());
            pd2.setOrderAmount(cpWithdraw.getWithdrawMoney());
            partList.add(pd2);
        }
        if (null != cpWithdraw.getWithdrawFee() && cpWithdraw.getWithdrawFee().compareTo(BigDecimal.ZERO) > 0) {
            pd2 = new PtePtradeParticipantDomain();
            pd2.setDicActorCode("BUYFEE");
            pd2.setFundType("01");
            pd2.setFchannelCode("09");
            pd2.setFchannelClassifyCode("903");
            pd2.setOrderAmount(cpWithdraw.getWithdrawFee());
            partList.add(pd2);
        }
        return pb;
    }

    @Override
    public boolean updateWithdrawToPteBack(Map<String, Object> map) throws ApiException {
        if (map == null || map.isEmpty()) {
            return false;
        }
        String rechargeCode = (String)map.get("acquireSeqno");
        String tenantCode = (String)map.get("tenantCode");
        Integer dataState = (Integer)map.get("dataState");
        if (StringUtils.isBlank((String)rechargeCode) || dataState == null) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdrawToPteBack.null", "\u53c2\u6570\u4e3a\u7a7a\uff01");
        }
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("withdrawCode", rechargeCode);
        pmap.put("tenantCode", tenantCode);
        CpWithdraw cpWithdraw = this.getWithdrawByCode(pmap);
        if (cpWithdraw == null) {
            throw new ApiException("cp.CpWithdrawServiceImpl.updateWithdrawToPteBack.null", "\u67e5\u8be2\u8ba2\u5355\u4fe1\u606f\u5931\u8d25\uff01");
        }
        if (dataState == cpWithdraw.getDataState()) {
            return true;
        }
        this.updateStateWithdrawModel(cpWithdraw.getWithdrawId(), dataState, cpWithdraw.getDataState());
        return true;
    }

    @Override
    public void updateWithdrawStateAndUser(Integer withdrawId, Integer dataState, Integer oldDataState, String userName, String userCode) throws ApiException {
        this.logger.error("cp.CpWithdrawServiceImpl.updateWithdrawStateAndUser", (Object)"====================================\u63d0\u73b0\u72b6\u6001\u66f4\u65b0====================================");
        this.logger.error("cp.CpWithdrawServiceImpl.updateWithdrawStateAndUser", (Object)("====================================dataState->" + dataState + "===================================="));
        CpWithdraw withdraw = this.getWithdraw(withdrawId);
        withdraw.setMemo(userName);
        this.updateWithdrawModel(withdraw);
        this.updateStateWithdrawModel(withdrawId, dataState, oldDataState);
        if (1 == dataState) {
            withdraw.setUserName(withdraw.getUserbankName());
            this.sendPay(withdraw);
        }
        this.logger.error("cp.CpWithdrawServiceImpl.updateWithdrawStateAndUser", (Object)"====================================\u53d1\u9001\u6d88\u606f====================================");
        MnsMnslistDomainBean mnsMnslistDomainBean = new MnsMnslistDomainBean();
        mnsMnslistDomainBean.setMnslistBustype("cp" + dataState);
        mnsMnslistDomainBean.setMnslistBusname("\u63d0\u73b0\u72b6\u6001\u66f4\u65b0");
        mnsMnslistDomainBean.setMemberCode(withdraw.getUserCode());
        mnsMnslistDomainBean.setDataTenant(withdraw.getTenantCode());
        mnsMnslistDomainBean.setMnslistPush(0);
        mnsMnslistDomainBean.setTenantCode(withdraw.getTenantCode());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("imsgSuserCode", "sys");
        map.put("imsgSuserName", "sys");
        ArrayList receiverList = new ArrayList();
        HashMap<String, String> listReceiver = new HashMap<String, String>();
        listReceiver.put("code", withdraw.getUserCode());
        listReceiver.put("name", withdraw.getUserName());
        listReceiver.put("withdraw", JsonUtil.buildNonEmptyBinder().toJson((Object)withdraw));
        receiverList.add(listReceiver);
        map.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        HashMap paramMap = new HashMap();
        map.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        mnsMnslistDomainBean.setMnslistExp(JsonUtil.buildNonDefaultBinder().toJson(map));
        this.logger.error("cp.CpWithdrawServiceImpl.sendTestForJsonNotice", (Object)("============================================mnsMnslistDomainBean->" + JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnslistDomainBean) + "============================================"));
        try {
            HashMap<String, String> mnsMap = new HashMap<String, String>();
            mnsMap.put("mnsMnslistDomainBean", JsonUtil.buildNonEmptyBinder().toJson((Object)mnsMnslistDomainBean));
            this.getInternalRouter().inInvoke("mns.ser.sendMnslist", mnsMap);
        }
        catch (Exception e) {
            this.logger.error(".saveGoodsInfo.checkGoodsNoApiCode.resourceGoodsList", (Object)"=================\u53d1\u9001\u6d88\u606f\u5931\u8d25\uff01");
        }
    }
}

