/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.consult.service.impl;

import com.yqbsoft.laser.service.consult.dao.CsConsultListMapper;
import com.yqbsoft.laser.service.consult.dao.CsConsultMapper;
import com.yqbsoft.laser.service.consult.domain.CsConsultDomain;
import com.yqbsoft.laser.service.consult.domain.CsConsultListDomain;
import com.yqbsoft.laser.service.consult.domain.CsConsultListReDomain;
import com.yqbsoft.laser.service.consult.domain.CsConsultReDomain;
import com.yqbsoft.laser.service.consult.model.CsConsult;
import com.yqbsoft.laser.service.consult.model.CsConsultList;
import com.yqbsoft.laser.service.consult.service.CsConsultService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CsConsultServiceImpl
extends BaseServiceImpl
implements CsConsultService {
    private static final String SYS_CODE = "cs.CsConsultServiceImpl";
    private CsConsultMapper csConsultMapper;
    private CsConsultListMapper csConsultListMapper;

    public void setCsConsultMapper(CsConsultMapper csConsultMapper) {
        this.csConsultMapper = csConsultMapper;
    }

    public void setCsConsultListMapper(CsConsultListMapper csConsultListMapper) {
        this.csConsultListMapper = csConsultListMapper;
    }

    private Date getSysDate() {
        try {
            return this.csConsultMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkConsult(CsConsultDomain csConsultDomain) {
        if (null == csConsultDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)csConsultDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setConsultDefault(CsConsult csConsult) {
        if (null == csConsult) {
            return;
        }
        if (null == csConsult.getDataState()) {
            csConsult.setDataState(0);
        }
        if (null == csConsult.getGmtCreate()) {
            csConsult.setGmtCreate(this.getSysDate());
        }
        csConsult.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)csConsult.getConsultCode())) {
            csConsult.setConsultCode(this.createUUIDString());
        }
    }

    private int getConsultMaxCode() {
        int code = 0;
        try {
            return this.csConsultMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.getConsultMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setConsultUpdataDefault(CsConsult csConsult) {
        if (null == csConsult) {
            return;
        }
        csConsult.setGmtModified(this.getSysDate());
    }

    private void saveConsultModel(CsConsult csConsult) throws ApiException {
        if (null == csConsult) {
            return;
        }
        try {
            this.csConsultMapper.insert(csConsult);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.saveConsultModel.ex", (Throwable)e);
        }
    }

    private void saveConsultBatchModel(List<CsConsult> csConsultList) throws ApiException {
        if (null == csConsultList || csConsultList.isEmpty()) {
            return;
        }
        try {
            this.csConsultMapper.insertBatch(csConsultList);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.saveConsultBatchModel.ex", (Throwable)e);
        }
    }

    private CsConsult getConsultModelById(Integer consultId) {
        if (null == consultId) {
            return null;
        }
        try {
            return this.csConsultMapper.selectByPrimaryKey(consultId);
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.getConsultModelById", (Throwable)e);
            return null;
        }
    }

    private CsConsult getConsultModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.csConsultMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.getConsultModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delConsultModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.csConsultMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.delConsultModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cs.CsConsultServiceImpl.delConsultModelByCode.num");
        }
    }

    private void deleteConsultModel(Integer consultId) throws ApiException {
        if (null == consultId) {
            return;
        }
        int i = 0;
        try {
            i = this.csConsultMapper.deleteByPrimaryKey(consultId);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.deleteConsultModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cs.CsConsultServiceImpl.deleteConsultModel.num");
        }
    }

    private void updateConsultModel(CsConsult csConsult) throws ApiException {
        if (null == csConsult) {
            return;
        }
        int i = 0;
        try {
            i = this.csConsultMapper.updateByPrimaryKeySelective(csConsult);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.updateConsultModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cs.CsConsultServiceImpl.updateConsultModel.num");
        }
    }

    private void updateStateConsultModel(Integer consultId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == consultId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("consultId", consultId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.csConsultMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.updateStateConsultModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cs.CsConsultServiceImpl.updateStateConsultModel.null");
        }
    }

    private void updateStateConsultModelByCode(String tenantCode, String consultCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)consultCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("consultCode", consultCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.csConsultMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.updateStateConsultModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cs.CsConsultServiceImpl.updateStateConsultModelByCode.null");
        }
    }

    private CsConsult makeConsult(CsConsultDomain csConsultDomain, CsConsult csConsult) {
        if (null == csConsultDomain) {
            return null;
        }
        if (null == csConsult) {
            csConsult = new CsConsult();
        }
        try {
            BeanUtils.copyAllPropertys((Object)csConsult, (Object)csConsultDomain);
            return csConsult;
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.makeConsult", (Throwable)e);
            return null;
        }
    }

    private CsConsultReDomain makeCsConsultReDomain(CsConsult csConsult) {
        if (null == csConsult) {
            return null;
        }
        CsConsultReDomain csConsultReDomain = new CsConsultReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)csConsultReDomain, (Object)csConsult);
            return csConsultReDomain;
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.makeCsConsultReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CsConsult> queryConsultModelPage(Map<String, Object> parammap) {
        try {
            return this.csConsultMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.queryConsultModel", (Throwable)e);
            return null;
        }
    }

    private int countConsult(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.csConsultMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.countConsult", (Throwable)e);
        }
        return i;
    }

    private CsConsult createCsConsult(CsConsultDomain csConsultDomain) {
        String msg = this.checkConsult(csConsultDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cs.CsConsultServiceImpl.saveConsult.checkConsult", msg);
        }
        CsConsult csConsult = this.makeConsult(csConsultDomain, null);
        this.setConsultDefault(csConsult);
        return csConsult;
    }

    private String checkConsultList(CsConsultListDomain csConsultListDomain) {
        if (null == csConsultListDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)csConsultListDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setConsultListDefault(CsConsultList csConsultList) {
        if (null == csConsultList) {
            return;
        }
        if (null == csConsultList.getDataState()) {
            csConsultList.setDataState(0);
        }
        if (null == csConsultList.getGmtCreate()) {
            csConsultList.setGmtCreate(this.getSysDate());
        }
        csConsultList.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)csConsultList.getConsultListCode())) {
            csConsultList.setConsultListCode(this.createUUIDString());
        }
    }

    private int getConsultListMaxCode() {
        int code = 0;
        try {
            return this.csConsultListMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.getConsultListMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setConsultListUpdataDefault(CsConsultList csConsultList) {
        if (null == csConsultList) {
            return;
        }
        csConsultList.setGmtModified(this.getSysDate());
    }

    private void saveConsultListModel(CsConsultList csConsultList) throws ApiException {
        if (null == csConsultList) {
            return;
        }
        try {
            this.csConsultListMapper.insert(csConsultList);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.saveConsultListModel.ex", (Throwable)e);
        }
    }

    private void saveConsultListBatchModel(List<CsConsultList> csConsultListList) throws ApiException {
        if (null == csConsultListList || csConsultListList.isEmpty()) {
            return;
        }
        try {
            this.csConsultListMapper.insertBatch(csConsultListList);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.saveConsultListBatchModel.ex", (Throwable)e);
        }
    }

    private CsConsultList getConsultListModelById(Integer consultListId) {
        if (null == consultListId) {
            return null;
        }
        try {
            return this.csConsultListMapper.selectByPrimaryKey(consultListId);
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.getConsultListModelById", (Throwable)e);
            return null;
        }
    }

    private CsConsultList getConsultListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.csConsultListMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.getConsultListModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delConsultListModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.csConsultListMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.delConsultListModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cs.CsConsultServiceImpl.delConsultListModelByCode.num");
        }
    }

    private void deleteConsultListModel(Integer consultListId) throws ApiException {
        if (null == consultListId) {
            return;
        }
        int i = 0;
        try {
            i = this.csConsultListMapper.deleteByPrimaryKey(consultListId);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.deleteConsultListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cs.CsConsultServiceImpl.deleteConsultListModel.num");
        }
    }

    private void updateConsultListModel(CsConsultList csConsultList) throws ApiException {
        if (null == csConsultList) {
            return;
        }
        int i = 0;
        try {
            i = this.csConsultListMapper.updateByPrimaryKeySelective(csConsultList);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.updateConsultListModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("cs.CsConsultServiceImpl.updateConsultListModel.num");
        }
    }

    private void updateStateConsultListModel(Integer consultListId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == consultListId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("consultListId", consultListId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.csConsultListMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.updateStateConsultListModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cs.CsConsultServiceImpl.updateStateConsultListModel.null");
        }
    }

    private void updateStateConsultListModelByCode(String tenantCode, String consultListCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)consultListCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("consultListCode", consultListCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.csConsultListMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("cs.CsConsultServiceImpl.updateStateConsultListModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("cs.CsConsultServiceImpl.updateStateConsultListModelByCode.null");
        }
    }

    private CsConsultList makeConsultList(CsConsultListDomain csConsultListDomain, CsConsultList csConsultList) {
        if (null == csConsultListDomain) {
            return null;
        }
        if (null == csConsultList) {
            csConsultList = new CsConsultList();
        }
        try {
            BeanUtils.copyAllPropertys((Object)csConsultList, (Object)csConsultListDomain);
            return csConsultList;
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.makeConsultList", (Throwable)e);
            return null;
        }
    }

    private CsConsultListReDomain makeCsConsultListReDomain(CsConsultList csConsultList) {
        if (null == csConsultList) {
            return null;
        }
        CsConsultListReDomain csConsultListReDomain = new CsConsultListReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)csConsultListReDomain, (Object)csConsultList);
            return csConsultListReDomain;
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.makeCsConsultListReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CsConsultList> queryConsultListModelPage(Map<String, Object> parammap) {
        try {
            return this.csConsultListMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.queryConsultListModel", (Throwable)e);
            return null;
        }
    }

    private int countConsultList(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.csConsultListMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("cs.CsConsultServiceImpl.countConsultList", (Throwable)e);
        }
        return i;
    }

    private CsConsultList createCsConsultList(CsConsultListDomain csConsultListDomain) {
        String msg = this.checkConsultList(csConsultListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cs.CsConsultServiceImpl.saveConsultList.checkConsultList", msg);
        }
        CsConsultList csConsultList = this.makeConsultList(csConsultListDomain, null);
        this.setConsultListDefault(csConsultList);
        return csConsultList;
    }

    @Override
    public String saveConsult(CsConsultDomain csConsultDomain) throws ApiException {
        CsConsult csConsult = this.createCsConsult(csConsultDomain);
        this.saveConsultModel(csConsult);
        return csConsult.getConsultCode();
    }

    @Override
    public String saveConsultBatch(List<CsConsultDomain> csConsultDomainList) throws ApiException {
        if (null == csConsultDomainList || csConsultDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CsConsult> csConsultList = new ArrayList<CsConsult>();
        String code = "";
        for (CsConsultDomain csConsultDomain : csConsultDomainList) {
            CsConsult csConsult = this.createCsConsult(csConsultDomain);
            code = csConsult.getConsultCode();
            csConsultList.add(csConsult);
        }
        this.saveConsultBatchModel(csConsultList);
        return code;
    }

    @Override
    public void updateConsultState(Integer consultId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateConsultModel(consultId, dataState, oldDataState);
    }

    @Override
    public void updateConsultStateByCode(String tenantCode, String consultCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateConsultModelByCode(tenantCode, consultCode, dataState, oldDataState);
    }

    @Override
    public void updateConsult(CsConsultDomain csConsultDomain) throws ApiException {
        String msg = this.checkConsult(csConsultDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cs.CsConsultServiceImpl.updateConsult.checkConsult", msg);
        }
        CsConsult oldCsConsult = this.getConsultModelById(csConsultDomain.getConsultId());
        if (null == oldCsConsult) {
            throw new ApiException("cs.CsConsultServiceImpl.updateConsult.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CsConsult csConsult = this.makeConsult(csConsultDomain, oldCsConsult);
        this.setConsultUpdataDefault(csConsult);
        this.updateConsultModel(csConsult);
    }

    private CsConsultReDomain makeList(CsConsult csConsult) {
        if (null == csConsult) {
            return null;
        }
        CsConsultReDomain csConsultReDomain = new CsConsultReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)csConsultReDomain, (Object)csConsult);
        }
        catch (Exception e) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("consultCode", csConsult.getConsultCode());
        parammap.put("tenantCode", csConsult.getTenantCode());
        List<CsConsultList> consultListlist = this.queryConsultListModelPage(parammap);
        if (null == consultListlist || consultListlist.isEmpty()) {
            return csConsultReDomain;
        }
        ArrayList<CsConsultListReDomain> reList = new ArrayList<CsConsultListReDomain>();
        for (CsConsultList csConsultList : consultListlist) {
            CsConsultListReDomain csConsultListReDomain = new CsConsultListReDomain();
            try {
                BeanUtils.copyAllPropertys((Object)csConsultListReDomain, (Object)csConsultList);
            }
            catch (Exception e) {
                return null;
            }
            reList.add(csConsultListReDomain);
        }
        csConsultReDomain.setCsConsultListReDomainList(reList);
        return csConsultReDomain;
    }

    @Override
    public CsConsultReDomain getConsult(Integer consultId) {
        return this.makeList(this.getConsultModelById(consultId));
    }

    @Override
    public void deleteConsult(Integer consultId) throws ApiException {
        this.deleteConsultModel(consultId);
    }

    @Override
    public QueryResult<CsConsult> queryConsultPage(Map<String, Object> map) {
        List<CsConsult> csConsultList = this.queryConsultModelPage(map);
        for (CsConsult csConsult : csConsultList) {
            List<CsConsultList> csConsultLists = this.queryConsultListModelPage(this.getQueryMapParam("tenantCode,consultCode", new Object[]{csConsult.getTenantCode(), csConsult.getConsultCode()}));
            csConsult.setCsConsultListReDomainList(csConsultLists);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countConsult(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(csConsultList);
        return queryResult;
    }

    @Override
    public CsConsultReDomain getConsultByCode(String tenantCode, String consultCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("consultCode", consultCode);
        return this.makeList(this.getConsultModelByCode(map));
    }

    @Override
    public void deleteConsultByCode(String tenantCode, String consultCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("consultCode", consultCode);
        this.delConsultModelByCode(map);
    }

    @Override
    public String saveConsultList(CsConsultListDomain csConsultListDomain) throws ApiException {
        CsConsultList csConsultList = this.createCsConsultList(csConsultListDomain);
        this.saveConsultListModel(csConsultList);
        return csConsultList.getConsultListCode();
    }

    @Override
    public String saveConsultListBatch(List<CsConsultListDomain> csConsultListDomainList) throws ApiException {
        if (null == csConsultListDomainList || csConsultListDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CsConsultList> csConsultListList = new ArrayList<CsConsultList>();
        String code = "";
        for (CsConsultListDomain csConsultListDomain : csConsultListDomainList) {
            CsConsultList csConsultList = this.createCsConsultList(csConsultListDomain);
            code = csConsultList.getConsultListCode();
            csConsultListList.add(csConsultList);
        }
        this.saveConsultListBatchModel(csConsultListList);
        return code;
    }

    @Override
    public void updateConsultListState(Integer consultListId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateConsultListModel(consultListId, dataState, oldDataState);
    }

    @Override
    public void updateConsultListStateByCode(String tenantCode, String consultListCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateConsultListModelByCode(tenantCode, consultListCode, dataState, oldDataState);
    }

    @Override
    public void updateConsultList(CsConsultListDomain csConsultListDomain) throws ApiException {
        String msg = this.checkConsultList(csConsultListDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("cs.CsConsultServiceImpl.updateConsultList.checkConsultList", msg);
        }
        CsConsultList oldCsConsultList = this.getConsultListModelById(csConsultListDomain.getConsultListId());
        if (null == oldCsConsultList) {
            throw new ApiException("cs.CsConsultServiceImpl.updateConsultList.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CsConsultList csConsultList = this.makeConsultList(csConsultListDomain, oldCsConsultList);
        this.setConsultListUpdataDefault(csConsultList);
        this.updateConsultListModel(csConsultList);
    }

    @Override
    public CsConsultList getConsultList(Integer consultListId) {
        return this.getConsultListModelById(consultListId);
    }

    @Override
    public void deleteConsultList(Integer consultListId) throws ApiException {
        this.deleteConsultListModel(consultListId);
    }

    @Override
    public QueryResult<CsConsultList> queryConsultListPage(Map<String, Object> map) {
        List<CsConsultList> csConsultListList = this.queryConsultListModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countConsultList(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(csConsultListList);
        return queryResult;
    }

    @Override
    public CsConsultList getConsultListByCode(String tenantCode, String consultListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("consultListCode", consultListCode);
        return this.getConsultListModelByCode(map);
    }

    @Override
    public void deleteConsultListByCode(String tenantCode, String consultListCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("consultListCode", consultListCode);
        this.delConsultListModelByCode(map);
    }
}

