/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcContractMapper;
import com.yqbsoft.laser.service.contract.dao.OcPackageMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcPackageDomain;
import com.yqbsoft.laser.service.contract.model.OcContract;
import com.yqbsoft.laser.service.contract.model.OcContractGoods;
import com.yqbsoft.laser.service.contract.model.OcPackage;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractServiceImpl
extends BaseServiceImpl
implements OcContractService {
    public static final String SYS_CODE = "oc.CONTRACT.OcContractServiceImpl";
    private OcContractMapper ocContractMapper;
    private OcContractGoodsMapper ocContractGoodsMapper;
    private OcPackageMapper ocPackageMapper;

    public void setOcContractMapper(OcContractMapper ocContractMapper) {
        this.ocContractMapper = ocContractMapper;
    }

    public void setOcContractGoodsMapper(OcContractGoodsMapper ocContractGoodsMapper) {
        this.ocContractGoodsMapper = ocContractGoodsMapper;
    }

    public void setOcPackageMapper(OcPackageMapper ocPackageMapper) {
        this.ocPackageMapper = ocPackageMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocContractMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContract(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractDomain.getTenantCode())) {
            msg = msg + "\u5546\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractDomain.getAppmanageIcode())) {
            msg = msg + "AppmanageIcode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractDefault(OcContract ocContract) {
        if (null == ocContract) {
            return;
        }
        if (null == ocContract.getDataState()) {
            ocContract.setDataState(0);
        }
        if (null == ocContract.getGmtCreate()) {
            ocContract.setGmtCreate(this.getSysDate());
        }
        ocContract.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocContract.getContractBillcode())) {
            ocContract.setContractBillcode(this.getNo(null, OcContract.class.getSimpleName(), "contractCode", ocContract.getTenantCode()));
        }
    }

    private int getContractMaxCode() {
        int code = 0;
        try {
            return this.ocContractMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractUpdataDefault(OcContract ocContract) {
        if (null == ocContract) {
            return;
        }
        ocContract.setGmtModified(this.getSysDate());
    }

    private void saveContractModel(OcContract ocContract) throws ApiException {
        if (null == ocContract) {
            return;
        }
        try {
            this.ocContractMapper.insert(ocContract);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractModel.ex", (Throwable)e);
        }
    }

    private OcContract getContractModelById(Integer contractId) {
        if (null == contractId) {
            return null;
        }
        try {
            return this.ocContractMapper.selectByPrimaryKey(contractId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractModelById", (Throwable)e);
            return null;
        }
    }

    public OcContract getContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractModelByCode.num");
        }
    }

    private void deleteContractModel(Integer contractId) throws ApiException {
        if (null == contractId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.deleteByPrimaryKey(contractId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractModel.num");
        }
    }

    private void updateContractModel(OcContract ocContract) throws ApiException {
        if (null == ocContract) {
            return;
        }
        try {
            this.ocContractMapper.updateByPrimaryKeySelective(ocContract);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModel.ex", (Throwable)e);
        }
    }

    private void updateStateContractModel(Integer contractId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contractId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractId", contractId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.null");
        }
    }

    private OcContract makeContract(OcContractDomain ocContractDomain, OcContract ocContract) {
        if (null == ocContractDomain) {
            return null;
        }
        if (null == ocContract) {
            ocContract = new OcContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContract, (Object)ocContractDomain);
            return ocContract;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContract", (Throwable)e);
            return null;
        }
    }

    private List<OcContract> queryContractModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractModel", (Throwable)e);
            return null;
        }
    }

    private int countContract(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContract", (Throwable)e);
        }
        return i;
    }

    private String checkContractGoods(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getTenantCode())) {
            msg = msg + "\u5546\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getAppmanageIcode())) {
            msg = msg + "AppmanageIcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsCode())) {
            msg = msg + "\u539f\u59cb\u5355\u636e\u53f7\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractGoodsDefault(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return;
        }
        if (null == ocContractGoods.getDataState()) {
            ocContractGoods.setDataState(0);
        }
        if (null == ocContractGoods.getGmtCreate()) {
            ocContractGoods.setGmtCreate(this.getSysDate());
        }
        ocContractGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocContractGoods.getContractGoodsCode())) {
            ocContractGoods.setContractGoodsCode(this.createUUIDString());
        }
    }

    private int getContractGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocContractGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractGoodsUpdataDefault(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return;
        }
        ocContractGoods.setGmtModified(this.getSysDate());
    }

    private void saveContractGoodsModel(OcContractGoods ocContractGoods) throws ApiException {
        if (null == ocContractGoods) {
            return;
        }
        try {
            this.ocContractGoodsMapper.insert(ocContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoodsModel.ex", (Throwable)e);
        }
    }

    private OcContractGoods getContractGoodsModelById(Integer contractGoodsId) {
        if (null == contractGoodsId) {
            return null;
        }
        try {
            return this.ocContractGoodsMapper.selectByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public OcContractGoods getContractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delContractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractGoodsModelByCode.num");
        }
    }

    private void deleteContractGoodsModel(Integer contractGoodsId) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.deleteByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractGoodsModel.num");
        }
    }

    private void updateContractGoodsModel(OcContractGoods ocContractGoods) throws ApiException {
        if (null == ocContractGoods) {
            return;
        }
        try {
            this.ocContractGoodsMapper.updateByPrimaryKeySelective(ocContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStateContractGoodsModel(Integer contractGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contractGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsId", contractGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractGoodsModel.null");
        }
    }

    private OcContractGoods makeContractGoods(OcContractGoodsDomain ocContractGoodsDomain, OcContractGoods ocContractGoods) {
        if (null == ocContractGoodsDomain) {
            return null;
        }
        if (null == ocContractGoods) {
            ocContractGoods = new OcContractGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoods, (Object)ocContractGoodsDomain);
            return ocContractGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContractGoods", (Throwable)e);
            return null;
        }
    }

    private List<OcContractGoods> queryContractGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countContractGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContractGoods", (Throwable)e);
        }
        return i;
    }

    private String checkPackage(OcPackageDomain ocPackageDomain) {
        if (null == ocPackageDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPackageDefault(OcPackage ocPackage) {
        if (null == ocPackage) {
            return;
        }
        if (null == ocPackage.getDataState()) {
            ocPackage.setDataState(0);
        }
        if (null == ocPackage.getGmtCreate()) {
            ocPackage.setGmtCreate(this.getSysDate());
        }
        ocPackage.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocPackage.getPackageCode())) {
            ocPackage.setPackageCode(this.createUUIDString());
        }
    }

    private int getPackageMaxCode() {
        int code = 0;
        try {
            return this.ocPackageMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPackageMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPackageUpdataDefault(OcPackage ocPackage) {
        if (null == ocPackage) {
            return;
        }
        ocPackage.setGmtModified(this.getSysDate());
    }

    private void savePackageModel(OcPackage ocPackage) throws ApiException {
        if (null == ocPackage) {
            return;
        }
        try {
            this.ocPackageMapper.insert(ocPackage);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.savePackageModel.ex", (Throwable)e);
        }
    }

    private OcPackage getPackageModelById(Integer packageId) {
        if (null == packageId) {
            return null;
        }
        try {
            return this.ocPackageMapper.selectByPrimaryKey(packageId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPackageModelById", (Throwable)e);
            return null;
        }
    }

    public OcPackage getPackageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocPackageMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPackageModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPackageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocPackageMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delPackageModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delPackageModelByCode.num");
        }
    }

    private void deletePackageModel(Integer packageId) throws ApiException {
        if (null == packageId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocPackageMapper.deleteByPrimaryKey(packageId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deletePackageModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deletePackageModel.num");
        }
    }

    private void updatePackageModel(OcPackage ocPackage) throws ApiException {
        if (null == ocPackage) {
            return;
        }
        try {
            this.ocPackageMapper.updateByPrimaryKeySelective(ocPackage);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackageModel.ex", (Throwable)e);
        }
    }

    private void updateStatePackageModel(Integer packageId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == packageId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageId", packageId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocPackageMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStatePackageModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStatePackageModel.null");
        }
    }

    private OcPackage makePackage(OcPackageDomain ocPackageDomain, OcPackage ocPackage) {
        if (null == ocPackageDomain) {
            return null;
        }
        if (null == ocPackage) {
            ocPackage = new OcPackage();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocPackage, (Object)ocPackageDomain);
            return ocPackage;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makePackage", (Throwable)e);
            return null;
        }
    }

    private List<OcPackage> queryPackageModelPage(Map<String, Object> parammap) {
        try {
            return this.ocPackageMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryPackageModel", (Throwable)e);
            return null;
        }
    }

    private int countPackage(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocPackageMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countPackage", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveContract(OcContractDomain ocContractDomain) throws ApiException {
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContract.checkContract", msg);
        }
        OcContract ocContract = this.makeContract(ocContractDomain, null);
        this.setContractDefault(ocContract);
        this.saveContractModel(ocContract);
        this.savePackageList(ocContractDomain.getPackageList(), ocContract.getContractBillcode(), ocContract.getTenantCode());
        return ocContract.getContractBillcode();
    }

    private void savePackageList(List<OcPackageDomain> packageList, String contractBillcode, String tenantCode) {
        if (packageList.isEmpty() || packageList == null) {
            return;
        }
        for (OcPackageDomain ocPackageDomain : packageList) {
            ocPackageDomain.setContractBillcode(contractBillcode);
            ocPackageDomain.setTenantCode(tenantCode);
            this.savePackage(ocPackageDomain);
        }
    }

    @Override
    public void updateContractState(Integer contractId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContractModel(contractId, dataState, oldDataState);
    }

    @Override
    public void updateContract(OcContractDomain ocContractDomain) throws ApiException {
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.checkContract", msg);
        }
        OcContract oldOcContract = this.getContractModelById(ocContractDomain.getContractId());
        if (null == oldOcContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContract ocContract = this.makeContract(ocContractDomain, oldOcContract);
        this.setContractUpdataDefault(ocContract);
        this.updateContractModel(ocContract);
    }

    @Override
    public OcContract getContract(Integer contractId) {
        return this.getContractModelById(contractId);
    }

    @Override
    public void deleteContract(Integer contractId) throws ApiException {
        this.deleteContractModel(contractId);
    }

    @Override
    public QueryResult<OcContract> queryContractPage(Map<String, Object> map) {
        List<OcContract> ocContractList = this.queryContractModelPage(map);
        int count = this.countContract(map);
        if (map.get("childFlag") != null && ocContractList != null && !ocContractList.isEmpty()) {
            map.clear();
            for (OcContract ocContract : ocContractList) {
                map.put("contractBillcode", ocContract.getContractBillcode());
                map.put("tenantCode", ocContract.getTenantCode());
                ocContract.setPackageList(this.setPackageList(map));
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractList);
        return queryResult;
    }

    private List<OcPackage> setPackageList(Map<String, Object> map) {
        QueryResult<OcPackage> rueryResult = this.queryPackagePage(map);
        return rueryResult.getList();
    }

    @Override
    public OcContract getContractByCode(Map<String, Object> map) {
        return this.getContractModelByCode(map);
    }

    @Override
    public void delContractByCode(Map<String, Object> map) throws ApiException {
        this.delContractModelByCode(map);
    }

    @Override
    public void saveContractGoods(OcContractGoodsDomain ocContractGoodsDomain) throws ApiException {
        String msg = this.checkContractGoods(ocContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoods.checkContractGoods", msg);
        }
        OcContractGoods ocContractGoods = this.makeContractGoods(ocContractGoodsDomain, null);
        this.setContractGoodsDefault(ocContractGoods);
        this.saveContractGoodsModel(ocContractGoods);
    }

    @Override
    public void updateContractGoodsState(Integer contractGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContractGoodsModel(contractGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateContractGoods(OcContractGoodsDomain ocContractGoodsDomain) throws ApiException {
        String msg = this.checkContractGoods(ocContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoods.checkContractGoods", msg);
        }
        OcContractGoods oldOcContractGoods = this.getContractGoodsModelById(ocContractGoodsDomain.getContractGoodsId());
        if (null == oldOcContractGoods) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractGoods ocContractGoods = this.makeContractGoods(ocContractGoodsDomain, oldOcContractGoods);
        this.setContractGoodsUpdataDefault(ocContractGoods);
        this.updateContractGoodsModel(ocContractGoods);
    }

    @Override
    public OcContractGoods getContractGoods(Integer contractGoodsId) {
        return this.getContractGoodsModelById(contractGoodsId);
    }

    @Override
    public void deleteContractGoods(Integer contractGoodsId) throws ApiException {
        this.deleteContractGoodsModel(contractGoodsId);
    }

    @Override
    public QueryResult<OcContractGoods> queryContractGoodsPage(Map<String, Object> map) {
        List<OcContractGoods> ocContractGoodsList = this.queryContractGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractGoodsList);
        return queryResult;
    }

    @Override
    public OcContractGoods getContractGoodsByCode(Map<String, Object> map) {
        return this.getContractGoodsModelByCode(map);
    }

    @Override
    public void delContractGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delContractGoodsModelByCode(map);
    }

    @Override
    public void savePackage(OcPackageDomain ocPackageDomain) throws ApiException {
        String msg = this.checkPackage(ocPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.savePackage.checkPackage", msg);
        }
        OcPackage ocPackage = this.makePackage(ocPackageDomain, null);
        this.setPackageDefault(ocPackage);
        this.savePackageModel(ocPackage);
        this.saveContractGoodsList(ocPackageDomain.getContractGoodsList(), ocPackage);
    }

    private void saveContractGoodsList(List<OcContractGoodsDomain> contractGoodsList, OcPackage ocPackage) {
        if (contractGoodsList == null || contractGoodsList.isEmpty()) {
            return;
        }
        for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
            ocContractGoodsDomain.setPackageCode(ocPackage.getPackageCode());
            ocContractGoodsDomain.setContractBillcode(ocPackage.getContractBillcode());
            this.saveContractGoods(ocContractGoodsDomain);
        }
    }

    @Override
    public void updatePackageState(Integer packageId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePackageModel(packageId, dataState, oldDataState);
    }

    @Override
    public void updatePackage(OcPackageDomain ocPackageDomain) throws ApiException {
        String msg = this.checkPackage(ocPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackage.checkPackage", msg);
        }
        OcPackage oldOcPackage = this.getPackageModelById(ocPackageDomain.getPackageId());
        if (null == oldOcPackage) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackage.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcPackage ocPackage = this.makePackage(ocPackageDomain, oldOcPackage);
        this.setPackageUpdataDefault(ocPackage);
        this.updatePackageModel(ocPackage);
    }

    @Override
    public OcPackage getPackage(Integer packageId) {
        return this.getPackageModelById(packageId);
    }

    @Override
    public void deletePackage(Integer packageId) throws ApiException {
        this.deletePackageModel(packageId);
    }

    @Override
    public QueryResult<OcPackage> queryPackagePage(Map<String, Object> map) {
        List<OcPackage> ocPackageList = this.queryPackageModelPage(map);
        if (ocPackageList != null && !ocPackageList.isEmpty()) {
            for (OcPackage ocPackage : ocPackageList) {
                map.put("packageCode", ocPackage.getPackageCode());
                ocPackage.setContractGoodsList(this.queryContractGoodsModelPage(map));
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPackage(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocPackageList);
        map.clear();
        return queryResult;
    }

    @Override
    public OcPackage getPackageByCode(Map<String, Object> map) {
        return this.getPackageModelByCode(map);
    }

    @Override
    public void delPackageByCode(Map<String, Object> map) throws ApiException {
        this.delPackageModelByCode(map);
    }

    @Override
    public void updateContractStateByCode(Map<String, Object> map) throws ApiException {
        Integer contractId = (Integer)map.get("contractId");
        Integer dataState = (Integer)map.get("dataState");
        Integer oldDataState = (Integer)map.get("oldDataState");
        this.updateStateContractModel(contractId, dataState, oldDataState);
    }

    @Override
    public QueryResult<OcContract> getOcContractByGoods(Map<String, Object> map) throws ApiException {
        List<OcContractGoods> ocContractGoodsList = this.queryContractGoodsModelPage(map);
        ArrayList<OcContract> contractList = new ArrayList<OcContract>();
        for (OcContractGoods goods : ocContractGoodsList) {
            HashMap<String, Object> pmap = new HashMap<String, Object>();
            pmap.put("contractBillcode", goods.getContractBillcode());
            OcContract contract = this.getContractByCode(pmap);
            contract.setOcContractGoods(goods);
            contractList.add(contract);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(contractList);
        return queryResult;
    }
}

