/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcShoppingGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcShoppingMapper;
import com.yqbsoft.laser.service.contract.domain.GoodsNumDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcPackageDomain;
import com.yqbsoft.laser.service.contract.domain.OcShoppingDomain;
import com.yqbsoft.laser.service.contract.domain.OcShoppingGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcShoppingReDomain;
import com.yqbsoft.laser.service.contract.engine.ContractPollThread;
import com.yqbsoft.laser.service.contract.engine.ContractService;
import com.yqbsoft.laser.service.contract.model.OcPackage;
import com.yqbsoft.laser.service.contract.model.OcShopping;
import com.yqbsoft.laser.service.contract.model.OcShoppingGoods;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcShoppingService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jsoup.helper.StringUtil;

public class OcShoppingServiceImpl
extends BaseServiceImpl
implements OcShoppingService {
    public static final String SYS_CODE = "oc.CONTRACT.OcShoppingServiceImpl";
    private static ContractService contractService;
    private static Object lock;
    private OcShoppingMapper ocShoppingMapper;
    private OcShoppingGoodsMapper ocShoppingGoodsMapper;
    private OcContractService ocContractService;

    public void setOcShoppingMapper(OcShoppingMapper ocShoppingMapper) {
        this.ocShoppingMapper = ocShoppingMapper;
    }

    public void setOcShoppingGoodsMapper(OcShoppingGoodsMapper ocShoppingGoodsMapper) {
        this.ocShoppingGoodsMapper = ocShoppingGoodsMapper;
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    private Date getSysDate() {
        try {
            return this.ocShoppingMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkShopping(OcShoppingDomain ocShoppingDomain) {
        if (null == ocShoppingDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setShoppingDefault(OcShopping ocShopping) {
        if (null == ocShopping) {
            return;
        }
        if (null == ocShopping.getDataState()) {
            ocShopping.setDataState(0);
        }
        if (null == ocShopping.getGmtCreate()) {
            ocShopping.setGmtCreate(this.getSysDate());
        }
        ocShopping.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocShopping.getShoppingCode())) {
            ocShopping.setShoppingCode(this.createUUIDString());
        }
    }

    private int getShoppingMaxCode() {
        int code = 0;
        try {
            return this.ocShoppingMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setShoppingUpdataDefault(OcShopping ocShopping) {
        if (null == ocShopping) {
            return;
        }
        ocShopping.setGmtModified(this.getSysDate());
    }

    private void saveShoppingModel(OcShopping ocShopping) throws ApiException {
        if (null == ocShopping) {
            return;
        }
        try {
            this.ocShoppingMapper.insert(ocShopping);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.saveShoppingModel.ex", (Throwable)e);
        }
    }

    private OcShopping getShoppingModelById(Integer shoppingId) {
        if (null == shoppingId) {
            return null;
        }
        try {
            return this.ocShoppingMapper.selectByPrimaryKey(shoppingId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingModelById", (Throwable)e);
            return null;
        }
    }

    public OcShopping getShoppingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocShoppingMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingModelByCode", (Throwable)e);
            return null;
        }
    }

    public void updateCmountShopping(Integer shoppingsId, BigDecimal addcamount) throws ApiException {
        if (null == shoppingsId || null == addcamount) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingId", shoppingsId);
        map.put("shoppingCamount", addcamount);
        int i = 0;
        try {
            i = this.ocShoppingMapper.updateCamountByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateCmountShopping.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateCmountShopping.null");
        }
    }

    public void delShoppingModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShoppingMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingModelByCode.num");
        }
    }

    private void deleteShoppingModel(Integer shoppingId) throws ApiException {
        if (null == shoppingId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShoppingMapper.deleteByPrimaryKey(shoppingId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShoppingModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShoppingModel.num");
        }
    }

    private void updateShoppingModel(OcShopping ocShopping) throws ApiException {
        if (null == ocShopping) {
            return;
        }
        try {
            this.ocShoppingMapper.updateByPrimaryKeySelective(ocShopping);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingModel.ex", (Throwable)e);
        }
    }

    private void updateStateShoppingModel(Integer shoppingId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == shoppingId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingId", shoppingId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocShoppingMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateStateShoppingModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateStateShoppingModel.null");
        }
    }

    private OcShopping makeShopping(OcShoppingDomain ocShoppingDomain, OcShopping ocShopping) {
        if (null == ocShoppingDomain) {
            return null;
        }
        if (null == ocShopping) {
            ocShopping = new OcShopping();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocShopping, (Object)ocShoppingDomain);
            return ocShopping;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.makeShopping", (Throwable)e);
            return null;
        }
    }

    private List<OcShopping> queryShoppingModelPage(Map<String, Object> parammap) {
        try {
            return this.ocShoppingMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.queryShoppingModel", (Throwable)e);
            return null;
        }
    }

    private int countShopping(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocShoppingMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.countShopping", (Throwable)e);
        }
        return i;
    }

    private String checkShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getMemberCode())) {
            msg = msg + "\u5356\u5bb6\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getMemberBcode())) {
            msg = msg + "\u4e70\u5bb6\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (ocShoppingGoodsDomain.getPricesetNprice() == null) {
            msg = msg + "\u4ef7\u683c\u4e3a\u7a7a;";
        }
        if (ocShoppingGoodsDomain.getGoodsCamount() == null) {
            msg = msg + "\u6570\u91cf\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getShoppingCode())) {
            msg = msg + "\u8d2d\u7269\u8f66\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocShoppingGoodsDomain.getGoodsCode())) {
            msg = msg + "\u539f\u59cb\u5355\u636e\u53f7\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setShoppingGoodsDefault(OcShoppingGoods ocShoppingGoods) {
        if (null == ocShoppingGoods) {
            return;
        }
        if (null == ocShoppingGoods.getDataState()) {
            ocShoppingGoods.setDataState(0);
        }
        if (null == ocShoppingGoods.getGmtCreate()) {
            ocShoppingGoods.setGmtCreate(this.getSysDate());
        }
        ocShoppingGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocShoppingGoods.getShoppingGoodsCode())) {
            ocShoppingGoods.setShoppingGoodsCode(this.createUUIDString());
        }
    }

    private int getShoppingGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocShoppingGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setShoppingGoodsUpdataDefault(OcShoppingGoods ocShoppingGoods) {
        if (null == ocShoppingGoods) {
            return;
        }
        ocShoppingGoods.setGmtModified(this.getSysDate());
    }

    private void saveShoppingGoodsModel(OcShoppingGoods ocShoppingGoods) throws ApiException {
        if (null == ocShoppingGoods) {
            return;
        }
        try {
            this.ocShoppingGoodsMapper.insert(ocShoppingGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.saveShoppingGoodsModel.ex", (Throwable)e);
        }
    }

    private OcShoppingGoods getShoppingGoodsModelById(Integer shoppingGoodsId) {
        if (null == shoppingGoodsId) {
            return null;
        }
        try {
            return this.ocShoppingGoodsMapper.selectByPrimaryKey(shoppingGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public OcShoppingGoods getShoppingGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocShoppingGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.getShoppingGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delShoppingGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.delShoppingGoodsModelByCode.num");
        }
    }

    private void deleteShoppingGoodsModel(Integer shoppingGoodsId) throws ApiException {
        if (null == shoppingGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.deleteByPrimaryKey(shoppingGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShoppingGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.deleteShoppingGoodsModel.num");
        }
    }

    private void updateShoppingGoodsModel(OcShoppingGoods ocShoppingGoods) throws ApiException {
        if (null == ocShoppingGoods) {
            return;
        }
        try {
            this.ocShoppingGoodsMapper.updateByPrimaryKeySelective(ocShoppingGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStateShoppingGoodsModel(Integer shoppingGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == shoppingGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingGoodsId", shoppingGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateStateShoppingGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateStateShoppingGoodsModel.null");
        }
    }

    private OcShoppingGoods makeShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain, OcShoppingGoods ocShoppingGoods) {
        if (null == ocShoppingGoodsDomain) {
            return null;
        }
        if (null == ocShoppingGoods) {
            ocShoppingGoods = new OcShoppingGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingGoods, (Object)ocShoppingGoodsDomain);
            return ocShoppingGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.makeShoppingGoods", (Throwable)e);
            return null;
        }
    }

    private List<OcShoppingGoods> queryShoppingGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocShoppingGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.queryShoppingGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countShoppingGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocShoppingGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.countShoppingGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public void saveShopping(OcShoppingDomain ocShoppingDomain) throws ApiException {
        String msg = this.checkShopping(ocShoppingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.saveShopping.checkShopping", msg);
        }
        OcShopping ocShopping = this.makeShopping(ocShoppingDomain, null);
        this.setShoppingDefault(ocShopping);
        this.saveShoppingModel(ocShopping);
    }

    @Override
    public void updateShoppingState(Integer shoppingId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateShoppingModel(shoppingId, dataState, oldDataState);
    }

    @Override
    public void updateShopping(OcShoppingDomain ocShoppingDomain) throws ApiException {
        String msg = this.checkShopping(ocShoppingDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShopping.checkShopping", msg);
        }
        OcShopping oldOcShopping = this.getShoppingModelById(ocShoppingDomain.getShoppingId());
        if (null == oldOcShopping) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShopping.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcShopping ocShopping = this.makeShopping(ocShoppingDomain, oldOcShopping);
        this.setShoppingUpdataDefault(ocShopping);
        this.updateShoppingModel(ocShopping);
    }

    @Override
    public OcShopping getShopping(Integer shoppingId) {
        return this.getShoppingModelById(shoppingId);
    }

    @Override
    public void deleteShopping(Integer shoppingId) throws ApiException {
        this.deleteShoppingModel(shoppingId);
    }

    @Override
    public QueryResult<OcShopping> queryShoppingPage(Map<String, Object> map) {
        List<OcShopping> ocShoppingList = this.queryShoppingModelPage(map);
        if (ocShoppingList != null && !ocShoppingList.isEmpty()) {
            for (OcShopping ocShopping : ocShoppingList) {
                HashMap<String, Object> parammap = new HashMap<String, Object>();
                parammap.putAll(map);
                parammap.put("shoppingCode", ocShopping.getShoppingCode());
                List<OcShoppingGoods> list = this.queryShoppingGoodsModelPage(parammap);
                ocShopping.setList(list);
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countShopping(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocShoppingList);
        return queryResult;
    }

    private List<OcPackageDomain> makePackageDomain(List<OcShoppingGoodsDomain> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, ArrayList<OcShoppingGoodsDomain>> packageMap = new HashMap<String, ArrayList<OcShoppingGoodsDomain>>();
        for (OcShoppingGoodsDomain ocShoppingGoodsDomain : list) {
            ArrayList<OcShoppingGoodsDomain> goodsList;
            String warsehouseCode = ocShoppingGoodsDomain.getWarehouseCode();
            String memberCode = ocShoppingGoodsDomain.getMemberCode();
            if (StringUtils.isBlank((String)warsehouseCode)) {
                warsehouseCode = "";
            }
            if ((goodsList = (ArrayList<OcShoppingGoodsDomain>)packageMap.get(memberCode + "-" + warsehouseCode)) == null) {
                goodsList = new ArrayList<OcShoppingGoodsDomain>();
            }
            goodsList.add(ocShoppingGoodsDomain);
            packageMap.put(memberCode + "-" + warsehouseCode, goodsList);
        }
        ArrayList<OcPackageDomain> packageList = null;
        if (!packageMap.isEmpty()) {
            packageList = new ArrayList<OcPackageDomain>();
            for (String key : packageMap.keySet()) {
                OcPackageDomain ocPackage = new OcPackageDomain();
                ocPackage.setShoppingGoodsList((List)packageMap.get(key));
                packageList.add(ocPackage);
            }
        }
        return packageList;
    }

    public List<OcPackage> makePackage(List<OcShoppingGoods> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<String, ArrayList<OcShoppingGoods>> packageMap = new HashMap<String, ArrayList<OcShoppingGoods>>();
        for (OcShoppingGoods ocShoppingGoods : list) {
            String warsehouseCode = ocShoppingGoods.getWarehouseCode();
            String memberCode = ocShoppingGoods.getMemberCode();
            ArrayList<OcShoppingGoods> goodsList = (ArrayList<OcShoppingGoods>)packageMap.get(memberCode + "-" + warsehouseCode);
            if (goodsList == null) {
                goodsList = new ArrayList<OcShoppingGoods>();
            }
            goodsList.add(ocShoppingGoods);
            packageMap.put(warsehouseCode, goodsList);
        }
        ArrayList<OcPackage> packageList = null;
        if (!packageMap.isEmpty()) {
            packageList = new ArrayList<OcPackage>();
            for (String key : packageMap.keySet()) {
                OcPackage ocPackage = new OcPackage();
                ocPackage.setShoppingGoodsList((List)packageMap.get(key));
                packageList.add(ocPackage);
            }
        }
        return packageList;
    }

    @Override
    public OcShopping getShoppingByCode(Map<String, Object> map) {
        return this.getShoppingModelByCode(map);
    }

    @Override
    public void delShoppingByCode(Map<String, Object> map) throws ApiException {
        this.delShoppingModelByCode(map);
    }

    @Override
    public String saveShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) throws ApiException {
        String msg = this.checkShoppingGoods(ocShoppingGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.saveShoppingGoods.checkShoppingGoods", msg);
        }
        OcShoppingGoods ocShoppingGoods = this.makeShoppingGoods(ocShoppingGoodsDomain, null);
        this.setShoppingGoodsDefault(ocShoppingGoods);
        this.saveShoppingGoodsModel(ocShoppingGoods);
        return ocShoppingGoods.getShoppingGoodsCode();
    }

    @Override
    public String insertShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) throws ApiException {
        if (ocShoppingGoodsDomain == null) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.insertShoppingGoods.ocShoppingGoodsDomain.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        if (ocShoppingGoodsDomain.getMemberBcode().equals(ocShoppingGoodsDomain.getMemberCode())) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.insertShoppingGoods.check.buyMember", "\u4e0d\u80fd\u8d2d\u4e70\u81ea\u5bb6\u5546\u54c1");
        }
        OcShopping ocShopping = this.saveOrUpdateShopping(ocShoppingGoodsDomain);
        if (ocShopping == null) {
            return null;
        }
        ocShoppingGoodsDomain.setShoppingCode(ocShopping.getShoppingCode());
        return this.saveOrUpdateShoppingGoods(ocShoppingGoodsDomain);
    }

    private String saveOrUpdateShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (ocShoppingGoodsDomain == null) {
            return null;
        }
        OcShoppingGoods ocShoppingGoods = this.getShoppingGoodsByGlide(ocShoppingGoodsDomain);
        if (ocShoppingGoods == null) {
            return this.saveShoppingGoods(ocShoppingGoodsDomain);
        }
        ocShoppingGoods.setGoodsCamount(ocShoppingGoods.getGoodsCamount().add(ocShoppingGoodsDomain.getGoodsCamount()));
        ocShoppingGoods.setGoodsCweight(ocShoppingGoods.getGoodsCweight().add(ocShoppingGoodsDomain.getGoodsCweight()));
        this.updateShoppingGoodsModel(ocShoppingGoods);
        return ocShoppingGoods.getShoppingCode();
    }

    private OcShoppingGoods getShoppingGoodsByGlide(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        OcShoppingGoods ocShoppingGoods = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocShoppingGoodsDomain.getTenantCode());
        map.put("shoppingCode", ocShoppingGoodsDomain.getShoppingCode());
        map.put("skuCode", ocShoppingGoodsDomain.getSkuCode());
        List<OcShoppingGoods> list = this.queryShoppingGoodsModelPage(map);
        if (list != null && !list.isEmpty()) {
            ocShoppingGoods = list.get(0);
        }
        return ocShoppingGoods;
    }

    private OcShopping saveOrUpdateShopping(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (ocShoppingGoodsDomain == null) {
            return null;
        }
        OcShopping ocShopping = this.getShoppingGroupby(ocShoppingGoodsDomain);
        if (ocShopping == null) {
            ocShopping = this.saveShoppingByGoods(ocShoppingGoodsDomain);
        } else {
            if (null == ocShopping.getGoodsMoney()) {
                ocShopping.setGoodsMoney(new BigDecimal("0"));
            }
            ocShopping.setShoppingCamount(ocShopping.getShoppingCamount().add(ocShoppingGoodsDomain.getGoodsCamount()));
            ocShopping.getGoodsMoney().add(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice()));
            if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
                ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
            }
            ocShopping.getPricesetRefrice().add(ocShoppingGoodsDomain.getGoodsCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice()));
            this.updateShoppingModel(ocShopping);
        }
        return ocShopping;
    }

    private OcShopping saveShoppingByGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (ocShoppingGoodsDomain == null) {
            return null;
        }
        OcShopping ocShopping = new OcShopping();
        try {
            BeanUtils.copyAllPropertys((Object)ocShopping, (Object)ocShoppingGoodsDomain);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isEmpty((String)ocShopping.getShoppingType())) {
            ocShopping.setShoppingType("00");
        }
        ocShopping.setShoppingCamount(ocShoppingGoodsDomain.getGoodsCamount());
        ocShopping.setShoppingCweight(ocShoppingGoodsDomain.getGoodsCweight());
        ocShopping.setShoppingDate(this.getSysDate());
        ocShopping.setGoodsMoney(ocShopping.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetNprice()));
        if (null == ocShoppingGoodsDomain.getPricesetRefrice()) {
            ocShoppingGoodsDomain.setPricesetRefrice(new BigDecimal("0"));
        }
        ocShopping.setPricesetRefrice(ocShopping.getShoppingCamount().multiply(ocShoppingGoodsDomain.getPricesetRefrice()));
        this.setShoppingDefault(ocShopping);
        this.saveShoppingModel(ocShopping);
        return ocShopping;
    }

    private OcShopping getShoppingGroupby(OcShoppingGoodsDomain ocShoppingGoodsDomain) {
        if (null == ocShoppingGoodsDomain) {
            return null;
        }
        String str = DisUtil.getMap((String)"DdFalgSetting-key", (String)(ocShoppingGoodsDomain.getTenantCode() + "-shopping-shoppingkey"));
        if (StringUtils.isBlank((String)str)) {
            str = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-shopping-shoppingkey");
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)str)) {
            String[] param = str.split("\\|");
            Object obj = null;
            for (String s : param) {
                obj = BeanUtils.forceGetProperty((Object)ocShoppingGoodsDomain, (String)s);
                if (null == obj) continue;
                parammap.put(s, obj);
            }
        } else {
            parammap.put("memberCode", ocShoppingGoodsDomain.getMemberCode());
        }
        parammap.put("memberBcode", ocShoppingGoodsDomain.getMemberBcode());
        parammap.put("tenantCode", ocShoppingGoodsDomain.getTenantCode());
        parammap.put("shoppingType", StringUtils.isBlank((String)ocShoppingGoodsDomain.getShoppingType()) ? ocShoppingGoodsDomain.getGoodsType() : ocShoppingGoodsDomain.getShoppingType());
        List<OcShopping> list = this.queryShoppingModelPage(parammap);
        OcShopping ocShopping = null;
        if (list != null && !list.isEmpty()) {
            ocShopping = list.get(0);
        }
        return ocShopping;
    }

    @Override
    public void updateShoppingGoodsState(Integer shoppingGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateShoppingGoodsModel(shoppingGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateShoppingGoods(OcShoppingGoodsDomain ocShoppingGoodsDomain) throws ApiException {
        String msg = this.checkShoppingGoods(ocShoppingGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoods.checkShoppingGoods", msg);
        }
        OcShoppingGoods oldOcShoppingGoods = this.getShoppingGoodsModelById(ocShoppingGoodsDomain.getShoppingGoodsId());
        if (null == oldOcShoppingGoods) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcShoppingGoods ocShoppingGoods = this.makeShoppingGoods(ocShoppingGoodsDomain, oldOcShoppingGoods);
        this.setShoppingGoodsUpdataDefault(ocShoppingGoods);
        this.updateShoppingGoodsModel(ocShoppingGoods);
    }

    @Override
    public OcShoppingGoods getShoppingGoods(Integer shoppingGoodsId) {
        return this.getShoppingGoodsModelById(shoppingGoodsId);
    }

    @Override
    public void deleteShoppingGoods(Integer shoppingGoodsId) throws ApiException {
        OcShoppingGoods ocShoppingGoods = this.getShoppingGoodsModelById(shoppingGoodsId);
        if (ocShoppingGoods == null) {
            return;
        }
        this.updateShoppingGoodsNum(shoppingGoodsId, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    private void updateShoppingNum(OcShoppingGoods ocShoppingGoods, BigDecimal amount, BigDecimal weight) {
        if (ocShoppingGoods == null || amount == null) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoods.updateShoppingNum", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocShoppingGoods.getTenantCode());
        map.put("shoppingCode", ocShoppingGoods.getShoppingCode());
        OcShopping ocShopping = this.getShoppingByCode(map);
        if (ocShopping == null) {
            return;
        }
        ocShopping.setShoppingCamount(ocShopping.getShoppingCamount().add(amount));
        if (ocShopping.getShoppingCamount().compareTo(BigDecimal.ZERO) == 0) {
            this.deleteShopping(ocShopping.getShoppingId());
        } else {
            this.updateShoppingModel(ocShopping);
        }
    }

    @Override
    public QueryResult<OcShoppingGoods> queryShoppingGoodsPage(Map<String, Object> map) {
        List<OcShoppingGoods> ocShoppingGoodsList = this.queryShoppingGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countShoppingGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocShoppingGoodsList);
        return queryResult;
    }

    @Override
    public OcShoppingGoods getShoppingGoodsByCode(Map<String, Object> map) {
        return this.getShoppingGoodsModelByCode(map);
    }

    @Override
    public void delShoppingGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delShoppingGoodsModelByCode(map);
    }

    @Override
    public void updateShoppingGoodsNum(Integer shoppingGoodsId, BigDecimal amount, BigDecimal weight) throws ApiException {
        OcShoppingGoods ocShoppingGoods = this.getShoppingGoods(shoppingGoodsId);
        if (ocShoppingGoods == null) {
            return;
        }
        BigDecimal GoodsCamount = ocShoppingGoods.getGoodsCamount();
        this.updateShoppingNum(ocShoppingGoods, amount.subtract(GoodsCamount), null);
        if (amount.compareTo(BigDecimal.ZERO) == 0) {
            this.deleteShoppingGoodsModel(shoppingGoodsId);
        } else {
            ocShoppingGoods.setGoodsCamount(amount);
            if (null == ocShoppingGoods.getGoodsSupplynum() || ocShoppingGoods.getGoodsSupplynum().subtract(ocShoppingGoods.getGoodsCamount()).intValue() < 0) {
                throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoodsNum.no", "\u5e93\u5b58\u4e0d\u8db3");
            }
            this.updateShoppingGoodsModel(ocShoppingGoods);
        }
    }

    @Override
    public void updateShoppingGoodsNumBatch(List<GoodsNumDomain> goodsList) throws ApiException {
        if (goodsList == null || goodsList.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShoppingGoods.updateShoppingGoodsNumBatch", "\u53c2\u6570\u4e3a\u7a7a");
        }
        for (GoodsNumDomain goodsNumDomain : goodsList) {
            this.updateShoppingGoodsNum(goodsNumDomain.getId(), goodsNumDomain.getNum(), goodsNumDomain.getWeight());
        }
    }

    @Override
    public void deleteShoppingGoodsBatch(List<Integer> idList) throws ApiException {
        if (idList == null || idList.isEmpty()) {
            return;
        }
        for (Integer shoppingGoodsId : idList) {
            this.deleteShoppingGoods(shoppingGoodsId);
        }
    }

    @Override
    public String saveShoppingCartOrder(OcShoppingDomain ocShoppingDomain) {
        OcContractDomain ocContractDomain = this.makeContract(ocShoppingDomain, "0");
        this.handleShoppingGoods(ocShoppingDomain);
        return ocContractDomain.getContractBillcode();
    }

    private void handleShoppingGoods(OcShoppingDomain ocShoppingDomain) {
        if (ocShoppingDomain == null) {
            return;
        }
        List<OcPackageDomain> packageList = ocShoppingDomain.getPackageList();
        if (packageList == null || packageList.isEmpty()) {
            return;
        }
        for (OcPackageDomain ocPackageDomain : packageList) {
            List<OcShoppingGoodsDomain> goodsList = ocPackageDomain.getShoppingGoodsList();
            if (goodsList == null || goodsList.isEmpty()) continue;
            for (OcShoppingGoodsDomain ocShoppingGoodsDomain : goodsList) {
                this.deleteShoppingGoods(ocShoppingGoodsDomain.getShoppingGoodsId());
            }
        }
    }

    @Override
    public String saveContractByOcShopping(OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        OcContractDomain ocContractDomain = this.makeContract(ocShoppingDomain, contractTypepro);
        this.handleShoppingGoods(ocShoppingDomain);
        return this.ocContractService.saveContract(ocContractDomain);
    }

    @Override
    public String saveContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        return this.saveContract(ocContractDomain, shoppingGoodsIdList);
    }

    @Override
    public String sendContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        String code = this.saveContract(ocContractDomain, shoppingGoodsIdList);
        this.getContractService().putQueue(ocContractDomain);
        return code;
    }

    @Override
    public String sendBatchContractByDel(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList) {
        String code = this.saveBatchContract(ocContractDomainList, shoppingGoodsIdList);
        if (null != ocContractDomainList && !ocContractDomainList.isEmpty()) {
            for (OcContractDomain ocContractDomain : ocContractDomainList) {
                this.getContractService().putQueue(ocContractDomain);
            }
        }
        return code;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContractService getContractService() {
        Object object = lock;
        synchronized (object) {
            if (null == contractService) {
                contractService = new ContractService((OcContractEngineService)SpringApplicationContextUtil.getBean((String)"ocContractEngineService"));
                for (int i = 0; i < 20; ++i) {
                    contractService.addPollPool(new ContractPollThread(contractService));
                }
            }
            return contractService;
        }
    }

    private String saveBatchContract(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList) {
        if (null == ocContractDomainList || ocContractDomainList.isEmpty()) {
            return null;
        }
        if (null != shoppingGoodsIdList && !shoppingGoodsIdList.isEmpty()) {
            this.deleteShoppingGoodsBatch(shoppingGoodsIdList);
        }
        return this.ocContractService.saveBatchContract(ocContractDomainList);
    }

    private String saveContract(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        if (null == ocContractDomain) {
            return null;
        }
        if (null != shoppingGoodsIdList && !shoppingGoodsIdList.isEmpty()) {
            this.deleteShoppingGoodsBatch(shoppingGoodsIdList);
        }
        return this.ocContractService.saveContract(ocContractDomain);
    }

    public OcContractDomain makeContract(OcShoppingDomain ocShoppingDomain, String contractTypepro) {
        if (ocShoppingDomain == null) {
            return null;
        }
        String jsonStr = JsonUtil.buildNormalBinder().toJson((Object)ocShoppingDomain);
        OcContractDomain ocContractDomain = (OcContractDomain)JsonUtil.buildNormalBinder().getJsonToObject(jsonStr, OcContractDomain.class);
        String value = DisUtil.getMap((String)"DdFalgSetting-key", (String)(ocShoppingDomain.getTenantCode() + "-paytime-orderDuration"));
        if (StringUtil.isBlank((String)value)) {
            value = "1440";
        }
        ocContractDomain.setContractPmode(ocShoppingDomain.getScontractPmode());
        ocContractDomain.setGoodsNum(ocShoppingDomain.getShoppingCamount());
        ocContractDomain.setContractTypepro(contractTypepro);
        ocContractDomain.setContractPaydate(DateUtils.addMinutes((Date)new Date(), (int)Integer.valueOf(value)));
        ocContractDomain.setContractRemark(ocShoppingDomain.getShoppingRemark());
        ArrayList<OcContractGoodsDomain> goodsList = new ArrayList<OcContractGoodsDomain>();
        for (OcPackageDomain ocPackageDomain : ocContractDomain.getPackageList()) {
            goodsList.addAll(ocPackageDomain.getContractGoodsList());
        }
        ocContractDomain.setContractMoney(ocShoppingDomain.getGoodsMoney());
        BigDecimal contractHmoney = ocShoppingDomain.getGoodsMoney();
        BigDecimal goodsPmoney = ocShoppingDomain.getGoodsPmoney();
        if (goodsPmoney != null) {
            contractHmoney = contractHmoney.add(goodsPmoney);
        }
        ocContractDomain.setDataBmoney(contractHmoney);
        return ocContractDomain;
    }

    @Override
    public List<OcShoppingReDomain> queryShoppingToContract(List<Integer> shoppingGoodsIdList, String terminalType) {
        OcShoppingReDomain ocShoppingReDomain;
        if (null == shoppingGoodsIdList || shoppingGoodsIdList.isEmpty()) {
            return null;
        }
        HashMap<String, OcShoppingReDomain> shoppingmap = new HashMap<String, OcShoppingReDomain>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Integer shoppingGoodsId : shoppingGoodsIdList) {
            List<OcShoppingGoodsDomain> goodslist;
            OcShoppingGoods ocShoppingGoods = this.getShoppingGoods(shoppingGoodsId);
            OcShoppingGoodsDomain ocShoppingGoodsDomain = this.makeShoppingGoodsDomain(ocShoppingGoods);
            if (null == ocShoppingGoodsDomain || StringUtils.isBlank((String)ocShoppingGoodsDomain.getShoppingCode())) continue;
            String shoppingCode = ocShoppingGoodsDomain.getShoppingCode();
            ocShoppingReDomain = (OcShoppingReDomain)shoppingmap.get(shoppingCode);
            if (null == ocShoppingReDomain) {
                map.put("shoppingCode", ocShoppingGoodsDomain.getShoppingCode());
                map.put("tenantCode", ocShoppingGoodsDomain.getTenantCode());
                OcShopping ocShopping = this.getShoppingByCode(map);
                ocShoppingReDomain = this.makeShoppingReDomain(ocShopping);
                if (null == ocShoppingReDomain) continue;
                shoppingmap.put(shoppingCode, ocShoppingReDomain);
            }
            if (null == (goodslist = ocShoppingReDomain.getList())) {
                goodslist = new ArrayList<OcShoppingGoodsDomain>();
                ocShoppingReDomain.setList(goodslist);
            }
            goodslist.add(ocShoppingGoodsDomain);
        }
        ArrayList<OcShoppingReDomain> list = new ArrayList<OcShoppingReDomain>();
        for (String key : shoppingmap.keySet()) {
            ocShoppingReDomain = (OcShoppingReDomain)shoppingmap.get(key);
            ocShoppingReDomain.setPackageList(this.makePackageDomain(ocShoppingReDomain.getList()));
            ocShoppingReDomain.setList(null);
            list.add((OcShoppingReDomain)shoppingmap.get(key));
        }
        return list;
    }

    private OcShoppingReDomain makeShoppingReDomain(OcShopping ocShopping) {
        if (null == ocShopping) {
            return null;
        }
        OcShoppingReDomain ocShoppingReDomain = new OcShoppingReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingReDomain, (Object)ocShopping);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.makeShoppingReDomain.e", (Throwable)e);
        }
        return ocShoppingReDomain;
    }

    private OcShoppingGoodsDomain makeShoppingGoodsDomain(OcShoppingGoods ocShoppingGoods) {
        if (null == ocShoppingGoods) {
            return null;
        }
        OcShoppingGoodsDomain ocShoppingGoodsDomain = new OcShoppingGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocShoppingGoodsDomain, (Object)ocShoppingGoods);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcShoppingServiceImpl.makeShoppingGoodsDomain.e", (Throwable)e);
        }
        return ocShoppingGoodsDomain;
    }

    @Override
    public void updateShoppingGoodsPmInfo(Integer shoppingGoodsId, String promotionCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("shoppingGoodsId", shoppingGoodsId);
        map.put("promotionCode", promotionCode);
        this.ocShoppingGoodsMapper.updateShoppingGoodsPmInfo(map);
    }

    @Override
    public void updateShoppingGoodsCheckState(String memberCode, String shoppingCode, Integer shoppingGoodsId, Integer checkState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("memberBCode", memberCode);
        map.put("shoppingCode", shoppingCode);
        map.put("shoppingGoodsId", shoppingGoodsId);
        map.put("checkState", checkState);
        this.ocShoppingGoodsMapper.updateShoppingGoodsCheckState(map);
    }

    @Override
    public void updateShopGoodsBySkuCode(Map<String, Object> map) {
        String msg = this.checkShopGoodsByMap(map);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShopGoodsBySkuCode.checkShopGoodsByMap", msg);
        }
        if (null != map.get("goodsSupplynum")) {
            map.put("shoppingGoodsAmount", map.get("goodsSupplynum"));
        }
        if (null != map.get("goodsSupplyweight")) {
            map.put("shoppingGoodsAmount", map.get("goodsSupplynum"));
        }
        this.updateShopGoodsBySkuCodeModel(map);
    }

    private String checkShopGoodsByMap(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)String.valueOf(map.get("skuCode")))) {
            msg = msg + "skuCode is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("goodsCode")))) {
            msg = msg + "goodsCode is null";
        }
        if (StringUtils.isBlank((String)String.valueOf(map.get("tenantCode")))) {
            msg = msg + "tenantCode is null";
        }
        return msg;
    }

    private void updateShopGoodsBySkuCodeModel(Map<String, Object> map) throws ApiException {
        if (null == map) {
            return;
        }
        try {
            this.ocShoppingGoodsMapper.updateShoppingGoodsBySkuCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcShoppingServiceImpl.updateShopGoodsBySkuCodeModel.ex", (Throwable)e);
        }
    }

    static {
        lock = new Object();
    }
}

