/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRefundGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcRefundMapper;
import com.yqbsoft.laser.service.contract.domain.OcRefundDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundFileDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.contract.engine.RefundPollThread;
import com.yqbsoft.laser.service.contract.engine.RefundPutThread;
import com.yqbsoft.laser.service.contract.engine.RefundService;
import com.yqbsoft.laser.service.contract.enumc.RefundState;
import com.yqbsoft.laser.service.contract.enumc.RefundType;
import com.yqbsoft.laser.service.contract.model.OcRefund;
import com.yqbsoft.laser.service.contract.model.OcRefundFile;
import com.yqbsoft.laser.service.contract.model.OcRefundGoods;
import com.yqbsoft.laser.service.contract.model.PtradeBackBean;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcRefundFileService;
import com.yqbsoft.laser.service.contract.service.OcRefundService;
import com.yqbsoft.laser.service.contract.service.OcRefundSettlService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRefundServiceImpl
extends BaseServiceImpl
implements OcRefundService {
    public static final String SYS_CODE = "oc.CONTRACT.OcRefundServiceImpl";
    private OcRefundMapper ocRefundMapper;
    private OcRefundGoodsMapper ocRefundGoodsMapper;
    private OcRefundSettlService ocRefundSettlService;
    private OcRefundFileService ocRefundFileService;
    private OcContractService ocContractService;
    private static RefundService refundService;
    private static Object lock;

    public OcContractService getOcContractService() {
        return this.ocContractService;
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    public OcRefundFileService getOcRefundFileService() {
        return this.ocRefundFileService;
    }

    public void setOcRefundFileService(OcRefundFileService ocRefundFileService) {
        this.ocRefundFileService = ocRefundFileService;
    }

    public OcRefundSettlService getOcRefundSettlService() {
        return this.ocRefundSettlService;
    }

    public void setOcRefundSettlService(OcRefundSettlService ocRefundSettlService) {
        this.ocRefundSettlService = ocRefundSettlService;
    }

    public void setOcRefundMapper(OcRefundMapper ocRefundMapper) {
        this.ocRefundMapper = ocRefundMapper;
    }

    public void setOcRefundGoodsMapper(OcRefundGoodsMapper ocRefundGoodsMapper) {
        this.ocRefundGoodsMapper = ocRefundGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRefundMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRefund(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            msg = msg + "RefundType\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRefundDefault(OcRefund ocRefund) {
        if (null == ocRefund) {
            return;
        }
        if (null == ocRefund.getDataState()) {
            ocRefund.setDataState(0);
        }
        if (null == ocRefund.getGmtCreate()) {
            ocRefund.setGmtCreate(this.getSysDate());
        }
        ocRefund.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocRefund.getRefundCode())) {
            ocRefund.setRefundCode(this.createUUIDString());
        }
    }

    private int getRefundMaxCode() {
        int code = 0;
        try {
            return this.ocRefundMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRefundUpdataDefault(OcRefund ocRefund) {
        if (null == ocRefund) {
            return;
        }
        ocRefund.setGmtModified(this.getSysDate());
    }

    private void saveRefundModel(OcRefund ocRefund) throws ApiException {
        if (null == ocRefund) {
            return;
        }
        try {
            this.ocRefundMapper.insert(ocRefund);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundModel.ex", (Throwable)e);
        }
    }

    private OcRefund getRefundModelById(Integer refundId) {
        if (null == refundId) {
            return null;
        }
        try {
            return this.ocRefundMapper.selectByPrimaryKey(refundId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundModelById", (Throwable)e);
            return null;
        }
    }

    public OcRefund getRefundModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRefundMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRefundModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundModelByCode.num");
        }
    }

    private void deleteRefundModel(Integer refundId) throws ApiException {
        if (null == refundId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundMapper.deleteByPrimaryKey(refundId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundModel.num");
        }
    }

    private void updateRefundModel(OcRefund ocRefund) throws ApiException {
        if (null == ocRefund) {
            return;
        }
        try {
            this.ocRefundMapper.updateByPrimaryKeySelective(ocRefund);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundModel.ex", (Throwable)e);
        }
    }

    private void updateStateRefundModel(Integer refundId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == refundId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundId", refundId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRefundMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundModel.null");
        }
    }

    private OcRefund makeRefund(OcRefundDomain ocRefundDomain, OcRefund ocRefund) {
        if (null == ocRefundDomain) {
            return null;
        }
        if (null == ocRefund) {
            ocRefund = new OcRefund();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefund, (Object)ocRefundDomain);
            return ocRefund;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeRefund", (Throwable)e);
            return null;
        }
    }

    private List<OcRefund> queryRefundModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRefundMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.queryRefundModel", (Throwable)e);
            return null;
        }
    }

    private int countRefund(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRefundMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.countRefund", (Throwable)e);
        }
        return i;
    }

    private String checkRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) {
        if (null == ocRefundGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundGoodsDomain.getContractGoodsCode())) {
            msg = msg + "ContractGoodsCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRefundGoodsDefault(OcRefundGoods ocRefundGoods) {
        if (null == ocRefundGoods) {
            return;
        }
        if (null == ocRefundGoods.getDataState()) {
            ocRefundGoods.setDataState(0);
        }
        if (null == ocRefundGoods.getGmtCreate()) {
            ocRefundGoods.setGmtCreate(this.getSysDate());
        }
        ocRefundGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocRefundGoods.getRefundGoodsCode())) {
            ocRefundGoods.setRefundGoodsCode(this.createUUIDString());
        }
    }

    private int getRefundGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocRefundGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRefundGoodsUpdataDefault(OcRefundGoods ocRefundGoods) {
        if (null == ocRefundGoods) {
            return;
        }
        ocRefundGoods.setGmtModified(this.getSysDate());
    }

    private void saveRefundGoodsModel(OcRefundGoods ocRefundGoods) throws ApiException {
        if (null == ocRefundGoods) {
            return;
        }
        try {
            this.ocRefundGoodsMapper.insert(ocRefundGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveBatchRefundGoodsModel(List<OcRefundGoods> ocRefundGoodsList) throws ApiException {
        if (null == ocRefundGoodsList || ocRefundGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ocRefundGoodsMapper.insertBatch(ocRefundGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveBatchRefundGoodsModel.ex", (Throwable)e);
        }
    }

    private OcRefundGoods getRefundGoodsModelById(Integer refundGoodsId) {
        if (null == refundGoodsId) {
            return null;
        }
        try {
            return this.ocRefundGoodsMapper.selectByPrimaryKey(refundGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public OcRefundGoods getRefundGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRefundGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRefundGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundGoodsModelByCode.num");
        }
    }

    private void deleteRefundGoodsModel(Integer refundGoodsId) throws ApiException {
        if (null == refundGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.deleteByPrimaryKey(refundGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundGoodsModel.num");
        }
    }

    private void updateRefundGoodsModel(OcRefundGoods ocRefundGoods) throws ApiException {
        if (null == ocRefundGoods) {
            return;
        }
        try {
            this.ocRefundGoodsMapper.updateByPrimaryKeySelective(ocRefundGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStateRefundGoodsModel(Integer refundGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == refundGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundGoodsId", refundGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundGoodsModel.null");
        }
    }

    private OcRefundGoods makeRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain, OcRefundGoods ocRefundGoods) {
        if (null == ocRefundGoodsDomain) {
            return null;
        }
        if (null == ocRefundGoods) {
            ocRefundGoods = new OcRefundGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundGoods, (Object)ocRefundGoodsDomain);
            return ocRefundGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeRefundGoods", (Throwable)e);
            return null;
        }
    }

    private List<OcRefundGoods> queryRefundGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRefundGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.queryRefundGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countRefundGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.countRefundGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public String saveRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefund.checkRefund", msg);
        }
        OcRefund ocRefund = this.makeRefund(ocRefundDomain, null);
        this.setRefundDefault(ocRefund);
        this.saveRefundModel(ocRefund);
        if (null == ocRefundDomain.getOcRefundGoodsDomainList() || ocRefundDomain.getOcRefundGoodsDomainList().isEmpty()) {
            this.ocContractService.updateContractAndRefund(ocRefund.getContractBillcode(), ocRefund.getTenantCode());
        } else {
            this.saveBatchRefundGoods(ocRefundDomain.getOcRefundGoodsDomainList(), ocRefund);
        }
        if (null != ocRefundDomain.getOcRefundFileDomainList() && !ocRefundDomain.getOcRefundFileDomainList().isEmpty()) {
            this.saveBatchFile(ocRefundDomain.getOcRefundFileDomainList(), ocRefund);
        }
        return ocRefund.getRefundCode();
    }

    private void saveBatchFile(List<OcRefundFileDomain> ocRefundFileDomainList, OcRefund ocRefund) {
        if (null == ocRefundFileDomainList || ocRefundFileDomainList.isEmpty() || null == ocRefund) {
            return;
        }
        String tenantCode = ocRefund.getTenantCode();
        for (OcRefundFileDomain ocRefundFileDomain : ocRefundFileDomainList) {
            ocRefundFileDomain.setRefundCode(ocRefund.getRefundCode());
            ocRefundFileDomain.setTenantCode(tenantCode);
            ocRefundFileDomain.setContractBillcode(ocRefund.getContractBillcode());
        }
        this.ocRefundFileService.saveRefundFileBatch(ocRefundFileDomainList);
    }

    @Override
    public void updateRefundState(Integer refundId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundModel(refundId, dataState, oldDataState);
    }

    @Override
    public void updateRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefund.checkRefund", msg);
        }
        OcRefund oldOcRefund = this.getRefundModelById(ocRefundDomain.getRefundId());
        if (null == oldOcRefund) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefund.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRefund ocRefund = this.makeRefund(ocRefundDomain, oldOcRefund);
        this.setRefundUpdataDefault(ocRefund);
        this.updateRefundModel(ocRefund);
    }

    @Override
    public OcRefundReDomain getRefund(Integer refundId) {
        return this.makeOcRefundDomain(this.getRefundModelById(refundId));
    }

    private OcRefundReDomain makeOcRefundDomain(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        OcRefundReDomain ocRefundReDomain = new OcRefundReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundReDomain, (Object)ocRefund);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeOcRefundDomain.e", (Throwable)e);
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", ocRefund.getRefundCode());
        map.put("tenantCode", ocRefund.getTenantCode());
        QueryResult<OcRefundFile> qlist = this.ocRefundFileService.queryRefundFilePage(map);
        if (null != qlist) {
            ocRefundReDomain.setOcRefundFileList(qlist.getRows());
        }
        ocRefundReDomain.setOcRefundGoodsList(this.queryRefundGoodsModelPage(map));
        return ocRefundReDomain;
    }

    private List<OcRefundReDomain> makeOcRefundReDomainList(List<OcRefund> ocRefundList) {
        if (ListUtil.isEmpty(ocRefundList)) {
            return null;
        }
        ArrayList<OcRefundReDomain> refundReDomainList = new ArrayList<OcRefundReDomain>();
        for (OcRefund ocRefund : ocRefundList) {
            OcRefundReDomain ocRefundReDomain = this.makeOcRefundDomain(ocRefund);
            refundReDomainList.add(ocRefundReDomain);
        }
        return refundReDomainList;
    }

    @Override
    public void deleteRefund(Integer refundId) throws ApiException {
        this.deleteRefundModel(refundId);
    }

    @Override
    public QueryResult<OcRefund> queryRefundPage(Map<String, Object> map) {
        List<OcRefund> ocRefundList = this.queryRefundModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefund(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundList);
        return queryResult;
    }

    @Override
    public QueryResult<OcRefundReDomain> queryRefundReDomainPage(Map<String, Object> map) {
        List<OcRefund> ocRefundList = this.queryRefundModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefund(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(this.makeOcRefundReDomainList(ocRefundList));
        return queryResult;
    }

    @Override
    public OcRefundReDomain getRefundByCode(Map<String, Object> map) {
        return this.makeOcRefundDomain(this.getRefundModelByCode(map));
    }

    @Override
    public void delRefundByCode(Map<String, Object> map) throws ApiException {
        this.delRefundModelByCode(map);
    }

    @Override
    public String saveRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) throws ApiException {
        OcRefundGoods ocRefundGoods = this.makeRefundGoods(ocRefundGoodsDomain);
        this.saveRefundGoodsModel(ocRefundGoods);
        return ocRefundGoods.getRefundGoodsCode();
    }

    private void saveBatchRefundGoods(List<OcRefundGoodsDomain> ocRefundGoodsDomainList, OcRefund ocRefund) {
        if (null == ocRefundGoodsDomainList || ocRefundGoodsDomainList.isEmpty() || null == ocRefund) {
            return;
        }
        ArrayList<OcRefundGoods> ocRefundGoodsList = new ArrayList<OcRefundGoods>();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            ocRefundGoodsDomain.setRefundCode(ocRefund.getRefundCode());
            ocRefundGoodsDomain.setContractBillcode(ocRefund.getContractBillcode());
            ocRefundGoodsList.add(this.makeRefundGoods(ocRefundGoodsDomain));
        }
        this.saveBatchRefundGoodsModel(ocRefundGoodsList);
    }

    private OcRefundGoods makeRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) {
        String msg = this.checkRefundGoods(ocRefundGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundGoods.checkRefundGoods", msg);
        }
        OcRefundGoods ocRefundGoods = this.makeRefundGoods(ocRefundGoodsDomain, null);
        this.setRefundGoodsDefault(ocRefundGoods);
        this.ocContractService.updateContractGoodsAndRefund(ocRefundGoods.getTenantCode(), ocRefundGoods.getContractGoodsCode(), ocRefundGoods.getGoodsCamount(), ocRefundGoods.getGoodsCweight());
        return ocRefundGoods;
    }

    @Override
    public void updateRefundGoodsState(Integer refundGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundGoodsModel(refundGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) throws ApiException {
        String msg = this.checkRefundGoods(ocRefundGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundGoods.checkRefundGoods", msg);
        }
        OcRefundGoods oldOcRefundGoods = this.getRefundGoodsModelById(ocRefundGoodsDomain.getRefundGoodsId());
        if (null == oldOcRefundGoods) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRefundGoods ocRefundGoods = this.makeRefundGoods(ocRefundGoodsDomain, oldOcRefundGoods);
        this.setRefundGoodsUpdataDefault(ocRefundGoods);
        this.updateRefundGoodsModel(ocRefundGoods);
    }

    @Override
    public OcRefundGoods getRefundGoods(Integer refundGoodsId) {
        return this.getRefundGoodsModelById(refundGoodsId);
    }

    @Override
    public void deleteRefundGoods(Integer refundGoodsId) throws ApiException {
        this.deleteRefundGoodsModel(refundGoodsId);
    }

    @Override
    public QueryResult<OcRefundGoods> queryRefundGoodsPage(Map<String, Object> map) {
        List<OcRefundGoods> ocRefundGoodsList = this.queryRefundGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefundGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundGoodsList);
        return queryResult;
    }

    @Override
    public OcRefundGoods getRefundGoodsByCode(Map<String, Object> map) {
        return this.getRefundGoodsModelByCode(map);
    }

    @Override
    public void delRefundGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delRefundGoodsModelByCode(map);
    }

    @Override
    public void updateRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        Integer oldDatastate = ocRefund.getDataState();
        Integer datastate = 0;
        if (oldDatastate == RefundState.APPLY.getCode()) {
            datastate = RefundState.RESAPP.getCode();
        } else if (oldDatastate == RefundState.SEND.getCode()) {
            datastate = RefundState.RESGOODS.getCode();
        } else {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.refundDataState." + oldDatastate, "\u9000\u8d27\u5355\u72b6\u6001\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c~");
        }
        this.updateRefundState(ocRefund.getRefundId(), datastate, ocRefund.getDataState());
    }

    @Override
    public String saveRefundPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundPay.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundPay.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        this.updateRefundState(ocRefund.getRefundId(), RefundState.SUC.getCode(), ocRefund.getDataState());
        return "success";
    }

    @Override
    public void sendRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        OcRefund ocRefund = this.updateRefundPass(refundCode, tenantCode, map);
        if (null != ocRefund) {
            this.getRefundService().putQueue(ocRefund);
        }
    }

    @Override
    public OcRefund updateRefundPass(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPass.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPass.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        String type = ocRefund.getRefundType();
        Integer oldDatastate = ocRefund.getDataState();
        if (null != map && !map.isEmpty()) {
            OcRefund newOcRefund = new OcRefund();
            newOcRefund.setRefundId(ocRefund.getRefundId());
            try {
                BeanUtils.copyAllPropertys((Object)newOcRefund, map);
            }
            catch (Exception e) {
                throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPass.e", (Throwable)e);
            }
            this.updateRefundModel(newOcRefund);
        }
        Integer dataState = 0;
        boolean pay = false;
        if (type.equals(RefundType.REFMONEY.getCode()) && oldDatastate == RefundState.APPLY.getCode()) {
            dataState = RefundState.PASS.getCode();
            pay = true;
        } else if (type.equals(RefundType.REFGOODS.getCode()) && oldDatastate == RefundState.SEND.getCode()) {
            pay = true;
            dataState = RefundState.ARR.getCode();
        } else {
            dataState = oldDatastate + 1;
        }
        this.updateRefundState(ocRefund.getRefundId(), dataState, oldDatastate);
        ocRefund.setDataState(dataState);
        if (pay) {
            return ocRefund;
        }
        return null;
    }

    @Override
    public void updateRefundPay(OcRefund ocRefund) {
        if (null == ocRefund) {
            return;
        }
        PtradeBackBean ptradeBackBean = new PtradeBackBean();
        ptradeBackBean.setAcquireSeqno_new(ocRefund.getRefundCode());
        ptradeBackBean.setAcquireSeqno(ocRefund.getContractBillcode());
        ptradeBackBean.setTenantCode(ocRefund.getTenantCode());
        ptradeBackBean.setOrderAmount(ocRefund.getRefundMoney());
        ptradeBackBean.setPtradpdeCode("PAYMENTBACK");
        ptradeBackBean.setPaymentNotifyurl("oc.refund.saveRefundPay");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ptradeBackBean", JsonUtil.buildNormalBinder().toJson((Object)ptradeBackBean));
        this.updateRefundState(ocRefund.getRefundId(), RefundState.PAY.getCode(), ocRefund.getDataState());
        String ptePtradeInfoCode = this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", paramMap);
        if (StringUtils.isBlank((String)ptePtradeInfoCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPay.null", "");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RefundService getRefundService() {
        Object object = lock;
        synchronized (object) {
            if (null == refundService) {
                refundService = new RefundService((OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"));
                refundService.addPollPool(new RefundPollThread(refundService));
            }
            return refundService;
        }
    }

    @Override
    public void loadRefundProcess() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", RefundState.ARR.getCode());
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<OcRefund> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getRefundService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getRefundService().getPage());
                result = this.queryRefundPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getRefundService().addPutPool(new RefundPutThread(this.getRefundService(), result.getRows()));
                    if (result.getRows().size() == this.getRefundService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getRefundService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    static {
        lock = new Object();
    }
}

