/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.engine;

import com.yqbsoft.laser.service.contract.domain.OcCflowNodeReDomain;
import com.yqbsoft.laser.service.contract.domain.OcCflowPprocessDomain;
import com.yqbsoft.laser.service.contract.engine.PprocessService;
import com.yqbsoft.laser.service.contract.model.OcCflowPprocess;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.suppercore.sync.AbstractEtcInfoThread;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.HashMap;
import java.util.List;

public class PprocessModelPutThread
extends AbstractEtcInfoThread {
    public static final String SYS_CODE = "oc.CONTRACT.PprocessModelPutThread";
    private PprocessService pprocessService;
    private OcContractService ocContractService;
    private List<OcCflowPprocess> pprocessList;

    public PprocessModelPutThread(PprocessService pprocessService, OcContractService ocContractService, List<OcCflowPprocess> pprocessList) {
        this.pprocessService = pprocessService;
        this.ocContractService = ocContractService;
        this.pprocessList = pprocessList;
    }

    public void run() {
        try {
            this.off(this.pprocessList);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.PprocessModelPutThread.run.e", (Throwable)e);
        }
    }

    public void off(List<OcCflowPprocess> pprocessList) {
        if (null == pprocessList || pprocessList.isEmpty()) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (OcCflowPprocess ocCflowPprocess : pprocessList) {
            OcCflowPprocessDomain ocCflowPprocessDomain = this.make(ocCflowPprocess);
            if (null == ocCflowPprocessDomain.getOcContractDomain()) {
                map.put("contractBillcode", ocCflowPprocessDomain.getContractBillcode());
                map.put("tenantCode", ocCflowPprocessDomain.getTenantCode());
                ocCflowPprocessDomain.setOcContractDomain(this.ocContractService.getContractByCode(map));
            }
            if (null == ocCflowPprocessDomain.getOcCflowNodeReDomain()) {
                String json = DisUtil.getMap((String)"ocProtCflowNode", (String)(ocCflowPprocessDomain.getCflowNodeCode() + "-" + ocCflowPprocessDomain.getTenantCode()));
                if (StringUtils.isBlank((String)json)) {
                    json = DisUtil.getMap((String)"ocProtCflowNode", (String)(ocCflowPprocessDomain.getCflowNodeCode() + "-" + "00000000"));
                }
                if (StringUtils.isNotBlank((String)json)) {
                    OcCflowNodeReDomain ocCflowNodeReDomain = (OcCflowNodeReDomain)JsonUtil.buildNormalBinder().getJsonToObject(json, OcCflowNodeReDomain.class);
                    ocCflowPprocessDomain.setOcCflowNodeReDomain(ocCflowNodeReDomain);
                }
            }
            this.pprocessService.putQueue(ocCflowPprocessDomain);
        }
    }

    private OcCflowPprocessDomain make(OcCflowPprocess ocCflowPprocess) {
        if (null == ocCflowPprocess) {
            return null;
        }
        OcCflowPprocessDomain ocCflowPprocessDomain = new OcCflowPprocessDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocCflowPprocessDomain, (Object)ocCflowPprocess);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.PprocessModelPutThread.make.e", (Throwable)e);
        }
        return ocCflowPprocessDomain;
    }
}

