/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.domain.OcRecflowPprocessDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundDomain;
import com.yqbsoft.laser.service.contract.model.OcRecflowPprocess;
import com.yqbsoft.laser.service.contract.model.OcRefund;
import com.yqbsoft.laser.service.contract.model.OcSendcontractData;
import com.yqbsoft.laser.service.contract.refundes.PprocessModelPutThread;
import com.yqbsoft.laser.service.contract.refundes.PprocessPollThread;
import com.yqbsoft.laser.service.contract.refundes.PprocessPutThread;
import com.yqbsoft.laser.service.contract.refundes.PprocessService;
import com.yqbsoft.laser.service.contract.refundes.RefundDomainPutThread;
import com.yqbsoft.laser.service.contract.service.OcRecflowPprocessService;
import com.yqbsoft.laser.service.contract.service.OcRefundEngineService;
import com.yqbsoft.laser.service.contract.service.OcRefundFlowEngineService;
import com.yqbsoft.laser.service.contract.service.OcRefundService;
import com.yqbsoft.laser.service.contract.service.impl.OcRefundCtrlServiceImpl;
import com.yqbsoft.laser.service.contract.service.impl.OcRefundServiceImpl;
import com.yqbsoft.laser.service.contract.service.impl.OcSendcontractDataServiceImpl;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRefundEngineServiceImpl
extends BaseServiceImpl
implements OcRefundEngineService {
    public static final String SYS_CODE = "oc.CONTRACT.OcRefundEngineServiceImpl";
    private static PprocessService pprocessService;
    private static Object lock;
    private OcRefundFlowEngineService ocRefundFlowEngineService;
    private OcRecflowPprocessService ocRecflowPprocessService;
    OcRefundService ocRefundService;

    public void setOcRefundService(OcRefundService ocRefundService) {
        this.ocRefundService = ocRefundService;
    }

    public OcRecflowPprocessService getOcRecflowPprocessService() {
        return this.ocRecflowPprocessService;
    }

    public void setOcRecflowPprocessService(OcRecflowPprocessService ocRecflowPprocessService) {
        this.ocRecflowPprocessService = ocRecflowPprocessService;
    }

    public OcRefundFlowEngineService getOcRefundFlowEngineService() {
        return this.ocRefundFlowEngineService;
    }

    public void setOcRefundFlowEngineService(OcRefundFlowEngineService ocRefundFlowEngineService) {
        this.ocRefundFlowEngineService = ocRefundFlowEngineService;
    }

    @Override
    public void sendRefundEngineStart(OcRefundDomain ocRefundDomain) {
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundEngineStart(ocRefundDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        } else {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendRefundEngineStart.pprocessList", (Object)(ocRefundDomain.getRefundCode() + "=" + ocRefundDomain.getTenantCode()));
        }
    }

    @Override
    public void sendRefundNext(String refundCode, String tenantCode, Map<String, Object> map) {
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundNext(refundCode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    @Override
    public String sendContracPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (null == dataState || dataState != 3) {
            return "success";
        }
        this.sendRefundNext(refundCode, tenantCode, null);
        return "success";
    }

    @Override
    public String sendContracSubPay(String businessOrder, String businessOrderno, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (null == dataState || dataState != 3) {
            return "success";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSubCode", businessOrderno);
        this.sendRefundNext(businessOrder, tenantCode, map);
        return "success";
    }

    @Override
    public String sendContracBatchPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        if (null == dataState || dataState != 3) {
            return "success";
        }
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundBatchNext(refundCode, tenantCode, null);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
        return "success";
    }

    @Override
    public void sendRefundBack(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundBack(refundCode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    @Override
    public void sendFlowNode(OcRecflowPprocessDomain ocRecflowPprocessDomain) {
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveFlowNode(ocRecflowPprocessDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PprocessService getPprocessService() {
        Object object = lock;
        synchronized (object) {
            if (null == pprocessService) {
                pprocessService = new PprocessService((OcRefundEngineService)SpringApplicationContextUtil.getBean((String)"ocRefundEngineService"));
                for (int i = 0; i < 20; ++i) {
                    pprocessService.addPollPool(new PprocessPollThread(pprocessService));
                }
            }
            return pprocessService;
        }
    }

    @Override
    public void queryPprocessLoadDb() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<OcRecflowPprocess> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getPprocessService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getPprocessService().getPage());
                result = this.ocRecflowPprocessService.queryRecflowPprocessPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getPprocessService().addPutPool(new PprocessModelPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), result.getRows()));
                    if (result.getRows().size() == this.getPprocessService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getPprocessService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundEngineServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public String sendBatchSaveRefund(List<OcRefundDomain> ocRefundDomainList) throws ApiException {
        String code = this.ocRefundService.saveBatchRefund(ocRefundDomainList);
        OcRefundCtrlServiceImpl.getRefundEsService().addPutPool(new RefundDomainPutThread(OcRefundCtrlServiceImpl.getRefundEsService(), ocRefundDomainList));
        return code;
    }

    @Override
    public Map<String, String> sendsaveRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        OcRefund ocRefund = this.ocRefundService.saveRefundre(ocRefundDomain);
        ArrayList<OcRefundDomain> ocRefundDomainList = new ArrayList<OcRefundDomain>();
        ocRefundDomainList.add(ocRefundDomain);
        OcRefundCtrlServiceImpl.getRefundEsService().addPutPool(new RefundDomainPutThread(OcRefundCtrlServiceImpl.getRefundEsService(), ocRefundDomainList));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", "success");
        map.put("code", ocRefund.getRefundCode());
        return map;
    }

    @Override
    public String sendSaveRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        OcSendcontractData ocSendcontractData = this.ocRefundService.saveRefundRe(ocRefundDomain);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendUpdateRefundStateByNcode(String refundNcode, String channelCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcRefund ocRefund = this.ocRefundService.getRefundByNcode(refundNcode, channelCode, tenantCode);
        if (null == ocRefund) {
            return null;
        }
        this.sendRefundNext(ocRefund.getRefundCode(), tenantCode, map);
        return "";
    }

    @Override
    public String sendRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        Map<String, Object> remap = this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
        if (MapUtil.isEmpty(remap)) {
            return null;
        }
        OcSendcontractData ocSendcontractData = (OcSendcontractData)remap.get("ocSendcontractData");
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        OcRefund ocRefund = (OcRefund)remap.get("ocRefund");
        if (null != ocRefund) {
            OcRefundServiceImpl.getRefundService().putQueue(ocRefund);
        }
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendsaveRefundPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.saveRefundPay(refundCode, tenantCode, ptradeSeqno, dataState);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundPass(String refundCode, String tenantCode, Map<String, Object> map) {
        Map<String, Object> remap = this.ocRefundService.updateRefundPass(refundCode, tenantCode, map);
        if (MapUtil.isEmpty(remap)) {
            return null;
        }
        OcSendcontractData ocSendcontractData = (OcSendcontractData)remap.get("ocSendcontractData");
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        OcRefund ocRefund = (OcRefund)remap.get("ocRefund");
        if (null != ocRefund) {
            OcRefundServiceImpl.getRefundService().putQueue(ocRefund);
        }
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundPay(OcRefund ocRefund) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundPay(ocRefund);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundRefuse(String refundCode, String tenantCode, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundRefuse(refundCode, tenantCode, map);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundRes(refundCode, tenantCode, map);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundStateByCode(String refundCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundStateByCode(refundCode, dataState, oldDataState, tenantCode);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundStateById(Integer refundId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundState(refundId, dataState, oldDataState);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    static {
        lock = new Object();
    }
}

