/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRefundGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcRefundMapper;
import com.yqbsoft.laser.service.contract.domain.DisChannelsendDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractproDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundCtrlCflowDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundCtrlDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundFileDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.contract.domain.OcSendcontractDataDomain;
import com.yqbsoft.laser.service.contract.engine.RefundPollThread;
import com.yqbsoft.laser.service.contract.engine.RefundPutThread;
import com.yqbsoft.laser.service.contract.engine.RefundService;
import com.yqbsoft.laser.service.contract.enumc.RefundState;
import com.yqbsoft.laser.service.contract.enumc.RefundType;
import com.yqbsoft.laser.service.contract.model.OcContractGoods;
import com.yqbsoft.laser.service.contract.model.OcContractpro;
import com.yqbsoft.laser.service.contract.model.OcRefund;
import com.yqbsoft.laser.service.contract.model.OcRefundCtrl;
import com.yqbsoft.laser.service.contract.model.OcRefundFile;
import com.yqbsoft.laser.service.contract.model.OcRefundGoods;
import com.yqbsoft.laser.service.contract.model.OcSendcontractApi;
import com.yqbsoft.laser.service.contract.model.OcSendcontractApiconf;
import com.yqbsoft.laser.service.contract.model.OcSendcontractData;
import com.yqbsoft.laser.service.contract.model.PtradeBackBean;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcContractproService;
import com.yqbsoft.laser.service.contract.service.OcRefundCtrlService;
import com.yqbsoft.laser.service.contract.service.OcRefundFileService;
import com.yqbsoft.laser.service.contract.service.OcRefundService;
import com.yqbsoft.laser.service.contract.service.OcRefundSettlService;
import com.yqbsoft.laser.service.contract.service.OcSendDataBaseService;
import com.yqbsoft.laser.service.contract.service.OcSendcontractApiService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRefundServiceImpl
extends BaseServiceImpl
implements OcRefundService {
    public static final String SYS_CODE = "oc.CONTRACT.OcRefundServiceImpl";
    private static RefundService refundService;
    private static Object lock;
    private OcRefundMapper ocRefundMapper;
    private OcRefundGoodsMapper ocRefundGoodsMapper;
    private OcRefundSettlService ocRefundSettlService;
    private OcRefundFileService ocRefundFileService;
    private OcContractService ocContractService;
    private OcSendcontractApiService ocSendcontractApiService;
    private OcSendDataBaseService ocSendDataBaseService;
    OcRefundCtrlService ocRefundCtrlService;
    OcContractproService ocContractproService;

    public void setOcRefundCtrlService(OcRefundCtrlService ocRefundCtrlService) {
        this.ocRefundCtrlService = ocRefundCtrlService;
    }

    public OcSendDataBaseService getOcSendDataBaseService() {
        if (null == this.ocSendDataBaseService) {
            this.ocSendDataBaseService = (OcSendDataBaseService)SpringApplicationContextUtil.getBean((String)"ocSendDataBaseService");
        }
        return this.ocSendDataBaseService;
    }

    public OcContractproService getContractproService() {
        if (null == this.ocContractproService) {
            this.ocContractproService = (OcContractproService)SpringApplicationContextUtil.getBean((String)"ocContractproService");
        }
        return this.ocContractproService;
    }

    public void setOcSendcontractApiService(OcSendcontractApiService ocSendcontractApiService) {
        this.ocSendcontractApiService = ocSendcontractApiService;
    }

    public OcContractService getOcContractService() {
        return this.ocContractService;
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    public OcRefundFileService getOcRefundFileService() {
        return this.ocRefundFileService;
    }

    public void setOcRefundFileService(OcRefundFileService ocRefundFileService) {
        this.ocRefundFileService = ocRefundFileService;
    }

    public OcRefundSettlService getOcRefundSettlService() {
        return this.ocRefundSettlService;
    }

    public void setOcRefundSettlService(OcRefundSettlService ocRefundSettlService) {
        this.ocRefundSettlService = ocRefundSettlService;
    }

    public void setOcRefundMapper(OcRefundMapper ocRefundMapper) {
        this.ocRefundMapper = ocRefundMapper;
    }

    public void setOcRefundGoodsMapper(OcRefundGoodsMapper ocRefundGoodsMapper) {
        this.ocRefundGoodsMapper = ocRefundGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRefundMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRefund(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundDomain.getRefundType())) {
            msg = msg + "RefundType\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRefundDefault(OcRefund ocRefund) {
        if (null == ocRefund) {
            return;
        }
        if (null == ocRefund.getDataState()) {
            ocRefund.setDataState(0);
        }
        if (null == ocRefund.getGmtCreate()) {
            ocRefund.setGmtCreate(this.getSysDate());
        }
        ocRefund.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocRefund.getRefundCode())) {
            ocRefund.setRefundCode(this.getNo(null, OcRefund.class.getSimpleName(), "refundCode", ocRefund.getTenantCode()));
        }
    }

    private int getRefundMaxCode() {
        int code = 0;
        try {
            return this.ocRefundMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRefundUpdataDefault(OcRefund ocRefund) {
        if (null == ocRefund) {
            return;
        }
        ocRefund.setGmtModified(this.getSysDate());
    }

    private void saveRefundModel(OcRefund ocRefund) throws ApiException {
        if (null == ocRefund) {
            return;
        }
        try {
            this.ocRefundMapper.insert(ocRefund);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundModel.ex", (Throwable)e);
        }
    }

    private OcRefund getRefundModelById(Integer refundId) {
        if (null == refundId) {
            return null;
        }
        try {
            return this.ocRefundMapper.selectByPrimaryKey(refundId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundModelById", (Throwable)e);
            return null;
        }
    }

    public OcRefund getRefundModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRefundMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRefundModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundModelByCode.num");
        }
    }

    private void deleteRefundModel(Integer refundId) throws ApiException {
        if (null == refundId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundMapper.deleteByPrimaryKey(refundId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundModel.num");
        }
    }

    private void updateRefundModel(OcRefund ocRefund) throws ApiException {
        if (null == ocRefund) {
            return;
        }
        try {
            this.ocRefundMapper.updateByPrimaryKeySelective(ocRefund);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundModel.ex", (Throwable)e);
        }
    }

    private void updateStateRefundModel(Integer refundId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == refundId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundId", refundId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        this.logger.error("oc.CONTRACT.OcRefundServiceImplupdateStateRefundModel====" + map);
        int i = 0;
        try {
            i = this.ocRefundMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundModel.null");
        }
        this.logger.error("oc.CONTRACT.OcRefundServiceImplupdateStateRefundModel!!!!!!!!!" + i);
    }

    private OcRefund makeRefund(OcRefundDomain ocRefundDomain, OcRefund ocRefund) {
        if (null == ocRefundDomain) {
            return null;
        }
        if (null == ocRefund) {
            ocRefund = new OcRefund();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefund, (Object)ocRefundDomain);
            return ocRefund;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeRefund", (Throwable)e);
            return null;
        }
    }

    private List<OcRefund> queryRefundModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRefundMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.queryRefundModel", (Throwable)e);
            return null;
        }
    }

    private int countRefund(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRefundMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.countRefund", (Throwable)e);
        }
        return i;
    }

    private String checkRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) {
        if (null == ocRefundGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundGoodsDomain.getContractGoodsCode())) {
            msg = msg + "ContractGoodsCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocRefundGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRefundGoodsDefault(OcRefundGoods ocRefundGoods) {
        if (null == ocRefundGoods) {
            return;
        }
        if (null == ocRefundGoods.getDataState()) {
            ocRefundGoods.setDataState(0);
        }
        if (null == ocRefundGoods.getGmtCreate()) {
            ocRefundGoods.setGmtCreate(this.getSysDate());
        }
        ocRefundGoods.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocRefundGoods.getRefundGoodsCode())) {
            ocRefundGoods.setRefundGoodsCode(this.createUUIDString());
        }
    }

    private int getRefundGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocRefundGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRefundGoodsUpdataDefault(OcRefundGoods ocRefundGoods) {
        if (null == ocRefundGoods) {
            return;
        }
        ocRefundGoods.setGmtModified(this.getSysDate());
    }

    private void saveRefundGoodsModel(OcRefundGoods ocRefundGoods) throws ApiException {
        if (null == ocRefundGoods) {
            return;
        }
        try {
            this.ocRefundGoodsMapper.insert(ocRefundGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveBatchRefundGoodsModel(List<OcRefundGoods> ocRefundGoodsList) throws ApiException {
        if (null == ocRefundGoodsList || ocRefundGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ocRefundGoodsMapper.insertBatch(ocRefundGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveBatchRefundGoodsModel.ex", (Throwable)e);
        }
    }

    private OcRefundGoods getRefundGoodsModelById(Integer refundGoodsId) {
        if (null == refundGoodsId) {
            return null;
        }
        try {
            return this.ocRefundGoodsMapper.selectByPrimaryKey(refundGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public OcRefundGoods getRefundGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRefundGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.getRefundGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delRefundGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.delRefundGoodsModelByCode.num");
        }
    }

    private void deleteRefundGoodsModel(Integer refundGoodsId) throws ApiException {
        if (null == refundGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.deleteByPrimaryKey(refundGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.deleteRefundGoodsModel.num");
        }
    }

    private void updateRefundGoodsModel(OcRefundGoods ocRefundGoods) throws ApiException {
        if (null == ocRefundGoods) {
            return;
        }
        try {
            this.ocRefundGoodsMapper.updateByPrimaryKeySelective(ocRefundGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStateRefundGoodsModel(Integer refundGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == refundGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundGoodsId", refundGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateStateRefundGoodsModel.null");
        }
    }

    private OcRefundGoods makeRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain, OcRefundGoods ocRefundGoods) {
        if (null == ocRefundGoodsDomain) {
            return null;
        }
        if (null == ocRefundGoods) {
            ocRefundGoods = new OcRefundGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundGoods, (Object)ocRefundGoodsDomain);
            return ocRefundGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeRefundGoods", (Throwable)e);
            return null;
        }
    }

    private List<OcRefundGoods> queryRefundGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRefundGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.queryRefundGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countRefundGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRefundGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.countRefundGoods", (Throwable)e);
        }
        return i;
    }

    @Override
    public OcSendcontractData saveRefundRe(OcRefundDomain ocRefundDomain) throws ApiException {
        OcRefund ocRefund = this.saveRefundModle(ocRefundDomain);
        if (null == ocRefund) {
            return null;
        }
        return this.saveSendcontractDataRe(ocRefund, "add");
    }

    @Override
    public OcRefund saveRefundre(OcRefundDomain ocRefundDomain) throws ApiException {
        return this.saveRefundModle(ocRefundDomain);
    }

    @Override
    public String saveBatchRefund(List<OcRefundDomain> ocRefundDomainList) throws ApiException {
        if (ListUtil.isEmpty(ocRefundDomainList)) {
            return null;
        }
        String code = null;
        for (OcRefundDomain ocRefundDomain : ocRefundDomainList) {
            code = this.saveRefund(ocRefundDomain);
        }
        return code;
    }

    @Override
    public String saveRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        OcRefund ocRefund = this.saveRefundModle(ocRefundDomain);
        return ocRefund.getRefundCode();
    }

    private OcRefund saveRefundModle(OcRefundDomain ocRefundDomain) {
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefund.checkRefund", msg);
        }
        OcRefund ocRefund = this.makeRefund(ocRefundDomain, null);
        this.setRefundDefault(ocRefund);
        this.saveRefundModel(ocRefund);
        this.saveOcRefundCtrl(ocRefund);
        this.saveBatchRefundGoods(ocRefundDomain.getOcRefundGoodsDomainList(), ocRefund);
        if (null != ocRefundDomain.getOcRefundFileDomainList() && !ocRefundDomain.getOcRefundFileDomainList().isEmpty()) {
            this.saveBatchFile(ocRefundDomain.getOcRefundFileDomainList(), ocRefund);
        }
        ocRefundDomain.setRefundCode(ocRefund.getRefundCode());
        ocRefundDomain.setRefundId(ocRefund.getRefundId());
        return ocRefund;
    }

    private String saveOcRefundCtrl(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        OcRefundCtrlDomain ocRefundCtrlDomain = this.createOcRefundCtrlDomain(ocRefund);
        if (null == ocRefundCtrlDomain) {
            return null;
        }
        return this.ocRefundCtrlService.saveRefundCtrl(ocRefundCtrlDomain);
    }

    private OcRefundCtrlDomain createOcRefundCtrlDomain(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        OcRefundCtrlDomain ocRefundCtrlDomain = new OcRefundCtrlDomain();
        ocRefundCtrlDomain.setRefundCode(ocRefund.getRefundCode());
        ocRefundCtrlDomain.setTenantCode(ocRefund.getTenantCode());
        ocRefundCtrlDomain.setContractBbillcode(ocRefund.getContractBbillcode());
        ocRefundCtrlDomain.setContractBillcode(ocRefund.getContractBillcode());
        return ocRefundCtrlDomain;
    }

    private void saveBatchFile(List<OcRefundFileDomain> ocRefundFileDomainList, OcRefund ocRefund) {
        if (null == ocRefundFileDomainList || ocRefundFileDomainList.isEmpty() || null == ocRefund) {
            return;
        }
        String tenantCode = ocRefund.getTenantCode();
        for (OcRefundFileDomain ocRefundFileDomain : ocRefundFileDomainList) {
            ocRefundFileDomain.setRefundCode(ocRefund.getRefundCode());
            ocRefundFileDomain.setTenantCode(tenantCode);
            ocRefundFileDomain.setContractBillcode(ocRefund.getContractBillcode());
        }
        this.ocRefundFileService.saveRefundFileBatch(ocRefundFileDomainList);
    }

    @Override
    public OcSendcontractData updateRefundState(Integer refundId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundModel(refundId, dataState, oldDataState);
        OcRefund ocRefund = this.getRefundModelById(refundId);
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    private OcSendcontractData saveSendcontractDataRe(OcRefund ocRefund, String sendcontractDataType) {
        if (null == ocRefund) {
            return null;
        }
        OcSendcontractDataDomain ocSendcontractDataDomain = new OcSendcontractDataDomain();
        ocSendcontractDataDomain.setAppmanageIcode(ocRefund.getAppmanageIcode());
        ocSendcontractDataDomain.setMemberBcode(ocRefund.getMemberBcode());
        ocSendcontractDataDomain.setMemberBname(ocRefund.getMemberBname());
        ocSendcontractDataDomain.setMemberCcode(ocRefund.getMemberCcode());
        ocSendcontractDataDomain.setMemberCname(ocRefund.getMemberCname());
        ocSendcontractDataDomain.setMemberCode(ocRefund.getMemberCode());
        ocSendcontractDataDomain.setMemberName(ocRefund.getMemberName());
        ocSendcontractDataDomain.setSendcontractDataOpcode(ocRefund.getRefundCode());
        ocSendcontractDataDomain.setSendcontractDataType(sendcontractDataType);
        ocSendcontractDataDomain.setTenantCode(ocRefund.getTenantCode());
        return this.getOcSendDataBaseService().synSendcontractDataRe(ocSendcontractDataDomain);
    }

    @Override
    public void updateRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        String msg = this.checkRefund(ocRefundDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefund.checkRefund", msg);
        }
        this.updateStateRefundModel(ocRefundDomain.getRefundId(), 0, 0);
        OcRefund oldOcRefund = this.getRefundModelById(ocRefundDomain.getRefundId());
        if (null == oldOcRefund) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefund.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRefund ocRefund = this.makeRefund(ocRefundDomain, oldOcRefund);
        this.setRefundUpdataDefault(ocRefund);
        this.updateRefundModel(ocRefund);
    }

    @Override
    public OcRefundReDomain getRefund(Integer refundId) {
        return this.makeOcRefundDomain(this.getRefundModelById(refundId));
    }

    private OcRefundReDomain makeOcRefundDomainRe(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        OcRefundReDomain ocRefundReDomain = new OcRefundReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundReDomain, (Object)ocRefund);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeOcRefundDomain.e", (Throwable)e);
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", ocRefund.getRefundCode());
        map.put("tenantCode", ocRefund.getTenantCode());
        QueryResult<OcRefundFile> qlist = this.ocRefundFileService.queryRefundFilePage(map);
        if (null != qlist) {
            ocRefundReDomain.setOcRefundFileDomainList(this.makeFileDomain(qlist.getList()));
        }
        ocRefundReDomain.setOcRefundGoodsDomainList(this.makeGoodsDomain(this.queryRefundGoodsModelPage(map)));
        return ocRefundReDomain;
    }

    private List<OcRefundFileDomain> makeFileDomain(List<OcRefundFile> ocRefundFileList) {
        if (ListUtil.isEmpty(ocRefundFileList)) {
            return null;
        }
        ArrayList<OcRefundFileDomain> ocRefundFileDomainList = new ArrayList<OcRefundFileDomain>();
        for (OcRefundFile ocRefundFile : ocRefundFileList) {
            OcRefundFileDomain ocRefundFileDomain = new OcRefundFileDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundFileDomain, (Object)ocRefundFile);
                ocRefundFileDomainList.add(ocRefundFileDomain);
            }
            catch (Exception e) {}
        }
        return ocRefundFileDomainList;
    }

    private List<OcRefundGoodsDomain> makeGoodsDomain(List<OcRefundGoods> ocRefundGoodsList) {
        if (ListUtil.isEmpty(ocRefundGoodsList)) {
            return null;
        }
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        for (OcRefundGoods ocRefundGoods : ocRefundGoodsList) {
            OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)ocRefundGoods);
                ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
            }
            catch (Exception e) {}
        }
        return ocRefundGoodsDomainList;
    }

    private OcRefundReDomain makeOcRefundDomain(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        OcRefundReDomain ocRefundReDomain = new OcRefundReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundReDomain, (Object)ocRefund);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeOcRefundDomain.e", (Throwable)e);
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", ocRefund.getRefundCode());
        map.put("tenantCode", ocRefund.getTenantCode());
        QueryResult<OcRefundFile> qlist = this.ocRefundFileService.queryRefundFilePage(map);
        QueryResult<OcRefundGoods> ocRefundGoodsQueryResult = this.queryRefundGoodsPage(map);
        if (null != qlist) {
            ocRefundReDomain.setOcRefundFileList(qlist.getRows());
        }
        if (null != ocRefundGoodsQueryResult) {
            ocRefundReDomain.setOcRefundGoodsList(ocRefundGoodsQueryResult.getRows());
        }
        ocRefundReDomain.setOcRefundGoodsList(this.queryRefundGoodsModelPage(map));
        return ocRefundReDomain;
    }

    private List<OcRefundReDomain> makeOcRefundReDomainList(List<OcRefund> ocRefundList, Map<String, Object> map) {
        if (ListUtil.isEmpty(ocRefundList)) {
            return null;
        }
        ArrayList<OcRefundReDomain> refundReDomainList = new ArrayList<OcRefundReDomain>();
        boolean ocContractProFlag = null == map.get("ocContractProFlag") ? false : Boolean.valueOf(map.get("ocContractProFlag").toString());
        boolean ocContractGoodsFlag = null == map.get("ocContractGoodsFlag") ? false : Boolean.valueOf(map.get("ocContractGoodsFlag").toString());
        for (OcRefund ocRefund : ocRefundList) {
            OcRefundReDomain ocRefundReDomain = this.makeOcRefundDomain(ocRefund);
            if (ocContractProFlag) {
                this.queryContractpro(ocRefundReDomain);
            }
            if (ocContractGoodsFlag) {
                this.queryContractGoods(ocRefundReDomain);
            }
            refundReDomainList.add(ocRefundReDomain);
        }
        return refundReDomainList;
    }

    void queryContractGoods(OcRefundReDomain ocRefundReDomain) {
        List<OcRefundGoods> ocRefundGoodsList = ocRefundReDomain.getOcRefundGoodsList();
        if (ListUtil.isEmpty(ocRefundGoodsList)) {
            return;
        }
        ArrayList<OcContractGoodsDomain> list = new ArrayList<OcContractGoodsDomain>();
        for (OcRefundGoods ocRefundGoods : ocRefundGoodsList) {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            if (null == ocRefundGoods.getContractGoodsCode()) continue;
            OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
            parammap.put("contractGoodsCode", ocRefundGoods.getContractGoodsCode());
            parammap.put("tenantCode", ocRefundGoods.getTenantCode());
            OcContractGoods ocContractGoods = this.ocContractService.getContractGoodsByCode(parammap);
            try {
                BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)ocContractGoods);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocContractGoodsDomain.setContractGoodsRefnum(ocRefundGoods.getRefundGoodsNum());
            list.add(ocContractGoodsDomain);
        }
        ocRefundReDomain.setGoodsList(list);
    }

    void queryContractpro(OcRefundReDomain ocRefundReDomain) {
        List<OcContractpro> proList = this.getContractproService().querycontractproByOrderCode(ocRefundReDomain.getTenantCode(), ocRefundReDomain.getContractBillcode());
        ocRefundReDomain.setOcContractproDomainList(this.makeOcContractproDomainList(proList));
    }

    private List<OcContractproDomain> makeOcContractproDomainList(List<OcContractpro> ocContractproList) {
        if (null == ocContractproList || ocContractproList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractproDomain> list = new ArrayList<OcContractproDomain>();
        for (OcContractpro ocContractpro : ocContractproList) {
            list.add(this.makeOcContractproDomain(ocContractpro));
        }
        return list;
    }

    private OcContractproDomain makeOcContractproDomain(OcContractpro OcContractpro2) {
        if (null == OcContractpro2) {
            return null;
        }
        OcContractproDomain ocContractproDomain = new OcContractproDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractproDomain, (Object)OcContractpro2);
            return ocContractproDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.makeOcContractproDomain", (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteRefund(Integer refundId) throws ApiException {
        this.deleteRefundModel(refundId);
    }

    @Override
    public QueryResult<OcRefund> queryRefundPage(Map<String, Object> map) {
        List<OcRefund> ocRefundList = this.queryRefundModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefund(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundList);
        return queryResult;
    }

    @Override
    public QueryResult<OcRefundReDomain> queryRefundReDomainPage(Map<String, Object> map) {
        int count = this.countRefund(map);
        List<Object> ocRefundList = new ArrayList();
        if (count > 0) {
            ocRefundList = this.queryRefundReDomainModelPage(map);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefund(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundList);
        return queryResult;
    }

    private List<OcRefundReDomain> queryRefundReDomainModelPage(Map<String, Object> map) {
        List<OcRefund> ocRefundList = this.queryRefundModelPage(map);
        return this.makeOcRefundReDomainList(ocRefundList, map);
    }

    @Override
    public OcRefundReDomain getRefundByCode(Map<String, Object> map) {
        return this.makeOcRefundDomain(this.getRefundModelByCode(map));
    }

    @Override
    public OcRefundReDomain getRefundDomainByCode(Map<String, Object> map) {
        return this.makeOcRefundDomainRe(this.getRefundModelByCode(map));
    }

    @Override
    public void delRefundByCode(Map<String, Object> map) throws ApiException {
        this.delRefundModelByCode(map);
    }

    @Override
    public String saveRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) throws ApiException {
        OcRefundGoods ocRefundGoods = this.makeRefundGoods(ocRefundGoodsDomain);
        this.saveRefundGoodsModel(ocRefundGoods);
        return ocRefundGoods.getRefundGoodsCode();
    }

    private void saveBatchRefundGoods(List<OcRefundGoodsDomain> ocRefundGoodsDomainList, OcRefund ocRefund) {
        if (null == ocRefundGoodsDomainList || ocRefundGoodsDomainList.isEmpty() || null == ocRefund) {
            return;
        }
        ArrayList<OcRefundGoods> ocRefundGoodsList = new ArrayList<OcRefundGoods>();
        for (OcRefundGoodsDomain ocRefundGoodsDomain : ocRefundGoodsDomainList) {
            ocRefundGoodsDomain.setRefundCode(ocRefund.getRefundCode());
            ocRefundGoodsDomain.setContractBillcode(ocRefund.getContractBillcode());
            ocRefundGoodsList.add(this.makeRefundGoods(ocRefundGoodsDomain));
        }
        this.saveBatchRefundGoodsModel(ocRefundGoodsList);
    }

    private OcRefundGoods makeRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) {
        String msg = this.checkRefundGoods(ocRefundGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundGoods.checkRefundGoods", msg);
        }
        OcRefundGoods ocRefundGoods = this.makeRefundGoods(ocRefundGoodsDomain, null);
        this.setRefundGoodsDefault(ocRefundGoods);
        return ocRefundGoods;
    }

    @Override
    public void updateRefundGoodsState(Integer refundGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundGoodsModel(refundGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateRefundGoods(OcRefundGoodsDomain ocRefundGoodsDomain) throws ApiException {
        String msg = this.checkRefundGoods(ocRefundGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundGoods.checkRefundGoods", msg);
        }
        OcRefundGoods oldOcRefundGoods = this.getRefundGoodsModelById(ocRefundGoodsDomain.getRefundGoodsId());
        if (null == oldOcRefundGoods) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRefundGoods ocRefundGoods = this.makeRefundGoods(ocRefundGoodsDomain, oldOcRefundGoods);
        this.setRefundGoodsUpdataDefault(ocRefundGoods);
        this.updateRefundGoodsModel(ocRefundGoods);
    }

    @Override
    public OcRefundGoods getRefundGoods(Integer refundGoodsId) {
        return this.getRefundGoodsModelById(refundGoodsId);
    }

    @Override
    public void deleteRefundGoods(Integer refundGoodsId) throws ApiException {
        this.deleteRefundGoodsModel(refundGoodsId);
    }

    @Override
    public QueryResult<OcRefundGoods> queryRefundGoodsPage(Map<String, Object> map) {
        List<OcRefundGoods> ocRefundGoodsList = this.queryRefundGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefundGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundGoodsList);
        return queryResult;
    }

    @Override
    public OcRefundGoods getRefundGoodsByCode(Map<String, Object> map) {
        return this.getRefundGoodsModelByCode(map);
    }

    @Override
    public void delRefundGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delRefundGoodsModelByCode(map);
    }

    @Override
    public OcSendcontractData updateRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String goodsCode = (String)map.get("goodsCode");
        if (null == goodsCode) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.goodsCode.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        Integer oldDatastate = ocRefund.getDataState();
        Integer datastate = 0;
        if (oldDatastate == RefundState.APPLY.getCode()) {
            datastate = RefundState.REVOKE.getCode();
        } else if (oldDatastate == RefundState.SEND.getCode()) {
            datastate = RefundState.RESGOODS.getCode();
        } else {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.refundDataState." + oldDatastate, "\u9000\u8d27\u5355\u72b6\u6001\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c~");
        }
        this.updateStateRefundModel(ocRefund.getRefundId(), datastate, ocRefund.getDataState());
        this.saveContractRes(qmap);
        ocRefund.setDataState(datastate);
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    @Override
    public OcSendcontractData updateRefundRefuse(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        Integer oldDatastate = ocRefund.getDataState();
        Integer datastate = 0;
        if (oldDatastate == RefundState.APPLY.getCode()) {
            datastate = RefundState.RESAPP.getCode();
        } else if (oldDatastate == RefundState.SEND.getCode()) {
            datastate = RefundState.RESGOODS.getCode();
        } else {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundRes.refundDataState." + oldDatastate, "\u9000\u8d27\u5355\u72b6\u6001\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u540e\u64cd\u4f5c~");
        }
        this.updateStateRefundModel(ocRefund.getRefundId(), datastate, ocRefund.getDataState());
        this.saveContractRes(qmap);
        ocRefund.setDataState(datastate);
        ocRefund.setMemo((String)map.get("memo"));
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    private void saveContractRes(Map<String, Object> qmap) {
        if (null == qmap || qmap.isEmpty()) {
            return;
        }
        List<OcRefundGoods> rlist = this.queryRefundGoodsModelPage(qmap);
        if (null == rlist || rlist.isEmpty()) {
            return;
        }
        for (OcRefundGoods ocRefundGoods : rlist) {
            if (null != ocRefundGoods.getGoodsCamount()) {
                ocRefundGoods.setGoodsCamount(ocRefundGoods.getGoodsCamount().multiply(new BigDecimal(-1)));
            }
            if (null != ocRefundGoods.getGoodsCweight()) {
                ocRefundGoods.setGoodsCweight(ocRefundGoods.getGoodsCweight().multiply(new BigDecimal(-1)));
            }
            this.ocContractService.updateContractGoodsAndRefund(ocRefundGoods.getTenantCode(), ocRefundGoods.getContractGoodsCode(), ocRefundGoods.getGoodsCamount(), ocRefundGoods.getGoodsCweight(), 0);
        }
    }

    @Override
    public OcSendcontractData saveRefundPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundPay.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.saveRefundPay.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        this.updateStateRefundModel(ocRefund.getRefundId(), RefundState.SUC.getCode(), ocRefund.getDataState());
        ocRefund.setDataState(RefundState.SUC.getCode());
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    @Override
    public Map<String, Object> sendRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        return this.updateRefundPass(refundCode, tenantCode, map);
    }

    @Override
    public Map<String, Object> updateRefundPass(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isEmpty((String)refundCode) || StringUtils.isEmpty((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPass.null", "\u53c2\u6570\u4e3a\u7a7a");
        }
        HashMap<String, Object> qmap = new HashMap<String, Object>();
        qmap.put("refundCode", refundCode);
        qmap.put("tenantCode", tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(qmap);
        if (ocRefund == null) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPass.no", "\u9000\u6b3e\u8ba2\u5355\u4e0d\u5b58\u5728" + qmap);
        }
        String type = ocRefund.getRefundType();
        Integer oldDatastate = ocRefund.getDataState();
        if (null != map && !map.isEmpty()) {
            OcRefund newOcRefund = new OcRefund();
            newOcRefund.setRefundId(ocRefund.getRefundId());
            try {
                BeanUtils.copyAllPropertys((Object)newOcRefund, map);
            }
            catch (Exception e) {
                throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPass.e", (Throwable)e);
            }
            this.updateRefundModel(newOcRefund);
        }
        Integer dataState = 0;
        boolean pay = false;
        if (type.equals(RefundType.REFMONEY.getCode()) && oldDatastate == RefundState.APPLY.getCode()) {
            dataState = RefundState.PASS.getCode();
            pay = true;
        } else if (type.equals(RefundType.REFGOODS.getCode()) && oldDatastate == RefundState.ARR.getCode()) {
            pay = true;
            dataState = RefundState.PLAT.getCode();
        } else {
            dataState = oldDatastate + 1;
        }
        ocRefund.setDataState(dataState);
        this.updateStateRefundModel(ocRefund.getRefundId(), dataState, oldDatastate);
        boolean flag = true;
        if (pay) {
            this.ocContractService.updateContractRefund(tenantCode, ocRefund.getContractBillcode(), ocRefund.getContractState());
            if (null == ocRefund.getRefundMoney()) {
                flag = false;
            } else {
                int r = ocRefund.getRefundMoney().compareTo(BigDecimal.ZERO);
                if (r <= 0) {
                    flag = false;
                }
            }
        }
        ocRefund.setDataState(dataState);
        OcSendcontractData ocSendcontractData = this.saveSendcontractDataRe(ocRefund, "update");
        HashMap<String, Object> remap = new HashMap<String, Object>();
        remap.put("ocSendcontractData", ocSendcontractData);
        if (flag) {
            remap.put("ocRefund", ocRefund);
        }
        return remap;
    }

    @Override
    public String updatePay(String refundCode, String type, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        Map map = this.getQueryMapParam("refundCode,tenantCode", new Object[]{refundCode, tenantCode});
        OcRefund ocRefund = this.getRefundModelByCode(map);
        if (null == ocRefund) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updatePay.ocRefund", map.toString());
        }
        PtradeBackBean ptradeBackBean = new PtradeBackBean();
        ptradeBackBean.setAcquireSeqno_new(ocRefund.getRefundCode());
        ptradeBackBean.setAcquireSeqno(ocRefund.getContractBbillcode());
        ptradeBackBean.setBusinessOrder(ocRefund.getContractBillcode());
        ptradeBackBean.setBusinessOrderno(ocRefund.getContractBbillcode());
        ptradeBackBean.setPtradeSeqno(ocRefund.getPtradeSeqno());
        ptradeBackBean.setTenantCode(ocRefund.getTenantCode());
        ptradeBackBean.setOrderAmount(ocRefund.getRefundMoney());
        ptradeBackBean.setPtradpdeCode("PAYMENTBACK");
        ptradeBackBean.setPaymentNotifyurl("oc.refund.saveRefundPay");
        ptradeBackBean.setBackAmountType(type);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ptradeBackBean", JsonUtil.buildNormalBinder().toJson((Object)ptradeBackBean));
        String ptePtradeInfoCode = this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", paramMap);
        if (StringUtils.isBlank((String)ptePtradeInfoCode)) {
            return "error";
        }
        return "success";
    }

    @Override
    public String updateSendRefundPay(OcRefundDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            return null;
        }
        PtradeBackBean ptradeBackBean = new PtradeBackBean();
        ptradeBackBean.setAcquireSeqno_new(ocRefundDomain.getRefundCode());
        ptradeBackBean.setAcquireSeqno(ocRefundDomain.getContractBbillcode());
        ptradeBackBean.setBusinessOrder(ocRefundDomain.getContractBillcode());
        ptradeBackBean.setBusinessOrderno(ocRefundDomain.getContractBbillcode());
        ptradeBackBean.setPtradeSeqno(ocRefundDomain.getPtradeSeqno());
        ptradeBackBean.setTenantCode(ocRefundDomain.getTenantCode());
        ptradeBackBean.setOrderAmount(ocRefundDomain.getRefundMoney());
        ptradeBackBean.setPtradpdeCode("PAYMENTBACK");
        ptradeBackBean.setPaymentNotifyurl("oc.refund.saveRefundPay");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ptradeBackBean", JsonUtil.buildNormalBinder().toJson((Object)ptradeBackBean));
        String ptePtradeInfoCode = this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", paramMap);
        if (StringUtils.isBlank((String)ptePtradeInfoCode)) {
            return "error";
        }
        return "success";
    }

    @Override
    public OcSendcontractData updateRefundPay(OcRefund ocRefund) {
        if (null == ocRefund) {
            return null;
        }
        PtradeBackBean ptradeBackBean = new PtradeBackBean();
        ptradeBackBean.setAcquireSeqno_new(ocRefund.getRefundCode());
        ptradeBackBean.setAcquireSeqno(ocRefund.getContractBbillcode());
        ptradeBackBean.setBusinessOrder(ocRefund.getContractBillcode());
        ptradeBackBean.setBusinessOrderno(ocRefund.getContractBbillcode());
        ptradeBackBean.setPtradeSeqno(ocRefund.getPtradeSeqno());
        ptradeBackBean.setTenantCode(ocRefund.getTenantCode());
        ptradeBackBean.setOrderAmount(ocRefund.getRefundMoney());
        ptradeBackBean.setPtradpdeCode("PAYMENTBACK");
        ptradeBackBean.setPaymentNotifyurl("oc.refund.saveRefundPay");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("ptradeBackBean", JsonUtil.buildNormalBinder().toJson((Object)ptradeBackBean));
        this.updateStateRefundModel(ocRefund.getRefundId(), RefundState.PAY.getCode(), ocRefund.getDataState());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("refundCode", ocRefund.getRefundCode());
        map.put("tenantCode", ocRefund.getTenantCode());
        String ptePtradeInfoCode = this.internalInvoke("pte.ptrade.saveParticipantByPtradeBack", paramMap);
        if (StringUtils.isBlank((String)ptePtradeInfoCode)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundPay.null", "");
        }
        ocRefund.setDataState(RefundState.PAY.getCode());
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RefundService getRefundService() {
        Object object = lock;
        synchronized (object) {
            if (null == refundService) {
                refundService = new RefundService((OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"));
                refundService.addPollPool(new RefundPollThread(refundService));
            }
            return refundService;
        }
    }

    @Override
    public void loadRefundProcess() {
        this.loadDb();
    }

    @Override
    public boolean sendApiOcRefund(OcRefund ocRefund) throws ApiException {
        if (null == ocRefund || StringUtils.isBlank((String)ocRefund.getMemberBcode()) || StringUtils.isBlank((String)ocRefund.getTenantCode())) {
            return false;
        }
        HashMap<String, Object> apiMap = new HashMap<String, Object>();
        apiMap.put("tenantCode", ocRefund.getTenantCode());
        QueryResult<OcSendcontractApi> userApi = this.ocSendcontractApiService.querySendcontractApiPage(apiMap);
        if (null == userApi || userApi.getList().size() <= 0) {
            return false;
        }
        List userApiList = userApi.getList();
        List<OcSendcontractApi> uApiList = this.structureApi(userApiList, ocRefund);
        if (null == uApiList || uApiList.isEmpty()) {
            return false;
        }
        for (OcSendcontractApi rsRessendApi : uApiList) {
            HashMap<String, OcRefund> paramMap1 = new HashMap<String, OcRefund>();
            paramMap1.put("ocRefund", ocRefund);
            String result = (String)this.getInternalRouter().inInvoke(rsRessendApi.getSendcontractApiapicode(), "1.0", "0", paramMap1);
            if (!StringUtils.isEmpty((String)result) && !"false".equals(result)) continue;
            this.logger.error("\u672a\u6210\u529f\u5904\u7406\u7684api *****" + rsRessendApi.getSendcontractApiCode() + "*****" + ocRefund.getMemberBcode());
            return false;
        }
        return false;
    }

    private void updateRefundStateByCodes(String refundCode, Integer dataState, Integer oldDataState, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundCode", refundCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("tenantCode", tenantCode);
        try {
            this.ocRefundMapper.updateRefundStateByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.updateRefundStateByCodes===" + map);
        }
    }

    @Override
    public OcSendcontractData updateRefundStateByCode(String refundCode, Integer dataState, Integer oldDataState, String tenantCode) throws ApiException {
        this.updateRefundStateByCodes(refundCode, dataState, oldDataState, tenantCode);
        OcRefund ocRefund = this.getRefundModelByCode(this.getQueryMapParam("refundCode,tenantCode", new Object[]{refundCode, tenantCode}));
        return this.saveSendcontractDataRe(ocRefund, "update");
    }

    private List<OcSendcontractApi> structureApi(List<OcSendcontractApi> userApiList, OcRefund ocRefund) {
        ArrayList<OcSendcontractApi> ocSendcontractApiList = new ArrayList<OcSendcontractApi>();
        for (OcSendcontractApi ocSendsendApi : userApiList) {
            List apiconfList;
            Map<String, List<String>> map;
            HashMap<String, Object> apiconfMap = new HashMap<String, Object>();
            apiconfMap.put("sendcontractApiapicode", ocSendsendApi.getSendcontractApiCode());
            apiconfMap.put("tenantCode", ocSendsendApi.getTenantCode());
            QueryResult<OcSendcontractApiconf> apiconf = this.ocSendcontractApiService.querysendcontractApiconfPage(apiconfMap);
            if (null == apiconf || apiconf.getList().size() <= 0) {
                ocSendcontractApiList.add(ocSendsendApi);
            }
            if (null == (map = this.makeScopelist(apiconfList = apiconf.getList())) || map.isEmpty()) continue;
            boolean flag = true;
            for (String key : map.keySet()) {
                String objValue = (String)BeanUtils.forceGetProperty((Object)ocSendsendApi, (String)key);
                if (null == objValue) {
                    flag = false;
                    break;
                }
                if (map.get(key).contains(objValue)) continue;
                flag = false;
                break;
            }
            if (!flag || ocSendcontractApiList.contains(ocSendsendApi)) continue;
            ocSendcontractApiList.add(ocSendsendApi);
        }
        return ocSendcontractApiList;
    }

    private Map<String, List<String>> makeScopelist(List<OcSendcontractApiconf> apiconfList) {
        if (ListUtil.isEmpty(apiconfList)) {
            return null;
        }
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (OcSendcontractApiconf ocSendcontractApiconf : apiconfList) {
            ArrayList<String> list = (ArrayList<String>)map.get(ocSendcontractApiconf.getSendcontractApiconfType());
            if (null == list) {
                list = new ArrayList<String>();
                map.put(ocSendcontractApiconf.getSendcontractApiconfType(), list);
            }
            list.add(ocSendcontractApiconf.getSendcontractApiconfOp());
        }
        return map;
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", RefundState.ARR.getCode());
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<OcRefund> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = OcRefundServiceImpl.getRefundService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", OcRefundServiceImpl.getRefundService().getPage());
                result = this.queryRefundPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    OcRefundServiceImpl.getRefundService().addPutPool(new RefundPutThread(OcRefundServiceImpl.getRefundService(), result.getRows()));
                    if (result.getRows().size() == OcRefundServiceImpl.getRefundService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            OcRefundServiceImpl.getRefundService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public OcSendcontractData updateRefundStateByNcode(String refundNcode, String channelCode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)refundNcode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<OcRefund> list = this.queryRefundModelPage(this.getQueryMapParam("refundNcode,channelCode,tenantCode", new Object[]{refundNcode, channelCode, tenantCode}));
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        return this.updateRefundState(list.get(0).getRefundId(), dataState, oldDataState);
    }

    @Override
    public OcRefund getRefundByNcode(String refundNcode, String channelCode, String tenantCode) {
        if (StringUtils.isBlank((String)refundNcode) || StringUtils.isBlank((String)channelCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        List<OcRefund> list = this.queryRefundModelPage(this.getQueryMapParam("refundNcode,channelCode,tenantCode", new Object[]{refundNcode, channelCode, tenantCode}));
        if (ListUtil.isEmpty(list)) {
            return null;
        }
        return list.get(0);
    }

    @Override
    public String sendOcRefund(OcRefundReDomain ocRefundDomain) {
        if (null == ocRefundDomain) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.sendOcRefund", (Object)"param is null");
            return "error";
        }
        OcRefundReDomain ocRefundReDomain = this.getRefundDomainByCode(this.getQueryParamMap("refundCode,tenantCode", new Object[]{ocRefundDomain.getRefundCode(), ocRefundDomain.getTenantCode()}));
        if (null == ocRefundReDomain) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.sendOcRefund", (Object)(ocRefundDomain.getRefundCode() + "-" + ocRefundDomain.getTenantCode()));
            return "error";
        }
        ArrayList<DisChannelsendDomain> disChannelsendDomainList = new ArrayList<DisChannelsendDomain>();
        DisChannelsendDomain disChannelsendDomain = new DisChannelsendDomain();
        if (null == ocRefundReDomain.getDataState()) {
            ocRefundReDomain.setDataState(0);
        }
        disChannelsendDomain.setChannelsendDir(ocRefundReDomain.getDataState().toString());
        disChannelsendDomain.setChannelsendType("OcRefund");
        disChannelsendDomain.setChannelCode(ocRefundReDomain.getChannelCode());
        disChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)ocRefundReDomain));
        disChannelsendDomain.setTenantCode(ocRefundReDomain.getTenantCode());
        disChannelsendDomainList.add(disChannelsendDomain);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("disChannelsendDomainList", JsonUtil.buildNormalBinder().toJson(disChannelsendDomainList));
        try {
            this.getInternalRouter().inInvoke("dis.channelsendBase.sendChannelsendBatch", map);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "success";
    }

    @Override
    public void updateExtrinsicStateByRefundCode(String refundCode, String dataOpnextbillstate, String tenantCode) throws ApiException {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)dataOpnextbillstate) || StringUtils.isBlank((String)tenantCode)) {
            this.logger.error("oc.CONTRACT.OcRefundServiceImpl.updateExtrinsicStateBysendgoodsCode.param", (Object)(refundCode + "-" + dataOpnextbillstate + "-" + tenantCode));
            return;
        }
        this.updateExtrinsicStateByCode(this.getQueryParamMap("refundCode,dataOpnextbillstate,tenantCode", new Object[]{refundCode, dataOpnextbillstate, tenantCode}));
    }

    @Override
    public Map<String, Object> queryOcRefundCount(Map<String, Object> map) throws ApiException {
        Map<String, Object> resMap = null;
        try {
            resMap = this.ocRefundMapper.countData(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.queryOcRefundCount.ex", (Throwable)e);
        }
        return resMap;
    }

    public void updateExtrinsicStateByCode(Map<String, Object> map) {
        if (MapUtil.isEmpty(map)) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateExtrinsicStateByCode.null", "map is null");
        }
        int i = 0;
        try {
            i = this.ocRefundMapper.updateExtrinsicStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateExtrinsicStateByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateExtrinsicStateByCode.null");
        }
    }

    @Override
    public void updateRefundFlowState(OcRefundCtrlCflowDomain ocRefundCtrlCflowDomain) throws ApiException {
        if (null == ocRefundCtrlCflowDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocRefundCtrlCflowDomain.getTenantCode());
        map.put("refundCtrlSeqno", ocRefundCtrlCflowDomain.getRefundCtrlSeqno());
        OcRefundCtrl ocRefundCtrl = this.ocRefundCtrlService.getRefundCtrlByCode(map);
        if (null == ocRefundCtrl) {
            throw new ApiException("oc.CONTRACT.OcRefundServiceImpl.updateRefundFlowState.null", "\u6570\u636e\u4e3a\u7a7a" + ((Object)map).toString());
        }
        this.updateRefundStateByCodes(ocRefundCtrl.getRefundCode(), ocRefundCtrlCflowDomain.getDataState(), ocRefundCtrlCflowDomain.getOldDataState(), ocRefundCtrl.getTenantCode());
        this.ocRefundCtrlService.updateRefundCtrlCflow(ocRefundCtrlCflowDomain);
    }

    static {
        lock = new Object();
    }
}

