/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRefundSettlMapper;
import com.yqbsoft.laser.service.contract.domain.OcRefundSettlDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundSettlReDomain;
import com.yqbsoft.laser.service.contract.model.OcRefundSettl;
import com.yqbsoft.laser.service.contract.service.OcRefundSettlService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRefundSettlServiceImpl
extends BaseServiceImpl
implements OcRefundSettlService {
    private static final String SYS_CODE = "oc.CONTRACT.OcRefundSettlServiceImpl";
    private OcRefundSettlMapper ocRefundSettlMapper;

    public void setOcRefundSettlMapper(OcRefundSettlMapper ocRefundSettlMapper) {
        this.ocRefundSettlMapper = ocRefundSettlMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRefundSettlMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundSettlServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRefundSettl(OcRefundSettlDomain ocRefundSettlDomain) {
        if (null == ocRefundSettlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundSettlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRefundSettlDefault(OcRefundSettl ocRefundSettl) {
        if (null == ocRefundSettl) {
            return;
        }
        if (null == ocRefundSettl.getDataState()) {
            ocRefundSettl.setDataState(0);
        }
        if (null == ocRefundSettl.getGmtCreate()) {
            ocRefundSettl.setGmtCreate(this.getSysDate());
        }
        ocRefundSettl.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocRefundSettl.getRefundSettlBillcode())) {
            ocRefundSettl.setRefundSettlBillcode(this.createUUIDString());
        }
    }

    private int getRefundSettlMaxCode() {
        int code = 0;
        try {
            return this.ocRefundSettlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundSettlServiceImpl.getRefundSettlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRefundSettlUpdataDefault(OcRefundSettl ocRefundSettl) {
        if (null == ocRefundSettl) {
            return;
        }
        ocRefundSettl.setGmtModified(this.getSysDate());
    }

    private void saveRefundSettlModel(OcRefundSettl ocRefundSettl) throws ApiException {
        if (null == ocRefundSettl) {
            return;
        }
        try {
            this.ocRefundSettlMapper.insert(ocRefundSettl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.saveRefundSettlModel.ex", (Throwable)e);
        }
    }

    private void saveRefundSettlBatchModel(List<OcRefundSettl> ocRefundSettlList) throws ApiException {
        if (null == ocRefundSettlList || ocRefundSettlList.isEmpty()) {
            return;
        }
        try {
            this.ocRefundSettlMapper.insertBatch(ocRefundSettlList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.saveRefundSettlBatchModel.ex", (Throwable)e);
        }
    }

    private OcRefundSettl getRefundSettlModelById(Integer refundSettlId) {
        if (null == refundSettlId) {
            return null;
        }
        try {
            return this.ocRefundSettlMapper.selectByPrimaryKey(refundSettlId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundSettlServiceImpl.getRefundSettlModelById", (Throwable)e);
            return null;
        }
    }

    private OcRefundSettl getRefundSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRefundSettlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundSettlServiceImpl.getRefundSettlModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRefundSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundSettlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.delRefundSettlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.delRefundSettlModelByCode.num");
        }
    }

    private void deleteRefundSettlModel(Integer refundSettlId) throws ApiException {
        if (null == refundSettlId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundSettlMapper.deleteByPrimaryKey(refundSettlId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.deleteRefundSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.deleteRefundSettlModel.num");
        }
    }

    private void updateRefundSettlModel(OcRefundSettl ocRefundSettl) throws ApiException {
        if (null == ocRefundSettl) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundSettlMapper.updateByPrimaryKeySelective(ocRefundSettl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.updateRefundSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.updateRefundSettlModel.num");
        }
    }

    private void updateStateRefundSettlModel(Integer refundSettlId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == refundSettlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundSettlId", refundSettlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRefundSettlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.updateStateRefundSettlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.updateStateRefundSettlModel.null");
        }
    }

    private void updateStateRefundSettlModelByCode(String tenantCode, String refundSettlBillcode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)refundSettlBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("refundSettlBillcode", refundSettlBillcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRefundSettlMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.updateStateRefundSettlModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.updateStateRefundSettlModelByCode.null");
        }
    }

    private OcRefundSettl makeRefundSettl(OcRefundSettlDomain ocRefundSettlDomain, OcRefundSettl ocRefundSettl) {
        if (null == ocRefundSettlDomain) {
            return null;
        }
        if (null == ocRefundSettl) {
            ocRefundSettl = new OcRefundSettl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundSettl, (Object)ocRefundSettlDomain);
            return ocRefundSettl;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundSettlServiceImpl.makeRefundSettl", (Throwable)e);
            return null;
        }
    }

    private OcRefundSettlReDomain makeOcRefundSettlReDomain(OcRefundSettl ocRefundSettl) {
        if (null == ocRefundSettl) {
            return null;
        }
        OcRefundSettlReDomain ocRefundSettlReDomain = new OcRefundSettlReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundSettlReDomain, (Object)ocRefundSettl);
            return ocRefundSettlReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundSettlServiceImpl.makeOcRefundSettlReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcRefundSettl> queryRefundSettlModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRefundSettlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundSettlServiceImpl.queryRefundSettlModel", (Throwable)e);
            return null;
        }
    }

    private int countRefundSettl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRefundSettlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundSettlServiceImpl.countRefundSettl", (Throwable)e);
        }
        return i;
    }

    private OcRefundSettl createOcRefundSettl(OcRefundSettlDomain ocRefundSettlDomain) {
        String msg = this.checkRefundSettl(ocRefundSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.saveRefundSettl.checkRefundSettl", msg);
        }
        OcRefundSettl ocRefundSettl = this.makeRefundSettl(ocRefundSettlDomain, null);
        this.setRefundSettlDefault(ocRefundSettl);
        return ocRefundSettl;
    }

    @Override
    public String saveRefundSettl(OcRefundSettlDomain ocRefundSettlDomain) throws ApiException {
        OcRefundSettl ocRefundSettl = this.createOcRefundSettl(ocRefundSettlDomain);
        this.saveRefundSettlModel(ocRefundSettl);
        return ocRefundSettl.getRefundSettlBillcode();
    }

    @Override
    public String saveRefundSettlBatch(List<OcRefundSettlDomain> ocRefundSettlDomainList) throws ApiException {
        if (null == ocRefundSettlDomainList || ocRefundSettlDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcRefundSettl> ocRefundSettlList = new ArrayList<OcRefundSettl>();
        String code = "";
        for (OcRefundSettlDomain ocRefundSettlDomain : ocRefundSettlDomainList) {
            OcRefundSettl ocRefundSettl = this.createOcRefundSettl(ocRefundSettlDomain);
            code = ocRefundSettl.getRefundSettlBillcode();
            ocRefundSettlList.add(ocRefundSettl);
        }
        this.saveRefundSettlBatchModel(ocRefundSettlList);
        return code;
    }

    @Override
    public void updateRefundSettlState(Integer refundSettlId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundSettlModel(refundSettlId, dataState, oldDataState);
    }

    @Override
    public void updateRefundSettlStateByCode(String tenantCode, String refundSettlBillcode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundSettlModelByCode(tenantCode, refundSettlBillcode, dataState, oldDataState);
    }

    @Override
    public void updateRefundSettl(OcRefundSettlDomain ocRefundSettlDomain) throws ApiException {
        String msg = this.checkRefundSettl(ocRefundSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.updateRefundSettl.checkRefundSettl", msg);
        }
        OcRefundSettl oldOcRefundSettl = this.getRefundSettlModelById(ocRefundSettlDomain.getRefundSettlId());
        if (null == oldOcRefundSettl) {
            throw new ApiException("oc.CONTRACT.OcRefundSettlServiceImpl.updateRefundSettl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRefundSettl ocRefundSettl = this.makeRefundSettl(ocRefundSettlDomain, oldOcRefundSettl);
        this.setRefundSettlUpdataDefault(ocRefundSettl);
        this.updateRefundSettlModel(ocRefundSettl);
    }

    @Override
    public OcRefundSettl getRefundSettl(Integer refundSettlId) {
        return this.getRefundSettlModelById(refundSettlId);
    }

    @Override
    public void deleteRefundSettl(Integer refundSettlId) throws ApiException {
        this.deleteRefundSettlModel(refundSettlId);
    }

    @Override
    public QueryResult<OcRefundSettl> queryRefundSettlPage(Map<String, Object> map) {
        List<OcRefundSettl> ocRefundSettlList = this.queryRefundSettlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefundSettl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundSettlList);
        return queryResult;
    }

    @Override
    public OcRefundSettl getRefundSettlByCode(String tenantCode, String refundSettlBillcode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("refundSettlBillcode", refundSettlBillcode);
        return this.getRefundSettlModelByCode(map);
    }

    @Override
    public void deleteRefundSettlByCode(String tenantCode, String refundSettlBillcode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("refundSettlBillcode", refundSettlBillcode);
        this.delRefundSettlModelByCode(map);
    }
}

