/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.model.OcContract;
import com.yqbsoft.laser.service.contract.model.OcContractGoods;
import com.yqbsoft.laser.service.contract.model.OcContractSettings;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcContractSettingsService;
import com.yqbsoft.laser.service.contract.service.OcContractTimeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.DateUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

public class OcContractTimeServiceImpl
extends BaseServiceImpl
implements OcContractTimeService {
    private OcContractSettingsService ocContractSettingsService;
    private OcContractService ocContractService;
    private OcContractEngineService ocContractEngineService;

    public void setOcContractEngineService(OcContractEngineService ocContractEngineService) {
        this.ocContractEngineService = ocContractEngineService;
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    public void setOcContractSettingsService(OcContractSettingsService ocContractSettingsService) {
        this.ocContractSettingsService = ocContractSettingsService;
    }

    @Override
    public void doContractCancel() throws ApiException {
        OcContractSettings contractSettings = this.ocContractSettingsService.getContractSettings();
        if (null != contractSettings && contractSettings.getPlayDays() != null && contractSettings.getPlayDays() != 0) {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            parammap.put("gmtCreateQend", DateUtil.getDateString((Date)DateUtils.addDays((Date)new Date(), (int)(-contractSettings.getPlayDays().intValue())), (String)"yyyy-MM-dd HH:mm:ss"));
            parammap.put("dataState", 1);
            parammap.put("fuzzy", false);
            List ocContractList = this.ocContractService.queryContractPage(parammap).getList();
            if (ListUtil.isNotEmpty((Collection)ocContractList)) {
                for (OcContract ocContract : ocContractList) {
                    try {
                        this.ocContractService.updateContractStateExtend(ocContract.getContractId(), -1, 1);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Override
    public void doContractReceive() throws ApiException {
        OcContractSettings contractSettings = this.ocContractSettingsService.getContractSettings();
        if (null != contractSettings && contractSettings.getReceiveDays() != null && contractSettings.getReceiveDays() != 0) {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            parammap.put("gmtModifiedQend", DateUtil.getDateString((Date)DateUtils.addDays((Date)new Date(), (int)(-contractSettings.getReceiveDays().intValue())), (String)"yyyy-MM-dd HH:mm:ss"));
            parammap.put("dataState", 3);
            parammap.put("fuzzy", false);
            List ocContractList = this.ocContractService.queryContractPage(parammap).getList();
            if (ListUtil.isNotEmpty((Collection)ocContractList)) {
                for (OcContract ocContract : ocContractList) {
                    try {
                        this.ocContractEngineService.sendContractNext(ocContract.getContractBillcode(), ocContract.getTenantCode(), null);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    @Override
    public void doContractAppraise() throws ApiException {
        OcContractSettings contractSettings = this.ocContractSettingsService.getContractSettings();
        if (null != contractSettings && contractSettings.getAppraiseDays() != null && contractSettings.getAppraiseDays() != 0) {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            parammap.put("gmtModifiedQend", DateUtil.getDateString((Date)DateUtils.addDays((Date)new Date(), (int)(-contractSettings.getAppraiseDays().intValue())), (String)"yyyy-MM-dd HH:mm:ss"));
            parammap.put("dataState", 4);
            parammap.put("fuzzy", false);
            parammap.put("contractAppraise", 0);
            List ocContractList = this.ocContractService.queryContractPage(parammap).getList();
            if (ListUtil.isNotEmpty((Collection)ocContractList)) {
                for (OcContract ocContract : ocContractList) {
                    try {
                        HashMap<String, Object> para = new HashMap<String, Object>();
                        para.put("contractBillcode", ocContract.getContractBillcode());
                        List ocContractGoodsList = this.ocContractService.queryContractGoodsPage(para).getList();
                        if (!ListUtil.isNotEmpty((Collection)ocContractGoodsList)) continue;
                        for (OcContractGoods ocContractGoods : ocContractGoodsList) {
                            HashMap<String, String> paramMap = new HashMap<String, String>();
                            paramMap.put("resEvaluateGoodsDomain", JsonUtil.buildNormalBinder().toJson((Object)ocContractGoods));
                            String msg = this.internalInvoke("res.evaluate.sendEvaluateGoodsDefault", paramMap);
                            this.logger.info("OcContractTimeService.res.evaluate.sendEvaluateGoodsDefault", (Object)msg);
                        }
                    }
                    catch (Exception exception) {
                    }
                }
            }
        }
    }
}

