/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcContractSettingsMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractSettingsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractSettingsReDomain;
import com.yqbsoft.laser.service.contract.model.OcContractSettings;
import com.yqbsoft.laser.service.contract.service.OcContractSettingsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractSettingsServiceImpl
extends BaseServiceImpl
implements OcContractSettingsService {
    private static final String SYS_CODE = "oc.CONTRACT.OcContractSettingsServiceImpl";
    private OcContractSettingsMapper ocContractSettingsMapper;

    public void setOcContractSettingsMapper(OcContractSettingsMapper ocContractSettingsMapper) {
        this.ocContractSettingsMapper = ocContractSettingsMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocContractSettingsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSettingsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContractSettings(OcContractSettingsDomain ocContractSettingsDomain) {
        if (null == ocContractSettingsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setContractSettingsDefault(OcContractSettings ocContractSettings) {
        if (null == ocContractSettings) {
            return;
        }
        if (null == ocContractSettings.getDataState()) {
            ocContractSettings.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocContractSettings.getGmtCreate()) {
            ocContractSettings.setGmtCreate(date);
        }
        ocContractSettings.setGmtModified(date);
        if (StringUtils.isBlank((String)ocContractSettings.getContractSettingsCode())) {
            ocContractSettings.setContractSettingsCode(this.getNo(null, "OcContractSettings", "ocContractSettings", ocContractSettings.getTenantCode()));
        }
    }

    private int getContractSettingsMaxCode() {
        int code = 0;
        try {
            return this.ocContractSettingsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSettingsServiceImpl.getContractSettingsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractSettingsUpdataDefault(OcContractSettings ocContractSettings) {
        if (null == ocContractSettings) {
            return;
        }
        ocContractSettings.setGmtModified(this.getSysDate());
    }

    private void saveContractSettingsModel(OcContractSettings ocContractSettings) throws ApiException {
        if (null == ocContractSettings) {
            return;
        }
        try {
            this.ocContractSettingsMapper.insert(ocContractSettings);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.saveContractSettingsModel.ex", (Throwable)e);
        }
    }

    private void saveContractSettingsBatchModel(List<OcContractSettings> ocContractSettingsList) throws ApiException {
        if (null == ocContractSettingsList || ocContractSettingsList.isEmpty()) {
            return;
        }
        try {
            this.ocContractSettingsMapper.insertBatch(ocContractSettingsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.saveContractSettingsBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractSettings getContractSettingsModelById(Integer contractSettingsId) {
        if (null == contractSettingsId) {
            return null;
        }
        try {
            return this.ocContractSettingsMapper.selectByPrimaryKey(contractSettingsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSettingsServiceImpl.getContractSettingsModelById", (Throwable)e);
            return null;
        }
    }

    private OcContractSettings getContractSettingsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractSettingsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSettingsServiceImpl.getContractSettingsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractSettingsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSettingsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.delContractSettingsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.delContractSettingsModelByCode.num");
        }
    }

    private void deleteContractSettingsModel(Integer contractSettingsId) throws ApiException {
        if (null == contractSettingsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSettingsMapper.deleteByPrimaryKey(contractSettingsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.deleteContractSettingsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.deleteContractSettingsModel.num");
        }
    }

    private void updateContractSettingsModel(OcContractSettings ocContractSettings) throws ApiException {
        if (null == ocContractSettings) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSettingsMapper.updateByPrimaryKey(ocContractSettings);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.updateContractSettingsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.updateContractSettingsModel.num");
        }
    }

    private void updateStateContractSettingsModel(Integer contractSettingsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractSettingsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSettingsId", contractSettingsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractSettingsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.updateStateContractSettingsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.updateStateContractSettingsModel.null");
        }
    }

    private void updateStateContractSettingsModelByCode(String tenantCode, String contractSettingsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractSettingsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSettingsCode", contractSettingsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractSettingsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.updateStateContractSettingsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.updateStateContractSettingsModelByCode.null");
        }
    }

    private OcContractSettings makeContractSettings(OcContractSettingsDomain ocContractSettingsDomain, OcContractSettings ocContractSettings) {
        if (null == ocContractSettingsDomain) {
            return null;
        }
        if (null == ocContractSettings) {
            ocContractSettings = new OcContractSettings();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettings, (Object)ocContractSettingsDomain);
            return ocContractSettings;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSettingsServiceImpl.makeContractSettings", (Throwable)e);
            return null;
        }
    }

    private OcContractSettingsReDomain makeOcContractSettingsReDomain(OcContractSettings ocContractSettings) {
        if (null == ocContractSettings) {
            return null;
        }
        OcContractSettingsReDomain ocContractSettingsReDomain = new OcContractSettingsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettingsReDomain, (Object)ocContractSettings);
            return ocContractSettingsReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSettingsServiceImpl.makeOcContractSettingsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractSettings> queryContractSettingsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractSettingsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSettingsServiceImpl.queryContractSettingsModel", (Throwable)e);
            return null;
        }
    }

    private int countContractSettings(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractSettingsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractSettingsServiceImpl.countContractSettings", (Throwable)e);
        }
        return i;
    }

    private OcContractSettings createOcContractSettings(OcContractSettingsDomain ocContractSettingsDomain) {
        String msg = this.checkContractSettings(ocContractSettingsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.saveContractSettings.checkContractSettings", msg);
        }
        OcContractSettings ocContractSettings = this.makeContractSettings(ocContractSettingsDomain, null);
        this.setContractSettingsDefault(ocContractSettings);
        return ocContractSettings;
    }

    @Override
    public String saveContractSettings(OcContractSettingsDomain ocContractSettingsDomain) throws ApiException {
        OcContractSettings ocContractSettings = this.createOcContractSettings(ocContractSettingsDomain);
        this.saveContractSettingsModel(ocContractSettings);
        return ocContractSettings.getContractSettingsCode();
    }

    @Override
    public String saveContractSettingsBatch(List<OcContractSettingsDomain> ocContractSettingsDomainList) throws ApiException {
        if (null == ocContractSettingsDomainList || ocContractSettingsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractSettings> ocContractSettingsList = new ArrayList<OcContractSettings>();
        String code = "";
        for (OcContractSettingsDomain ocContractSettingsDomain : ocContractSettingsDomainList) {
            OcContractSettings ocContractSettings = this.createOcContractSettings(ocContractSettingsDomain);
            code = ocContractSettings.getContractSettingsCode();
            ocContractSettingsList.add(ocContractSettings);
        }
        this.saveContractSettingsBatchModel(ocContractSettingsList);
        return code;
    }

    @Override
    public void updateContractSettingsState(Integer contractSettingsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contractSettingsId) {
            return;
        }
        this.updateStateContractSettingsModel(contractSettingsId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractSettingsStateByCode(String tenantCode, String contractSettingsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contractSettingsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContractSettingsModelByCode(tenantCode, contractSettingsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractSettings(OcContractSettingsDomain ocContractSettingsDomain) throws ApiException {
        String msg = this.checkContractSettings(ocContractSettingsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.updateContractSettings.checkContractSettings", msg);
        }
        OcContractSettings oldOcContractSettings = this.getContractSettingsModelById(ocContractSettingsDomain.getContractSettingsId());
        if (null == oldOcContractSettings) {
            throw new ApiException("oc.CONTRACT.OcContractSettingsServiceImpl.updateContractSettings.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractSettings ocContractSettings = this.makeContractSettings(ocContractSettingsDomain, oldOcContractSettings);
        this.setContractSettingsUpdataDefault(ocContractSettings);
        this.updateContractSettingsModel(ocContractSettings);
    }

    @Override
    public OcContractSettings getContractSettings(Integer contractSettingsId) {
        if (null == contractSettingsId) {
            return null;
        }
        return this.getContractSettingsModelById(contractSettingsId);
    }

    @Override
    public void deleteContractSettings(Integer contractSettingsId) throws ApiException {
        if (null == contractSettingsId) {
            return;
        }
        this.deleteContractSettingsModel(contractSettingsId);
    }

    @Override
    public QueryResult<OcContractSettings> queryContractSettingsPage(Map<String, Object> map) {
        List<OcContractSettings> ocContractSettingsList = this.queryContractSettingsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractSettings(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractSettingsList);
        return queryResult;
    }

    @Override
    public OcContractSettings getContractSettingsByCode(String tenantCode, String contractSettingsCode) throws ApiException {
        if (StringUtils.isBlank((String)contractSettingsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSettingsCode", contractSettingsCode);
        return this.getContractSettingsModelByCode(map);
    }

    @Override
    public void deleteContractSettingsByCode(String tenantCode, String contractSettingsCode) throws ApiException {
        if (StringUtils.isBlank((String)contractSettingsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractSettingsCode", contractSettingsCode);
        this.delContractSettingsModelByCode(map);
    }

    @Override
    public OcContractSettings getContractSettings() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", 1);
        List<OcContractSettings> ocContractSettingsList = this.queryContractSettingsModelPage(map);
        if (ListUtil.isNotEmpty(ocContractSettingsList)) {
            return ocContractSettingsList.get(0);
        }
        return null;
    }
}

