/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.domain.DisChannel;
import com.yqbsoft.laser.service.contract.domain.GoodsSendNumBean;
import com.yqbsoft.laser.service.contract.domain.OcCflowPprocessDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundDomain;
import com.yqbsoft.laser.service.contract.domain.OcReorderDomain;
import com.yqbsoft.laser.service.contract.domain.PtePtfchannel;
import com.yqbsoft.laser.service.contract.domain.PtePtfmemchannel;
import com.yqbsoft.laser.service.contract.domain.PtePtfmemchannellist;
import com.yqbsoft.laser.service.contract.domain.TaTransferaBean;
import com.yqbsoft.laser.service.contract.domain.TaTransferaListBean;
import com.yqbsoft.laser.service.contract.domain.VdFaccountInfo;
import com.yqbsoft.laser.service.contract.engine.ContractDomainPutThread;
import com.yqbsoft.laser.service.contract.engine.PprocessModelPutThread;
import com.yqbsoft.laser.service.contract.engine.PprocessPollThread;
import com.yqbsoft.laser.service.contract.engine.PprocessPutThread;
import com.yqbsoft.laser.service.contract.engine.PprocessService;
import com.yqbsoft.laser.service.contract.model.OcCflowPprocess;
import com.yqbsoft.laser.service.contract.model.OcContract;
import com.yqbsoft.laser.service.contract.model.OcContractSettl;
import com.yqbsoft.laser.service.contract.model.OcRefund;
import com.yqbsoft.laser.service.contract.model.OcSendcontractData;
import com.yqbsoft.laser.service.contract.model.PmUserCoupon;
import com.yqbsoft.laser.service.contract.service.OcCflowPprocessService;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractFlowEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcRefundService;
import com.yqbsoft.laser.service.contract.service.OcShoppingService;
import com.yqbsoft.laser.service.contract.service.impl.OcContractServiceImpl;
import com.yqbsoft.laser.service.contract.service.impl.OcRefundServiceImpl;
import com.yqbsoft.laser.service.contract.service.impl.OcSendcontractDataServiceImpl;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupQueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractEngineServiceImpl
extends BaseServiceImpl
implements OcContractEngineService {
    public static final String SYS_CODE = "oc.CONTRACT.OcContractEngineServiceImpl";
    private static PprocessService pprocessService;
    private static Object lock;
    private OcContractFlowEngineService ocContractFlowEngineService;
    private OcCflowPprocessService ocCflowPprocessService;
    OcContractService ocContractService;
    OcRefundService ocRefundService;
    OcShoppingService ocShoppingService;

    public void setOcShoppingService(OcShoppingService ocShoppingService) {
        this.ocShoppingService = ocShoppingService;
    }

    public void setOcRefundService(OcRefundService ocRefundService) {
        this.ocRefundService = ocRefundService;
    }

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    public OcCflowPprocessService getOcCflowPprocessService() {
        return this.ocCflowPprocessService;
    }

    public void setOcCflowPprocessService(OcCflowPprocessService ocCflowPprocessService) {
        this.ocCflowPprocessService = ocCflowPprocessService;
    }

    public OcContractFlowEngineService getOcContractFlowEngineService() {
        return this.ocContractFlowEngineService;
    }

    public void setOcContractFlowEngineService(OcContractFlowEngineService ocContractFlowEngineService) {
        this.ocContractFlowEngineService = ocContractFlowEngineService;
    }

    @Override
    public void sendContractEngineStart(OcContractDomain ocContractDomain) {
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveContractEngineStart(ocContractDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        } else {
            this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.sendContractEngineStart.pprocessList", (Object)(ocContractDomain.getContractBillcode() + "=" + ocContractDomain.getTenantCode()));
        }
    }

    @Override
    public void sendContractNext(String contractBillcode, String tenantCode, Map<String, Object> map) {
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveContractNext(contractBillcode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
    }

    @Override
    public String sendContracPay(String contractBillcode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (null == dataState || dataState != 3) {
            return "success";
        }
        this.sendContractNext(contractBillcode, tenantCode, null);
        return "success";
    }

    @Override
    public String sendContracSubPay(String businessOrder, String businessOrderno, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (null == dataState || dataState != 3) {
            return "success";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSubCode", businessOrderno);
        this.sendContractNext(businessOrder, tenantCode, map);
        return "success";
    }

    @Override
    public String sendContracBatchPay(String contractBbillcode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (StringUtils.isBlank((String)contractBbillcode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        if (null == dataState || dataState != 3) {
            return "success";
        }
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveContractBatchNext(contractBbillcode, tenantCode, null);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
        return "success";
    }

    @Override
    public void sendContractBack(String contractBillcode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveContractBack(contractBillcode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
    }

    @Override
    public void sendFlowNode(OcCflowPprocessDomain ocCflowPprocessDomain) {
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveFlowNode(ocCflowPprocessDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PprocessService getPprocessService() {
        Object object = lock;
        synchronized (object) {
            if (null == pprocessService) {
                pprocessService = new PprocessService((OcContractEngineService)SpringApplicationContextUtil.getBean((String)"ocContractEngineService"));
                for (int i = 0; i < 20; ++i) {
                    pprocessService.addPollPool(new PprocessPollThread(pprocessService));
                }
            }
            return pprocessService;
        }
    }

    @Override
    public void queryPprocessLoadDb() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<OcCflowPprocess> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getPprocessService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getPprocessService().getPage());
                result = this.ocCflowPprocessService.queryCflowPprocessPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getPprocessService().addPutPool(new PprocessModelPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), result.getRows()));
                    if (result.getRows().size() == this.getPprocessService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getPprocessService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractEngineServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public String sendBatchSaveContract(List<OcContractDomain> ocContractDomainList) throws ApiException {
        String code = this.ocContractService.saveBatchContract(ocContractDomainList);
        OcContractServiceImpl.getContractService().addPutPool(new ContractDomainPutThread(OcContractServiceImpl.getContractService(), ocContractDomainList));
        return code;
    }

    @Override
    public Map<String, String> sendsaveContract(OcContractDomain ocContractDomain) throws ApiException {
        String code = this.ocContractService.saveContract(ocContractDomain);
        ArrayList<OcContractDomain> ocContractDomainList = new ArrayList<OcContractDomain>();
        ocContractDomainList.add(ocContractDomain);
        OcContractServiceImpl.getContractService().addPutPool(new ContractDomainPutThread(OcContractServiceImpl.getContractService(), ocContractDomainList));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", "success");
        map.put("code", code);
        return map;
    }

    @Override
    public String sendSaveRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        OcSendcontractData ocSendcontractData = this.ocRefundService.saveRefundRe(ocRefundDomain);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendUpdateContracState(String contractNbillcode, String channelCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcContract ocContract = this.ocContractService.getByNbCode(contractNbillcode, channelCode, tenantCode);
        if (null == ocContract) {
            return "error";
        }
        this.sendContractNext(ocContract.getContractBillcode(), tenantCode, map);
        return "success";
    }

    @Override
    public String sendUpdateRefundStateByNcode(String refundNcode, String channelCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundStateByNcode(refundNcode, channelCode, tenantCode, dataState, oldDataState);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        Map<String, Object> remap = this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
        if (MapUtil.isEmpty(remap)) {
            return null;
        }
        OcSendcontractData ocSendcontractData = (OcSendcontractData)remap.get("ocSendcontractData");
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        OcRefund ocRefund = (OcRefund)remap.get("ocRefund");
        if (null != ocRefund) {
            OcRefundServiceImpl.getRefundService().putQueue(ocRefund);
        }
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendsaveRefundPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.saveRefundPay(refundCode, tenantCode, ptradeSeqno, dataState);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundPass(String refundCode, String tenantCode, Map<String, Object> map) {
        Map<String, Object> remap = this.ocRefundService.updateRefundPass(refundCode, tenantCode, map);
        if (MapUtil.isEmpty(remap)) {
            return null;
        }
        OcSendcontractData ocSendcontractData = (OcSendcontractData)remap.get("ocSendcontractData");
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        OcRefund ocRefund = (OcRefund)remap.get("ocRefund");
        if (null != ocRefund) {
            OcRefundServiceImpl.getRefundService().putQueue(ocRefund);
        }
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundPay(OcRefund ocRefund) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundPay(ocRefund);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public void sendContractAgglomeration(List<PmUserCoupon> pmUserCouponList) {
        this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.sendContractAgglomeration", (Object)JsonUtil.buildNormalBinder().toJson(pmUserCouponList));
        if (ListUtil.isEmpty(pmUserCouponList)) {
            this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.sendContractAgglomeration", (Object)"pmUserCouponList is null");
            return;
        }
        for (PmUserCoupon pmUserCoupon : pmUserCouponList) {
            String usercouponOcode = pmUserCoupon.getUsercouponOcode();
            String tenantCode = pmUserCoupon.getTenantCode();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractValidate", new Date());
            this.sendContractNext(usercouponOcode, tenantCode, map);
        }
    }

    @Override
    public void sendAgglomerationEnd(List<PmUserCoupon> pmUserCouponList) {
        this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.sendContractAgglomeration", (Object)JsonUtil.buildNormalBinder().toJson(pmUserCouponList));
        if (ListUtil.isEmpty(pmUserCouponList)) {
            this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.sendContractAgglomeration", (Object)"pmUserCouponList is null");
            return;
        }
        for (PmUserCoupon pmUserCoupon : pmUserCouponList) {
            String usercouponOcode = pmUserCoupon.getUsercouponOcode();
            String tenantCode = pmUserCoupon.getTenantCode();
            if (1 == pmUserCoupon.getCouponOnceNumsod()) {
                this.sendContractBack(usercouponOcode, tenantCode, null);
                continue;
            }
            OcRefundDomain ocRefundDomain = new OcRefundDomain();
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("contractBillcode", usercouponOcode);
            map.put("tenantCode", tenantCode);
            OcContractReDomain contractByCode = this.ocContractService.getContractByCode(map);
            if (contractByCode.getDataState() == -1) continue;
            try {
                BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)contractByCode);
            }
            catch (Exception e) {
                return;
            }
            ocRefundDomain.setRefundType("B01");
            ocRefundDomain.setRefundMoney(contractByCode.getDataBmoney());
            ocRefundDomain.setContractState(contractByCode.getDataState());
            this.sendSaveRefund(ocRefundDomain);
        }
    }

    @Override
    public String sendupdateRefundRefuse(String refundCode, String tenantCode, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundRefuse(refundCode, tenantCode, map);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundRes(refundCode, tenantCode, map);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundStateByCode(String refundCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundStateByCode(refundCode, dataState, oldDataState, tenantCode);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundStateById(Integer refundId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundState(refundId, dataState, oldDataState);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public void sendSaveActGoods() {
    }

    @Override
    public void sendSavePayBack(Object dataState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractPaydateQend", new Date());
        map.put("dataState", dataState);
        QueryResult<OcContract> qlist = this.ocContractService.queryContractPage(map);
        if (null == qlist || ListUtil.isEmpty((Collection)qlist.getList())) {
            return;
        }
        for (OcContract ocContract : qlist.getList()) {
            try {
                this.sendContractBack(ocContract.getContractBillcode(), ocContract.getTenantCode(), null);
            }
            catch (Exception e) {}
        }
    }

    @Override
    public String sendContractByDel(OcContractDomain ocContractDomain, List<Integer> shoppingGoodsIdList) {
        if (null == ocContractDomain) {
            return null;
        }
        this.ocShoppingService.saveContractByDel(ocContractDomain, shoppingGoodsIdList);
        ArrayList<OcContractDomain> ocContractDomainList = new ArrayList<OcContractDomain>();
        ocContractDomainList.add(ocContractDomain);
        OcContractServiceImpl.getContractService().addPutPool(new ContractDomainPutThread(OcContractServiceImpl.getContractService(), ocContractDomainList));
        return ocContractDomain.getContractBillcode();
    }

    @Override
    public String sendBatchContractByDel(List<OcContractDomain> ocContractDomainList, List<Integer> shoppingGoodsIdList) {
        if (ListUtil.isEmpty(ocContractDomainList)) {
            return null;
        }
        this.ocShoppingService.saveBatchContractByDel(ocContractDomainList, shoppingGoodsIdList);
        OcContractServiceImpl.getContractService().addPutPool(new ContractDomainPutThread(OcContractServiceImpl.getContractService(), ocContractDomainList));
        return ocContractDomainList.get(0).getContractBillcode();
    }

    @Override
    public void sendSaveOffPayOk(OcContractSettlDomain ocContractSettlDomain) {
        if (null == ocContractSettlDomain) {
            return;
        }
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveOffPayOk(ocContractSettlDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
    }

    @Override
    public void sendSaveOffPayOkBatch(List<OcContractSettlDomain> ocContractSettlDomainList) {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            return;
        }
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveOffPayOkBatch(ocContractSettlDomainList);
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            if (!ocContractSettlDomain.getContractSettlType().equals("4")) continue;
            HashMap<String, Object> paramStr = new HashMap<String, Object>();
            paramStr.put("settlytype", ocContractSettlDomain.getContractSettlOpno());
            String str = this.sendUpdateContracbal(ocContractSettlDomain.getContractBillcode(), null, null, ocContractSettlDomain.getTenantCode(), paramStr);
            this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.saveOffPayOkBatch.str", (Object)str);
            if (!StringUtils.isEmpty((String)str) && str.equals("success")) continue;
            this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.saveOffPayOkBatch.null", (Object)(ocContractSettlDomain.getContractBillcode() + "=" + ocContractSettlDomain.getTenantCode()));
            return;
        }
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
    }

    @Override
    public String sendUpdateContracbal(String contractBillcode, String fundType, String feeName, String tenantCode, Map<String, Object> map) {
        String settlytype1;
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        if (null == ocContractReDomain) {
            return "error";
        }
        List<OcContractSettl> settlList = this.ocContractService.queryContractSettlByContractCode(tenantCode, contractBillcode);
        this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.sendUpdateContracbal.null", (Object)(JsonUtil.buildNormalBinder().toJson(settlList) + "==fundType===" + fundType + "==contractBillcode===" + contractBillcode));
        if (ListUtil.isEmpty(settlList)) {
            return "success";
        }
        if (StringUtils.isBlank((String)fundType)) {
            fundType = "01";
        }
        String settlytype = fundType;
        boolean flag = false;
        if (fundType.indexOf("B") >= 0) {
            flag = true;
            fundType = fundType.substring(1);
        }
        if (fundType.indexOf("C") >= 0) {
            flag = true;
            settlytype = fundType = fundType.substring(1);
        }
        if (MapUtil.isNotEmpty(map) && StringUtils.isNotBlank((String)(settlytype1 = String.valueOf(map.get("settlytype"))))) {
            settlytype = settlytype1;
        }
        this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.sendUpdateContracbal.null1", (Object)("===fundType===" + fundType + "==settlytype==" + settlytype));
        for (OcContractSettl ocContractSettl : settlList) {
            if (!settlytype.equals(ocContractSettl.getContractSettlOpno())) continue;
            String type = ocContractReDomain.getMemberBcode().substring(0, 1);
            VdFaccountInfo vdFaccountInfo = this.getOuterFaccount(ocContractReDomain.getMemberBcode(), type + fundType, tenantCode);
            if (null == vdFaccountInfo) {
                this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.ocContractReDomain.", (Object)("===memberBcode==" + ocContractReDomain.getMemberBcode() + "====faccountType===" + type + fundType));
                return "error";
            }
            if (vdFaccountInfo.getFaccountAmount().subtract(ocContractSettl.getContractSettlPmoney()).compareTo(BigDecimal.ZERO) == -1) {
                this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.vdFaccountInfo.", (Object)("===faccountAmount==" + vdFaccountInfo.getFaccountAmount() + "===contractSettlPmoney====" + ocContractSettl.getContractSettlPmoney()));
                return "error";
            }
            TaTransferaBean taTransferaBean = new TaTransferaBean();
            taTransferaBean.setFundType(fundType);
            taTransferaBean.setTenantCode(ocContractReDomain.getTenantCode());
            taTransferaBean.setTransferaMoney(ocContractSettl.getContractSettlPmoney());
            taTransferaBean.setTransferaName(feeName);
            taTransferaBean.setTransferaRemark("[" + ocContractReDomain.getContractBillcode() + "]" + feeName);
            taTransferaBean.setTransferaType("15");
            taTransferaBean.setTransferaOpcode(ocContractSettl.getContractSettlBillcode());
            if (flag) {
                taTransferaBean.setUserinfoCode(ocContractReDomain.getMemberCode());
            } else {
                taTransferaBean.setUserinfoCode(ocContractReDomain.getMemberBcode());
            }
            ArrayList<TaTransferaListBean> taTransferaListBeanList = new ArrayList<TaTransferaListBean>();
            taTransferaBean.setTaTransferaListBeanList(taTransferaListBeanList);
            TaTransferaListBean taTransferaListBean = new TaTransferaListBean();
            if (flag) {
                taTransferaListBean.setTransferaListUcode(ocContractReDomain.getMemberBcode());
            } else {
                taTransferaListBean.setTransferaListUcode(ocContractReDomain.getMemberCode());
            }
            taTransferaListBean.setTransferaListMoney(ocContractSettl.getContractSettlPmoney());
            taTransferaListBean.setTransferaListRemark("[" + ocContractReDomain.getContractBillcode() + "]" + feeName);
            taTransferaListBean.setTransferaListFtype(fundType);
            taTransferaListBeanList.add(taTransferaListBean);
            this.saveTaTransfera(taTransferaBean);
        }
        return "success";
    }

    private void saveTaTransfera(TaTransferaBean taTransferaBean) {
        if (null == taTransferaBean) {
            return;
        }
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("taTransferaBean", JsonUtil.buildNormalBinder().toJson((Object)taTransferaBean));
        String str = this.internalInvoke("ta.taTransfera.saveTransferaBeanOne", pmap);
        OcReorderDomain ocReorderDomain = (OcReorderDomain)JsonUtil.buildNormalBinder().getJsonToObject(str, OcReorderDomain.class);
        if (null == ocReorderDomain || ocReorderDomain.isError()) {
            throw new ApiException("oc.CONTRACT.OcContractEngineServiceImpl.saveTaTransfera.str", str);
        }
    }

    @Override
    public String sendUpdateContracfee(String contractBillcode, String fundType, String feeName, String tenantCode, Map<String, Object> map) {
        PtePtfmemchannellist ptePtfmemchannellist;
        OcContractReDomain ocContractReDomain = this.ocContractService.getContractByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
        if (null == ocContractReDomain) {
            return "error";
        }
        String fchannelPmodeCode = "web";
        String fchannelDr = "pay";
        String tginfoCode = "";
        String channelCode = ocContractReDomain.getChannelCode();
        String proappCode = ocContractReDomain.getAppmanageIcode();
        if (StringUtils.isBlank((String)fundType)) {
            fundType = "02";
        }
        List<PtePtfchannel> list = this.getPtfchannel(ocContractReDomain.getMemberCode(), fchannelPmodeCode, tenantCode, fchannelDr, tginfoCode, channelCode, proappCode);
        Map<String, PtePtfmemchannellist> remap = this.getPtmemfchannel(ocContractReDomain.getMemberBcode(), tenantCode, fchannelDr);
        PtePtfchannel payptePtfchannel = null;
        BigDecimal fchannelPay = null;
        for (PtePtfchannel ptePtfchannel : list) {
            if (!fundType.equals(ptePtfchannel.getFundType())) continue;
            payptePtfchannel = ptePtfchannel;
            fchannelPay = ptePtfchannel.getFchannelPay();
            break;
        }
        if (MapUtil.isNotEmpty(remap) && null != (ptePtfmemchannellist = remap.get(payptePtfchannel.getFundType())) && null != ptePtfmemchannellist.getFchannelPay()) {
            fchannelPay = ptePtfmemchannellist.getFchannelPay();
        }
        if (null == fchannelPay || fchannelPay.compareTo(BigDecimal.ZERO) <= 0) {
            return "success";
        }
        BigDecimal orderAmount = ocContractReDomain.getDataBmoney().multiply(fchannelPay).divide(new BigDecimal("100"));
        String type = ocContractReDomain.getMemberBcode().substring(0, 1);
        VdFaccountInfo vdFaccountInfo = this.getOuterFaccount(ocContractReDomain.getMemberBcode(), type + fundType, tenantCode);
        if (null == vdFaccountInfo) {
            this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.ocContractReDomain.", (Object)("===memberBcode==" + ocContractReDomain.getMemberBcode() + "====faccountType===" + type + fundType));
            return "error";
        }
        if (vdFaccountInfo.getFaccountAmount().subtract(orderAmount).compareTo(BigDecimal.ZERO) == -1) {
            orderAmount = vdFaccountInfo.getFaccountAmount();
        }
        if (orderAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return "success";
        }
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        ocContractSettlDomain.setContractBillcode(ocContractReDomain.getContractBillcode());
        ocContractSettlDomain.setMemberBcode(ocContractReDomain.getMemberBcode());
        ocContractSettlDomain.setMemberBname(ocContractReDomain.getMemberBname());
        ocContractSettlDomain.setMemberCode(ocContractReDomain.getMemberCode());
        ocContractSettlDomain.setMemberName(ocContractReDomain.getMemberName());
        ocContractSettlDomain.setMemberCcode(ocContractReDomain.getMemberCcode());
        ocContractSettlDomain.setMemberCname(ocContractReDomain.getMemberCname());
        ocContractSettlDomain.setContractSettlType("0");
        ocContractSettlDomain.setContractSettlBlance("FEE");
        ocContractSettlDomain.setContractPmode("0");
        ocContractSettlDomain.setContractSettlPmoney(orderAmount);
        ocContractSettlDomain.setContractSettlGmoney(orderAmount);
        ocContractSettlDomain.setContractSettlOpno(fundType);
        ocContractSettlDomain.setContractSettlOpemo(fchannelPay.toString());
        ocContractSettlDomain.setTenantCode(ocContractReDomain.getTenantCode());
        ocContractSettlDomain.setAppmanageIcode(ocContractReDomain.getAppmanageIcode());
        this.ocContractService.saveContractSettl(ocContractSettlDomain);
        return "success";
    }

    private VdFaccountInfo getOuterFaccount(String merchantCode, String faccountType, String tenantCode) {
        HashMap<String, String> pmap = new HashMap<String, String>();
        pmap.put("merchantCode", merchantCode);
        pmap.put("faccountType", faccountType);
        pmap.put("tenantCode", tenantCode);
        List list = (List)this.readObj("vd.faccount.queryOuterFaccount", pmap, "list", new Object[]{VdFaccountInfo.class});
        if (ListUtil.isEmpty((Collection)list)) {
            return null;
        }
        return (VdFaccountInfo)list.get(0);
    }

    public List<PtePtfchannel> getPtfchannel(String memberCode, String fchannelPmodeCode, String tenantCode, String fchannelDr, String tginfoCode, String channelCode, String proappCode) {
        DisChannel disChannel;
        if (StringUtils.isBlank((String)fchannelPmodeCode) || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)fchannelDr)) {
            return null;
        }
        List qlist = null;
        String mpmemberCode = "";
        if (StringUtils.isNotBlank((String)channelCode) && null != (disChannel = (DisChannel)SupDisUtil.getMapJson((String)"DisChannel-channelCode", (String)(channelCode + "-" + tenantCode), DisChannel.class))) {
            mpmemberCode = "-" + disChannel.getMemberCode();
        }
        if (StringUtils.isNotBlank((String)memberCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + memberCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannel.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + memberCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannel.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)tginfoCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tginfoCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannel.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tginfoCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannel.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)channelCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + channelCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannel.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + channelCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannel.class);
        }
        if (ListUtil.isEmpty(qlist) && StringUtils.isNotBlank((String)proappCode) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + proappCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannel.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + proappCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannel.class);
        }
        if (ListUtil.isEmpty(qlist) && ListUtil.isEmpty((Collection)(qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tenantCode + mpmemberCode + "-" + fchannelDr), PtePtfchannel.class))) && StringUtils.isNotBlank((String)mpmemberCode)) {
            qlist = SupDisUtil.getMapListJson((String)"PtePtfchannel_dr_key", (String)(fchannelPmodeCode + "-" + tenantCode + "-" + fchannelDr), PtePtfchannel.class);
        }
        if (ListUtil.isEmpty(qlist)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("fchannelPmodeCode", fchannelPmodeCode);
            map.put("tenantCode", tenantCode);
            map.put("fchannelDr", fchannelDr);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
            qlist = (List)this.readObj("pte.ptfchannel.queryPtfchannelReList", paramMap, "list", new Object[]{PtePtfchannel.class});
            if (null == qlist || qlist.isEmpty()) {
                this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.getPayChannel.null", (Object)((Object)map).toString());
                return null;
            }
        }
        return qlist;
    }

    public Map<String, PtePtfmemchannellist> getPtmemfchannel(String memberCode, String tenantCode, String fchannelDr) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)fchannelDr)) {
            return null;
        }
        List qlist = null;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("memberCode", memberCode);
        map.put("tenantCode", tenantCode);
        map.put("fchannelDr", fchannelDr);
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String object = this.internalInvoke("pte.Ptfmemchannel.queryPtfmemchannelPage", paramMap);
        if (object == null) {
            this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.pte.Ptfmemchannel.queryPtfmemchannelPage", (Object)((Object)paramMap).toString());
            return null;
        }
        SupQueryResult supQueryResult = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(object, SupQueryResult.class);
        qlist = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResult.getList()), PtePtfmemchannel.class);
        if (null == qlist || qlist.isEmpty()) {
            this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.getPtmemfchannel.qlist", (Object)(((Object)paramMap).toString() + "===object===" + object));
            return null;
        }
        map.put("ptfmemchannelCode", ((PtePtfmemchannel)qlist.get(0)).getPtfmemchannelCode());
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String objectStr = this.internalInvoke("pte.Ptfmemchannel.queryPtfmemchannellistPage", paramMap);
        if (StringUtils.isBlank((String)objectStr)) {
            this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.pte.Ptfmemchannel.queryPtfmemchannellistPage", (Object)((Object)paramMap).toString());
            return null;
        }
        SupQueryResult supQueryResultStr = (SupQueryResult)JsonUtil.buildNormalBinder().getJsonToObject(objectStr, SupQueryResult.class);
        List qlistlist = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)supQueryResultStr.getList()), PtePtfmemchannellist.class);
        if (null == qlistlist || qlistlist.isEmpty()) {
            this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.getPtmemfchannel.qlist", (Object)(((Object)paramMap).toString() + "===object===" + objectStr));
            return null;
        }
        HashMap<String, PtePtfmemchannellist> remap = new HashMap<String, PtePtfmemchannellist>();
        for (PtePtfmemchannellist ptePtfmemchannellist : qlistlist) {
            if (!StringUtils.isNotBlank((String)ptePtfmemchannellist.getPtfmemchannellistValue())) continue;
            remap.put(ptePtfmemchannellist.getPtfmemchannellistValue(), ptePtfmemchannellist);
        }
        return remap;
    }

    @Override
    public String sendUpdateTopNum(List<GoodsSendNumBean> goodsSendNumBeanList) {
        this.logger.error("oc.CONTRACT.OcContractEngineServiceImpl.goodsSendNumBeanList", (Object)JsonUtil.buildNonDefaultBinder().toJson(goodsSendNumBeanList));
        if (ListUtil.isEmpty(goodsSendNumBeanList)) {
            return null;
        }
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.updateTopNum(goodsSendNumBeanList);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
        return "success";
    }

    @Override
    public String sendUpdateTopNum(String goodsSendNumBeanListStr) {
        List goodsSendNumBeanList = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(goodsSendNumBeanListStr, GoodsSendNumBean.class);
        return this.sendUpdateTopNum(goodsSendNumBeanList);
    }

    @Override
    public String sendFina(List<OcContractGoodsDomain> ocContractGoodsDomainList) {
        if (ListUtil.isEmpty(ocContractGoodsDomainList)) {
            return "success";
        }
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.sendFina(ocContractGoodsDomainList);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
        return "success";
    }

    static {
        lock = new Object();
    }
}

