/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.domain.OcCflowPprocessDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractDomain;
import com.yqbsoft.laser.service.contract.engine.ContractDomainPutThread;
import com.yqbsoft.laser.service.contract.engine.PprocessModelPutThread;
import com.yqbsoft.laser.service.contract.engine.PprocessPollThread;
import com.yqbsoft.laser.service.contract.engine.PprocessPutThread;
import com.yqbsoft.laser.service.contract.engine.PprocessService;
import com.yqbsoft.laser.service.contract.model.OcCflowPprocess;
import com.yqbsoft.laser.service.contract.service.OcCflowPprocessService;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractFlowEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.impl.OcContractServiceImpl;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractEngineServiceImpl
extends BaseServiceImpl
implements OcContractEngineService {
    public static final String SYS_CODE = "oc.CONTRACT.OcContractEngineServiceImpl";
    private static PprocessService pprocessService;
    private static Object lock;
    private OcContractFlowEngineService ocContractFlowEngineService;
    private OcCflowPprocessService ocCflowPprocessService;
    OcContractService ocContractService;

    public void setOcContractService(OcContractService ocContractService) {
        this.ocContractService = ocContractService;
    }

    public OcCflowPprocessService getOcCflowPprocessService() {
        return this.ocCflowPprocessService;
    }

    public void setOcCflowPprocessService(OcCflowPprocessService ocCflowPprocessService) {
        this.ocCflowPprocessService = ocCflowPprocessService;
    }

    public OcContractFlowEngineService getOcContractFlowEngineService() {
        return this.ocContractFlowEngineService;
    }

    public void setOcContractFlowEngineService(OcContractFlowEngineService ocContractFlowEngineService) {
        this.ocContractFlowEngineService = ocContractFlowEngineService;
    }

    @Override
    public void sendContractEngineStart(OcContractDomain ocContractDomain) {
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveContractEngineStart(ocContractDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
    }

    @Override
    public void sendContractNext(String contractBillcode, String tenantCode, Map<String, Object> map) {
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveContractNext(contractBillcode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
    }

    @Override
    public String sendContracPay(String contractBillcode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (null == dataState || dataState != 3) {
            return "success";
        }
        this.sendContractNext(contractBillcode, tenantCode, null);
        return "success";
    }

    @Override
    public String sendContracSubPay(String businessOrder, String businessOrderno, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (null == dataState || dataState != 3) {
            return "success";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSubCode", businessOrderno);
        this.sendContractNext(businessOrder, tenantCode, map);
        return "success";
    }

    @Override
    public String sendContracBatchPay(String contractBbillcode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (StringUtils.isBlank((String)contractBbillcode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        if (null == dataState || dataState != 3) {
            return "success";
        }
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveContractBatchNext(contractBbillcode, tenantCode, null);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
        return "success";
    }

    @Override
    public void sendContractBack(String contractBillcode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveContractBack(contractBillcode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
    }

    @Override
    public void sendFlowNode(OcCflowPprocessDomain ocCflowPprocessDomain) {
        List<OcCflowPprocessDomain> pprocessList = this.ocContractFlowEngineService.saveFlowNode(ocCflowPprocessDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), pprocessList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PprocessService getPprocessService() {
        Object object = lock;
        synchronized (object) {
            if (null == pprocessService) {
                pprocessService = new PprocessService((OcContractEngineService)SpringApplicationContextUtil.getBean((String)"ocContractEngineService"));
                for (int i = 0; i < 20; ++i) {
                    pprocessService.addPollPool(new PprocessPollThread(pprocessService));
                }
            }
            return pprocessService;
        }
    }

    @Override
    public void queryPprocessLoadDb() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<OcCflowPprocess> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getPprocessService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getPprocessService().getPage());
                result = this.ocCflowPprocessService.queryCflowPprocessPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getPprocessService().addPutPool(new PprocessModelPutThread(this.getPprocessService(), (OcContractService)SpringApplicationContextUtil.getBean((String)"ocContractService"), result.getRows()));
                    if (result.getRows().size() == this.getPprocessService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getPprocessService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractEngineServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public String sendBatchSaveContract(List<OcContractDomain> ocContractDomainList) throws ApiException {
        String code = this.ocContractService.saveBatchContract(ocContractDomainList);
        OcContractServiceImpl.getContractService().addPutPool(new ContractDomainPutThread(OcContractServiceImpl.getContractService(), ocContractDomainList));
        return code;
    }

    @Override
    public Map<String, String> sendsaveContract(OcContractDomain ocContractDomain) throws ApiException {
        String code = this.ocContractService.saveContract(ocContractDomain);
        ArrayList<OcContractDomain> ocContractDomainList = new ArrayList<OcContractDomain>();
        ocContractDomainList.add(ocContractDomain);
        OcContractServiceImpl.getContractService().addPutPool(new ContractDomainPutThread(OcContractServiceImpl.getContractService(), ocContractDomainList));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", "success");
        map.put("code", code);
        return map;
    }

    @Override
    public String sendUpdateContracState(String contractNbillcode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        this.ocContractService.updateContracStateByNb(contractNbillcode, tenantCode, dataState, oldDataState, map);
        return "success";
    }

    static {
        lock = new Object();
    }
}

