/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.ContractConstants;
import com.yqbsoft.laser.service.contract.dao.OcContractGoodsMapper;
import com.yqbsoft.laser.service.contract.dao.OcContractMapper;
import com.yqbsoft.laser.service.contract.dao.OcContractSettlMapper;
import com.yqbsoft.laser.service.contract.dao.OcPackageMapper;
import com.yqbsoft.laser.service.contract.domain.GoodsSendNumBean;
import com.yqbsoft.laser.service.contract.domain.OcCflowReDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractCtrlCflowDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractCtrlDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractReDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractSettlDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractproDomain;
import com.yqbsoft.laser.service.contract.domain.OcPackageDomain;
import com.yqbsoft.laser.service.contract.domain.OcReorderDomain;
import com.yqbsoft.laser.service.contract.domain.PackageExpressDomain;
import com.yqbsoft.laser.service.contract.domain.TmProappEnv;
import com.yqbsoft.laser.service.contract.domain.TypeBean;
import com.yqbsoft.laser.service.contract.engine.ContractDomainPutThread;
import com.yqbsoft.laser.service.contract.engine.ContractPollThread;
import com.yqbsoft.laser.service.contract.engine.ContractService;
import com.yqbsoft.laser.service.contract.enumc.ContractPropertyEnum;
import com.yqbsoft.laser.service.contract.enumc.PackageModeEnum;
import com.yqbsoft.laser.service.contract.model.OcContract;
import com.yqbsoft.laser.service.contract.model.OcContractCtrl;
import com.yqbsoft.laser.service.contract.model.OcContractGoods;
import com.yqbsoft.laser.service.contract.model.OcContractSettl;
import com.yqbsoft.laser.service.contract.model.OcContractpro;
import com.yqbsoft.laser.service.contract.model.OcPackage;
import com.yqbsoft.laser.service.contract.service.OcContractCtrlService;
import com.yqbsoft.laser.service.contract.service.OcContractEngineService;
import com.yqbsoft.laser.service.contract.service.OcContractService;
import com.yqbsoft.laser.service.contract.service.OcContractproService;
import com.yqbsoft.laser.service.contract.service.OcSendDataBaseService;
import com.yqbsoft.laser.service.domain.client.other.domain.SkuStockDomain;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.cache.dis.SupDisUtil;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.ScriptUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.CollectionUtils;

public class OcContractServiceImpl
extends BaseServiceImpl
implements OcContractService {
    public static final String SYS_CODE = "oc.CONTRACT.OcContractServiceImpl";
    private static ContractService contractService;
    private static Object lock;
    private OcContractMapper ocContractMapper;
    private OcContractGoodsMapper ocContractGoodsMapper;
    private OcPackageMapper ocPackageMapper;
    private OcContractSettlMapper ocContractSettlMapper;
    private OcContractCtrlService ocContractCtrlService;
    private OcSendDataBaseService ocSendDataBaseService;
    OcContractproService ocContractproService;
    private OcContractEngineService ocContractEngineService;

    public void setOcContractproService(OcContractproService ocContractproService) {
        this.ocContractproService = ocContractproService;
    }

    public OcSendDataBaseService getOcSendDataBaseService() {
        if (null == this.ocSendDataBaseService) {
            this.ocSendDataBaseService = (OcSendDataBaseService)SpringApplicationContextUtil.getBean((String)"ocSendDataBaseService");
        }
        return this.ocSendDataBaseService;
    }

    public OcContractCtrlService getOcContractCtrlService() {
        return this.ocContractCtrlService;
    }

    public void setOcContractCtrlService(OcContractCtrlService ocContractCtrlService) {
        this.ocContractCtrlService = ocContractCtrlService;
    }

    public void setOcContractSettlMapper(OcContractSettlMapper ocContractSettlMapper) {
        this.ocContractSettlMapper = ocContractSettlMapper;
    }

    public void setOcContractMapper(OcContractMapper ocContractMapper) {
        this.ocContractMapper = ocContractMapper;
    }

    public void setOcContractGoodsMapper(OcContractGoodsMapper ocContractGoodsMapper) {
        this.ocContractGoodsMapper = ocContractGoodsMapper;
    }

    public void setOcPackageMapper(OcPackageMapper ocPackageMapper) {
        this.ocPackageMapper = ocPackageMapper;
    }

    public OcContractEngineService getOcContractEngineService() {
        if (this.ocContractEngineService == null) {
            this.ocContractEngineService = (OcContractEngineService)SpringApplicationContextUtil.getBean((String)"ocContractEngineService", OcContractEngineService.class);
        }
        return this.ocContractEngineService;
    }

    private Date getSysDate() {
        try {
            return this.ocContractMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContract(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractDomain.getTenantCode())) {
            msg = msg + "\u5546\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractDefault(OcContract ocContract) {
        TypeBean typeBean;
        if (null == ocContract) {
            return;
        }
        if (null == ocContract.getDataState()) {
            ocContract.setDataState(0);
        }
        Date nowdate = this.getSysDate();
        if (null == ocContract.getGmtCreate()) {
            ocContract.setGmtCreate(nowdate);
        }
        ocContract.setGmtModified(nowdate);
        if (StringUtils.isBlank((String)ocContract.getContractBillcode())) {
            ocContract.setContractBillcode(this.getNo(null, OcContract.class.getSimpleName(), "contractCode", ocContract.getTenantCode()));
        }
        if (StringUtils.isBlank((String)ocContract.getContractBbillcode())) {
            ocContract.setContractBbillcode(ocContract.getContractBillcode());
        }
        if (StringUtils.isBlank((String)ocContract.getContractTypepro())) {
            ocContract.setContractTypepro("00");
        }
        if (StringUtils.isNotBlank((String)ocContract.getAppmanageIcode())) {
            ocContract.setCashback(this.makeInv(ocContract));
        }
        if (null == ocContract.getContractInvstate()) {
            ocContract.setContractInvstate(this.checkInv(ocContract.getContractType(), ocContract.getContractTypepro(), ocContract.getTenantCode()));
            if (null == ocContract.getCashback() || ocContract.getCashback().compareTo(BigDecimal.ZERO) == 0) {
                ocContract.setContractInvstate(3);
            }
        }
        if (null != (typeBean = this.getOcSetting(ocContract.getContractType(), ocContract.getTenantCode()))) {
            if (StringUtils.isBlank((String)ocContract.getContractBlance())) {
                ocContract.setContractBlance(typeBean.getBlance());
            }
            if (StringUtils.isBlank((String)ocContract.getContractPmode())) {
                ocContract.setContractPmode(typeBean.getPmode());
            }
        }
    }

    private BigDecimal makeInv(OcContract ocContract) {
        if (null == ocContract) {
            return new BigDecimal("0");
        }
        TmProappEnv tmProappEnv = (TmProappEnv)SupDisUtil.getMapJson((String)"TmProappEnv-tenant-ProappCode", (String)(ocContract.getAppmanageIcode() + "-" + ocContract.getTenantCode()), TmProappEnv.class);
        if (null == tmProappEnv) {
            return ocContract.getDataBmoney();
        }
        String confJson = tmProappEnv.getProappEnvOpenconf();
        if (StringUtils.isBlank((String)confJson)) {
            return ocContract.getDataBmoney();
        }
        Map confMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(confJson, String.class, String.class);
        if (null == confMap || confMap.isEmpty()) {
            return ocContract.getDataBmoney();
        }
        String inv = (String)confMap.get("inv");
        if (StringUtils.isBlank((String)inv)) {
            return ocContract.getDataBmoney();
        }
        if ("opay".equals(inv)) {
            return ocContract.getPricesetRefrice();
        }
        if ("mpay".equals(inv)) {
            return ocContract.getContractMoney();
        }
        return ocContract.getDataBmoney();
    }

    private int checkOa(OcContract ocContract, TypeBean typeBean, List<OcContractGoodsDomain> goodsList) {
        Map map;
        if (null == ocContract || null == typeBean) {
            return 0;
        }
        String contractType = ocContract.getContractType();
        String contractTypepro = ocContract.getContractTypepro();
        String tenantCode = ocContract.getTenantCode();
        if (StringUtils.isBlank((String)contractType) || StringUtils.isBlank((String)contractTypepro) || StringUtils.isBlank((String)tenantCode)) {
            return 0;
        }
        if (StringUtils.isBlank((String)typeBean.getOaflag()) || "0".equals(typeBean.getOaflag())) {
            return 0;
        }
        String conf = typeBean.getOaconf();
        if (StringUtils.isNotBlank((String)conf) && null != (map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(conf, String.class, String.class)) && !map.isEmpty()) {
            for (String key : map.keySet()) {
                Object obj = "memberCcode".equals(key) ? BeanUtils.forceGetProperty((Object)goodsList.get(0), (String)key) : BeanUtils.forceGetProperty((Object)ocContract, (String)key);
                if (null == obj || StringUtils.isBlank((String)obj.toString())) {
                    return 0;
                }
                if (obj.toString().indexOf((String)map.get(key)) >= 0) continue;
                return 0;
            }
            return 1;
        }
        return 1;
    }

    private int checkEc(OcContract ocContract, List<OcContractGoodsDomain> goodsList) {
        Map map;
        if (null == ocContract) {
            return 0;
        }
        String contractType = ocContract.getContractType();
        String contractTypepro = ocContract.getContractTypepro();
        String tenantCode = ocContract.getTenantCode();
        if (StringUtils.isBlank((String)contractType) || StringUtils.isBlank((String)contractTypepro) || StringUtils.isBlank((String)tenantCode)) {
            return 0;
        }
        TypeBean typeBean = this.getOcSetting(contractType, tenantCode);
        if (null == typeBean) {
            return 0;
        }
        if (StringUtils.isBlank((String)typeBean.getEcflag()) || "0".equals(typeBean.getEcflag())) {
            return 0;
        }
        String conf = typeBean.getEcconf();
        if (StringUtils.isNotBlank((String)conf) && null != (map = (Map)JsonUtil.buildNormalBinder().getJsonToMap(conf, String.class, String.class)) && !map.isEmpty()) {
            for (String key : map.keySet()) {
                Object obj = "memberCcode".equals(key) ? BeanUtils.forceGetProperty((Object)goodsList.get(0), (String)key) : BeanUtils.forceGetProperty((Object)ocContract, (String)key);
                if (null == obj || StringUtils.isBlank((String)obj.toString())) {
                    return 0;
                }
                if (obj.toString().indexOf((String)map.get(key)) >= 0) continue;
                return 0;
            }
            return 1;
        }
        return 1;
    }

    private int checkInv(String contractType, String contractTypepro, String tenantCode) {
        if (StringUtils.isBlank((String)contractType) || StringUtils.isBlank((String)contractTypepro) || StringUtils.isBlank((String)tenantCode)) {
            return 0;
        }
        TypeBean typeBean = this.getOcSetting(contractType, tenantCode);
        if (null == typeBean) {
            return 0;
        }
        if (StringUtils.isBlank((String)typeBean.getInvp()) || "0".equals(typeBean.getInvp())) {
            return 0;
        }
        if (StringUtils.isNotBlank((String)typeBean.getNinvpro()) && typeBean.getNinvpro().equals(contractTypepro)) {
            return 3;
        }
        return 1;
    }

    private TypeBean getOcSetting(String contractType, String tenantCode) {
        String memo;
        TypeBean typeBean = null;
        OcCflowReDomain ocCflowReDomain = (OcCflowReDomain)DisUtil.getMapJson((String)"ocProtCflow", (String)(contractType + "-" + tenantCode), OcCflowReDomain.class);
        if (null == ocCflowReDomain) {
            ocCflowReDomain = (OcCflowReDomain)DisUtil.getMapJson((String)"ocProtCflow", (String)(contractType + "-" + "00000000"), OcCflowReDomain.class);
        }
        if (null != ocCflowReDomain && StringUtils.isNotBlank((String)(memo = ocCflowReDomain.getMemo()))) {
            typeBean = (TypeBean)JsonUtil.buildNormalBinder().getJsonToObject(memo, TypeBean.class);
        }
        return typeBean;
    }

    private int getContractMaxCode() {
        int code = 0;
        try {
            return this.ocContractMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractUpdataDefault(OcContract ocContract) {
        if (null == ocContract) {
            return;
        }
        ocContract.setGmtModified(this.getSysDate());
    }

    private void saveContractModel(OcContract ocContract) throws ApiException {
        if (null == ocContract) {
            return;
        }
        try {
            this.ocContractMapper.insert(ocContract);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractModel.ex", (Throwable)e);
        }
    }

    private OcContract getContractModelById(Integer contractId) {
        if (null == contractId) {
            return null;
        }
        try {
            return this.ocContractMapper.selectByPrimaryKey(contractId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractModelById", (Throwable)e);
            return null;
        }
    }

    public OcContract getContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delContractModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractModelByCode.num");
        }
    }

    private void deleteContractModel(Integer contractId) throws ApiException {
        if (null == contractId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.deleteByPrimaryKey(contractId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractModel.num");
        }
    }

    private void updateContractModelPayByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updatePayByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModelPayByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModelPayByCode.num");
        }
    }

    private void updateContractModelBlanceByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateBlanceByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModelBlanceByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModelBlanceByCode.num");
        }
    }

    private void updateContractModel(OcContract ocContract) throws ApiException {
        if (null == ocContract) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateByPrimaryKeySelective(ocContract);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractModel.i");
        }
    }

    private void updateStateContractModel(Integer contractId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contractId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractId", contractId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModel.null");
        }
    }

    private void updateStateContractModelByNb(String tenantCode, String contractNbillcode, Integer dataState, Integer oldDataState, Map<String, Object> rmap) throws ApiException {
        if (StringUtils.isBlank((String)contractNbillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractNbillcode", contractNbillcode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != rmap && !rmap.isEmpty()) {
            map.putAll(rmap);
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateStateByNbCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModelByNb.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModelByNb.null");
        }
    }

    public OcContract getModelByNbCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractMapper.getByNbCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getModelByNbCode", (Throwable)e);
            return null;
        }
    }

    private void updateSendContractModel(String tenantCode, String contractBillcode, BigDecimal contractSendnum, BigDecimal contractSendweight) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractBillcode)) {
            return;
        }
        if (null == contractSendnum) {
            contractSendnum = BigDecimal.ZERO;
        }
        if (null == contractSendweight) {
            contractSendweight = BigDecimal.ZERO;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("contractSendnum", contractSendnum);
        map.put("contractSendweight", contractSendweight);
        int i = 0;
        try {
            i = this.ocContractMapper.updateSendStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateSendContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateSendContractModel.null");
        }
    }

    private void updateSendContractGoodsModel(String tenantCode, String contractGoodsCode, Integer dataState, Integer oldDataState, BigDecimal contractGoodsSendnum, BigDecimal contractGoodsSendweight) {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractGoodsCode) || null == dataState) {
            return;
        }
        if (null == contractGoodsSendnum) {
            contractGoodsSendnum = BigDecimal.ZERO;
        }
        if (null == contractGoodsSendweight) {
            contractGoodsSendweight = BigDecimal.ZERO;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsCode", contractGoodsCode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        map.put("contractGoodsSendnum", contractGoodsSendnum);
        map.put("contractGoodsSendweight", contractGoodsSendweight);
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateSendByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateSendContractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateSendContractGoodsModel.null");
        }
    }

    private void updateInvstateContractModel(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateInvstateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateInvstateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateInvstateContractModel.null");
        }
    }

    private void updateShowstateContractModel(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateShowstateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateShowstateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateShowstateContractModel.null");
        }
    }

    private void updateEcflagstateContractModel(String tenantCode, String contractBillcode, String contractEcurl, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("contractEcurl", contractEcurl);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractMapper.updateEcflagstateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateShowstateContractModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateShowstateContractModel.null");
        }
    }

    private void updateStateContractModelByCode(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState, Map<String, Object> rmap) throws ApiException {
        if (StringUtils.isBlank((String)contractBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != rmap && !rmap.isEmpty()) {
            map.putAll(rmap);
        }
        int i = 0;
        try {
            i = this.ocContractMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractModelByCode.null", "params=" + map);
        }
    }

    private OcContract makeContract(OcContractDomain ocContractDomain, OcContract ocContract) {
        if (null == ocContractDomain) {
            return null;
        }
        if (null == ocContract) {
            ocContract = new OcContract();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContract, (Object)ocContractDomain);
            return ocContract;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContract", (Throwable)e);
            return null;
        }
    }

    private OcContractReDomain makeOcContractDomain(OcContract ocContract) {
        if (null == ocContract) {
            return null;
        }
        OcContractReDomain ocContractDomain = new OcContractReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractDomain, (Object)ocContract);
            return ocContractDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeOcContractDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContract> queryContractModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractModel", (Throwable)e);
            return null;
        }
    }

    private int countContract(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContract", (Throwable)e);
        }
        return i;
    }

    private String checkContractGoods(OcContractGoodsDomain ocContractGoodsDomain) {
        if (null == ocContractGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractGoodsDomain.getTenantCode())) {
            msg = msg + "\u5546\u6237\u4ee3\u7801\u4e3a\u7a7a;";
        }
        if (!"2".equals(ocContractGoodsDomain.getContractGoodsGtype()) && StringUtils.isBlank((String)ocContractGoodsDomain.getGoodsCode())) {
            msg = msg + "\u539f\u59cb\u5355\u636e\u53f7\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractGoodsDefault(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return;
        }
        if (null == ocContractGoods.getDataState()) {
            ocContractGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocContractGoods.getGmtCreate()) {
            ocContractGoods.setGmtCreate(date);
        }
        ocContractGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)ocContractGoods.getContractGoodsCode())) {
            ocContractGoods.setContractGoodsCode(this.createUUIDString());
        }
        if (StringUtils.isBlank((String)ocContractGoods.getContractGoodsGtype())) {
            ocContractGoods.setContractGoodsGtype("0");
        }
    }

    private int getContractGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocContractGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractGoodsUpdataDefault(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return;
        }
        ocContractGoods.setGmtModified(this.getSysDate());
    }

    private void saveContractGoodsModel(OcContractGoods ocContractGoods) throws ApiException {
        if (null == ocContractGoods) {
            return;
        }
        try {
            this.ocContractGoodsMapper.insert(ocContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveContractGoodsBatchModel(List<OcContractGoods> ocContractGoodsList) throws ApiException {
        if (null == ocContractGoodsList || ocContractGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ocContractGoodsMapper.insertBatch(ocContractGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractGoods getContractGoodsModelById(Integer contractGoodsId) {
        if (null == contractGoodsId) {
            return null;
        }
        try {
            return this.ocContractGoodsMapper.selectByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractGoodsModelById", (Throwable)e);
            return null;
        }
    }

    public OcContractGoods getContractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delContractGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractGoodsModelByCode.num");
        }
    }

    private void deleteContractGoodsModel(Integer contractGoodsId) throws ApiException {
        if (null == contractGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.deleteByPrimaryKey(contractGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractGoodsModel.num");
        }
    }

    private void updateContractGoodsModel(OcContractGoods ocContractGoods) throws ApiException {
        if (null == ocContractGoods) {
            return;
        }
        try {
            this.ocContractGoodsMapper.updateByPrimaryKeySelective(ocContractGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModel.ex", (Throwable)e);
        }
    }

    private void updateStateContractGoodsModel(Integer contractGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contractGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractGoodsId", contractGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractGoodsModel.null");
        }
    }

    private OcContractGoods makeContractGoods(OcContractGoodsDomain ocContractGoodsDomain, OcContractGoods ocContractGoods) {
        if (null == ocContractGoodsDomain) {
            return null;
        }
        if (null == ocContractGoods) {
            ocContractGoods = new OcContractGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoods, (Object)ocContractGoodsDomain);
            return ocContractGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContractGoods", (Throwable)e);
            return null;
        }
    }

    private List<OcContractGoods> queryContractGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractGoodsModel", (Throwable)e);
            return null;
        }
    }

    private List<OcContractGoodsDomain> makeContractGoodsDomainList(List<OcContractGoods> ocContractGoodsList) {
        if (null == ocContractGoodsList || ocContractGoodsList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractGoodsDomain> ocContractGoodsDomainList = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoods ocContractGoods : ocContractGoodsList) {
            ocContractGoodsDomainList.add(this.makeContractGoodsDomain(ocContractGoods));
        }
        return ocContractGoodsDomainList;
    }

    private OcContractGoodsDomain makeContractGoodsDomain(OcContractGoods ocContractGoods) {
        if (null == ocContractGoods) {
            return null;
        }
        OcContractGoodsDomain ocContractGoodsDomain = new OcContractGoodsDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractGoodsDomain, (Object)ocContractGoods);
            return ocContractGoodsDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContractGoodsDomain", (Throwable)e);
            return null;
        }
    }

    private List<String> queryBuyerMemberCodesPage(Map<String, Object> params) {
        try {
            return this.ocContractMapper.getBuyerMerberCodes(params);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryBuyerMemberCodesPage", (Throwable)e);
            return null;
        }
    }

    private int countContractGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContractGoods", (Throwable)e);
        }
        return i;
    }

    private int countBuyerMerber(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractMapper.countBuyerMerber(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countBuyerMerber", (Throwable)e);
        }
        return i;
    }

    private void updateContractGoodsModelRefByCode(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateRefByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefByCode.i", String.valueOf(i));
        }
    }

    private void updateContractGoodsModelRefres(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractGoodsMapper.updateRefres(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefres.ex", e + "|||" + map);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoodsModelRefres.i", String.valueOf(i) + "||||" + map);
        }
    }

    private String checkPackage(OcPackageDomain ocPackageDomain) {
        if (null == ocPackageDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        return msg;
    }

    private void setPackageDefault(OcPackage ocPackage) {
        if (null == ocPackage) {
            return;
        }
        if (null == ocPackage.getDataState()) {
            ocPackage.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocPackage.getGmtCreate()) {
            ocPackage.setGmtCreate(date);
        }
        ocPackage.setGmtModified(date);
        if (StringUtils.isBlank((String)ocPackage.getPackageCode())) {
            ocPackage.setPackageCode(this.createUUIDString());
        }
    }

    private int getPackageMaxCode() {
        int code = 0;
        try {
            return this.ocPackageMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPackageMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setPackageUpdataDefault(OcPackage ocPackage) {
        if (null == ocPackage) {
            return;
        }
        ocPackage.setGmtModified(this.getSysDate());
    }

    private void savePackageModel(OcPackage ocPackage) throws ApiException {
        if (null == ocPackage) {
            return;
        }
        try {
            this.ocPackageMapper.insert(ocPackage);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.savePackageModel.ex", (Throwable)e);
        }
    }

    private OcPackage getPackageModelById(Integer packageId) {
        if (null == packageId) {
            return null;
        }
        try {
            return this.ocPackageMapper.selectByPrimaryKey(packageId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPackageModelById", (Throwable)e);
            return null;
        }
    }

    public OcPackage getPackageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocPackageMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getPackageModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delPackageModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocPackageMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delPackageModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delPackageModelByCode.num");
        }
    }

    private void deletePackageModel(Integer packageId) throws ApiException {
        if (null == packageId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocPackageMapper.deleteByPrimaryKey(packageId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deletePackageModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deletePackageModel.num");
        }
    }

    private void updatePackageModel(OcPackage ocPackage) throws ApiException {
        if (null == ocPackage) {
            return;
        }
        try {
            this.ocPackageMapper.updateByPrimaryKeySelective(ocPackage);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackageModel.ex", (Throwable)e);
        }
    }

    private void updateStatePackageModel(Integer packageId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == packageId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageId", packageId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocPackageMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStatePackageModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStatePackageModel.null");
        }
    }

    private OcPackage makePackage(OcPackageDomain ocPackageDomain, OcPackage ocPackage) {
        if (null == ocPackageDomain) {
            return null;
        }
        if (null == ocPackage) {
            ocPackage = new OcPackage();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocPackage, (Object)ocPackageDomain);
            return ocPackage;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makePackage", (Throwable)e);
            return null;
        }
    }

    private List<OcPackageDomain> makePackageDomainList(List<OcPackage> ocPackageList) {
        if (null == ocPackageList || ocPackageList.isEmpty()) {
            return null;
        }
        ArrayList<OcPackageDomain> list = new ArrayList<OcPackageDomain>();
        for (OcPackage ocPackage : ocPackageList) {
            list.add(this.makePackageDomain(ocPackage));
        }
        return list;
    }

    private OcPackageDomain makePackageDomain(OcPackage ocPackage) {
        if (null == ocPackage) {
            return null;
        }
        OcPackageDomain ocPackageDomain = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)ocPackage);
            this.makeContractGoodsList(ocPackageDomain);
            return ocPackageDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makePackageDomain", (Throwable)e);
            return null;
        }
    }

    private void makeContractGoodsList(OcPackageDomain ocPackageDomain) {
        if (null == ocPackageDomain) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", ocPackageDomain.getContractBillcode());
        parammap.put("packageBillno", ocPackageDomain.getPackageBillno());
        parammap.put("tenantCode", ocPackageDomain.getTenantCode());
        List<OcContractGoods> ocContractGoodsList = this.queryContractGoodsModelPage(parammap);
        if (null == ocContractGoodsList) {
            return;
        }
        ocPackageDomain.setContractGoodsList(this.makeContractGoodsDomainList(ocContractGoodsList));
    }

    private List<OcPackage> queryPackageModelPage(Map<String, Object> parammap) {
        try {
            return this.ocPackageMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryPackageModel", (Throwable)e);
            return null;
        }
    }

    private int countPackage(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocPackageMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countPackage", (Throwable)e);
        }
        return i;
    }

    private void updateExpressStateByCodeModel(PackageExpressDomain packageExpressDomain) {
        int i = 0;
        try {
            i = this.ocPackageMapper.updateExpressStateByCode(packageExpressDomain);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateExpressStateByCodeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateExpressStateByCodeModel.null");
        }
    }

    private String checkContractSettl(OcContractSettlDomain ocContractSettlDomain) {
        if (null == ocContractSettlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractSettlDomain.getContractBillcode())) {
            msg = msg + "ContractBillcode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ocContractSettlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractSettlDefault(OcContractSettl ocContractSettl) {
        if (null == ocContractSettl) {
            return;
        }
        if (null == ocContractSettl.getDataState()) {
            ocContractSettl.setDataState(0);
        }
        if (null == ocContractSettl.getGmtCreate()) {
            ocContractSettl.setGmtCreate(this.getSysDate());
        }
        ocContractSettl.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocContractSettl.getContractSettlBillcode())) {
            ocContractSettl.setContractSettlBillcode(this.createUUIDString());
        }
    }

    private int getContractSettlMaxCode() {
        int code = 0;
        try {
            return this.ocContractSettlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractSettlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractSettlUpdataDefault(OcContractSettl ocContractSettl) {
        if (null == ocContractSettl) {
            return;
        }
        ocContractSettl.setGmtModified(this.getSysDate());
    }

    private void saveContractSettlModel(OcContractSettl ocContractSettl) throws ApiException {
        if (null == ocContractSettl) {
            return;
        }
        try {
            this.ocContractSettlMapper.insert(ocContractSettl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractSettlModel.ex", (Throwable)e);
        }
    }

    private void saveContractSettlModelBatch(List<OcContractSettl> ocContractSettlList) throws ApiException {
        if (null == ocContractSettlList || ocContractSettlList.isEmpty()) {
            return;
        }
        try {
            this.ocContractSettlMapper.insertBatch(ocContractSettlList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractSettlModelBatch.ex", (Throwable)e);
        }
    }

    private OcContractSettl getContractSettlModelById(Integer contractSettlId) {
        if (null == contractSettlId) {
            return null;
        }
        try {
            return this.ocContractSettlMapper.selectByPrimaryKey(contractSettlId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractSettlModelById", (Throwable)e);
            return null;
        }
    }

    public OcContractSettl getContractSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractSettlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getContractSettlModelByCode", (Throwable)e);
            return null;
        }
    }

    public void delContractSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSettlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractSettlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.delContractSettlModelByCode.num");
        }
    }

    private void deleteContractSettlModel(Integer contractSettlId) throws ApiException {
        if (null == contractSettlId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractSettlMapper.deleteByPrimaryKey(contractSettlId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.deleteContractSettlModel.num");
        }
    }

    private void updateContractSettlModel(OcContractSettl ocContractSettl) throws ApiException {
        if (null == ocContractSettl) {
            return;
        }
        try {
            this.ocContractSettlMapper.updateByPrimaryKeySelective(ocContractSettl);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractSettlModel.ex", (Throwable)e);
        }
    }

    private void updateStateContractSettlModel(Integer contractSettlId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == contractSettlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSettlId", contractSettlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocContractSettlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractSettlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateStateContractSettlModel.null");
        }
    }

    private OcContractSettl makeContractSettl(OcContractSettlDomain ocContractSettlDomain, OcContractSettl ocContractSettl) {
        if (null == ocContractSettlDomain) {
            return null;
        }
        if (null == ocContractSettl) {
            ocContractSettl = new OcContractSettl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettl, (Object)ocContractSettlDomain);
            return ocContractSettl;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeContractSettl", (Throwable)e);
            return null;
        }
    }

    private List<OcContractproDomain> makeOcContractproDomainList(List<OcContractpro> ocContractproList) {
        if (null == ocContractproList || ocContractproList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractproDomain> list = new ArrayList<OcContractproDomain>();
        for (OcContractpro ocContractpro : ocContractproList) {
            list.add(this.makeOcContractproDomain(ocContractpro));
        }
        return list;
    }

    private OcContractproDomain makeOcContractproDomain(OcContractpro OcContractpro2) {
        if (null == OcContractpro2) {
            return null;
        }
        OcContractproDomain ocContractproDomain = new OcContractproDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractproDomain, (Object)OcContractpro2);
            return ocContractproDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeOcContractproDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractSettlDomain> makeOcContractSettlDomainList(List<OcContractSettl> ocContractSettlList) {
        if (null == ocContractSettlList || ocContractSettlList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractSettlDomain> list = new ArrayList<OcContractSettlDomain>();
        for (OcContractSettl ocContractSettl : ocContractSettlList) {
            list.add(this.makeOcContractSettlDomain(ocContractSettl));
        }
        return list;
    }

    private OcContractSettlDomain makeOcContractSettlDomain(OcContractSettl ocContractSettl) {
        if (null == ocContractSettl) {
            return null;
        }
        OcContractSettlDomain ocContractSettlDomain = new OcContractSettlDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractSettlDomain, (Object)ocContractSettl);
            return ocContractSettlDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeOcContractSettlDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractSettl> queryContractSettlModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractSettlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractSettlModel", (Throwable)e);
            return null;
        }
    }

    private int countContractSettl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractSettlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.countContractSettl", (Throwable)e);
        }
        return i;
    }

    private List<OcContractGoodsDomain> makeOcContractGoodsDomainList(List<OcContractGoods> ocContractGoods) {
        if (ocContractGoods == null || ocContractGoods.isEmpty()) {
            return null;
        }
        ArrayList<OcContractGoodsDomain> goodsList = new ArrayList<OcContractGoodsDomain>();
        try {
            for (OcContractGoods goods : ocContractGoods) {
                OcContractGoodsDomain goodsDomain = new OcContractGoodsDomain();
                BeanUtils.copyAllPropertys((Object)goodsDomain, (Object)goods);
                goodsList.add(goodsDomain);
            }
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.makeOcContractGoodsDomainList.ex", (Throwable)e);
        }
        return goodsList;
    }

    @Override
    public String sendsaveContract(OcContractDomain ocContractDomain) throws ApiException {
        this.saveOrder(ocContractDomain);
        ArrayList<OcContractDomain> ocContractDomainList = new ArrayList<OcContractDomain>();
        ocContractDomainList.add(ocContractDomain);
        OcContractServiceImpl.getContractService().addPutPool(new ContractDomainPutThread(OcContractServiceImpl.getContractService(), ocContractDomainList));
        return ocContractDomain.getContractBillcode();
    }

    @Override
    public String sendBatchSaveContract(List<OcContractDomain> ocContractDomainList) throws ApiException {
        if (null == ocContractDomainList || ocContractDomainList.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.sendBatchSaveContract.null", "");
        }
        String contractBbillcode = this.saveBatchContract(ocContractDomainList);
        OcContractServiceImpl.getContractService().addPutPool(new ContractDomainPutThread(OcContractServiceImpl.getContractService(), ocContractDomainList));
        return contractBbillcode;
    }

    @Override
    public String saveBatchContract(List<OcContractDomain> ocContractDomainList) throws ApiException {
        if (null == ocContractDomainList || ocContractDomainList.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveBatchContract.null", "");
        }
        String contractBbillcode = "";
        if (ocContractDomainList.size() > 1) {
            contractBbillcode = this.getNo(null, OcContract.class.getSimpleName(), "contractBbillcode", ocContractDomainList.get(0).getTenantCode());
        }
        for (OcContractDomain ocContractDomain : ocContractDomainList) {
            ocContractDomain.setContractBbillcode(contractBbillcode);
            this.saveOrder(ocContractDomain);
            if (!StringUtils.isBlank((String)contractBbillcode)) continue;
            contractBbillcode = ocContractDomain.getContractBbillcode();
        }
        return contractBbillcode;
    }

    @Override
    public String saveContract(OcContractDomain ocContractDomain) throws ApiException {
        OcContract ocContract = this.saveOrder(ocContractDomain);
        return ocContract.getContractBillcode();
    }

    private OcPackageDomain createpackgeByGoods(OcContractDomain ocContractDomain, OcContractGoodsDomain ocContractGoodsDomain) {
        if (ocContractDomain == null || null == ocContractGoodsDomain) {
            return null;
        }
        OcPackageDomain ocPackage = new OcPackageDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocPackage, (Object)ocContractDomain);
            BeanUtils.copyAllPropertys((Object)ocPackage, (Object)ocContractGoodsDomain);
        }
        catch (Exception e) {
            // empty catch block
        }
        ocPackage.setGoodsNum(ocContractGoodsDomain.getGoodsNum());
        ocPackage.setGoodsWeight(ocContractGoodsDomain.getGoodsWeight());
        ocPackage.setGoodsMoney(ocContractGoodsDomain.getContractGoodsInmoney());
        ocPackage.setGoodsPmoney(ocContractGoodsDomain.getContractGoodsMoney());
        ocPackage.setPricesetRefrice(ocContractGoodsDomain.getContractGoodsPefinmoney());
        return ocPackage;
    }

    private OcPackageDomain getPackgeGroupby(String str, OcContractDomain ocContractDomain, OcContractGoodsDomain ocContractGoodsDomain, Map<String, OcPackageDomain> packgeMap, List<OcPackageDomain> ocPackgeList) {
        if (null == ocContractGoodsDomain || null == packgeMap || null == ocPackgeList || null == ocContractDomain) {
            return null;
        }
        String mapKey = "";
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((String)str)) {
            String[] param = str.split("\\|");
            Object obj = null;
            for (String s : param) {
                obj = BeanUtils.forceGetProperty((Object)ocContractGoodsDomain, (String)s);
                if (null == obj) continue;
                parammap.put(s, obj);
                if (StringUtils.isNotBlank((String)mapKey)) {
                    mapKey = mapKey + "-";
                }
                mapKey = mapKey + obj;
            }
        } else {
            parammap.put("memberCode", ocContractGoodsDomain.getMemberCode());
            if (StringUtils.isNotBlank((String)mapKey)) {
                mapKey = mapKey + "-";
            }
            mapKey = mapKey + ocContractGoodsDomain.getMemberCode();
        }
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocContractDomain.getContractBillcode();
        parammap.put("contractBillcode", ocContractDomain.getContractBillcode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocContractDomain.getMemberBcode();
        parammap.put("memberBcode", ocContractDomain.getMemberBcode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocContractDomain.getChannelCode();
        parammap.put("channelCode", ocContractDomain.getChannelCode());
        if (StringUtils.isNotBlank((String)mapKey)) {
            mapKey = mapKey + "-";
        }
        mapKey = mapKey + ocContractDomain.getTenantCode();
        parammap.put("tenantCode", ocContractDomain.getTenantCode());
        OcPackageDomain ocPackageDomain = null;
        ocPackageDomain = packgeMap.get(mapKey);
        if (null == ocContractGoodsDomain.getGoodsCamount()) {
            ocContractGoodsDomain.setGoodsCamount(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getGoodsCweight()) {
            ocContractGoodsDomain.setGoodsCweight(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
            ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
            ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
        }
        if (null == ocContractGoodsDomain.getContractGoodsPefinmoney()) {
            ocContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
        }
        if (null == ocPackageDomain) {
            ocPackageDomain = this.createpackgeByGoods(ocContractDomain, ocContractGoodsDomain);
            ocPackgeList.add(ocPackageDomain);
            packgeMap.put(mapKey, ocPackageDomain);
        } else {
            if (null == ocPackageDomain.getGoodsNum()) {
                ocPackageDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == ocPackageDomain.getGoodsWeight()) {
                ocPackageDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            ocPackageDomain.setGoodsNum(ocPackageDomain.getGoodsNum().add(ocContractGoodsDomain.getGoodsNum()));
            ocPackageDomain.setGoodsWeight(ocPackageDomain.getGoodsWeight().add(ocContractGoodsDomain.getGoodsWeight()));
            ocPackageDomain.setGoodsMoney(ocPackageDomain.getGoodsMoney().add(ocContractGoodsDomain.getContractGoodsInmoney()));
            ocPackageDomain.setGoodsPmoney(ocPackageDomain.getGoodsPmoney().add(ocContractGoodsDomain.getContractGoodsMoney()));
            ocPackageDomain.setPricesetRefrice(ocPackageDomain.getPricesetRefrice().add(ocContractGoodsDomain.getContractGoodsPefinmoney()));
        }
        return ocPackageDomain;
    }

    public void makePack(OcContractDomain ocContractDomain) {
        if (null == ocContractDomain || ListUtil.isNotEmpty(ocContractDomain.getPackageList()) || ListUtil.isEmpty(ocContractDomain.getGoodsList())) {
            return;
        }
        HashMap<String, OcPackageDomain> packgeMap = new HashMap<String, OcPackageDomain>();
        String tenantCode = ocContractDomain.getTenantCode();
        String shoppingpackgeStr = DisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-shopping-shoppingpackgekey"));
        if (StringUtils.isBlank((String)shoppingpackgeStr)) {
            shoppingpackgeStr = DisUtil.getMap((String)"DdFalgSetting-key", (String)"00000000-shopping-shoppingpackgekey");
        }
        ArrayList<OcPackageDomain> packageList = new ArrayList<OcPackageDomain>();
        ocContractDomain.setPackageList(packageList);
        for (OcContractGoodsDomain ocContractGoodsDomain : ocContractDomain.getGoodsList()) {
            if (StringUtils.isBlank((String)ocContractDomain.getMemberCode())) {
                ocContractDomain.setMemberCode(ocContractGoodsDomain.getMemberCode());
                ocContractDomain.setMemberName(ocContractGoodsDomain.getMemberName());
            }
            if (null == ocContractGoodsDomain.getGoodsNum()) {
                ocContractGoodsDomain.setGoodsNum(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsInmoney()) {
                ocContractGoodsDomain.setContractGoodsInmoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsMoney()) {
                ocContractGoodsDomain.setContractGoodsMoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getContractGoodsPefinmoney()) {
                ocContractGoodsDomain.setContractGoodsPefinmoney(BigDecimal.ZERO);
            }
            if (null == ocContractGoodsDomain.getGoodsWeight()) {
                ocContractGoodsDomain.setGoodsWeight(BigDecimal.ZERO);
            }
            this.getPackgeGroupby(shoppingpackgeStr, ocContractDomain, ocContractGoodsDomain, packgeMap, packageList);
        }
    }

    private OcContract saveOrder(OcContractDomain ocContractDomain) {
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContract.checkContract", msg);
        }
        ocContractDomain.setContractId(null);
        OcContract ocContract = this.makeContract(ocContractDomain, null);
        this.setContractDefault(ocContract);
        this.makePack(ocContractDomain);
        ocContract.setContractEcflag(this.checkEc(ocContract, ocContractDomain.getPackageList().get(0).getContractGoodsList()));
        this.saveContractModel(ocContract);
        this.savePackageList(ocContractDomain.getPackageList(), ocContract);
        this.saveOcContractSettl(ocContractDomain.getOcContractSettlList(), ocContract);
        this.saveOcContractpro(ocContractDomain.getOcContractproDomainList(), ocContract);
        String contractCtrlSeqno = this.saveOcContractCtrl(ocContract);
        ocContractDomain.setContractCtrlSeqno(contractCtrlSeqno);
        ocContractDomain.setContractBillcode(ocContract.getContractBillcode());
        ocContractDomain.setContractBbillcode(ocContract.getContractBbillcode());
        ocContractDomain.setContractTypepro(ocContract.getContractTypepro());
        return ocContract;
    }

    private void saveOcContractpro(List<OcContractproDomain> ocContractproDomainList, OcContract ocContract) {
        if (null == ocContract || null == ocContractproDomainList || ocContractproDomainList.isEmpty()) {
            return;
        }
        for (OcContractproDomain ocContractproDomain : ocContractproDomainList) {
            ocContractproDomain.setContractBbillcode(ocContract.getContractBbillcode());
            ocContractproDomain.setContractBillcode(ocContract.getContractBillcode());
            ocContractproDomain.setContractNbbillcode(ocContract.getContractNbbillcode());
            ocContractproDomain.setContractNbillcode(ocContract.getContractNbillcode());
            ocContractproDomain.setTenantCode(ocContract.getTenantCode());
            ocContractproDomain.setAppmanageIcode(ocContract.getAppmanageIcode());
        }
        this.ocContractproService.savecontractproBatch(ocContractproDomainList);
    }

    private void saveOcContractSettl(List<OcContractSettlDomain> ocContractSettlDomainList, OcContract ocContract) {
        if (null == ocContract || null == ocContractSettlDomainList || ocContractSettlDomainList.isEmpty()) {
            return;
        }
        ArrayList<OcContractSettl> ocContractSettlList = new ArrayList<OcContractSettl>();
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            ocContractSettlDomain.setContractBillcode(ocContract.getContractBillcode());
            if (StringUtils.isBlank((String)ocContractSettlDomain.getMemberBcode())) {
                ocContractSettlDomain.setMemberBcode(ocContract.getMemberBcode());
                ocContractSettlDomain.setMemberBname(ocContract.getMemberBname());
            }
            if (StringUtils.isBlank((String)ocContractSettlDomain.getMemberCcode())) {
                ocContractSettlDomain.setMemberCcode(ocContract.getMemberCcode());
                ocContractSettlDomain.setMemberCname(ocContract.getMemberCname());
            }
            if (StringUtils.isBlank((String)ocContractSettlDomain.getMemberCode())) {
                ocContractSettlDomain.setMemberCode(ocContract.getMemberCode());
                ocContractSettlDomain.setMemberName(ocContract.getMemberName());
            }
            ocContractSettlDomain.setTenantCode(ocContract.getTenantCode());
            OcContractSettl ocContractSettl = this.createContractsettl(ocContractSettlDomain);
            ocContractSettlList.add(ocContractSettl);
        }
        this.saveContractSettlModelBatch(ocContractSettlList);
    }

    private String saveOcContractCtrl(OcContract ocContract) {
        if (null == ocContract) {
            return null;
        }
        OcContractCtrlDomain ocContractCtrlDomain = this.createOcContractCtrlDomain(ocContract);
        if (null == ocContractCtrlDomain) {
            return null;
        }
        return this.ocContractCtrlService.saveContractCtrl(ocContractCtrlDomain);
    }

    private OcContractCtrlDomain createOcContractCtrlDomain(OcContract ocContract) {
        if (null == ocContract) {
            return null;
        }
        OcContractCtrlDomain ocContractCtrlDomain = new OcContractCtrlDomain();
        ocContractCtrlDomain.setTenantCode(ocContract.getTenantCode());
        ocContractCtrlDomain.setContractBbillcode(ocContract.getContractBbillcode());
        ocContractCtrlDomain.setContractBillcode(ocContract.getContractBillcode());
        return ocContractCtrlDomain;
    }

    private void savePackageList(List<OcPackageDomain> packageList, OcContract ocContract) {
        if (packageList == null || packageList.isEmpty() || null == ocContract) {
            return;
        }
        String contractBillcode = ocContract.getContractBillcode();
        String tenantCode = ocContract.getTenantCode();
        for (OcPackageDomain ocPackageDomain : packageList) {
            BigDecimal goodsMoney = ocPackageDomain.getGoodsMoney();
            BigDecimal goodsPmoney = ocPackageDomain.getGoodsPmoney();
            String goodsPmbillno = ocPackageDomain.getGoodsPmbillno();
            BigDecimal goodsWeight = ocPackageDomain.getGoodsWeight();
            BigDecimal goodsNum = ocPackageDomain.getGoodsNum();
            String areaCode = ocPackageDomain.getAreaCode();
            String areaName = ocPackageDomain.getAreaName();
            String warehouseName = ocPackageDomain.getWarehouseName();
            String warehouseCode = ocPackageDomain.getWarehouseCode();
            String contractPumode = ocPackageDomain.getContractPumode();
            try {
                BeanUtils.copyAllPropertys((Object)ocPackageDomain, (Object)ocContract);
            }
            catch (Exception e) {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.savePackageList.e", (Throwable)e);
            }
            if (StringUtils.isNotBlank((String)contractPumode)) {
                ocPackageDomain.setContractPumode(contractPumode);
            }
            ocPackageDomain.setContractBillcode(contractBillcode);
            ocPackageDomain.setTenantCode(tenantCode);
            ocPackageDomain.setGoodsMoney(goodsMoney);
            ocPackageDomain.setGoodsPmoney(goodsPmoney);
            ocPackageDomain.setGoodsPmbillno(goodsPmbillno);
            ocPackageDomain.setGoodsWeight(goodsWeight);
            ocPackageDomain.setGoodsNum(goodsNum);
            ocPackageDomain.setAreaCode(areaCode);
            ocPackageDomain.setAreaName(areaName);
            ocPackageDomain.setWarehouseCode(warehouseCode);
            ocPackageDomain.setWarehouseName(warehouseName);
            ocPackageDomain.setMemberBcode(ocContract.getMemberBcode());
            ocPackageDomain.setMemberBname(ocContract.getMemberBname());
            ocPackageDomain.setMemberCode(ocContract.getMemberCode());
            ocPackageDomain.setMemberName(ocContract.getMemberName());
            this.savePackageBycon(ocPackageDomain, ocContract);
        }
    }

    @Override
    public void updateContractState(Integer contractId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContractModel(contractId, dataState, oldDataState);
    }

    @Override
    public void updateContractStateExtend(Integer contractId, Integer dataState, Integer oldDataState) {
        if (contractId == null || contractId <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractStateExtend.contractId.null", "\u8ba2\u5355\u7f16\u53f7\u6709\u8bef");
        }
        switch (dataState) {
            case -1: {
                this.extend_can(contractId, dataState, oldDataState);
                break;
            }
            case 2: {
                this.extend_offlinePay(contractId, dataState, oldDataState);
                break;
            }
            case 4: {
                this.extend_offlinePay(contractId, dataState, oldDataState);
                break;
            }
            default: {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractStateExtend.dataState", "\u4e0d\u652f\u6301\u7684\u8ba2\u5355\u72b6\u6001");
            }
        }
    }

    private void extend_can(Integer contractId, Integer dataState, Integer oldDataState) {
        OcContract ocContract = this.getContractModelById(contractId);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.extend_can.ocContract", "\u8ba2\u5355\u4e0d\u5b58\u5728" + contractId);
        }
        if (null != oldDataState && oldDataState.intValue() != ocContract.getDataState().intValue()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.extend_can.dataState", "\u8ba2\u5355\u72b6\u6001\u5df2\u53d8\u5316[" + oldDataState + "][" + ocContract.getDataState() + "]");
        }
        String contractBillcode = ocContract.getContractBillcode();
        String tenantCode = ocContract.getTenantCode();
        this.getOcContractEngineService().sendContractBack(contractBillcode, tenantCode, null);
    }

    private void extend_offlinePay(Integer contractId, Integer dataState, Integer oldDataState) {
        OcContract ocContract = this.getContractModelById(contractId);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.extend_offlinePay.ocContract", "\u8ba2\u5355\u4e0d\u5b58\u5728" + contractId);
        }
        if (null != oldDataState && oldDataState.intValue() != ocContract.getDataState().intValue()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.extend_offlinePay.dataState", "\u8ba2\u5355\u72b6\u6001\u5df2\u53d8\u5316[" + oldDataState + "][" + ocContract.getDataState() + "]");
        }
        String contractBillcode = ocContract.getContractBillcode();
        String tenantCode = ocContract.getTenantCode();
        this.getOcContractEngineService().sendContractNext(contractBillcode, tenantCode, null);
    }

    @Override
    public void updateContract(OcContractDomain ocContractDomain) throws ApiException {
        String msg = this.checkContract(ocContractDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.checkContract", msg);
        }
        OcContract oldOcContract = null;
        if (ocContractDomain.getContractId() != null) {
            oldOcContract = this.getContractModelById(ocContractDomain.getContractId());
        } else if (StringUtils.isNotBlankLoop((String[])new String[]{ocContractDomain.getContractBillcode(), ocContractDomain.getTenantCode()})) {
            oldOcContract = this.getContractModelByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{ocContractDomain.getContractBillcode(), ocContractDomain.getTenantCode()}));
        }
        if (null == oldOcContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContract.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContract ocContract = this.makeContract(ocContractDomain, oldOcContract);
        this.setContractUpdataDefault(ocContract);
        this.updateContractModel(ocContract);
    }

    @Override
    public OcContractReDomain getContract(Integer contractId) {
        OcContract ocContract = this.getContractModelById(contractId);
        OcContractReDomain ocContractDomain = this.makeReDomain(ocContract);
        return ocContractDomain;
    }

    @Override
    public void deleteContract(Integer contractId) throws ApiException {
        this.deleteContractModel(contractId);
    }

    @Override
    public QueryResult<OcContract> queryContractPage(Map<String, Object> map) {
        int count = this.countContract(map);
        List<Object> ocContractList = new ArrayList();
        if (count > 0) {
            ocContractList = this.queryContractModelPage(map);
            if (map.get("childFlag") != null && ocContractList != null && !ocContractList.isEmpty()) {
                map.clear();
                for (OcContract ocContract : ocContractList) {
                    map.put("contractBillcode", ocContract.getContractBillcode());
                    map.put("tenantCode", ocContract.getTenantCode());
                    map.put("mode", PackageModeEnum.AUTO.getCode());
                    ocContract.setPackageList(this.setPackageList(map));
                }
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractList);
        return queryResult;
    }

    private List<OcPackage> setPackageList(Map<String, Object> map) {
        QueryResult<OcPackage> rueryResult = this.queryPackagePage(map);
        if (null == rueryResult) {
            return null;
        }
        return rueryResult.getList();
    }

    private List<OcPackageDomain> queryPackageDomainList(String contractBillcode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("mode", PackageModeEnum.AUTO.getCode());
        List<OcPackage> packageList = this.queryPackageModelPage(map);
        if (ListUtil.isEmpty(packageList)) {
            return null;
        }
        ArrayList<OcPackageDomain> packageDomainList = new ArrayList<OcPackageDomain>();
        for (OcPackage ocPackage : packageList) {
            OcPackageDomain domain = new OcPackageDomain();
            try {
                BeanUtils.copyAllPropertys((Object)domain, (Object)ocPackage);
                packageDomainList.add(domain);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryPackageDomainList.foreach.ex", (Throwable)e);
            }
        }
        return packageDomainList;
    }

    private List<OcContractGoodsDomain> queryContractGoodsDomainList(String contractBillcode, String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", contractBillcode);
        parammap.put("tenantCode", tenantCode);
        List<OcContractGoods> goodsList = this.queryContractGoodsModelPage(parammap);
        if (ListUtil.isEmpty(goodsList)) {
            return null;
        }
        ArrayList<OcContractGoodsDomain> goodsDomainList = new ArrayList<OcContractGoodsDomain>();
        for (OcContractGoods ocContractGoods : goodsList) {
            OcContractGoodsDomain goodsDomain = new OcContractGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)goodsDomain, (Object)ocContractGoods);
                goodsDomainList.add(goodsDomain);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryContractGoodsDomainList.foreach.ex", (Throwable)e);
            }
        }
        return goodsDomainList;
    }

    private List<OcContractReDomain> queryContractReDomainModelPage(Map<String, Object> map) {
        ArrayList<OcContractReDomain> contractReDomainList = new ArrayList<OcContractReDomain>();
        List<OcContract> contractList = this.ocContractMapper.query(map);
        if (contractList == null || contractList.isEmpty()) {
            return null;
        }
        boolean childFlag = map.get("childFlag") != null;
        for (OcContract ocContract : contractList) {
            OcContractReDomain contractReDomain = this.makeOcContractDomain(ocContract);
            if (childFlag) {
                contractReDomain.setPackageList(this.queryPackageDomainList(ocContract.getContractBillcode(), ocContract.getTenantCode()));
                contractReDomain.setGoodsList(this.queryContractGoodsDomainList(ocContract.getContractBillcode(), ocContract.getTenantCode()));
            }
            contractReDomainList.add(contractReDomain);
        }
        return contractReDomainList;
    }

    @Override
    public QueryResult<OcContractReDomain> queryContractPageReDomain(Map<String, Object> map) {
        int count = this.countContract(map);
        List<Object> ocContractList = new ArrayList();
        if (count > 0) {
            ocContractList = this.queryContractReDomainModelPage(map);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(count);
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractList);
        return queryResult;
    }

    @Override
    public OcContractReDomain getContractByCode(Map<String, Object> map) {
        OcContract ocContract = this.getContractModelByCode(map);
        OcContractReDomain ocContractDomain = this.makeReDomain(ocContract);
        return ocContractDomain;
    }

    @Override
    public OcContract getContractOneByCode(Map<String, Object> map) {
        return this.getContractModelByCode(map);
    }

    @Override
    public OcContract getContractModelByCodes(Map<String, Object> map) {
        return this.getContractModelByCode(map);
    }

    private OcContractReDomain makeReDomain(OcContract ocContract) {
        if (null == ocContract) {
            return null;
        }
        OcContractReDomain ocContractDomain = this.makeOcContractDomain(ocContract);
        if (null == ocContractDomain) {
            return null;
        }
        TypeBean typeBean = this.getOcSetting(ocContract.getContractType(), ocContract.getTenantCode());
        if (null != typeBean) {
            ocContractDomain.setIntpay(typeBean.getIntpay());
            ocContractDomain.setPmpay(typeBean.getPmpay());
            ocContractDomain.setBlance(typeBean.getBlance());
            ocContractDomain.setPmode(typeBean.getPmode());
            ocContractDomain.setFreight(typeBean.getFreight());
            ocContractDomain.setCoppay(typeBean.getCoppay());
            ocContractDomain.setUrpay(typeBean.getUrpay());
            int i = this.checkInv(ocContract.getContractType(), ocContract.getContractTypepro(), ocContract.getTenantCode());
            if (0 == i) {
                ocContractDomain.setInvp("0");
            } else {
                ocContractDomain.setInvp("1");
            }
            ocContractDomain.setRef(typeBean.getRef());
            ocContractDomain.setReg(typeBean.getReg());
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", ocContract.getContractBillcode());
        parammap.put("tenantCode", ocContract.getTenantCode());
        List<OcPackage> ocPackageList = this.queryPackageModelPage(parammap);
        if (null == ocPackageList || ocPackageList.isEmpty()) {
            return ocContractDomain;
        }
        List<OcPackageDomain> packageList = this.makePackageDomainList(ocPackageList);
        ocContractDomain.setPackageList(packageList);
        List<OcContractSettl> ocContractSettlList = this.queryContractSettlModelPage(parammap);
        ocContractDomain.setOcContractSettlList(this.makeOcContractSettlDomainList(ocContractSettlList));
        ArrayList<OcContractGoodsDomain> goodsList = new ArrayList<OcContractGoodsDomain>();
        for (OcPackageDomain ocPackageDomain : packageList) {
            goodsList.addAll(ocPackageDomain.getContractGoodsList());
        }
        if (ListUtil.isEmpty(goodsList)) {
            parammap.put("contractBillcode", ocContract.getContractBillcode());
            ocContractDomain.setGoodsList(this.makeOcContractGoodsDomainList(this.queryContractGoodsModelPage(parammap)));
        } else {
            ocContractDomain.setGoodsList(goodsList);
        }
        ocContractDomain.setOaflag(this.checkOa(ocContract, typeBean, ocContractDomain.getGoodsList()) + "");
        List<OcContractpro> proList = this.ocContractproService.querycontractproByOrderCode(ocContract.getTenantCode(), ocContract.getContractBillcode());
        ocContractDomain.setOcContractproDomainList(this.makeOcContractproDomainList(proList));
        return ocContractDomain;
    }

    @Override
    public void delContractByCode(Map<String, Object> map) throws ApiException {
        this.delContractModelByCode(map);
    }

    @Override
    public void saveContractGoods(OcContractGoodsDomain ocContractGoodsDomain) throws ApiException {
        OcContractGoods ocContractGoods = this.createContractgoods(ocContractGoodsDomain);
        this.saveContractGoodsModel(ocContractGoods);
    }

    private OcContractGoods createContractgoods(OcContractGoodsDomain ocContractGoodsDomain) {
        String msg = this.checkContractGoods(ocContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractGoods.checkContractGoods", msg);
        }
        OcContractGoods ocContractGoods = this.makeContractGoods(ocContractGoodsDomain, null);
        this.setContractGoodsDefault(ocContractGoods);
        return ocContractGoods;
    }

    @Override
    public void updateContractGoodsState(Integer contractGoodsId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContractGoodsModel(contractGoodsId, dataState, oldDataState);
    }

    @Override
    public void updateContractGoods(OcContractGoodsDomain ocContractGoodsDomain) throws ApiException {
        String msg = this.checkContractGoods(ocContractGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoods.checkContractGoods", msg);
        }
        OcContractGoods oldOcContractGoods = this.getContractGoodsModelById(ocContractGoodsDomain.getContractGoodsId());
        if (null == oldOcContractGoods) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractGoods ocContractGoods = this.makeContractGoods(ocContractGoodsDomain, oldOcContractGoods);
        this.setContractGoodsUpdataDefault(ocContractGoods);
        this.updateContractGoodsModel(ocContractGoods);
    }

    @Override
    public OcContractGoods getContractGoods(Integer contractGoodsId) {
        return this.getContractGoodsModelById(contractGoodsId);
    }

    @Override
    public void deleteContractGoods(Integer contractGoodsId) throws ApiException {
        this.deleteContractGoodsModel(contractGoodsId);
    }

    @Override
    public QueryResult<OcContractGoods> queryContractGoodsPage(Map<String, Object> map) {
        List<OcContractGoods> ocContractGoodsList = this.queryContractGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractGoodsList);
        return queryResult;
    }

    @Override
    public OcContractGoods getContractGoodsByCode(Map<String, Object> map) {
        return this.getContractGoodsModelByCode(map);
    }

    @Override
    public void delContractGoodsByCode(Map<String, Object> map) throws ApiException {
        this.delContractGoodsModelByCode(map);
    }

    @Override
    public void savePackage(OcPackageDomain ocPackageDomain) throws ApiException {
        this.savePackageBycon(ocPackageDomain, null);
    }

    private void savePackageBycon(OcPackageDomain ocPackageDomain, OcContract ocContract) {
        String msg = this.checkPackage(ocPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.savePackage.checkPackage", msg);
        }
        OcPackage ocPackage = this.makePackage(ocPackageDomain, null);
        this.setPackageDefault(ocPackage);
        this.savePackageModel(ocPackage);
        this.saveContractGoodsList(ocPackageDomain.getContractGoodsList(), ocPackage, ocContract);
    }

    private void saveContractGoodsList(List<OcContractGoodsDomain> contractGoodsList, OcPackage ocPackage, OcContract ocContract) {
        if (contractGoodsList == null || contractGoodsList.isEmpty() || null == ocPackage) {
            return;
        }
        ArrayList<OcContractGoods> ocContractGoodsList = new ArrayList<OcContractGoods>();
        for (OcContractGoodsDomain ocContractGoodsDomain : contractGoodsList) {
            ocContractGoodsDomain.setPackageCode(ocPackage.getPackageCode());
            ocContractGoodsDomain.setContractBillcode(ocPackage.getContractBillcode());
            ocContractGoodsDomain.setTenantCode(ocPackage.getTenantCode());
            ocContractGoodsDomain.setMemberBcode(ocPackage.getMemberBcode());
            ocContractGoodsDomain.setMemberBname(ocPackage.getMemberBname());
            if (StringUtils.isBlank((String)ocContractGoodsDomain.getContractGoodsGtype())) {
                ocContractGoodsDomain.setContractGoodsGtype("0");
            }
            if (null != ocContract) {
                if (StringUtils.isBlank((String)ocContractGoodsDomain.getMemberCcode()) && StringUtils.isNotBlank((String)ocContract.getMemberCcode())) {
                    ocContractGoodsDomain.setMemberCcode(ocContract.getMemberCcode());
                    ocContractGoodsDomain.setMemberCname(ocContract.getMemberCname());
                }
                ocContractGoodsDomain.setMemberCode(ocContract.getMemberCode());
                ocContractGoodsDomain.setMemberName(ocContract.getMemberName());
            }
            OcContractGoods ocContractGoods = this.createContractgoods(ocContractGoodsDomain);
            ocContractGoodsList.add(ocContractGoods);
        }
        this.saveContractGoodsBatchModel(ocContractGoodsList);
    }

    @Override
    public void updatePackageState(Integer packageId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStatePackageModel(packageId, dataState, oldDataState);
    }

    @Override
    public void updatePackage(OcPackageDomain ocPackageDomain) throws ApiException {
        String msg = this.checkPackage(ocPackageDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackage.checkPackage", msg);
        }
        OcPackage oldOcPackage = this.getPackageModelById(ocPackageDomain.getPackageId());
        if (null == oldOcPackage) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackage.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcPackage ocPackage = this.makePackage(ocPackageDomain, oldOcPackage);
        this.setPackageUpdataDefault(ocPackage);
        this.updatePackageModel(ocPackage);
    }

    @Override
    public OcPackage getPackage(Integer packageId) {
        return this.getPackageModelById(packageId);
    }

    @Override
    public void deletePackage(Integer packageId) throws ApiException {
        this.deletePackageModel(packageId);
    }

    @Override
    public QueryResult<OcPackage> queryPackagePage(Map<String, Object> map) {
        List<OcPackage> ocPackageList = this.queryPackageModelPage(map);
        if (ocPackageList != null && !ocPackageList.isEmpty()) {
            for (OcPackage ocPackage : ocPackageList) {
                map.put("packageCode", ocPackage.getPackageCode());
                ocPackage.setContractGoodsList(this.queryContractGoodsModelPage(map));
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countPackage(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocPackageList);
        map.clear();
        return queryResult;
    }

    @Override
    public OcPackage getPackageByCode(Map<String, Object> map) {
        return this.getPackageModelByCode(map);
    }

    @Override
    public void delPackageByCode(Map<String, Object> map) throws ApiException {
        this.delPackageModelByCode(map);
    }

    @Override
    public void updateContractStateByCode(Map<String, Object> map) throws ApiException {
        String contractBillcode = map.get("contractBillcode").toString();
        Integer dataState = (Integer)map.get("dataState");
        Integer oldDataState = (Integer)map.get("oldDataState");
        OcContract contract = this.getContractModelByCode(map);
        this.updateStateContractModel(contract.getContractId(), dataState, oldDataState);
        if (ContractPropertyEnum.VIRTUAL.getCode().equals(contract.getContractProperty())) {
            this.updateExtContractPackage(contract.getTenantCode(), contractBillcode, null, null);
        }
    }

    @Override
    public QueryResult<OcContract> getOcContractByGoods(Map<String, Object> map) throws ApiException {
        List<OcContractGoods> ocContractGoodsList = this.queryContractGoodsModelPage(map);
        ArrayList<OcContract> contractList = new ArrayList<OcContract>();
        for (OcContractGoods goods : ocContractGoodsList) {
            HashMap<String, Object> pmap = new HashMap<String, Object>();
            pmap.put("contractBillcode", goods.getContractBillcode());
            pmap.put("tenantCode", goods.getTenantCode());
            OcContract contract = this.getContractModelByCode(pmap);
            if (contract == null) continue;
            contract.setOcContractGoods(goods);
            contractList.add(contract);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(contractList);
        return queryResult;
    }

    @Override
    public void sendContractMsg(String tenantCode, String contractBillcode) throws ApiException {
        if (StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)contractBillcode)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendContractMsg", (Object)"\u8bf7\u6c42\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        OcContract ocContract = this.getContractModelByCode(this.getQueryParamMap("tenantCode,contractBillcode", new Object[]{tenantCode, contractBillcode}));
        if (ocContract == null) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.sendContractMsg", (Object)"\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
            return;
        }
        List<OcContractGoods> goodslist = this.queryContractGoodsModelPage(this.getQueryParamMap("tenantCode,contractBillcode", new Object[]{tenantCode, contractBillcode}));
        this.sendMns(ocContract, goodslist);
    }

    public void sendMns(OcContract ocContract, List<OcContractGoods> goodslist) {
        if (ListUtil.isEmpty(goodslist)) {
            return;
        }
        ConcurrentHashMap<String, String> mnsMap = new ConcurrentHashMap<String, String>();
        mnsMap.put("mnslistSubject", "");
        mnsMap.put("mnslistSource", "0");
        if (ContractConstants.NEW_ORDER.equals(ocContract.getDataState())) {
            mnsMap.put("mnslistBusType", "o1");
        } else if (ContractConstants.PAY_FINISH_ORDER.equals(ocContract.getDataState())) {
            mnsMap.put("mnslistBusType", "o2");
        } else {
            return;
        }
        HashMap<String, String> contentMap = new HashMap<String, String>();
        ArrayList<Map<String, String>> receiverList = new ArrayList<Map<String, String>>();
        this.makeReceiver(ocContract.getTenantCode(), ocContract.getMemberCode(), receiverList);
        if (!ocContract.getMemberCode().equals(ocContract.getMemberCcode())) {
            this.makeReceiver(ocContract.getTenantCode(), ocContract.getMemberCcode(), receiverList);
        }
        contentMap.put("memberName", ocContract.getMemberBname());
        contentMap.put("goodsRemark", goodslist.get(0).getGoodsRemark());
        contentMap.put("orderAmount", String.valueOf(ocContract.getContractMoney().setScale(2, 5)));
        contentMap.put("contractBillcode", ocContract.getContractBillcode());
        mnsMap.put("mnslistExp", this.getMnslistExp(contentMap, receiverList));
        mnsMap.put("tenantCode", ocContract.getTenantCode());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("mnsMnslistDomainBean", JsonUtil.buildNormalBinder().toJson(mnsMap));
        this.inAsyncInvoke("mns.mns.saveSendMnslist", paramMap);
    }

    private void makeReceiver(String tenantCode, String memberCode, List<Map<String, String>> receiverList) {
        if (StringUtils.isNotBlank((String)memberCode)) {
            HashMap<String, String> map = new HashMap<String, String>();
            Map<String, Object> member = this.getMember(tenantCode, memberCode);
            String phone = (String)member.get("merberPhone");
            if (StringUtils.isBlank((String)phone)) {
                phone = (String)member.get("merberTel");
            }
            if (StringUtils.isBlank((String)phone)) {
                return;
            }
            map.put("telphone", phone);
            map.put("name", (String)member.get("merberCompname"));
            receiverList.add(map);
        }
    }

    private Map<String, Object> getMember(String tenantCode, String memberCode) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("map", JsonUtil.buildNormalBinder().toJson((Object)this.getQueryParamMap("tenantCode,merberCode", new Object[]{tenantCode, memberCode})));
        String result = this.internalInvoke("mm.merber.getMerberByCode", paramMap);
        Map resultMap = null;
        try {
            resultMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(result, String.class, Object.class);
        }
        catch (Exception e) {
            // empty catch block
        }
        return resultMap;
    }

    private String getMnslistExp(Map<String, String> contentMap, List<Map<String, String>> receiverList) {
        HashMap<String, String> expMap = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.putAll(contentMap);
        HashMap<String, String> mapSender = new HashMap<String, String>();
        mapSender.put("code", "sys");
        mapSender.put("name", "sys");
        expMap.put("sender", JsonUtil.buildNonDefaultBinder().toJson(mapSender));
        expMap.put("receiverList", JsonUtil.buildNonDefaultBinder().toJson(receiverList));
        expMap.put("theme", "");
        expMap.put("paramMap", JsonUtil.buildNonDefaultBinder().toJson(paramMap));
        return JsonUtil.buildNonDefaultBinder().toJson(expMap);
    }

    @Override
    public String updateContractAndRefund(String tenantCode, String contractBillcode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        OcContract contract = this.getContractModelByCode(map);
        if (contract == null) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractAndRefund.null", "\u8ba2\u5355\u4fe1\u606f\u4e3a\u7a7a");
        }
        this.updateStateContractModel(contract.getContractId(), -1, contract.getDataState());
        return contract.getContractBillcode();
    }

    @Override
    public void updateContractGoodsAndRefund(String tenantCode, String contractGoodsCode, BigDecimal contractGoodsRefnum, BigDecimal contractGoodsRefweight, int dataState) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("dataState", dataState);
        map.put("contractGoodsCode", contractGoodsCode);
        map.put("contractGoodsRefnum", contractGoodsRefnum);
        map.put("contractGoodsRefweight", contractGoodsRefweight);
        this.updateContractGoodsModelRefByCode(map);
    }

    @Override
    public void updateContractGoodsRefundres(String tenantCode, String contractGoodsCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractGoodsCode", contractGoodsCode);
        this.updateContractGoodsModelRefres(map);
    }

    @Override
    public void updateRefundPass(String refundCode, String tenantCode) {
    }

    @Override
    public void updateCashSettl(String tenantCode, String contractBillcode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        this.updateCashSettlModel(map);
    }

    private void updateCashSettlModel(Map<String, Object> map) {
        try {
            int i = this.ocContractMapper.updateCashSettl(map);
            if (i <= 0) {
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateCashSettlModel", "\u66f4\u65b0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateCashSettlModel", (Throwable)e);
        }
    }

    @Override
    public void updateContractSubMoney(Integer contractId, String modifyMoney, String remark) {
        if (StringUtils.isEmpty((String)modifyMoney)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractMoneyApply", "\u4ef7\u683c\u4e3a\u7a7a\uff01");
        }
        OcContract contract = this.getContractModelById(contractId);
        if (contract == null) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractMoneyApply", "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        BigDecimal updateMoney = new BigDecimal(modifyMoney);
        contract.setContractMoney(contract.getContractMoney().add(updateMoney));
        contract.setDataBmoney(contract.getDataBmoney().add(updateMoney));
        contract.setGmtModified(this.getSysDate());
        BigDecimal goodsPmoney = contract.getGoodsPmoney();
        if (null == goodsPmoney) {
            goodsPmoney = BigDecimal.ZERO;
        }
        goodsPmoney = goodsPmoney.subtract(updateMoney);
        contract.setGoodsPmoney(goodsPmoney);
        contract.setMemo(remark);
        this.updateContractMoneyPass(contract, updateMoney);
    }

    private void updateContractMoneyPass(OcContract contract, BigDecimal updateMoney) {
        if (contract == null) {
            return;
        }
        BigDecimal basePrice = BigDecimal.ZERO;
        BigDecimal amount = null;
        List<OcContractGoods> contractGoodsList = this.queryContractGoodsModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contract.getContractBillcode(), contract.getTenantCode()}));
        BigDecimal smoney = updateMoney;
        BigDecimal money = contract.getContractInmoney();
        BigDecimal nmoney = BigDecimal.ZERO;
        BigDecimal nsmoney = null;
        if (ListUtil.isNotEmpty(contractGoodsList)) {
            for (int i = 0; i < contractGoodsList.size(); ++i) {
                OcContractGoods ocContractGoods = contractGoodsList.get(i);
                nmoney = ocContractGoods.getContractGoodsInmoney();
                if (i == contractGoodsList.size() - 1) {
                    nsmoney = smoney;
                    smoney = BigDecimal.ZERO;
                } else {
                    nsmoney = nmoney.divide(money, 2, 5).multiply(updateMoney);
                    smoney = smoney.subtract(nsmoney);
                }
                ocContractGoods.setContractGoodsMoney(ocContractGoods.getContractGoodsMoney().add(nsmoney));
                ocContractGoods.setContractGoodsPrice(ocContractGoods.getContractGoodsMoney().divide(ocContractGoods.getGoodsNum(), 2, 5));
                this.updateContractGoodsModel(ocContractGoods);
                if (ocContractGoods.getPricesetBaseprice() == null) continue;
                basePrice = basePrice.add(ocContractGoods.getPricesetBaseprice());
            }
        }
        if (contract.getCashback() != null) {
            if (basePrice != BigDecimal.ZERO && basePrice.compareTo(contract.getContractMoney()) < 0) {
                amount = this.calBackAmount(this.getQueryMapParam("orderAmount,pricesetBaseprice", new Object[]{contract.getContractMoney(), basePrice}), contract.getTenantCode());
            }
            if (amount != null) {
                contract.setCashback(amount);
            }
        }
        this.updateContractModel(contract);
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("businessOrderno", contract.getContractBillcode());
        paramMap.put("ptradeSeqno", contract.getPtradeSeqno());
        paramMap.put("tenantCode", contract.getTenantCode());
        paramMap.put("money", contract.getContractMoney());
        paramMap.put("transferAmount", amount);
    }

    @Override
    public void loadContractMsg() throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractTypepro", "0");
        map.put("dataState", "0");
        map.put("endPayDate", DateUtil.addMinutes((Date)this.getSysDate(), (int)-1));
        List<OcContract> list = this.queryContractModelPage(map);
        for (OcContract oc : list) {
            map.clear();
            map.put("contractBillcode", oc.getContractBillcode());
            map.put("tenantCode", oc.getTenantCode());
            List<OcContractGoods> goodslist = this.queryContractGoodsModelPage(map);
            if (goodslist == null || goodslist.size() == 0) continue;
            ArrayList<OcContractGoodsDomain> goodsdomainlist = new ArrayList<OcContractGoodsDomain>();
            for (OcContractGoods goods : goodslist) {
                OcContractGoodsDomain goodsDomain = new OcContractGoodsDomain();
                try {
                    BeanUtils.copyAllPropertysNotNull((Object)goodsDomain, (Object)goods);
                }
                catch (Exception e) {
                    this.logger.error("cancle", (Object)e.getMessage());
                }
                goodsdomainlist.add(goodsDomain);
            }
            HashMap<String, Integer> pmap = new HashMap<String, Integer>();
            pmap.put("contractId", oc.getContractId());
            pmap.put("dataState", -1);
            pmap.put("oldDataState", 0);
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("map", JsonUtil.buildNormalBinder().toJson(pmap));
            paramMap.put("goodsList", JsonUtil.buildNormalBinder().toJson(goodsdomainlist));
            paramMap.put("ctype", 3);
            paramMap.put("tenantCode", oc.getTenantCode());
            paramMap.put("contractBillcode", oc.getContractBillcode());
            this.inAsyncInvoke("oc.contract.updateContractStateByCode", paramMap);
        }
    }

    private void processExtContractPackage(OcContract ocContract) {
        if (ContractPropertyEnum.VIRTUAL.getCode().equals(ocContract.getContractProperty())) {
            this.virtualContractPackage(ocContract);
        }
    }

    private void virtualContractPackage(OcContract ocContract) {
        if (ocContract == null) {
            return;
        }
        Integer num = ocContract.getGoodsNum().intValue();
        if (num <= 0) {
            return;
        }
        ConcurrentHashMap<String, String> vmap = new ConcurrentHashMap<String, String>();
        String prefix = DateUtil.getDateStr((String)"yyyyMMdd");
        ArrayList<OcPackageDomain> packageDomainList = new ArrayList<OcPackageDomain>();
        for (int i = 0; i < num; ++i) {
            OcPackageDomain packageDomain = new OcPackageDomain();
            try {
                BeanUtils.copyAllPropertys((Object)packageDomain, (Object)ocContract);
            }
            catch (Exception e) {
                this.logger.error("oc.CONTRACT.OcContractServiceImpl.virtualContractPakege", (Object)"\u5c5e\u6027\u590d\u5236\u5931\u8d25");
                throw new ApiException("oc.CONTRACT.OcContractServiceImpl.virtualContractPackage", "\u5c5e\u6027\u590d\u5236\u5931\u8d25");
            }
            packageDomain.setPackageMode(PackageModeEnum.AUTO.getCode());
            String code = this.generateRandom(vmap, ocContract.getContractBillcode());
            String packageBillno = prefix + code;
            packageDomain.setPackageBillno(packageBillno);
            Date vaildDate = DateUtil.getDateToString((String)DateUtil.getAfterDate((Date)this.getSysDate(), (int)7, (String)"yyyy-MM-dd HH:mm:ss"), (String)"yyyy-MM-dd HH:mm:ss");
            packageDomain.setGmtVaild(vaildDate);
            packageDomainList.add(packageDomain);
        }
        this.savePackageList(packageDomainList, ocContract);
    }

    private String generateRandom(Map<String, String> vmap, String tenantCode) {
        int rand;
        String code = "";
        do {
            Random r = new Random();
            rand = r.nextInt(99999999);
        } while (vmap.containsKey(code = String.format("%08d", rand)));
        List<OcPackage> list = this.queryPackageModelPage(this.getQueryParamMap("tenantCode,packageBillno", new Object[]{tenantCode, code}));
        if (!ListUtil.isEmpty(list)) {
            return this.generateRandom(vmap, tenantCode);
        }
        vmap.put(code, code);
        return code;
    }

    @Override
    public void updateExtContractPackage(String tenantCode, String contractBillcode, Integer dataState, Integer oldDataState) throws ApiException {
        OcContract ocContract = this.getContractModelByCode(this.getQueryParamMap("tenantCode,contractBillcode", new Object[]{tenantCode, contractBillcode}));
        if (ocContract == null) {
            return;
        }
        this.processExtContractPackage(ocContract);
        if (dataState == null || oldDataState == null) {
            return;
        }
        this.updateContractState(ocContract.getContractId(), dataState, oldDataState);
    }

    @Override
    public void saveContractSendGoods(Map<String, Object> map) {
        if (map == null || StringUtils.isBlank((String)((String)map.get("contractBillcode")))) {
            return;
        }
        int dataState = 8;
        ArrayList<String> skuCodes = new ArrayList<String>();
        ArrayList<BigDecimal> goodsNums = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> pricesetMakeprice = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> pricesetBaseprice = new ArrayList<BigDecimal>();
        HashMap<String, Object> pmap = new HashMap<String, Object>();
        pmap.put("contractBillcode", map.get("contractBillcode"));
        pmap.put("tenantCode", map.get("tenantCode"));
        OcContract oc = this.getContractModelByCode(pmap);
        QueryResult<OcPackage> rs = this.queryPackagePage(pmap);
        if (rs != null && rs.getList() != null) {
            for (OcPackage pack : rs.getList()) {
                for (OcContractGoods goods : pack.getContractGoodsList()) {
                    goodsNums.add(goods.getGoodsCamount());
                    skuCodes.add(goods.getGoodsCode());
                    pricesetMakeprice.add(goods.getPricesetMakeprice());
                    pricesetBaseprice.add(goods.getPricesetBaseprice());
                }
                pack.setPackageMode((String)map.get("packageMode"));
                pack.setPackageBillno((String)map.get("packageBillno"));
                pack.setPackageName((String)map.get("packageName"));
                this.updatePackageModel(pack);
            }
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("skuCodes", skuCodes);
        paramMap.put("goodsNums", goodsNums);
        paramMap.put("storeGoodsBtype", "102");
        paramMap.put("merberCode", oc.getMemberBcode());
        paramMap.put("merberName", oc.getMemberBname());
        paramMap.put("channelCodeOUT", "TS");
        paramMap.put("channelNameOUT", "\u603b\u4ed3");
        paramMap.put("channelCodeIN", oc.getChannelCode());
        paramMap.put("channelNameIN", oc.getChannelName());
        paramMap.put("merberBcode", oc.getMemberCode());
        paramMap.put("merberBname", oc.getMemberName());
        paramMap.put("pricesetMakeprice", pricesetMakeprice);
        paramMap.put("pricesetBaseprice", pricesetBaseprice);
        paramMap.put("tenantCode", oc.getTenantCode());
        pmap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        this.internalInvoke("rs.resourceGoods.updateSkuStockRecord", pmap);
        this.updateContractState(oc.getContractId(), dataState, oc.getDataState());
    }

    @Override
    public void updateContractStateToSuccess(String contractBillcode, String tenantCode) {
        if (StringUtils.isEmpty((String)contractBillcode) || StringUtils.isEmpty((String)tenantCode)) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractStateToSuccess", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        OcContract contract = this.getContractModelByCode(map);
        if (contract == null) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractStateToSuccess", (Object)"\u8ba2\u5355\u4e0d\u5b58\u5728");
            return;
        }
        this.updateStateContractModel(contract.getContractId(), 3, contract.getDataState());
    }

    @Override
    public void updateContractStateForGroupbuy(String contractNbillcode, String tenantCode, String type) {
        if (StringUtils.isEmpty((String)contractNbillcode) || StringUtils.isEmpty((String)tenantCode) || StringUtils.isEmpty((String)type)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractStateForGroupbuy.ex", "\u53c2\u6570\u4e3a\u7a7a");
        }
        List<OcContract> contractList = this.queryContractModelPage(this.getQueryMapParam("contractNbillcode,tenantCode", new Object[]{contractNbillcode, tenantCode}));
        if (ListUtil.isEmpty(contractList)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractStateForGroupbuy.ex", "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        List<OcContractGoods> contractGoodsList = this.queryContractGoodsModelPage(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractList.get(0).getContractBillcode(), tenantCode}));
        if (ListUtil.isEmpty(contractGoodsList)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractStateForGroupbuy.ex", "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        if ("success".equals(type)) {
            SkuStockDomain skuStockDomain = new SkuStockDomain();
            skuStockDomain.setTenantCode(tenantCode);
            skuStockDomain.setSkuCode(contractGoodsList.get(0).getGoodsCode());
            skuStockDomain.setGoodsNum(new BigDecimal(contractList.size()));
            skuStockDomain.setDataOpbillstate(contractGoodsList.get(0).getDataOpbillstate());
            skuStockDomain.setType("4");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("skuList", JsonUtil.buildNormalBinder().toJson(Arrays.asList(skuStockDomain)));
            this.internalInvoke("rs.sku.updateSkuStock", param);
        }
        if ("fail".equals(type)) {
            for (OcContract ocContract : contractList) {
                this.updateStateContractModel(ocContract.getContractId(), 9, ocContract.getDataState());
            }
        }
    }

    private BigDecimal calBackAmount(Map<String, Object> paramMap, String tenantCode) {
        String script = SupDisUtil.getMap((String)"DdFalgSetting-key", (String)(tenantCode + "-" + "exchange-backAmountScript"));
        if (StringUtils.isBlank((String)script)) {
            return null;
        }
        Object amount = ScriptUtil.evel((String)script, paramMap);
        if (amount == null) {
            this.logger.error("OrderMngCon.calBackAmount.error", (Object)script);
            return null;
        }
        BigDecimal backAmount = null;
        try {
            backAmount = new BigDecimal(amount.toString());
        }
        catch (Exception e) {
            this.logger.error("OrderMngCon.calBackAmount.error", (Throwable)e);
        }
        return backAmount;
    }

    @Override
    public void updatePackageUse(OcPackageDomain ocPackageDomain) {
        if (ocPackageDomain == null) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackageUse.ex", "\u8ba2\u5355\u4e0d\u5b58\u5728\uff01");
        }
        this.updatePackage(ocPackageDomain);
        this.updatePackageState(ocPackageDomain.getPackageId(), 1, 0);
        this.updateVcontractStateByPackage(ocPackageDomain.getContractBillcode(), ocPackageDomain.getTenantCode());
    }

    @Override
    public QueryResult<String> getBuyerMemberCodes(Map<String, Object> map) {
        if (CollectionUtils.isEmpty(map)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.getBuyerMemberCodes", "args is null");
        }
        List<String> memberCodes = this.queryBuyerMemberCodesPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countBuyerMerber(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(memberCodes);
        return queryResult;
    }

    private void updateVcontractStateByPackage(String contractBillcode, String tenantCode) {
        List<OcPackage> packageList = this.queryPackageModelPage(this.getQueryMapParam("contractBillcode,packageMode,tenantCode,dataState", new Object[]{contractBillcode, "AUTO", tenantCode, 0}));
        if (ListUtil.isEmpty(packageList)) {
            OcContract contract = this.getContractModelByCode(this.getQueryMapParam("contractBillcode,tenantCode", new Object[]{contractBillcode, tenantCode}));
            this.updateContractState(contract.getContractId(), 7, contract.getDataState());
        }
    }

    @Override
    public String saveContractSettl(OcContractSettlDomain ocContractSettlDomain) throws ApiException {
        OcContractSettl ocContractSettl = this.createContractsettl(ocContractSettlDomain);
        this.saveContractSettlModel(ocContractSettl);
        return ocContractSettl.getContractSettlBillcode();
    }

    private OcContractSettl createContractsettl(OcContractSettlDomain ocContractSettlDomain) {
        String msg = this.checkContractSettl(ocContractSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractSettl.checkContractSettl", msg);
        }
        OcContractSettl ocContractSettl = this.makeContractSettl(ocContractSettlDomain, null);
        this.setContractSettlDefault(ocContractSettl);
        return ocContractSettl;
    }

    @Override
    public void updateContractSettlState(Integer contractSettlId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateContractSettlModel(contractSettlId, dataState, oldDataState);
    }

    @Override
    public void updateContractSettl(OcContractSettlDomain ocContractSettlDomain) throws ApiException {
        String msg = this.checkContractSettl(ocContractSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractSettl.checkContractSettl", msg);
        }
        OcContractSettl oldOcContractSettl = this.getContractSettlModelById(ocContractSettlDomain.getContractSettlId());
        if (null == oldOcContractSettl) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractSettl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractSettl ocContractSettl = this.makeContractSettl(ocContractSettlDomain, oldOcContractSettl);
        this.setContractSettlUpdataDefault(ocContractSettl);
        this.updateContractSettlModel(ocContractSettl);
    }

    @Override
    public OcContractSettl getContractSettl(Integer contractSettlId) {
        return this.getContractSettlModelById(contractSettlId);
    }

    @Override
    public void deleteContractSettl(Integer contractSettlId) throws ApiException {
        this.deleteContractSettlModel(contractSettlId);
    }

    @Override
    public QueryResult<OcContractSettl> queryContractSettlPage(Map<String, Object> map) {
        List<OcContractSettl> ocContractSettlList = this.queryContractSettlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractSettl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractSettlList);
        return queryResult;
    }

    @Override
    public OcContractSettl getContractSettlByCode(Map<String, Object> map) {
        return this.getContractSettlModelByCode(map);
    }

    @Override
    public void delContractSettlByCode(Map<String, Object> map) throws ApiException {
        this.delContractSettlModelByCode(map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContractService getContractService() {
        Object object = lock;
        synchronized (object) {
            if (null == contractService) {
                contractService = new ContractService((OcContractEngineService)SpringApplicationContextUtil.getBean((String)"ocContractEngineService"));
                for (int i = 0; i < 200; ++i) {
                    contractService.addPollPool(new ContractPollThread(contractService));
                }
            }
            return contractService;
        }
    }

    @Override
    public void updateContractFlowState(OcContractCtrlCflowDomain ocContractCtrlCflowDomain) throws ApiException {
        if (null == ocContractCtrlCflowDomain) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", ocContractCtrlCflowDomain.getTenantCode());
        map.put("contractCtrlSeqno", ocContractCtrlCflowDomain.getContractCtrlSeqno());
        OcContractCtrl ocContractCtrl = this.ocContractCtrlService.getContractCtrlByCode(map);
        if (null == ocContractCtrl) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractFlowState.null", "\u6570\u636e\u4e3a\u7a7a" + ocContractCtrlCflowDomain.getTenantCode() + " " + ocContractCtrlCflowDomain.getContractCtrlSeqno());
        }
        HashMap<String, Object> rmap = new HashMap<String, Object>();
        if (null != ocContractCtrlCflowDomain.getContractPaygmoney()) {
            rmap.put("contractPaygmoney", ocContractCtrlCflowDomain.getContractPaygmoney());
        }
        this.updateStateContractModelByCode(ocContractCtrl.getTenantCode(), ocContractCtrl.getContractBillcode(), ocContractCtrlCflowDomain.getDataState(), ocContractCtrlCflowDomain.getOldDataState(), rmap);
        this.ocContractCtrlService.updateContractCtrlCflow(ocContractCtrlCflowDomain);
        DisUtil.set((String)("ocContract-state-" + ocContractCtrl.getContractBillcode() + ocContractCtrl.getTenantCode()), (String)String.valueOf(ocContractCtrlCflowDomain.getDataState()), (int)10);
    }

    @Override
    public void updateContractPay(String contractBillcode, String tenantCode, BigDecimal contractPaygmoney) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        map.put("contractPaygmoney", contractPaygmoney);
        this.updateContractModelPayByCode(map);
    }

    @Override
    public OcReorderDomain updatePackageExpress(PackageExpressDomain packageExpressDomain) {
        if (null == packageExpressDomain) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updatePackageExpress.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)packageExpressDomain.getPackageCode())) {
            packageExpressDomain.setOldDataState(0);
        }
        this.updateExpressStateByCodeModel(packageExpressDomain);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("packageCode", packageExpressDomain.getPackageCode());
        map.put("tenantCode", packageExpressDomain.getTenantCode());
        OcPackage ocPackage = this.getPackageModelByCode(map);
        if (null != ocPackage) {
            // empty if block
        }
        OcReorderDomain ocReorderDomain = new OcReorderDomain();
        ocReorderDomain.setOrderState("2");
        return ocReorderDomain;
    }

    @Override
    public void updateContractPtradeSeqno(Map<String, String> map) {
        if (map.get("contractBillcode") == null || map.get("ptradeSeqno") == null) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractPtradeSeqno.params", "\u53c2\u6570\u6709\u8bef");
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.putAll(map);
        OcContract ocContract = this.getContractModelByCode(parammap);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractPtradeSeqno.null", ((Object)parammap).toString());
        }
        OcContract newOcContract = new OcContract();
        newOcContract.setContractId(ocContract.getContractId());
        newOcContract.setPtradeSeqno(map.get("ptradeSeqno"));
        this.updateContractModel(newOcContract);
    }

    @Override
    public void updateContractAppraise(String contractBillcode, String tenantCode, Integer appraise) {
        if (StringUtils.hasBlank((String[])new String[]{contractBillcode, tenantCode}) || appraise == null) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.updateContractAppraise.map.null", (Object)"\u53c2\u6570\u4e3a\u7a7a");
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", contractBillcode);
        parammap.put("tenantCode", tenantCode);
        OcContract ocContract = this.getContractModelByCode(parammap);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractAppraise.null", ((Object)parammap).toString());
        }
        OcContract newOcContract = new OcContract();
        newOcContract.setContractId(ocContract.getContractId());
        newOcContract.setContractAppraise(appraise);
        this.updateContractModel(newOcContract);
    }

    @Override
    public void updateContractRefund(String tenantCode, String contractBillcode, Integer contractState) {
        if (StringUtils.isBlank((String)contractBillcode) || StringUtils.isBlank((String)tenantCode)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefund.params", "\u53c2\u6570\u6709\u8bef");
        }
        if (null == contractState) {
            contractState = 0;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        OcContract ocContract = this.getContractModelByCode(map);
        if (null == ocContract) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefund.null", "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        if (ocContract.getDataState() - contractState != 0) {
            return;
        }
        List<OcContractGoods> list = this.queryContractGoodsModelPage(map);
        if (null == list || list.isEmpty()) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.updateContractRefund.goodsnull", "\u5408\u540c\u4e0d\u5b58\u5728");
        }
        boolean flag = true;
        for (OcContractGoods ocContractGoods : list) {
            if (null == ocContractGoods.getContractGoodsRefnum()) {
                ocContractGoods.setContractGoodsRefnum(BigDecimal.ZERO);
            }
            if (ocContractGoods.getGoodsCamount().subtract(ocContractGoods.getContractGoodsRefnum()).intValue() <= 0) continue;
            flag = false;
            break;
        }
        if (flag) {
            this.getOcContractEngineService().sendContractBack(contractBillcode, tenantCode, null);
        }
    }

    @Override
    public String saveContractSettlBatch(List<OcContractSettlDomain> ocContractSettlDomainList) throws ApiException {
        if (ListUtil.isEmpty(ocContractSettlDomainList)) {
            throw new ApiException("oc.CONTRACT.OcContractServiceImpl.saveContractSettlBatch.null", "");
        }
        for (OcContractSettlDomain ocContractSettlDomain : ocContractSettlDomainList) {
            if (null != ocContractSettlDomain.getContractSettlId()) {
                this.updateContractSettl(ocContractSettlDomain);
                continue;
            }
            this.saveContractSettl(ocContractSettlDomain);
        }
        return "";
    }

    @Override
    public List<OcContractSettl> queryContractSettlByContractCode(String tenantCode, String contractBillcode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("contractBillcode", contractBillcode);
        parammap.put("tenantCode", tenantCode);
        return this.queryContractSettlModelPage(parammap);
    }

    @Override
    public void updateContractBlance(String contractBillcode, String tenantCode, String contractBlance) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractBillcode", contractBillcode);
        map.put("contractBlance", contractBlance);
        this.updateContractModelBlanceByCode(map);
    }

    @Override
    public void updateContractInvstate(String contractBillcode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateInvstateContractModel(tenantCode, contractBillcode, dataState, oldDataState);
    }

    @Override
    public void updateContractShowstate(String contractBillcode, String tenantCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateShowstateContractModel(tenantCode, contractBillcode, dataState, oldDataState);
    }

    @Override
    public void updateContractEcflagstate(String contractBillcode, String tenantCode, String contractEcurl, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateEcflagstateContractModel(tenantCode, contractBillcode, contractEcurl, dataState, oldDataState);
    }

    private Integer getEcflagStateByCode(String contractBillcode, String tenantCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractBillcode", contractBillcode);
        map.put("tenantCode", tenantCode);
        int res = 0;
        try {
            res = this.ocContractMapper.getEcflagStateByCode(map);
        }
        catch (Exception ex) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getEcflagStateByCode" + map);
            return -1;
        }
        return res;
    }

    @Override
    public Integer getStateByContractBillcode(String contractBillcode, String tenantCode) throws ApiException {
        return this.getEcflagStateByCode(contractBillcode, tenantCode);
    }

    @Override
    public Map<String, Object> syncOrderService(String orderStr) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        this.logger.error("syncOrderService ==== ", (Object)orderStr);
        return resultMap;
    }

    @Override
    public String updateSendNum(List<GoodsSendNumBean> goodsSendNumBeanList) {
        if (ListUtil.isEmpty(goodsSendNumBeanList)) {
            return "error";
        }
        for (GoodsSendNumBean goodsSendNumBean : goodsSendNumBeanList) {
            this.updateSendContractModel(goodsSendNumBean.getTenantCode(), goodsSendNumBean.getContractBillcode(), goodsSendNumBean.getContractGoodsSendnum(), goodsSendNumBean.getContractGoodsSendweight());
            this.updateSendContractGoodsModel(goodsSendNumBean.getTenantCode(), goodsSendNumBean.getContractGoodsCode(), 1, null, goodsSendNumBean.getContractGoodsSendnum(), goodsSendNumBean.getContractGoodsSendweight());
        }
        return "success";
    }

    @Override
    public List<OcContractGoods> queryCorderGoodsByBillcode(Map<String, Object> map) throws ApiException {
        List<OcContractGoods> ocContractGoods = this.ocContractGoodsMapper.queryCorderGoodsByBillcode(map);
        if (ocContractGoods.size() == 0) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.queryCorderGoodsByBillcode===" + map);
            return null;
        }
        return ocContractGoods;
    }

    @Override
    public String getOrderFreight(String tenantCode, String sku, String area) throws ApiException {
        String str = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("sku", sku);
        map.put("area", area);
        map.put("tenantCode", tenantCode);
        try {
            str = (String)this.getInternalRouter().inInvoke(" omns.jd.getFreight", map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getOrderFreight", (Object)((Object)map).toString());
        }
        return str;
    }

    @Override
    public String getBalance(String payType) throws ApiException {
        String str = "";
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("payType", payType);
        try {
            str = (String)this.getInternalRouter().inInvoke("omns.jd.getBalance", map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getBalance", (Object)((Object)map).toString());
        }
        return str;
    }

    @Override
    public QueryResult<Map<String, Object>> getBalanceDetail(Map<String, Object> map) throws ApiException {
        QueryResult retList = null;
        if (null == map) {
            return null;
        }
        String str = "";
        try {
            str = (String)this.getInternalRouter().inInvoke("omns.jd.getBalanceDetail", map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractServiceImpl.getBalanceDetail", (Object)map.toString());
        }
        if (StringUtils.isBlank((String)str)) {
            return null;
        }
        Map dataStateMap = (Map)JsonUtil.buildNormalBinder().getJsonToMap(str, String.class, Object.class);
        if (null == dataStateMap) {
            return null;
        }
        String successs = (String)dataStateMap.get("success");
        if (StringUtils.isNotBlank((String)successs) && successs.equals("true")) {
            String reJson = (String)dataStateMap.get("ReJson");
            if (null == reJson) {
                return null;
            }
            Map map1 = (Map)JsonUtil.buildNormalBinder().getJsonToMap(reJson, String.class, Object.class);
            if (null == map1) {
                return null;
            }
            int total = (Integer)map1.get("total");
            String data = (String)map1.get("data");
            if (StringUtils.isBlank((String)data)) {
                return null;
            }
            List mapList = (List)JsonUtil.buildNormalBinder().getJsonToList(data, Map.class);
            if (null == mapList) {
                return null;
            }
            retList = new QueryResult();
            retList.setTotal((long)total);
            PageTools pageTools = new PageTools();
            pageTools.setRecordCount(total);
            retList.setPageTools((SupPageTools)pageTools);
            retList.setList(mapList);
            retList.setRows(mapList);
        }
        return retList;
    }

    @Override
    public void updateContracStateByNb(String contractNbillcode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        this.updateStateContractModelByNb(tenantCode, contractNbillcode, dataState, oldDataState, map);
    }

    @Override
    public OcContract getByNbCode(String contractNbillcode, String channelCode, String tenantCode) {
        return this.getModelByNbCode(this.getQueryMapParam("contractNbillcode,channelCode,tenantCode", new Object[]{contractNbillcode, channelCode, tenantCode}));
    }

    static {
        lock = new Object();
    }
}

