/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRegularMapper;
import com.yqbsoft.laser.service.contract.domain.OcRegularDomain;
import com.yqbsoft.laser.service.contract.domain.OcRegularReDomain;
import com.yqbsoft.laser.service.contract.model.OcRegular;
import com.yqbsoft.laser.service.contract.service.OcRegularService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRegularServiceImpl
extends BaseServiceImpl
implements OcRegularService {
    private static final String SYS_CODE = "oc.CONTRACT.OcRegularServiceImpl";
    private OcRegularMapper ocRegularMapper;

    public void setOcRegularMapper(OcRegularMapper ocRegularMapper) {
        this.ocRegularMapper = ocRegularMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRegularMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkregular(OcRegularDomain ocRegularDomain) {
        if (null == ocRegularDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRegularDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setregularDefault(OcRegular ocRegular) {
        if (null == ocRegular) {
            return;
        }
        if (null == ocRegular.getDataState()) {
            ocRegular.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocRegular.getGmtCreate()) {
            ocRegular.setGmtCreate(date);
        }
        ocRegular.setGmtModified(date);
        if (StringUtils.isBlank((String)ocRegular.getRegularCode())) {
            ocRegular.setRegularCode(this.getNo(null, "OcRegular", "ocRegular", ocRegular.getTenantCode()));
        }
    }

    private int getregularMaxCode() {
        int code = 0;
        try {
            return this.ocRegularMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getregularMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setregularUpdataDefault(OcRegular ocRegular) {
        if (null == ocRegular) {
            return;
        }
        ocRegular.setGmtModified(this.getSysDate());
    }

    private void saveregularModel(OcRegular ocRegular) throws ApiException {
        if (null == ocRegular) {
            return;
        }
        try {
            this.ocRegularMapper.insert(ocRegular);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.saveregularModel.ex", (Throwable)e);
        }
    }

    private void saveregularBatchModel(List<OcRegular> ocRegularList) throws ApiException {
        if (null == ocRegularList || ocRegularList.isEmpty()) {
            return;
        }
        try {
            this.ocRegularMapper.insertBatch(ocRegularList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.saveregularBatchModel.ex", (Throwable)e);
        }
    }

    private OcRegular getregularModelById(Integer regularId) {
        if (null == regularId) {
            return null;
        }
        try {
            return this.ocRegularMapper.selectByPrimaryKey(regularId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getregularModelById", (Throwable)e);
            return null;
        }
    }

    private OcRegular getregularModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRegularMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.getregularModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delregularModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRegularMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.delregularModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.delregularModelByCode.num");
        }
    }

    private void deleteregularModel(Integer regularId) throws ApiException {
        if (null == regularId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRegularMapper.deleteByPrimaryKey(regularId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.deleteregularModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.deleteregularModel.num");
        }
    }

    private void updateregularModel(OcRegular ocRegular) throws ApiException {
        if (null == ocRegular) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRegularMapper.updateByPrimaryKey(ocRegular);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateregularModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateregularModel.num");
        }
    }

    private void updateStateregularModel(Integer regularId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == regularId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("regularId", regularId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocRegularMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateregularModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateregularModel.null");
        }
    }

    private void updateStateregularModelByCode(String tenantCode, String regularcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)regularcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regularcode", regularcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocRegularMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateregularModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateStateregularModelByCode.null");
        }
    }

    private OcRegular makeregular(OcRegularDomain ocRegularDomain, OcRegular ocRegular) {
        if (null == ocRegularDomain) {
            return null;
        }
        if (null == ocRegular) {
            ocRegular = new OcRegular();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRegular, (Object)ocRegularDomain);
            return ocRegular;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.makeregular", (Throwable)e);
            return null;
        }
    }

    private OcRegularReDomain makeOcRegularReDomain(OcRegular ocRegular) {
        if (null == ocRegular) {
            return null;
        }
        OcRegularReDomain ocRegularReDomain = new OcRegularReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRegularReDomain, (Object)ocRegular);
            return ocRegularReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.makeOcRegularReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcRegular> queryregularModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRegularMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.queryregularModel", (Throwable)e);
            return null;
        }
    }

    private int countregular(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRegularMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRegularServiceImpl.countregular", (Throwable)e);
        }
        return i;
    }

    private OcRegular createOcRegular(OcRegularDomain ocRegularDomain) {
        String msg = this.checkregular(ocRegularDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.saveregular.checkregular", msg);
        }
        OcRegular ocRegular = this.makeregular(ocRegularDomain, null);
        this.setregularDefault(ocRegular);
        return ocRegular;
    }

    @Override
    public String saveregular(OcRegularDomain ocRegularDomain) throws ApiException {
        OcRegular ocRegular = this.createOcRegular(ocRegularDomain);
        this.saveregularModel(ocRegular);
        return ocRegular.getRegularCode();
    }

    @Override
    public String saveregularBatch(List<OcRegularDomain> ocRegularDomainList) throws ApiException {
        if (null == ocRegularDomainList || ocRegularDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcRegular> ocRegularList = new ArrayList<OcRegular>();
        String code = "";
        for (OcRegularDomain ocRegularDomain : ocRegularDomainList) {
            OcRegular ocRegular = this.createOcRegular(ocRegularDomain);
            code = ocRegular.getRegularCode();
            ocRegularList.add(ocRegular);
        }
        this.saveregularBatchModel(ocRegularList);
        return code;
    }

    @Override
    public void updateregularState(Integer regularId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == regularId) {
            return;
        }
        this.updateStateregularModel(regularId, dataState, oldDataState, map);
    }

    @Override
    public void updateregularStateByCode(String tenantCode, String regularcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)regularcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateregularModelByCode(tenantCode, regularcode, dataState, oldDataState, map);
    }

    @Override
    public void updateregular(OcRegularDomain ocRegularDomain) throws ApiException {
        String msg = this.checkregular(ocRegularDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateregular.checkregular", msg);
        }
        OcRegular oldOcRegular = this.getregularModelById(ocRegularDomain.getRegularId());
        if (null == oldOcRegular) {
            throw new ApiException("oc.CONTRACT.OcRegularServiceImpl.updateregular.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRegular ocRegular = this.makeregular(ocRegularDomain, oldOcRegular);
        this.setregularUpdataDefault(ocRegular);
        this.updateregularModel(ocRegular);
    }

    @Override
    public OcRegular getregular(Integer regularId) {
        if (null == regularId) {
            return null;
        }
        return this.getregularModelById(regularId);
    }

    @Override
    public void deleteregular(Integer regularId) throws ApiException {
        if (null == regularId) {
            return;
        }
        this.deleteregularModel(regularId);
    }

    @Override
    public QueryResult<OcRegular> queryregularPage(Map<String, Object> map) {
        List<OcRegular> ocRegularList = this.queryregularModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countregular(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRegularList);
        return queryResult;
    }

    @Override
    public OcRegular getregularByCode(String tenantCode, String regularcode) throws ApiException {
        if (StringUtils.isBlank((String)regularcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regularcode", regularcode);
        return this.getregularModelByCode(map);
    }

    @Override
    public void deleteregularByCode(String tenantCode, String regularcode) throws ApiException {
        if (StringUtils.isBlank((String)regularcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("regularcode", regularcode);
        this.delregularModelByCode(map);
    }
}

