/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRefundPmGoodsMapper;
import com.yqbsoft.laser.service.contract.domain.OcRefundPmGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundPmGoodsReDomain;
import com.yqbsoft.laser.service.contract.model.OcRefundPmGoods;
import com.yqbsoft.laser.service.contract.service.OcRefundPmGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRefundPmGoodsServiceImpl
extends BaseServiceImpl
implements OcRefundPmGoodsService {
    private static final String SYS_CODE = "oc.CONTRACT.OcRefundPmGoodsServiceImpl";
    private OcRefundPmGoodsMapper ocRefundPmGoodsMapper;

    public void setOcRefundPmGoodsMapper(OcRefundPmGoodsMapper ocRefundPmGoodsMapper) {
        this.ocRefundPmGoodsMapper = ocRefundPmGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRefundPmGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundPmGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRefundPmGoods(OcRefundPmGoodsDomain ocRefundPmGoodsDomain) {
        if (null == ocRefundPmGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundPmGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRefundPmGoodsDefault(OcRefundPmGoods ocRefundPmGoods) {
        if (null == ocRefundPmGoods) {
            return;
        }
        if (null == ocRefundPmGoods.getDataState()) {
            ocRefundPmGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocRefundPmGoods.getGmtCreate()) {
            ocRefundPmGoods.setGmtCreate(date);
        }
        ocRefundPmGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)ocRefundPmGoods.getRefundPmgoodsBillcode())) {
            ocRefundPmGoods.setRefundPmgoodsBillcode(this.getNo(null, "OcRefundPmGoods", "ocRefundPmGoods", ocRefundPmGoods.getTenantCode()));
        }
    }

    private int getRefundPmGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocRefundPmGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundPmGoodsServiceImpl.getRefundPmGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRefundPmGoodsUpdataDefault(OcRefundPmGoods ocRefundPmGoods) {
        if (null == ocRefundPmGoods) {
            return;
        }
        ocRefundPmGoods.setGmtModified(this.getSysDate());
    }

    private void saveRefundPmGoodsModel(OcRefundPmGoods ocRefundPmGoods) throws ApiException {
        if (null == ocRefundPmGoods) {
            return;
        }
        try {
            this.ocRefundPmGoodsMapper.insert(ocRefundPmGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.saveRefundPmGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveRefundPmGoodsBatchModel(List<OcRefundPmGoods> ocRefundPmGoodsList) throws ApiException {
        if (null == ocRefundPmGoodsList || ocRefundPmGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ocRefundPmGoodsMapper.insertBatch(ocRefundPmGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.saveRefundPmGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private OcRefundPmGoods getRefundPmGoodsModelById(Integer refundPmgoodsId) {
        if (null == refundPmgoodsId) {
            return null;
        }
        try {
            return this.ocRefundPmGoodsMapper.selectByPrimaryKey(refundPmgoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundPmGoodsServiceImpl.getRefundPmGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private OcRefundPmGoods getRefundPmGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRefundPmGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundPmGoodsServiceImpl.getRefundPmGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRefundPmGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundPmGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.delRefundPmGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.delRefundPmGoodsModelByCode.num");
        }
    }

    private void deleteRefundPmGoodsModel(Integer refundPmgoodsId) throws ApiException {
        if (null == refundPmgoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundPmGoodsMapper.deleteByPrimaryKey(refundPmgoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.deleteRefundPmGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.deleteRefundPmGoodsModel.num");
        }
    }

    private void updateRefundPmGoodsModel(OcRefundPmGoods ocRefundPmGoods) throws ApiException {
        if (null == ocRefundPmGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundPmGoodsMapper.updateByPrimaryKey(ocRefundPmGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.updateRefundPmGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.updateRefundPmGoodsModel.num");
        }
    }

    private void updateStateRefundPmGoodsModel(Integer refundPmgoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == refundPmgoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundPmgoodsId", refundPmgoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocRefundPmGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.updateStateRefundPmGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.updateStateRefundPmGoodsModel.null");
        }
    }

    private void updateStateRefundPmGoodsModelByCode(String tenantCode, String refundPmgoodsBillcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)refundPmgoodsBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("refundPmgoodsBillcode", refundPmgoodsBillcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocRefundPmGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.updateStateRefundPmGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.updateStateRefundPmGoodsModelByCode.null");
        }
    }

    private OcRefundPmGoods makeRefundPmGoods(OcRefundPmGoodsDomain ocRefundPmGoodsDomain, OcRefundPmGoods ocRefundPmGoods) {
        if (null == ocRefundPmGoodsDomain) {
            return null;
        }
        if (null == ocRefundPmGoods) {
            ocRefundPmGoods = new OcRefundPmGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundPmGoods, (Object)ocRefundPmGoodsDomain);
            return ocRefundPmGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundPmGoodsServiceImpl.makeRefundPmGoods", (Throwable)e);
            return null;
        }
    }

    private OcRefundPmGoodsReDomain makeOcRefundPmGoodsReDomain(OcRefundPmGoods ocRefundPmGoods) {
        if (null == ocRefundPmGoods) {
            return null;
        }
        OcRefundPmGoodsReDomain ocRefundPmGoodsReDomain = new OcRefundPmGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundPmGoodsReDomain, (Object)ocRefundPmGoods);
            return ocRefundPmGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundPmGoodsServiceImpl.makeOcRefundPmGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcRefundPmGoods> queryRefundPmGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRefundPmGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundPmGoodsServiceImpl.queryRefundPmGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countRefundPmGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRefundPmGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundPmGoodsServiceImpl.countRefundPmGoods", (Throwable)e);
        }
        return i;
    }

    private OcRefundPmGoods createOcRefundPmGoods(OcRefundPmGoodsDomain ocRefundPmGoodsDomain) {
        String msg = this.checkRefundPmGoods(ocRefundPmGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.saveRefundPmGoods.checkRefundPmGoods", msg);
        }
        OcRefundPmGoods ocRefundPmGoods = this.makeRefundPmGoods(ocRefundPmGoodsDomain, null);
        this.setRefundPmGoodsDefault(ocRefundPmGoods);
        return ocRefundPmGoods;
    }

    @Override
    public String saveRefundPmGoods(OcRefundPmGoodsDomain ocRefundPmGoodsDomain) throws ApiException {
        OcRefundPmGoods ocRefundPmGoods = this.createOcRefundPmGoods(ocRefundPmGoodsDomain);
        this.saveRefundPmGoodsModel(ocRefundPmGoods);
        return ocRefundPmGoods.getRefundPmgoodsBillcode();
    }

    @Override
    public String saveRefundPmGoodsBatch(List<OcRefundPmGoodsDomain> ocRefundPmGoodsDomainList) throws ApiException {
        if (null == ocRefundPmGoodsDomainList || ocRefundPmGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcRefundPmGoods> ocRefundPmGoodsList = new ArrayList<OcRefundPmGoods>();
        String code = "";
        for (OcRefundPmGoodsDomain ocRefundPmGoodsDomain : ocRefundPmGoodsDomainList) {
            OcRefundPmGoods ocRefundPmGoods = this.createOcRefundPmGoods(ocRefundPmGoodsDomain);
            code = ocRefundPmGoods.getRefundPmgoodsBillcode();
            ocRefundPmGoodsList.add(ocRefundPmGoods);
        }
        this.saveRefundPmGoodsBatchModel(ocRefundPmGoodsList);
        return code;
    }

    @Override
    public void updateRefundPmGoodsState(Integer refundPmgoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == refundPmgoodsId) {
            return;
        }
        this.updateStateRefundPmGoodsModel(refundPmgoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateRefundPmGoodsStateByCode(String tenantCode, String refundPmgoodsBillcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)refundPmgoodsBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRefundPmGoodsModelByCode(tenantCode, refundPmgoodsBillcode, dataState, oldDataState, map);
    }

    @Override
    public void updateRefundPmGoods(OcRefundPmGoodsDomain ocRefundPmGoodsDomain) throws ApiException {
        String msg = this.checkRefundPmGoods(ocRefundPmGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.updateRefundPmGoods.checkRefundPmGoods", msg);
        }
        OcRefundPmGoods oldOcRefundPmGoods = this.getRefundPmGoodsModelById(ocRefundPmGoodsDomain.getRefundPmgoodsId());
        if (null == oldOcRefundPmGoods) {
            throw new ApiException("oc.CONTRACT.OcRefundPmGoodsServiceImpl.updateRefundPmGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRefundPmGoods ocRefundPmGoods = this.makeRefundPmGoods(ocRefundPmGoodsDomain, oldOcRefundPmGoods);
        this.setRefundPmGoodsUpdataDefault(ocRefundPmGoods);
        this.updateRefundPmGoodsModel(ocRefundPmGoods);
    }

    @Override
    public OcRefundPmGoods getRefundPmGoods(Integer refundPmgoodsId) {
        if (null == refundPmgoodsId) {
            return null;
        }
        return this.getRefundPmGoodsModelById(refundPmgoodsId);
    }

    @Override
    public void deleteRefundPmGoods(Integer refundPmgoodsId) throws ApiException {
        if (null == refundPmgoodsId) {
            return;
        }
        this.deleteRefundPmGoodsModel(refundPmgoodsId);
    }

    @Override
    public QueryResult<OcRefundPmGoods> queryRefundPmGoodsPage(Map<String, Object> map) {
        List<OcRefundPmGoods> ocRefundPmGoodsList = this.queryRefundPmGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefundPmGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundPmGoodsList);
        return queryResult;
    }

    @Override
    public OcRefundPmGoods getRefundPmGoodsByCode(String tenantCode, String refundPmgoodsBillcode) throws ApiException {
        if (StringUtils.isBlank((String)refundPmgoodsBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("refundPmgoodsBillcode", refundPmgoodsBillcode);
        return this.getRefundPmGoodsModelByCode(map);
    }

    @Override
    public void deleteRefundPmGoodsByCode(String tenantCode, String refundPmgoodsBillcode) throws ApiException {
        if (StringUtils.isBlank((String)refundPmgoodsBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("refundPmgoodsBillcode", refundPmgoodsBillcode);
        this.delRefundPmGoodsModelByCode(map);
    }
}

