/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcContractPmGoodsMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractPmGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractPmGoodsReDomain;
import com.yqbsoft.laser.service.contract.model.OcContractPmGoods;
import com.yqbsoft.laser.service.contract.service.OcContractPmGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractPmGoodsServiceImpl
extends BaseServiceImpl
implements OcContractPmGoodsService {
    private static final String SYS_CODE = "oc.CONTRACT.OcContractPmGoodsServiceImpl";
    private OcContractPmGoodsMapper ocContractPmGoodsMapper;

    public void setOcContractPmGoodsMapper(OcContractPmGoodsMapper ocContractPmGoodsMapper) {
        this.ocContractPmGoodsMapper = ocContractPmGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocContractPmGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractPmGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContractPmGoods(OcContractPmGoodsDomain ocContractPmGoodsDomain) {
        if (null == ocContractPmGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractPmGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractPmGoodsDefault(OcContractPmGoods ocContractPmGoods) {
        if (null == ocContractPmGoods) {
            return;
        }
        if (null == ocContractPmGoods.getDataState()) {
            ocContractPmGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == ocContractPmGoods.getGmtCreate()) {
            ocContractPmGoods.setGmtCreate(date);
        }
        ocContractPmGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)ocContractPmGoods.getContractPmgoodsBillcode())) {
            ocContractPmGoods.setContractPmgoodsBillcode(this.getNo(null, "OcContractPmGoods", "ocContractPmGoods", ocContractPmGoods.getTenantCode()));
        }
    }

    private int getContractPmGoodsMaxCode() {
        int code = 0;
        try {
            return this.ocContractPmGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractPmGoodsServiceImpl.getContractPmGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractPmGoodsUpdataDefault(OcContractPmGoods ocContractPmGoods) {
        if (null == ocContractPmGoods) {
            return;
        }
        ocContractPmGoods.setGmtModified(this.getSysDate());
    }

    private void saveContractPmGoodsModel(OcContractPmGoods ocContractPmGoods) throws ApiException {
        if (null == ocContractPmGoods) {
            return;
        }
        try {
            this.ocContractPmGoodsMapper.insert(ocContractPmGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.saveContractPmGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveContractPmGoodsBatchModel(List<OcContractPmGoods> ocContractPmGoodsList) throws ApiException {
        if (null == ocContractPmGoodsList || ocContractPmGoodsList.isEmpty()) {
            return;
        }
        try {
            this.ocContractPmGoodsMapper.insertBatch(ocContractPmGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.saveContractPmGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractPmGoods getContractPmGoodsModelById(Integer contractPmgoodsId) {
        if (null == contractPmgoodsId) {
            return null;
        }
        try {
            return this.ocContractPmGoodsMapper.selectByPrimaryKey(contractPmgoodsId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractPmGoodsServiceImpl.getContractPmGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private OcContractPmGoods getContractPmGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractPmGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractPmGoodsServiceImpl.getContractPmGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractPmGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractPmGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.delContractPmGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.delContractPmGoodsModelByCode.num");
        }
    }

    private void deleteContractPmGoodsModel(Integer contractPmgoodsId) throws ApiException {
        if (null == contractPmgoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractPmGoodsMapper.deleteByPrimaryKey(contractPmgoodsId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.deleteContractPmGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.deleteContractPmGoodsModel.num");
        }
    }

    private void updateContractPmGoodsModel(OcContractPmGoods ocContractPmGoods) throws ApiException {
        if (null == ocContractPmGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractPmGoodsMapper.updateByPrimaryKey(ocContractPmGoods);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.updateContractPmGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.updateContractPmGoodsModel.num");
        }
    }

    private void updateStateContractPmGoodsModel(Integer contractPmgoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == contractPmgoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractPmgoodsId", contractPmgoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractPmGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.updateStateContractPmGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.updateStateContractPmGoodsModel.null");
        }
    }

    private void updateStateContractPmGoodsModelByCode(String tenantCode, String contractPmgoodsBillcode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)contractPmgoodsBillcode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractPmgoodsBillcode", contractPmgoodsBillcode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractPmGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.updateStateContractPmGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.updateStateContractPmGoodsModelByCode.null");
        }
    }

    private OcContractPmGoods makeContractPmGoods(OcContractPmGoodsDomain ocContractPmGoodsDomain, OcContractPmGoods ocContractPmGoods) {
        if (null == ocContractPmGoodsDomain) {
            return null;
        }
        if (null == ocContractPmGoods) {
            ocContractPmGoods = new OcContractPmGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractPmGoods, (Object)ocContractPmGoodsDomain);
            return ocContractPmGoods;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractPmGoodsServiceImpl.makeContractPmGoods", (Throwable)e);
            return null;
        }
    }

    private OcContractPmGoodsReDomain makeOcContractPmGoodsReDomain(OcContractPmGoods ocContractPmGoods) {
        if (null == ocContractPmGoods) {
            return null;
        }
        OcContractPmGoodsReDomain ocContractPmGoodsReDomain = new OcContractPmGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractPmGoodsReDomain, (Object)ocContractPmGoods);
            return ocContractPmGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractPmGoodsServiceImpl.makeOcContractPmGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractPmGoods> queryContractPmGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractPmGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractPmGoodsServiceImpl.queryContractPmGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countContractPmGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractPmGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractPmGoodsServiceImpl.countContractPmGoods", (Throwable)e);
        }
        return i;
    }

    private OcContractPmGoods createOcContractPmGoods(OcContractPmGoodsDomain ocContractPmGoodsDomain) {
        String msg = this.checkContractPmGoods(ocContractPmGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.saveContractPmGoods.checkContractPmGoods", msg);
        }
        OcContractPmGoods ocContractPmGoods = this.makeContractPmGoods(ocContractPmGoodsDomain, null);
        this.setContractPmGoodsDefault(ocContractPmGoods);
        return ocContractPmGoods;
    }

    @Override
    public String saveContractPmGoods(OcContractPmGoodsDomain ocContractPmGoodsDomain) throws ApiException {
        OcContractPmGoods ocContractPmGoods = this.createOcContractPmGoods(ocContractPmGoodsDomain);
        this.saveContractPmGoodsModel(ocContractPmGoods);
        return ocContractPmGoods.getContractPmgoodsBillcode();
    }

    @Override
    public String saveContractPmGoodsBatch(List<OcContractPmGoodsDomain> ocContractPmGoodsDomainList) throws ApiException {
        if (null == ocContractPmGoodsDomainList || ocContractPmGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractPmGoods> ocContractPmGoodsList = new ArrayList<OcContractPmGoods>();
        String code = "";
        for (OcContractPmGoodsDomain ocContractPmGoodsDomain : ocContractPmGoodsDomainList) {
            OcContractPmGoods ocContractPmGoods = this.createOcContractPmGoods(ocContractPmGoodsDomain);
            code = ocContractPmGoods.getContractPmgoodsBillcode();
            ocContractPmGoodsList.add(ocContractPmGoods);
        }
        this.saveContractPmGoodsBatchModel(ocContractPmGoodsList);
        return code;
    }

    @Override
    public void updateContractPmGoodsState(Integer contractPmgoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == contractPmgoodsId) {
            return;
        }
        this.updateStateContractPmGoodsModel(contractPmgoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractPmGoodsStateByCode(String tenantCode, String contractPmgoodsBillcode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)contractPmgoodsBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContractPmGoodsModelByCode(tenantCode, contractPmgoodsBillcode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractPmGoods(OcContractPmGoodsDomain ocContractPmGoodsDomain) throws ApiException {
        String msg = this.checkContractPmGoods(ocContractPmGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.updateContractPmGoods.checkContractPmGoods", msg);
        }
        OcContractPmGoods oldOcContractPmGoods = this.getContractPmGoodsModelById(ocContractPmGoodsDomain.getContractPmgoodsId());
        if (null == oldOcContractPmGoods) {
            throw new ApiException("oc.CONTRACT.OcContractPmGoodsServiceImpl.updateContractPmGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractPmGoods ocContractPmGoods = this.makeContractPmGoods(ocContractPmGoodsDomain, oldOcContractPmGoods);
        this.setContractPmGoodsUpdataDefault(ocContractPmGoods);
        this.updateContractPmGoodsModel(ocContractPmGoods);
    }

    @Override
    public OcContractPmGoods getContractPmGoods(Integer contractPmgoodsId) {
        if (null == contractPmgoodsId) {
            return null;
        }
        return this.getContractPmGoodsModelById(contractPmgoodsId);
    }

    @Override
    public void deleteContractPmGoods(Integer contractPmgoodsId) throws ApiException {
        if (null == contractPmgoodsId) {
            return;
        }
        this.deleteContractPmGoodsModel(contractPmgoodsId);
    }

    @Override
    public QueryResult<OcContractPmGoods> queryContractPmGoodsPage(Map<String, Object> map) {
        List<OcContractPmGoods> ocContractPmGoodsList = this.queryContractPmGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractPmGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractPmGoodsList);
        return queryResult;
    }

    @Override
    public OcContractPmGoods getContractPmGoodsByCode(String tenantCode, String contractPmgoodsBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractPmgoodsBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractPmgoodsBillcode", contractPmgoodsBillcode);
        return this.getContractPmGoodsModelByCode(map);
    }

    @Override
    public void deleteContractPmGoodsByCode(String tenantCode, String contractPmgoodsBillcode) throws ApiException {
        if (StringUtils.isBlank((String)contractPmgoodsBillcode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("contractPmgoodsBillcode", contractPmgoodsBillcode);
        this.delContractPmGoodsModelByCode(map);
    }
}

