/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.domain.GoodsSendNumBean;
import com.yqbsoft.laser.service.contract.domain.OcContractDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcRecflowPprocessDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundGoodsDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundReDomain;
import com.yqbsoft.laser.service.contract.model.OcRecflowPprocess;
import com.yqbsoft.laser.service.contract.model.OcRefund;
import com.yqbsoft.laser.service.contract.model.OcRefundGoods;
import com.yqbsoft.laser.service.contract.model.OcSendcontractData;
import com.yqbsoft.laser.service.contract.refundes.PprocessModelPutThread;
import com.yqbsoft.laser.service.contract.refundes.PprocessPollThread;
import com.yqbsoft.laser.service.contract.refundes.PprocessPutThread;
import com.yqbsoft.laser.service.contract.refundes.PprocessService;
import com.yqbsoft.laser.service.contract.refundes.RefundDomainPutThread;
import com.yqbsoft.laser.service.contract.service.OcRecflowPprocessService;
import com.yqbsoft.laser.service.contract.service.OcRefundEngineService;
import com.yqbsoft.laser.service.contract.service.OcRefundFlowEngineService;
import com.yqbsoft.laser.service.contract.service.OcRefundService;
import com.yqbsoft.laser.service.contract.service.impl.OcRefundCtrlServiceImpl;
import com.yqbsoft.laser.service.contract.service.impl.OcRefundServiceImpl;
import com.yqbsoft.laser.service.contract.service.impl.OcSendcontractDataServiceImpl;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.spring.SpringApplicationContextUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRefundEngineServiceImpl
extends BaseServiceImpl
implements OcRefundEngineService {
    public static final String SYS_CODE = "oc.CONTRACT.OcRefundEngineServiceImpl";
    private static PprocessService pprocessService;
    private static Object lock;
    private OcRefundFlowEngineService ocRefundFlowEngineService;
    private OcRecflowPprocessService ocRecflowPprocessService;
    OcRefundService ocRefundService;

    public void setOcRefundService(OcRefundService ocRefundService) {
        this.ocRefundService = ocRefundService;
    }

    public OcRecflowPprocessService getOcRecflowPprocessService() {
        return this.ocRecflowPprocessService;
    }

    public void setOcRecflowPprocessService(OcRecflowPprocessService ocRecflowPprocessService) {
        this.ocRecflowPprocessService = ocRecflowPprocessService;
    }

    public OcRefundFlowEngineService getOcRefundFlowEngineService() {
        return this.ocRefundFlowEngineService;
    }

    public void setOcRefundFlowEngineService(OcRefundFlowEngineService ocRefundFlowEngineService) {
        this.ocRefundFlowEngineService = ocRefundFlowEngineService;
    }

    @Override
    public void sendRefundEngineStart(OcRefundDomain ocRefundDomain) {
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundEngineStart(ocRefundDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        } else {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendRefundEngineStart.pprocessList", (Object)(ocRefundDomain.getRefundCode() + "=" + ocRefundDomain.getTenantCode()));
        }
    }

    @Override
    public void sendRefundNext(String refundCode, String tenantCode, Map<String, Object> map) {
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundNext(refundCode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    @Override
    public String sendContracPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (null == dataState || dataState != 3) {
            return "success";
        }
        this.sendRefundNext(refundCode, tenantCode, null);
        return "success";
    }

    @Override
    public String sendContracSubPay(String businessOrder, String businessOrderno, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (null == dataState || dataState != 3) {
            return "success";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("contractSubCode", businessOrderno);
        this.sendRefundNext(businessOrder, tenantCode, map);
        return "success";
    }

    @Override
    public String sendContracBatchPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        if (null == dataState || dataState != 3) {
            return "success";
        }
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundBatchNext(refundCode, tenantCode, null);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
        return "success";
    }

    @Override
    public String sendSaveRefundPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return "error";
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("payDataState", dataState);
        map.put("ptradeSeqno", ptradeSeqno);
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundBatchNext(refundCode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
        return "success";
    }

    @Override
    public void sendRefundBack(String refundCode, String tenantCode, Map<String, Object> map) {
        if (StringUtils.isBlank((String)refundCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveRefundBack(refundCode, tenantCode, map);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    @Override
    public void sendFlowNode(OcRecflowPprocessDomain ocRecflowPprocessDomain) {
        List<OcRecflowPprocessDomain> pprocessList = this.ocRefundFlowEngineService.saveFlowNode(ocRecflowPprocessDomain);
        if (null != pprocessList && !pprocessList.isEmpty()) {
            this.getPprocessService().addPutPool(new PprocessPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), pprocessList));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PprocessService getPprocessService() {
        Object object = lock;
        synchronized (object) {
            if (null == pprocessService) {
                pprocessService = new PprocessService((OcRefundEngineService)SpringApplicationContextUtil.getBean((String)"ocRefundEngineService"));
                for (int i = 0; i < 20; ++i) {
                    pprocessService.addPollPool(new PprocessPollThread(pprocessService));
                }
            }
            return pprocessService;
        }
    }

    @Override
    public void queryPprocessLoadDb() {
        this.loadDb();
    }

    private void loadDb() {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("dataState", "0");
            map.put("order", true);
            map.put("orderStr", "GMT_CREATE asc");
            QueryResult<OcRecflowPprocess> result = null;
            int startRow = 0;
            boolean flag = true;
            do {
                startRow = this.getPprocessService().getStartRow();
                map.put("startRow", startRow);
                map.put("rows", this.getPprocessService().getPage());
                result = this.ocRecflowPprocessService.queryRecflowPprocessPage(map);
                if (null != result && null != result.getPageTools() && null != result.getRows() && !result.getRows().isEmpty()) {
                    startRow = result.getPageTools().getRecordCountNo();
                    this.getPprocessService().addPutPool(new PprocessModelPutThread(this.getPprocessService(), (OcRefundService)SpringApplicationContextUtil.getBean((String)"ocRefundService"), result.getRows()));
                    if (result.getRows().size() == this.getPprocessService().getPage()) continue;
                    flag = false;
                    continue;
                }
                flag = false;
            } while (flag);
            this.getPprocessService().initStartRow();
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundEngineServiceImpl.loadDb.an.e", (Throwable)e);
        }
    }

    @Override
    public String sendBatchSaveRefund(List<OcRefundDomain> ocRefundDomainList) throws ApiException {
        String code = this.ocRefundService.saveBatchRefund(ocRefundDomainList);
        OcRefundCtrlServiceImpl.getRefundEsService().addPutPool(new RefundDomainPutThread(OcRefundCtrlServiceImpl.getRefundEsService(), ocRefundDomainList));
        return code;
    }

    @Override
    public Map<String, String> sendsaveRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        OcRefund ocRefund = this.ocRefundService.saveRefundre(ocRefundDomain);
        ArrayList<OcRefundDomain> ocRefundDomainList = new ArrayList<OcRefundDomain>();
        ocRefundDomainList.add(ocRefundDomain);
        OcRefundCtrlServiceImpl.getRefundEsService().addPutPool(new RefundDomainPutThread(OcRefundCtrlServiceImpl.getRefundEsService(), ocRefundDomainList));
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("state", "success");
        map.put("code", ocRefund.getRefundCode());
        return map;
    }

    @Override
    public String sendSaveRefund(OcRefundDomain ocRefundDomain) throws ApiException {
        OcSendcontractData ocSendcontractData = this.ocRefundService.saveRefundRe(ocRefundDomain);
        this.logger.error("ocSendcontractData", (Object)JsonUtil.buildNormalBinder().toJson((Object)ocSendcontractData));
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendUpdateRefundStateByNcode(String refundNcode, String channelCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcRefund ocRefund = this.ocRefundService.getRefundByNcode(refundNcode, channelCode, tenantCode);
        if (null == ocRefund) {
            return null;
        }
        this.sendRefundNext(ocRefund.getRefundCode(), tenantCode, map);
        return "";
    }

    @Override
    public String sendRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        Map<String, Object> remap = this.ocRefundService.sendRefundRes(refundCode, tenantCode, map);
        if (MapUtil.isEmpty(remap)) {
            return null;
        }
        OcSendcontractData ocSendcontractData = (OcSendcontractData)remap.get("ocSendcontractData");
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        OcRefund ocRefund = (OcRefund)remap.get("ocRefund");
        if (null != ocRefund) {
            OcRefundServiceImpl.getRefundService().putQueue(ocRefund);
        }
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendsaveRefundPay(String refundCode, String tenantCode, String ptradeSeqno, Integer dataState) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.saveRefundPay(refundCode, tenantCode, ptradeSeqno, dataState);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundPass(String refundCode, String tenantCode, Map<String, Object> map) {
        Map<String, Object> remap = this.ocRefundService.updateRefundPass(refundCode, tenantCode, map);
        if (MapUtil.isEmpty(remap)) {
            return null;
        }
        OcSendcontractData ocSendcontractData = (OcSendcontractData)remap.get("ocSendcontractData");
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        OcRefund ocRefund = (OcRefund)remap.get("ocRefund");
        if (null != ocRefund) {
            OcRefundServiceImpl.getRefundService().putQueue(ocRefund);
        }
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundPay(OcRefund ocRefund) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundPay(ocRefund);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundRefuse(String refundCode, String tenantCode, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundRefuse(refundCode, tenantCode, map);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundRes(String refundCode, String tenantCode, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundRes(refundCode, tenantCode, map);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundStateByCode(String refundCode, String tenantCode, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundStateByCode(refundCode, dataState, oldDataState, tenantCode);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendupdateRefundStateById(Integer refundId, Integer dataState, Integer oldDataState, Map<String, Object> map) {
        OcSendcontractData ocSendcontractData = this.ocRefundService.updateRefundState(refundId, dataState, oldDataState);
        if (null == ocSendcontractData) {
            return null;
        }
        OcSendcontractDataServiceImpl.getEsEngineService().putQueue(ocSendcontractData);
        return ocSendcontractData.getSendcontractDataOpcode();
    }

    @Override
    public String sendSaveOrderRefund(OcContractDomain ocContractDomain) throws ApiException {
        this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.sendSaveOrderRefund.ocContractDomain" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain));
        OcRefundDomain ocRefundDomain = this.getOcRefundDomain(ocContractDomain);
        if (ocRefundDomain == null) {
            return "error";
        }
        this.sendSaveRefund(ocRefundDomain);
        return "success";
    }

    @Override
    public void updateAuditCall(Map<String, Object> map) throws ApiException {
        this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.updateAuditCall:\u4f20\u5165\u53c2\u6570-", (Object)JsonUtil.buildNormalBinder().toJson(map));
        if (map.get("auditStatus") == null) {
            throw new ApiException("oc.CONTRACT.OcRefundEngineServiceImpl.updateAuditCall.ex", "\u5ba1\u6279\u53c2\u6570\u9519\u8bef\uff01");
        }
        String auditStatus = map.get("auditStatus").toString();
        OcRefundReDomain ocRefundReDomain = (OcRefundReDomain)JsonUtil.buildNormalBinder().getJsonToObject(map.get("ocRefundReDomain").toString(), OcRefundReDomain.class);
        if ("YES".equals(auditStatus)) {
            HashMap<String, Object> parammap = new HashMap<String, Object>();
            parammap.put("refundCode", ocRefundReDomain.getRefundCode());
            parammap.put("tenantCode", ocRefundReDomain.getTenantCode());
            List ocRefundGoodsList = this.ocRefundService.queryRefundGoodsPage(parammap).getList();
            if (ListUtil.isEmpty((Collection)ocRefundGoodsList)) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.saveContractGoods.sgSendgoodsGoodsList", parammap);
                return;
            }
            List<GoodsSendNumBean> sendNumList = this.makeGoodsSendNum(ocRefundGoodsList, -1);
            if (ListUtil.isEmpty(sendNumList)) {
                this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.saveContractGoods.sendNumList", parammap);
                return;
            }
            HashMap<String, String> apiParammap = new HashMap<String, String>();
            apiParammap.put("goodsSendNumBeanList", JsonUtil.buildNormalBinder().toJson(sendNumList));
            this.internalInvoke("oc.contract.updateSendNum", apiParammap);
            BigDecimal quota = BigDecimal.ZERO;
            if ("2".equals(ocRefundReDomain.getFchannelCode())) {
                quota = ocRefundReDomain.getRefundMoney().multiply(new BigDecimal(0.8));
            }
            if (quota.compareTo(BigDecimal.ZERO) != 0) {
                HashMap<String, String> paramMap = new HashMap<String, String>();
                HashMap<String, Object> pmap = new HashMap<String, Object>();
                pmap.put("quota", quota);
                pmap.put("quotaType", 6);
                pmap.put("contractBillcode", ocRefundReDomain.getContractBillcode());
                pmap.put("userInfoCode", ocRefundReDomain.getMemberBcode());
                paramMap.put("map", JsonUtil.buildNormalBinder().toJson(pmap));
                this.internalInvoke("crp.send.sendChangeAvailableQuota", paramMap);
            }
        } else if ("NO".equals(auditStatus)) {
            // empty if block
        }
    }

    private List<GoodsSendNumBean> makeGoodsSendNum(List<OcRefundGoods> ocRefundGoodsList, int dir) {
        if (ListUtil.isEmpty(ocRefundGoodsList)) {
            return null;
        }
        ArrayList<GoodsSendNumBean> sendNumList = new ArrayList<GoodsSendNumBean>();
        for (OcRefundGoods ocRefundGoods : ocRefundGoodsList) {
            GoodsSendNumBean goodsSendNumBean = new GoodsSendNumBean();
            goodsSendNumBean.setContractBillcode(ocRefundGoods.getContractBillcode());
            goodsSendNumBean.setContractGoodsCode(ocRefundGoods.getContractGoodsCode());
            goodsSendNumBean.setTenantCode(ocRefundGoods.getTenantCode());
            if (null == ocRefundGoods.getRefundGoodsNum()) {
                ocRefundGoods.setRefundGoodsNum(BigDecimal.ZERO);
            }
            if (null == ocRefundGoods.getRefundGoodsWeight()) {
                ocRefundGoods.setRefundGoodsWeight(BigDecimal.ZERO);
            }
            goodsSendNumBean.setContractGoodsSendnum(new BigDecimal(dir).multiply(ocRefundGoods.getRefundGoodsNum()));
            goodsSendNumBean.setContractGoodsSendweight(new BigDecimal(dir).multiply(ocRefundGoods.getRefundGoodsWeight()));
            sendNumList.add(goodsSendNumBean);
        }
        return sendNumList;
    }

    private OcRefundDomain getOcRefundDomain(OcContractDomain ocContractDomain) {
        OcRefundDomain ocRefundDomain = new OcRefundDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundDomain, (Object)ocContractDomain);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.getOcRefundDomain.ex" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain), (Throwable)e);
            return null;
        }
        ocRefundDomain.setRefundMoney(ocContractDomain.getDataBmoney());
        ocRefundDomain.setRefundType("B03");
        ocRefundDomain.setRefundUsertype("0");
        List<OcContractGoodsDomain> goodsList = ocContractDomain.getGoodsList();
        ArrayList<OcRefundGoodsDomain> ocRefundGoodsDomainList = new ArrayList<OcRefundGoodsDomain>();
        if (ListUtil.isNotEmpty(goodsList)) {
            for (OcContractGoodsDomain ocContractGoodsDomain : goodsList) {
                OcRefundGoodsDomain ocRefundGoodsDomain = new OcRefundGoodsDomain();
                try {
                    BeanUtils.copyAllPropertys((Object)ocRefundGoodsDomain, (Object)ocContractGoodsDomain);
                }
                catch (Exception e) {
                    this.logger.error("oc.CONTRACT.OcRefundEngineServiceImpl.getOcRefundDomain.ex1" + JsonUtil.buildNormalBinder().toJson((Object)ocContractDomain), (Throwable)e);
                }
                ocRefundGoodsDomainList.add(ocRefundGoodsDomain);
            }
        }
        ocRefundDomain.setOcRefundGoodsDomainList(ocRefundGoodsDomainList);
        return ocRefundDomain;
    }

    static {
        lock = new Object();
    }
}

