/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcRefundFileMapper;
import com.yqbsoft.laser.service.contract.domain.OcRefundFileDomain;
import com.yqbsoft.laser.service.contract.domain.OcRefundFileReDomain;
import com.yqbsoft.laser.service.contract.model.OcRefundFile;
import com.yqbsoft.laser.service.contract.service.OcRefundFileService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcRefundFileServiceImpl
extends BaseServiceImpl
implements OcRefundFileService {
    private static final String SYS_CODE = "oc.CONTRACT.OcRefundFileServiceImpl";
    private OcRefundFileMapper ocRefundFileMapper;

    public void setOcRefundFileMapper(OcRefundFileMapper ocRefundFileMapper) {
        this.ocRefundFileMapper = ocRefundFileMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocRefundFileMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundFileServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRefundFile(OcRefundFileDomain ocRefundFileDomain) {
        if (null == ocRefundFileDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocRefundFileDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRefundFileDefault(OcRefundFile ocRefundFile) {
        if (null == ocRefundFile) {
            return;
        }
        if (null == ocRefundFile.getDataState()) {
            ocRefundFile.setDataState(0);
        }
        if (null == ocRefundFile.getGmtCreate()) {
            ocRefundFile.setGmtCreate(this.getSysDate());
        }
        ocRefundFile.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ocRefundFile.getRefundFileCode())) {
            ocRefundFile.setRefundFileCode(this.createUUIDString());
        }
    }

    private int getRefundFileMaxCode() {
        int code = 0;
        try {
            return this.ocRefundFileMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundFileServiceImpl.getRefundFileMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRefundFileUpdataDefault(OcRefundFile ocRefundFile) {
        if (null == ocRefundFile) {
            return;
        }
        ocRefundFile.setGmtModified(this.getSysDate());
    }

    private void saveRefundFileModel(OcRefundFile ocRefundFile) throws ApiException {
        if (null == ocRefundFile) {
            return;
        }
        try {
            this.ocRefundFileMapper.insert(ocRefundFile);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.saveRefundFileModel.ex", (Throwable)e);
        }
    }

    private void saveRefundFileBatchModel(List<OcRefundFile> ocRefundFileList) throws ApiException {
        if (null == ocRefundFileList || ocRefundFileList.isEmpty()) {
            return;
        }
        try {
            this.ocRefundFileMapper.insertBatch(ocRefundFileList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.saveRefundFileBatchModel.ex", (Throwable)e);
        }
    }

    private OcRefundFile getRefundFileModelById(Integer refundFileId) {
        if (null == refundFileId) {
            return null;
        }
        try {
            return this.ocRefundFileMapper.selectByPrimaryKey(refundFileId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundFileServiceImpl.getRefundFileModelById", (Throwable)e);
            return null;
        }
    }

    private OcRefundFile getRefundFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocRefundFileMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundFileServiceImpl.getRefundFileModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRefundFileModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundFileMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.delRefundFileModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.delRefundFileModelByCode.num");
        }
    }

    private void deleteRefundFileModel(Integer refundFileId) throws ApiException {
        if (null == refundFileId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundFileMapper.deleteByPrimaryKey(refundFileId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.deleteRefundFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.deleteRefundFileModel.num");
        }
    }

    private void updateRefundFileModel(OcRefundFile ocRefundFile) throws ApiException {
        if (null == ocRefundFile) {
            return;
        }
        int i = 0;
        try {
            i = this.ocRefundFileMapper.updateByPrimaryKeySelective(ocRefundFile);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.updateRefundFileModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.updateRefundFileModel.num");
        }
    }

    private void updateStateRefundFileModel(Integer refundFileId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == refundFileId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("refundFileId", refundFileId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRefundFileMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.updateStateRefundFileModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.updateStateRefundFileModel.null");
        }
    }

    private void updateStateRefundFileModelByCode(String tenantCode, String refundFileCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)refundFileCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("refundFileCode", refundFileCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ocRefundFileMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.updateStateRefundFileModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.updateStateRefundFileModelByCode.null");
        }
    }

    private OcRefundFile makeRefundFile(OcRefundFileDomain ocRefundFileDomain, OcRefundFile ocRefundFile) {
        if (null == ocRefundFileDomain) {
            return null;
        }
        if (null == ocRefundFile) {
            ocRefundFile = new OcRefundFile();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundFile, (Object)ocRefundFileDomain);
            return ocRefundFile;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundFileServiceImpl.makeRefundFile", (Throwable)e);
            return null;
        }
    }

    private OcRefundFileReDomain makeOcRefundFileReDomain(OcRefundFile ocRefundFile) {
        if (null == ocRefundFile) {
            return null;
        }
        OcRefundFileReDomain ocRefundFileReDomain = new OcRefundFileReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocRefundFileReDomain, (Object)ocRefundFile);
            return ocRefundFileReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundFileServiceImpl.makeOcRefundFileReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcRefundFile> queryRefundFileModelPage(Map<String, Object> parammap) {
        try {
            return this.ocRefundFileMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundFileServiceImpl.queryRefundFileModel", (Throwable)e);
            return null;
        }
    }

    private int countRefundFile(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocRefundFileMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcRefundFileServiceImpl.countRefundFile", (Throwable)e);
        }
        return i;
    }

    private OcRefundFile createOcRefundFile(OcRefundFileDomain ocRefundFileDomain) {
        String msg = this.checkRefundFile(ocRefundFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.saveRefundFile.checkRefundFile", msg);
        }
        OcRefundFile ocRefundFile = this.makeRefundFile(ocRefundFileDomain, null);
        this.setRefundFileDefault(ocRefundFile);
        return ocRefundFile;
    }

    @Override
    public String saveRefundFile(OcRefundFileDomain ocRefundFileDomain) throws ApiException {
        OcRefundFile ocRefundFile = this.createOcRefundFile(ocRefundFileDomain);
        this.saveRefundFileModel(ocRefundFile);
        return ocRefundFile.getRefundFileCode();
    }

    @Override
    public String saveRefundFileBatch(List<OcRefundFileDomain> ocRefundFileDomainList) throws ApiException {
        if (null == ocRefundFileDomainList || ocRefundFileDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcRefundFile> ocRefundFileList = new ArrayList<OcRefundFile>();
        String code = "";
        for (OcRefundFileDomain ocRefundFileDomain : ocRefundFileDomainList) {
            OcRefundFile ocRefundFile = this.createOcRefundFile(ocRefundFileDomain);
            code = ocRefundFile.getRefundFileCode();
            ocRefundFileList.add(ocRefundFile);
        }
        this.saveRefundFileBatchModel(ocRefundFileList);
        return code;
    }

    @Override
    public void updateRefundFileState(Integer refundFileId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundFileModel(refundFileId, dataState, oldDataState);
    }

    @Override
    public void updateRefundFileStateByCode(String tenantCode, String refundFileCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateRefundFileModelByCode(tenantCode, refundFileCode, dataState, oldDataState);
    }

    @Override
    public void updateRefundFile(OcRefundFileDomain ocRefundFileDomain) throws ApiException {
        String msg = this.checkRefundFile(ocRefundFileDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.updateRefundFile.checkRefundFile", msg);
        }
        OcRefundFile oldOcRefundFile = this.getRefundFileModelById(ocRefundFileDomain.getRefundFileId());
        if (null == oldOcRefundFile) {
            throw new ApiException("oc.CONTRACT.OcRefundFileServiceImpl.updateRefundFile.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcRefundFile ocRefundFile = this.makeRefundFile(ocRefundFileDomain, oldOcRefundFile);
        this.setRefundFileUpdataDefault(ocRefundFile);
        this.updateRefundFileModel(ocRefundFile);
    }

    @Override
    public OcRefundFile getRefundFile(Integer refundFileId) {
        return this.getRefundFileModelById(refundFileId);
    }

    @Override
    public void deleteRefundFile(Integer refundFileId) throws ApiException {
        this.deleteRefundFileModel(refundFileId);
    }

    @Override
    public QueryResult<OcRefundFile> queryRefundFilePage(Map<String, Object> map) {
        List<OcRefundFile> ocRefundFileList = this.queryRefundFileModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRefundFile(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocRefundFileList);
        return queryResult;
    }

    @Override
    public OcRefundFile getRefundFileByCode(String tenantCode, String refundFileCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("refundFileCode", refundFileCode);
        return this.getRefundFileModelByCode(map);
    }

    @Override
    public void deleteRefundFileByCode(String tenantCode, String refundFileCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("refundFileCode", refundFileCode);
        this.delRefundFileModelByCode(map);
    }
}

