/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contract.service.impl;

import com.yqbsoft.laser.service.contract.dao.OcContractOwnerMapper;
import com.yqbsoft.laser.service.contract.domain.OcContractOwnerDomain;
import com.yqbsoft.laser.service.contract.domain.OcContractOwnerReDomain;
import com.yqbsoft.laser.service.contract.model.OcContractOwner;
import com.yqbsoft.laser.service.contract.service.OcContractOwnerService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OcContractOwnerServiceImpl
extends BaseServiceImpl
implements OcContractOwnerService {
    private static final String SYS_CODE = "oc.CONTRACT.OcContractOwnerServiceImpl";
    private OcContractOwnerMapper ocContractOwnerMapper;

    public void setOcContractOwnerMapper(OcContractOwnerMapper ocContractOwnerMapper) {
        this.ocContractOwnerMapper = ocContractOwnerMapper;
    }

    private Date getSysDate() {
        try {
            return this.ocContractOwnerMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractOwnerServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkContractOwner(OcContractOwnerDomain ocContractOwnerDomain) {
        if (null == ocContractOwnerDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ocContractOwnerDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setContractOwnerDefault(OcContractOwner ocContractOwner) {
        if (null == ocContractOwner) {
            return;
        }
        Date date = this.getSysDate();
        if (null == ocContractOwner.getGmtCreate()) {
            ocContractOwner.setGmtCreate(date);
        }
        ocContractOwner.setGmtModified(date);
        if (StringUtils.isBlank((String)ocContractOwner.getOwnerCode())) {
            ocContractOwner.setOwnerCode(this.getNo(null, "OcContractOwner", "ocContractOwner", ocContractOwner.getTenantCode()));
        }
    }

    private int getContractOwnerMaxCode() {
        int code = 0;
        try {
            return this.ocContractOwnerMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractOwnerServiceImpl.getContractOwnerMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setContractOwnerUpdataDefault(OcContractOwner ocContractOwner) {
        if (null == ocContractOwner) {
            return;
        }
        ocContractOwner.setGmtModified(this.getSysDate());
    }

    private void saveContractOwnerModel(OcContractOwner ocContractOwner) throws ApiException {
        if (null == ocContractOwner) {
            return;
        }
        try {
            this.ocContractOwnerMapper.insert(ocContractOwner);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.saveContractOwnerModel.ex", (Throwable)e);
        }
    }

    private void saveContractOwnerBatchModel(List<OcContractOwner> ocContractOwnerList) throws ApiException {
        if (null == ocContractOwnerList || ocContractOwnerList.isEmpty()) {
            return;
        }
        try {
            this.ocContractOwnerMapper.insertBatch(ocContractOwnerList);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.saveContractOwnerBatchModel.ex", (Throwable)e);
        }
    }

    private OcContractOwner getContractOwnerModelById(Integer ownerId) {
        if (null == ownerId) {
            return null;
        }
        try {
            return this.ocContractOwnerMapper.selectByPrimaryKey(ownerId);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractOwnerServiceImpl.getContractOwnerModelById", (Throwable)e);
            return null;
        }
    }

    private OcContractOwner getContractOwnerModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ocContractOwnerMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractOwnerServiceImpl.getContractOwnerModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delContractOwnerModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractOwnerMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.delContractOwnerModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.delContractOwnerModelByCode.num");
        }
    }

    @Override
    public void delByMap(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractOwnerMapper.delByMap(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.delContractOwnerModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.delContractOwnerModelByCode.num");
        }
    }

    private void deleteContractOwnerModel(Integer ownerId) throws ApiException {
        if (null == ownerId) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractOwnerMapper.deleteByPrimaryKey(ownerId);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.deleteContractOwnerModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.deleteContractOwnerModel.num");
        }
    }

    private void updateContractOwnerModel(OcContractOwner ocContractOwner) throws ApiException {
        if (null == ocContractOwner) {
            return;
        }
        int i = 0;
        try {
            i = this.ocContractOwnerMapper.updateByPrimaryKey(ocContractOwner);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.updateContractOwnerModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.updateContractOwnerModel.num");
        }
    }

    private void updateStateContractOwnerModel(Integer ownerId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == ownerId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ownerId", ownerId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractOwnerMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.updateStateContractOwnerModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.updateStateContractOwnerModel.null");
        }
    }

    private void updateStateContractOwnerModelByCode(String tenantCode, String ownerCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)ownerCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ownerCode", ownerCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.ocContractOwnerMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.updateStateContractOwnerModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.updateStateContractOwnerModelByCode.null");
        }
    }

    private OcContractOwner makeContractOwner(OcContractOwnerDomain ocContractOwnerDomain, OcContractOwner ocContractOwner) {
        if (null == ocContractOwnerDomain) {
            return null;
        }
        if (null == ocContractOwner) {
            ocContractOwner = new OcContractOwner();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ocContractOwner, (Object)ocContractOwnerDomain);
            return ocContractOwner;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractOwnerServiceImpl.makeContractOwner", (Throwable)e);
            return null;
        }
    }

    private OcContractOwnerReDomain makeOcContractOwnerReDomain(OcContractOwner ocContractOwner) {
        if (null == ocContractOwner) {
            return null;
        }
        OcContractOwnerReDomain ocContractOwnerReDomain = new OcContractOwnerReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ocContractOwnerReDomain, (Object)ocContractOwner);
            return ocContractOwnerReDomain;
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractOwnerServiceImpl.makeOcContractOwnerReDomain", (Throwable)e);
            return null;
        }
    }

    private List<OcContractOwner> queryContractOwnerModelPage(Map<String, Object> parammap) {
        try {
            return this.ocContractOwnerMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractOwnerServiceImpl.queryContractOwnerModel", (Throwable)e);
            return null;
        }
    }

    private int countContractOwner(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ocContractOwnerMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("oc.CONTRACT.OcContractOwnerServiceImpl.countContractOwner", (Throwable)e);
        }
        return i;
    }

    private OcContractOwner createOcContractOwner(OcContractOwnerDomain ocContractOwnerDomain) {
        String msg = this.checkContractOwner(ocContractOwnerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.saveContractOwner.checkContractOwner", msg);
        }
        OcContractOwner ocContractOwner = this.makeContractOwner(ocContractOwnerDomain, null);
        this.setContractOwnerDefault(ocContractOwner);
        return ocContractOwner;
    }

    @Override
    public String saveContractOwner(OcContractOwnerDomain ocContractOwnerDomain) throws ApiException {
        OcContractOwner ocContractOwner = this.createOcContractOwner(ocContractOwnerDomain);
        this.saveContractOwnerModel(ocContractOwner);
        return ocContractOwner.getOwnerCode();
    }

    @Override
    public String saveContractOwnerBatch(List<OcContractOwnerDomain> ocContractOwnerDomainList) throws ApiException {
        if (null == ocContractOwnerDomainList || ocContractOwnerDomainList.isEmpty()) {
            return null;
        }
        ArrayList<OcContractOwner> ocContractOwnerList = new ArrayList<OcContractOwner>();
        String code = "";
        for (OcContractOwnerDomain ocContractOwnerDomain : ocContractOwnerDomainList) {
            OcContractOwner ocContractOwner = this.createOcContractOwner(ocContractOwnerDomain);
            code = ocContractOwner.getOwnerCode();
            ocContractOwnerList.add(ocContractOwner);
        }
        this.saveContractOwnerBatchModel(ocContractOwnerList);
        return code;
    }

    @Override
    public void updateContractOwnerState(Integer ownerId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == ownerId) {
            return;
        }
        this.updateStateContractOwnerModel(ownerId, dataState, oldDataState, map);
    }

    @Override
    public void updateContractOwnerStateByCode(String tenantCode, String ownerCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)ownerCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateContractOwnerModelByCode(tenantCode, ownerCode, dataState, oldDataState, map);
    }

    @Override
    public void updateContractOwner(OcContractOwnerDomain ocContractOwnerDomain) throws ApiException {
        String msg = this.checkContractOwner(ocContractOwnerDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.updateContractOwner.checkContractOwner", msg);
        }
        OcContractOwner oldOcContractOwner = this.getContractOwnerModelById(ocContractOwnerDomain.getOwnerId());
        if (null == oldOcContractOwner) {
            throw new ApiException("oc.CONTRACT.OcContractOwnerServiceImpl.updateContractOwner.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        OcContractOwner ocContractOwner = this.makeContractOwner(ocContractOwnerDomain, oldOcContractOwner);
        this.setContractOwnerUpdataDefault(ocContractOwner);
        this.updateContractOwnerModel(ocContractOwner);
    }

    @Override
    public OcContractOwner getContractOwner(Integer ownerId) {
        if (null == ownerId) {
            return null;
        }
        return this.getContractOwnerModelById(ownerId);
    }

    @Override
    public void deleteContractOwner(Integer ownerId) throws ApiException {
        if (null == ownerId) {
            return;
        }
        this.deleteContractOwnerModel(ownerId);
    }

    @Override
    public QueryResult<OcContractOwner> queryContractOwnerPage(Map<String, Object> map) {
        List<OcContractOwner> ocContractOwnerList = this.queryContractOwnerModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countContractOwner(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ocContractOwnerList);
        return queryResult;
    }

    @Override
    public OcContractOwner getContractOwnerByCode(String tenantCode, String ownerCode) throws ApiException {
        if (StringUtils.isBlank((String)ownerCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ownerCode", ownerCode);
        return this.getContractOwnerModelByCode(map);
    }

    @Override
    public void deleteContractOwnerByCode(String tenantCode, String ownerCode) throws ApiException {
        if (StringUtils.isBlank((String)ownerCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("ownerCode", ownerCode);
        this.delContractOwnerModelByCode(map);
    }
}

