/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.contractorder.service.impl;

import com.yqbsoft.laser.service.contractorder.dao.CoCorderSettlMapper;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderSettlDomain;
import com.yqbsoft.laser.service.contractorder.domain.CoCorderSettlReDomain;
import com.yqbsoft.laser.service.contractorder.model.CoCorderSettl;
import com.yqbsoft.laser.service.contractorder.service.CoCorderSettlService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CoCorderSettlServiceImpl
extends BaseServiceImpl
implements CoCorderSettlService {
    private static final String SYS_CODE = "co.CONTRACTORDER.CoCorderSettlServiceImpl";
    private CoCorderSettlMapper coCorderSettlMapper;

    public void setCoCorderSettlMapper(CoCorderSettlMapper coCorderSettlMapper) {
        this.coCorderSettlMapper = coCorderSettlMapper;
    }

    private Date getSysDate() {
        try {
            return this.coCorderSettlMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSettlServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCorderSettl(CoCorderSettlDomain coCorderSettlDomain) {
        if (null == coCorderSettlDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)coCorderSettlDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCorderSettlDefault(CoCorderSettl coCorderSettl) {
        if (null == coCorderSettl) {
            return;
        }
        if (null == coCorderSettl.getDataState()) {
            coCorderSettl.setDataState(0);
        }
        if (null == coCorderSettl.getGmtCreate()) {
            coCorderSettl.setGmtCreate(this.getSysDate());
        }
        coCorderSettl.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)coCorderSettl.getCorderSettlCode())) {
            coCorderSettl.setCorderSettlCode(this.createUUIDString());
        }
    }

    private int getCorderSettlMaxCode() {
        int code = 0;
        try {
            return this.coCorderSettlMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSettlServiceImpl.getCorderSettlMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCorderSettlUpdataDefault(CoCorderSettl coCorderSettl) {
        if (null == coCorderSettl) {
            return;
        }
        coCorderSettl.setGmtModified(this.getSysDate());
    }

    private void saveCorderSettlModel(CoCorderSettl coCorderSettl) throws ApiException {
        if (null == coCorderSettl) {
            return;
        }
        try {
            this.coCorderSettlMapper.insert(coCorderSettl);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.saveCorderSettlModel.ex", (Throwable)e);
        }
    }

    private void saveCorderSettlBatchModel(List<CoCorderSettl> coCorderSettlList) throws ApiException {
        if (null == coCorderSettlList || coCorderSettlList.isEmpty()) {
            return;
        }
        try {
            this.coCorderSettlMapper.insertBatch(coCorderSettlList);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.saveCorderSettlBatchModel.ex", (Throwable)e);
        }
    }

    private CoCorderSettl getCorderSettlModelById(Integer corderSettlId) {
        if (null == corderSettlId) {
            return null;
        }
        try {
            return this.coCorderSettlMapper.selectByPrimaryKey(corderSettlId);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSettlServiceImpl.getCorderSettlModelById", (Throwable)e);
            return null;
        }
    }

    private CoCorderSettl getCorderSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.coCorderSettlMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSettlServiceImpl.getCorderSettlModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCorderSettlModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderSettlMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.delCorderSettlModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.delCorderSettlModelByCode.num");
        }
    }

    private void deleteCorderSettlModel(Integer corderSettlId) throws ApiException {
        if (null == corderSettlId) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderSettlMapper.deleteByPrimaryKey(corderSettlId);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.deleteCorderSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.deleteCorderSettlModel.num");
        }
    }

    private void updateCorderSettlModel(CoCorderSettl coCorderSettl) throws ApiException {
        if (null == coCorderSettl) {
            return;
        }
        int i = 0;
        try {
            i = this.coCorderSettlMapper.updateByPrimaryKey(coCorderSettl);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.updateCorderSettlModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.updateCorderSettlModel.num");
        }
    }

    private void updateStateCorderSettlModel(Integer corderSettlId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == corderSettlId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("corderSettlId", corderSettlId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderSettlMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.updateStateCorderSettlModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.updateStateCorderSettlModel.null");
        }
    }

    private void updateStateCorderSettlModelByCode(String tenantCode, String corderSettlCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)corderSettlCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderSettlCode", corderSettlCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.coCorderSettlMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.updateStateCorderSettlModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.updateStateCorderSettlModelByCode.null");
        }
    }

    private CoCorderSettl makeCorderSettl(CoCorderSettlDomain coCorderSettlDomain, CoCorderSettl coCorderSettl) {
        if (null == coCorderSettlDomain) {
            return null;
        }
        if (null == coCorderSettl) {
            coCorderSettl = new CoCorderSettl();
        }
        try {
            BeanUtils.copyAllPropertys((Object)coCorderSettl, (Object)coCorderSettlDomain);
            return coCorderSettl;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSettlServiceImpl.makeCorderSettl", (Throwable)e);
            return null;
        }
    }

    private CoCorderSettlReDomain makeCoCorderSettlReDomain(CoCorderSettl coCorderSettl) {
        if (null == coCorderSettl) {
            return null;
        }
        CoCorderSettlReDomain coCorderSettlReDomain = new CoCorderSettlReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)coCorderSettlReDomain, (Object)coCorderSettl);
            return coCorderSettlReDomain;
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSettlServiceImpl.makeCoCorderSettlReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CoCorderSettl> queryCorderSettlModelPage(Map<String, Object> parammap) {
        try {
            return this.coCorderSettlMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSettlServiceImpl.queryCorderSettlModel", (Throwable)e);
            return null;
        }
    }

    private int countCorderSettl(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.coCorderSettlMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("co.CONTRACTORDER.CoCorderSettlServiceImpl.countCorderSettl", (Throwable)e);
        }
        return i;
    }

    private CoCorderSettl createCoCorderSettl(CoCorderSettlDomain coCorderSettlDomain) {
        String msg = this.checkCorderSettl(coCorderSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.saveCorderSettl.checkCorderSettl", msg);
        }
        CoCorderSettl coCorderSettl = this.makeCorderSettl(coCorderSettlDomain, null);
        this.setCorderSettlDefault(coCorderSettl);
        return coCorderSettl;
    }

    @Override
    public String saveCorderSettl(CoCorderSettlDomain coCorderSettlDomain) throws ApiException {
        CoCorderSettl coCorderSettl = this.createCoCorderSettl(coCorderSettlDomain);
        this.saveCorderSettlModel(coCorderSettl);
        return coCorderSettl.getCorderSettlCode();
    }

    @Override
    public String saveCorderSettlBatch(List<CoCorderSettlDomain> coCorderSettlDomainList) throws ApiException {
        if (null == coCorderSettlDomainList || coCorderSettlDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CoCorderSettl> coCorderSettlList = new ArrayList<CoCorderSettl>();
        String code = "";
        for (CoCorderSettlDomain coCorderSettlDomain : coCorderSettlDomainList) {
            CoCorderSettl coCorderSettl = this.createCoCorderSettl(coCorderSettlDomain);
            code = coCorderSettl.getCorderSettlCode();
            coCorderSettlList.add(coCorderSettl);
        }
        this.saveCorderSettlBatchModel(coCorderSettlList);
        return code;
    }

    @Override
    public void updateCorderSettlState(Integer corderSettlId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCorderSettlModel(corderSettlId, dataState, oldDataState, map);
    }

    @Override
    public void updateCorderSettlStateByCode(String tenantCode, String corderSettlCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCorderSettlModelByCode(tenantCode, corderSettlCode, dataState, oldDataState, map);
    }

    @Override
    public void updateCorderSettl(CoCorderSettlDomain coCorderSettlDomain) throws ApiException {
        String msg = this.checkCorderSettl(coCorderSettlDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.updateCorderSettl.checkCorderSettl", msg);
        }
        CoCorderSettl oldCoCorderSettl = this.getCorderSettlModelById(coCorderSettlDomain.getCorderSettlId());
        if (null == oldCoCorderSettl) {
            throw new ApiException("co.CONTRACTORDER.CoCorderSettlServiceImpl.updateCorderSettl.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CoCorderSettl coCorderSettl = this.makeCorderSettl(coCorderSettlDomain, oldCoCorderSettl);
        this.setCorderSettlUpdataDefault(coCorderSettl);
        this.updateCorderSettlModel(coCorderSettl);
    }

    @Override
    public CoCorderSettl getCorderSettl(Integer corderSettlId) {
        return this.getCorderSettlModelById(corderSettlId);
    }

    @Override
    public void deleteCorderSettl(Integer corderSettlId) throws ApiException {
        this.deleteCorderSettlModel(corderSettlId);
    }

    @Override
    public QueryResult<CoCorderSettl> queryCorderSettlPage(Map<String, Object> map) {
        List<CoCorderSettl> coCorderSettlList = this.queryCorderSettlModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCorderSettl(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(coCorderSettlList);
        return queryResult;
    }

    @Override
    public CoCorderSettl getCorderSettlByCode(String tenantCode, String corderSettlCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderSettlCode", corderSettlCode);
        return this.getCorderSettlModelByCode(map);
    }

    @Override
    public void deleteCorderSettlByCode(String tenantCode, String corderSettlCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("corderSettlCode", corderSettlCode);
        this.delCorderSettlModelByCode(map);
    }
}

