/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crms.service.impl;

import com.yqbsoft.laser.service.crms.domain.CrmsChannelSendDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsSOrderDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsURechargeDomain;
import com.yqbsoft.laser.service.crms.engine.EsSendEnginePutThread;
import com.yqbsoft.laser.service.crms.engine.SendPutThread;
import com.yqbsoft.laser.service.crms.enums.OrderStateEnums;
import com.yqbsoft.laser.service.crms.model.CrmsChannelSend;
import com.yqbsoft.laser.service.crms.model.CrmsChannelSendList;
import com.yqbsoft.laser.service.crms.model.CrmsSOrder;
import com.yqbsoft.laser.service.crms.model.CrmsURecharge;
import com.yqbsoft.laser.service.crms.service.CrmsChannelSendBaseService;
import com.yqbsoft.laser.service.crms.service.CrmsChannelSendService;
import com.yqbsoft.laser.service.crms.service.CrmsSOrderService;
import com.yqbsoft.laser.service.crms.service.CrmsURechargeService;
import com.yqbsoft.laser.service.crms.service.impl.CrmsChannelSendListServiceImpl;
import com.yqbsoft.laser.service.crms.service.impl.CrmsChannelSendServiceImpl;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrmsChannelSendBaseServiceImpl
extends BaseServiceImpl
implements CrmsChannelSendBaseService {
    protected static final String SYS_CODE = "service.crms.CrmsChannelSendBaseServiceImpl";
    private CrmsChannelSendService crmsChannelSendService;
    private CrmsURechargeService crmsURechargeService;
    private CrmsSOrderService crmsSOrderService;

    public CrmsURechargeService getCrmsURechargeService() {
        return this.crmsURechargeService;
    }

    public void setCrmsURechargeService(CrmsURechargeService crmsURechargeService) {
        this.crmsURechargeService = crmsURechargeService;
    }

    public CrmsChannelSendService getCrmsChannelSendService() {
        return this.crmsChannelSendService;
    }

    public void setCrmsChannelSendService(CrmsChannelSendService crmsChannelSendService) {
        this.crmsChannelSendService = crmsChannelSendService;
    }

    public CrmsSOrderService getCrmsSOrderService() {
        return this.crmsSOrderService;
    }

    public void setCrmsSOrderService(CrmsSOrderService crmsSOrderService) {
        this.crmsSOrderService = crmsSOrderService;
    }

    @Override
    public void sendSaveChannelSend(CrmsChannelSend crmsChannelSend) {
        List<CrmsChannelSendList> crmsChannelSendLists = this.crmsChannelSendService.saveSendCrmsChannelSend(crmsChannelSend);
        this.sendSaveChannelSendLists(crmsChannelSendLists);
    }

    @Override
    public String sendSaveChannelSendLists(List<CrmsChannelSendList> crmsChannelSendLists) {
        if (ListUtil.isNotEmpty(crmsChannelSendLists)) {
            CrmsChannelSendListServiceImpl.getEsSendEngineService().addPutPool(new EsSendEnginePutThread(CrmsChannelSendListServiceImpl.getEsSendEngineService(), crmsChannelSendLists));
        }
        return null;
    }

    @Override
    public String saveURecharge(CrmsURechargeDomain crmsURechargeDomain) throws ApiException {
        List<CrmsChannelSend> crmsChannelSendList = this.crmsURechargeService.saveURecharge(crmsURechargeDomain);
        if (ListUtil.isNotEmpty(crmsChannelSendList)) {
            CrmsChannelSendServiceImpl.getSendService().addPutPool(new SendPutThread(CrmsChannelSendServiceImpl.getSendService(), crmsChannelSendList));
        }
        return crmsChannelSendList.get(0).getChannelsendOpcode();
    }

    @Override
    public String saveURechargeBatch(List<CrmsURechargeDomain> crmsURechargeDomainList) throws ApiException {
        List<CrmsChannelSend> crmsChannelSendList = this.crmsURechargeService.saveURechargeBatch(crmsURechargeDomainList);
        if (ListUtil.isNotEmpty(crmsChannelSendList)) {
            CrmsChannelSendServiceImpl.getSendService().addPutPool(new SendPutThread(CrmsChannelSendServiceImpl.getSendService(), crmsChannelSendList));
            return crmsChannelSendList.get(0).getChannelsendOpcode();
        }
        return null;
    }

    @Override
    public void updateURechargeState(Integer URechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<CrmsChannelSend> crmsChannelSendList = this.crmsURechargeService.updateURechargeState(URechargeId, dataState, oldDataState, map);
        if (ListUtil.isNotEmpty(crmsChannelSendList)) {
            CrmsChannelSendServiceImpl.getSendService().addPutPool(new SendPutThread(CrmsChannelSendServiceImpl.getSendService(), crmsChannelSendList));
        }
    }

    @Override
    public void updateURechargeStateByCode(String tenantCode, String URechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        List<CrmsChannelSend> crmsChannelSendList = this.crmsURechargeService.updateURechargeStateByCode(tenantCode, URechargeCode, dataState, oldDataState, map);
        if (ListUtil.isNotEmpty(crmsChannelSendList)) {
            CrmsChannelSendServiceImpl.getSendService().addPutPool(new SendPutThread(CrmsChannelSendServiceImpl.getSendService(), crmsChannelSendList));
        }
    }

    @Override
    public void updateURecharge(CrmsURechargeDomain crmsURechargeDomain) throws ApiException {
        List<CrmsChannelSend> crmsChannelSendList = this.crmsURechargeService.updateURecharge(crmsURechargeDomain);
        if (ListUtil.isNotEmpty(crmsChannelSendList)) {
            CrmsChannelSendServiceImpl.getSendService().addPutPool(new SendPutThread(CrmsChannelSendServiceImpl.getSendService(), crmsChannelSendList));
        }
    }

    @Override
    public void deleteURecharge(Integer URechargeId) throws ApiException {
        List<CrmsChannelSend> crmsChannelSendList = this.crmsURechargeService.deleteURecharge(URechargeId);
        if (ListUtil.isNotEmpty(crmsChannelSendList)) {
            CrmsChannelSendServiceImpl.getSendService().addPutPool(new SendPutThread(CrmsChannelSendServiceImpl.getSendService(), crmsChannelSendList));
        }
    }

    @Override
    public void deleteURechargeByCode(String tenantCode, String URechargeCode) throws ApiException {
        List<CrmsChannelSend> crmsChannelSendList = this.crmsURechargeService.deleteURechargeByCode(tenantCode, URechargeCode);
        if (ListUtil.isNotEmpty(crmsChannelSendList)) {
            CrmsChannelSendServiceImpl.getSendService().addPutPool(new SendPutThread(CrmsChannelSendServiceImpl.getSendService(), crmsChannelSendList));
        }
    }

    @Override
    public String saveSOrder(CrmsSOrderDomain crmsSOrderDomain) throws ApiException {
        List<CrmsChannelSend> crmsChannelSendList = this.crmsSOrderService.saveSOrder(crmsSOrderDomain);
        if (ListUtil.isNotEmpty(crmsChannelSendList)) {
            CrmsChannelSendServiceImpl.getSendService().addPutPool(new SendPutThread(CrmsChannelSendServiceImpl.getSendService(), crmsChannelSendList));
        }
        return crmsChannelSendList.get(0).getChannelsendOpcode();
    }

    @Override
    public String saveSOrderBatch(List<CrmsSOrderDomain> crmsSOrderDomainList) throws ApiException {
        List<CrmsChannelSend> crmsChannelSendList = this.crmsSOrderService.saveSOrderBatch(crmsSOrderDomainList);
        if (ListUtil.isNotEmpty(crmsChannelSendList)) {
            CrmsChannelSendServiceImpl.getSendService().addPutPool(new SendPutThread(CrmsChannelSendServiceImpl.getSendService(), crmsChannelSendList));
            return crmsChannelSendList.get(0).getChannelsendOpcode();
        }
        return null;
    }

    @Override
    public String updateAuditCall(Map<String, Object> map) {
        this.logger.error("service.crms.CrmsChannelSendBaseServiceImpl.updateAuditCall:\u4f20\u5165\u53c2\u6570-", (Object)JsonUtil.buildNormalBinder().toJson(map));
        HashMap<String, String> paramMap = new HashMap<String, String>();
        if (map.get("auditStatus") == null) {
            throw new ApiException("service.crms.CrmsChannelSendBaseServiceImpl.updateAuditCall.ex", "\u5ba1\u6279\u53c2\u6570\u9519\u8bef\uff01");
        }
        String auditStatus = map.get("auditStatus").toString();
        CrmsSOrder crmsSOrder = (CrmsSOrder)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(map.get("crmsSOrder")), CrmsSOrder.class);
        Integer dataState = OrderStateEnums.IN_AUDIT.getCode();
        if ("YES".equals(auditStatus)) {
            dataState = OrderStateEnums.SEND_OUT_GOODS.getCode();
        } else if ("NO".equals(auditStatus)) {
            dataState = OrderStateEnums.AUDIT_FAILURE.getCode();
        }
        crmsSOrder.setUserCode(map.get("auditUserCode").toString());
        this.crmsSOrderService.updateSOrderStateByCode(crmsSOrder.getTenantCode(), crmsSOrder.getSorderCode(), dataState, OrderStateEnums.IN_AUDIT.getCode(), null);
        if (dataState == 1) {
            JSONArray jsonObjects;
            paramMap.put("tenantCode", crmsSOrder.getTenantCode());
            paramMap.put("userinfoCode", crmsSOrder.getMemberBcode());
            paramMap.put("userinfoQuaKey", "depName");
            String result = this.internalInvoke("um.userinfoQua.queryUserinfoQuaList", paramMap);
            if (StringUtils.isNotBlank((String)result) && (jsonObjects = JSONArray.json2array((String)result)) != null && jsonObjects.size() > 0) {
                JSONObject domain = jsonObjects.get(0);
                CrmsURecharge crmsURecharge = this.crmsURechargeService.getURechargeByUserInfoCode(domain.getString("userinfoQuaVaule1"));
                CrmsURechargeDomain crmsURechargeDomain = new CrmsURechargeDomain();
                crmsURechargeDomain.setUrechargeId(crmsURecharge.getUrechargeId());
                crmsURechargeDomain.setRechargeAllmoney(crmsSOrder.getContractMoney());
                crmsURechargeDomain.setOrderCode(crmsSOrder.getSorderCode());
                this.crmsURechargeService.updateURecharge(crmsURechargeDomain);
            }
        } else if (dataState == 2) {
            ArrayList<CrmsChannelSendDomain> crmsChannelSendDomainList = new ArrayList<CrmsChannelSendDomain>();
            CrmsChannelSendDomain crmsChannelSendDomain = new CrmsChannelSendDomain();
            crmsChannelSendDomain.setChannelsendOpcode(crmsSOrder.getSorderCode());
            crmsChannelSendDomain.setChannelsendType("crmsSOrder");
            crmsChannelSendDomain.setChannelsendDir("audit");
            crmsChannelSendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)crmsSOrder));
            crmsChannelSendDomain.setTenantCode(crmsSOrder.getTenantCode());
            crmsChannelSendDomainList.add(crmsChannelSendDomain);
            List<CrmsChannelSend> crmsChannelSendList = this.crmsChannelSendService.saveChannelSendBatch(crmsChannelSendDomainList);
            if (ListUtil.isNotEmpty(crmsChannelSendList)) {
                CrmsChannelSendServiceImpl.getSendService().addPutPool(new SendPutThread(CrmsChannelSendServiceImpl.getSendService(), crmsChannelSendList));
            }
        }
        return "success";
    }
}

