/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crms.service.impl;

import com.yqbsoft.laser.service.crms.dao.CrmsSOrderMapper;
import com.yqbsoft.laser.service.crms.domain.CrmsChannelSendDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsSOrderDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsSOrderGoodsDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsSOrderReDomain;
import com.yqbsoft.laser.service.crms.model.CrmsChannelSend;
import com.yqbsoft.laser.service.crms.model.CrmsSOrder;
import com.yqbsoft.laser.service.crms.service.CrmsChannelSendService;
import com.yqbsoft.laser.service.crms.service.CrmsSOrderGoodsService;
import com.yqbsoft.laser.service.crms.service.CrmsSOrderService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrmsSOrderServiceImpl
extends BaseServiceImpl
implements CrmsSOrderService {
    private static final String SYS_CODE = "service.crms.CrmsSOrderServiceImpl";
    private CrmsSOrderMapper crmsSOrderMapper;
    private CrmsSOrderGoodsService crmsSOrderGoodsService;
    private CrmsChannelSendService crmsChannelSendService;

    public CrmsChannelSendService getCrmsChannelSendService() {
        return this.crmsChannelSendService;
    }

    public void setCrmsChannelSendService(CrmsChannelSendService crmsChannelSendService) {
        this.crmsChannelSendService = crmsChannelSendService;
    }

    public CrmsSOrderGoodsService getCrmsSOrderGoodsService() {
        return this.crmsSOrderGoodsService;
    }

    public void setCrmsSOrderGoodsService(CrmsSOrderGoodsService crmsSOrderGoodsService) {
        this.crmsSOrderGoodsService = crmsSOrderGoodsService;
    }

    public void setCrmsSOrderMapper(CrmsSOrderMapper crmsSOrderMapper) {
        this.crmsSOrderMapper = crmsSOrderMapper;
    }

    private Date getSysDate() {
        try {
            return this.crmsSOrderMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSOrder(CrmsSOrderDomain crmsSOrderDomain) {
        if (null == crmsSOrderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crmsSOrderDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSOrderDefault(CrmsSOrder crmsSOrder) {
        if (null == crmsSOrder) {
            return;
        }
        if (null == crmsSOrder.getDataState()) {
            crmsSOrder.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crmsSOrder.getGmtCreate()) {
            crmsSOrder.setGmtCreate(date);
        }
        crmsSOrder.setGmtModified(date);
        if (StringUtils.isBlank((String)crmsSOrder.getSorderCode())) {
            crmsSOrder.setSorderCode(this.getNo(null, "CrmsSOrder", "crmsSOrder", crmsSOrder.getTenantCode()));
        }
    }

    private int getSOrderMaxCode() {
        int code = 0;
        try {
            return this.crmsSOrderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.getSOrderMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSOrderUpdataDefault(CrmsSOrder crmsSOrder) {
        if (null == crmsSOrder) {
            return;
        }
        crmsSOrder.setGmtModified(this.getSysDate());
    }

    private void saveSOrderModel(CrmsSOrder crmsSOrder) throws ApiException {
        if (null == crmsSOrder) {
            return;
        }
        try {
            this.crmsSOrderMapper.insert(crmsSOrder);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.saveSOrderModel.ex", (Throwable)e);
        }
    }

    private void saveSOrderBatchModel(List<CrmsSOrder> crmsSOrderList) throws ApiException {
        if (null == crmsSOrderList || crmsSOrderList.isEmpty()) {
            return;
        }
        try {
            this.crmsSOrderMapper.insertBatch(crmsSOrderList);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.saveSOrderBatchModel.ex", (Throwable)e);
        }
    }

    private CrmsSOrder getSOrderModelById(Integer sorderId) {
        if (null == sorderId) {
            return null;
        }
        try {
            return this.crmsSOrderMapper.selectByPrimaryKey(sorderId);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.getSOrderModelById", (Throwable)e);
            return null;
        }
    }

    private CrmsSOrder getSOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crmsSOrderMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.getSOrderModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.delSOrderModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.delSOrderModelByCode.num");
        }
    }

    private void deleteSOrderModel(Integer sorderId) throws ApiException {
        if (null == sorderId) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.deleteByPrimaryKey(sorderId);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.deleteSOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.deleteSOrderModel.num");
        }
    }

    private void updateSOrderModel(CrmsSOrder crmsSOrder) throws ApiException {
        if (null == crmsSOrder) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.updateByPrimaryKey(crmsSOrder);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateSOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateSOrderModel.num");
        }
    }

    private void updateByPrimaryKeySelective(CrmsSOrder crmsSOrder) throws ApiException {
        if (null == crmsSOrder) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.updateByPrimaryKeySelective(crmsSOrder);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateByPrimaryKeySelective.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateByPrimaryKeySelective.num");
        }
    }

    private void updateStateSOrderModel(Integer sorderId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == sorderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sorderId", sorderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateStateSOrderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateStateSOrderModel.null");
        }
    }

    private void updateStateSOrderModelByCode(String tenantCode, String sorderCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)sorderCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sorderCode", sorderCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateStateSOrderModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateStateSOrderModelByCode.null");
        }
    }

    private CrmsSOrder makeSOrder(CrmsSOrderDomain crmsSOrderDomain, CrmsSOrder crmsSOrder) {
        if (null == crmsSOrderDomain) {
            return null;
        }
        if (null == crmsSOrder) {
            crmsSOrder = new CrmsSOrder();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crmsSOrder, (Object)crmsSOrderDomain);
            return crmsSOrder;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.makeSOrder", (Throwable)e);
            return null;
        }
    }

    private CrmsSOrderReDomain makeCrmsSOrderReDomain(CrmsSOrder crmsSOrder) {
        if (null == crmsSOrder) {
            return null;
        }
        CrmsSOrderReDomain crmsSOrderReDomain = new CrmsSOrderReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crmsSOrderReDomain, (Object)crmsSOrder);
            return crmsSOrderReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.makeCrmsSOrderReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrmsSOrder> querySOrderModelPage(Map<String, Object> parammap) {
        try {
            return this.crmsSOrderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.querySOrderModel", (Throwable)e);
            return null;
        }
    }

    private int countSOrder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crmsSOrderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.countSOrder", (Throwable)e);
        }
        return i;
    }

    private CrmsSOrder createCrmsSOrder(CrmsSOrderDomain crmsSOrderDomain) {
        String msg = this.checkSOrder(crmsSOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.saveSOrder.checkSOrder", msg);
        }
        CrmsSOrder crmsSOrder = this.makeSOrder(crmsSOrderDomain, null);
        this.setSOrderDefault(crmsSOrder);
        return crmsSOrder;
    }

    @Override
    public List<CrmsChannelSend> saveSOrder(CrmsSOrderDomain crmsSOrderDomain) throws ApiException {
        CrmsSOrder crmsSOrder = this.createCrmsSOrder(crmsSOrderDomain);
        this.saveSOrderModel(crmsSOrder);
        this.saveOrderGoodsList(crmsSOrderDomain.getCrmsSOrderGoodsDomainList(), crmsSOrder);
        ArrayList<CrmsSOrder> list = new ArrayList<CrmsSOrder>();
        list.add(crmsSOrder);
        return this.buildChannelSend(list, "insert");
    }

    private void saveOrderGoodsList(List<CrmsSOrderGoodsDomain> crmsSOrderGoodsDomainList, CrmsSOrder crmsSOrder) {
        if (crmsSOrderGoodsDomainList == null || crmsSOrderGoodsDomainList.isEmpty()) {
            return;
        }
        for (CrmsSOrderGoodsDomain crmsSOrderGoodsDomain : crmsSOrderGoodsDomainList) {
            crmsSOrderGoodsDomain.setCorderCode(crmsSOrder.getSorderCode());
            crmsSOrderGoodsDomain.setTenantCode(crmsSOrder.getTenantCode());
            crmsSOrderGoodsDomain.setMemberBcode(crmsSOrder.getMemberBcode());
            crmsSOrderGoodsDomain.setMemberBname(crmsSOrder.getMemberBname());
            if (StringUtils.isBlank((String)crmsSOrderGoodsDomain.getContractGoodsGtype())) {
                crmsSOrderGoodsDomain.setContractGoodsGtype("0");
            }
            if (null == crmsSOrderGoodsDomain.getContractGoodsType()) {
                crmsSOrderGoodsDomain.setContractGoodsType(0);
            }
            if (null == crmsSOrder) continue;
            if (StringUtils.isBlank((String)crmsSOrderGoodsDomain.getMemberCcode()) && StringUtils.isNotBlank((String)crmsSOrder.getMemberCcode())) {
                crmsSOrderGoodsDomain.setMemberCcode(crmsSOrder.getMemberCcode());
                crmsSOrderGoodsDomain.setMemberCname(crmsSOrder.getMemberCname());
            }
            crmsSOrderGoodsDomain.setMemberCode(crmsSOrder.getMemberCode());
            crmsSOrderGoodsDomain.setMemberName(crmsSOrder.getMemberName());
        }
        this.crmsSOrderGoodsService.saveSOrderGoodsBatch(crmsSOrderGoodsDomainList);
    }

    @Override
    public List<CrmsChannelSend> saveSOrderBatch(List<CrmsSOrderDomain> crmsSOrderDomainList) throws ApiException {
        if (null == crmsSOrderDomainList || crmsSOrderDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrmsChannelSend> crmsChannelSendList = new ArrayList<CrmsChannelSend>();
        for (CrmsSOrderDomain crmsSOrderDomain : crmsSOrderDomainList) {
            List<CrmsChannelSend> list = this.saveSOrder(crmsSOrderDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            crmsChannelSendList.addAll(list);
        }
        return crmsChannelSendList;
    }

    @Override
    public void updateSOrderState(Integer sorderId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == sorderId) {
            return;
        }
        this.updateStateSOrderModel(sorderId, dataState, oldDataState, map);
    }

    @Override
    public void updateSOrderStateByCode(String tenantCode, String sorderCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)sorderCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSOrderModelByCode(tenantCode, sorderCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSOrder(CrmsSOrderDomain crmsSOrderDomain) throws ApiException {
        this.logger.error("service.crms.CrmsSOrderServiceImpl.updateSOrder", (Object)JsonUtil.buildNormalBinder().toJson((Object)crmsSOrderDomain));
        String msg = this.checkSOrder(crmsSOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateSOrder.checkSOrder", msg);
        }
        CrmsSOrder oldCrmsSOrder = this.getSOrderModelById(crmsSOrderDomain.getSorderId());
        if (null == oldCrmsSOrder) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateSOrder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (crmsSOrderDomain.getContractValidate() != null && StringUtils.isNotBlank((String)crmsSOrderDomain.getAreaName())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("date", crmsSOrderDomain.getContractValidate());
            map.put("remark", crmsSOrderDomain.getAreaName());
            String memo = JsonUtil.buildNonNullBinder().toJson(map);
            CrmsSOrder crmsSOrder = new CrmsSOrder();
            if (StringUtils.isNotBlank((String)oldCrmsSOrder.getMemo())) {
                crmsSOrder.setMemo(oldCrmsSOrder.getMemo() + "," + memo);
            } else {
                crmsSOrder.setMemo(memo);
            }
            crmsSOrder.setSorderId(crmsSOrderDomain.getSorderId());
            this.setSOrderUpdataDefault(crmsSOrder);
            this.updateByPrimaryKeySelective(crmsSOrder);
        } else {
            CrmsSOrder crmsSOrder = this.makeSOrder(crmsSOrderDomain, oldCrmsSOrder);
            this.setSOrderUpdataDefault(crmsSOrder);
            this.updateSOrderModel(crmsSOrder);
        }
    }

    @Override
    public CrmsSOrder getSOrder(Integer sorderId) {
        if (null == sorderId) {
            return null;
        }
        return this.getSOrderModelById(sorderId);
    }

    @Override
    public void deleteSOrder(Integer sorderId) throws ApiException {
        if (null == sorderId) {
            return;
        }
        this.deleteSOrderModel(sorderId);
    }

    @Override
    public QueryResult<CrmsSOrder> querySOrderPage(Map<String, Object> map) {
        List<CrmsSOrder> crmsSOrderList = this.querySOrderModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSOrder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crmsSOrderList);
        return queryResult;
    }

    @Override
    public CrmsSOrder getSOrderByCode(String tenantCode, String sorderCode) throws ApiException {
        if (StringUtils.isBlank((String)sorderCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sorderCode", sorderCode);
        return this.getSOrderModelByCode(map);
    }

    @Override
    public void deleteSOrderByCode(String tenantCode, String sorderCode) throws ApiException {
        if (StringUtils.isBlank((String)sorderCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sorderCode", sorderCode);
        this.delSOrderModelByCode(map);
    }

    private List<CrmsChannelSend> buildChannelSend(List<CrmsSOrder> crmsSOrderList, String dri) {
        if (ListUtil.isEmpty(crmsSOrderList)) {
            return null;
        }
        ArrayList<CrmsChannelSend> crmsChannelSendList = new ArrayList();
        ArrayList<CrmsChannelSendDomain> disChannelsendDomainList = new ArrayList<CrmsChannelSendDomain>();
        for (CrmsSOrder crmsSOrder : crmsSOrderList) {
            CrmsChannelSendDomain pmChannelsendDomain = new CrmsChannelSendDomain();
            pmChannelsendDomain.setChannelsendOpcode(crmsSOrder.getSorderCode());
            pmChannelsendDomain.setChannelsendType("crmsSOrder");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)crmsSOrder));
            pmChannelsendDomain.setTenantCode(crmsSOrder.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        crmsChannelSendList = this.crmsChannelSendService.saveChannelSendBatch(disChannelsendDomainList);
        return crmsChannelSendList;
    }
}

