/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crms.service.impl;

import com.yqbsoft.laser.service.crms.CrmServerConstants;
import com.yqbsoft.laser.service.crms.dao.CrmsSOrderMapper;
import com.yqbsoft.laser.service.crms.domain.CrmsChannelSendDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsSOrderDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsSOrderGoodsDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsSOrderReDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsURechargeDomain;
import com.yqbsoft.laser.service.crms.domain.OcContractReDomain;
import com.yqbsoft.laser.service.crms.domain.PackageDomain;
import com.yqbsoft.laser.service.crms.domain.RsResourceGoodsDomain;
import com.yqbsoft.laser.service.crms.domain.RsSkuDomain;
import com.yqbsoft.laser.service.crms.enums.OrderStateEnums;
import com.yqbsoft.laser.service.crms.model.CrmsChannelSend;
import com.yqbsoft.laser.service.crms.model.CrmsSOrder;
import com.yqbsoft.laser.service.crms.model.CrmsSOrderGoods;
import com.yqbsoft.laser.service.crms.model.CrmsURecharge;
import com.yqbsoft.laser.service.crms.service.CrmsChannelSendService;
import com.yqbsoft.laser.service.crms.service.CrmsSOrderGoodsService;
import com.yqbsoft.laser.service.crms.service.CrmsSOrderService;
import com.yqbsoft.laser.service.crms.service.CrmsURechargeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.json.JSONArray;
import com.yqbsoft.laser.service.tool.json.JSONObject;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.MapUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrmsSOrderServiceImpl
extends BaseServiceImpl
implements CrmsSOrderService {
    private static final String SYS_CODE = "service.crms.CrmsSOrderServiceImpl";
    private CrmsSOrderMapper crmsSOrderMapper;
    private CrmsSOrderGoodsService crmsSOrderGoodsService;
    private CrmsChannelSendService crmsChannelSendService;
    private CrmsURechargeService crmsURechargeService;

    public CrmsChannelSendService getCrmsChannelSendService() {
        return this.crmsChannelSendService;
    }

    public void setCrmsChannelSendService(CrmsChannelSendService crmsChannelSendService) {
        this.crmsChannelSendService = crmsChannelSendService;
    }

    public CrmsSOrderGoodsService getCrmsSOrderGoodsService() {
        return this.crmsSOrderGoodsService;
    }

    public void setCrmsSOrderGoodsService(CrmsSOrderGoodsService crmsSOrderGoodsService) {
        this.crmsSOrderGoodsService = crmsSOrderGoodsService;
    }

    public CrmsURechargeService getCrmsURechargeService() {
        return this.crmsURechargeService;
    }

    public void setCrmsURechargeService(CrmsURechargeService crmsURechargeService) {
        this.crmsURechargeService = crmsURechargeService;
    }

    public void setCrmsSOrderMapper(CrmsSOrderMapper crmsSOrderMapper) {
        this.crmsSOrderMapper = crmsSOrderMapper;
    }

    private Date getSysDate() {
        try {
            return this.crmsSOrderMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSOrder(CrmsSOrderDomain crmsSOrderDomain) {
        if (null == crmsSOrderDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crmsSOrderDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSOrderDefault(CrmsSOrder crmsSOrder) {
        if (null == crmsSOrder) {
            return;
        }
        if (null != crmsSOrder.getDataStatestr()) {
            crmsSOrder.setDataState(Integer.valueOf(crmsSOrder.getDataStatestr()));
        }
        if (null == crmsSOrder.getDataState()) {
            crmsSOrder.setDataState(0);
        }
        if (null == crmsSOrder.getContractState()) {
            crmsSOrder.setContractState(CrmServerConstants.CONTRACT_STATE_0);
        }
        Date date = this.getSysDate();
        if (null == crmsSOrder.getGmtCreate()) {
            crmsSOrder.setGmtCreate(date);
        }
        crmsSOrder.setGmtModified(date);
        if (StringUtils.isBlank((String)crmsSOrder.getSorderCode())) {
            crmsSOrder.setSorderCode(this.getDateNo() + this.getNo(null, "CrmsSOrder", "crmsSOrder", crmsSOrder.getTenantCode()));
        }
    }

    private String getDateNo() {
        return new SimpleDateFormat("yyMMdd").format(new Date());
    }

    private int getSOrderMaxCode() {
        int code = 0;
        try {
            return this.crmsSOrderMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.getSOrderMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSOrderUpdataDefault(CrmsSOrder crmsSOrder) {
        if (null == crmsSOrder) {
            return;
        }
        crmsSOrder.setGmtModified(this.getSysDate());
    }

    private void saveSOrderModel(CrmsSOrder crmsSOrder) throws ApiException {
        if (null == crmsSOrder) {
            return;
        }
        try {
            this.crmsSOrderMapper.insert(crmsSOrder);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.saveSOrderModel.ex", (Throwable)e);
        }
    }

    private void saveSOrderBatchModel(List<CrmsSOrder> crmsSOrderList) throws ApiException {
        if (null == crmsSOrderList || crmsSOrderList.isEmpty()) {
            return;
        }
        try {
            this.crmsSOrderMapper.insertBatch(crmsSOrderList);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.saveSOrderBatchModel.ex", (Throwable)e);
        }
    }

    private CrmsSOrder getSOrderModelById(Integer sorderId) {
        if (null == sorderId) {
            return null;
        }
        try {
            return this.crmsSOrderMapper.selectByPrimaryKey(sorderId);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.getSOrderModelById", (Throwable)e);
            return null;
        }
    }

    private CrmsSOrder getSOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crmsSOrderMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.getSOrderModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSOrderModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.delSOrderModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.delSOrderModelByCode.num");
        }
    }

    private void deleteSOrderModel(Integer sorderId) throws ApiException {
        if (null == sorderId) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.deleteByPrimaryKey(sorderId);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.deleteSOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.deleteSOrderModel.num");
        }
    }

    private void updateSOrderModel(CrmsSOrder crmsSOrder) throws ApiException {
        if (null == crmsSOrder) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.updateByPrimaryKey(crmsSOrder);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateSOrderModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateSOrderModel.num");
        }
    }

    private void updateByPrimaryKeySelective(CrmsSOrder crmsSOrder) throws ApiException {
        if (null == crmsSOrder) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.updateByPrimaryKeySelective(crmsSOrder);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateByPrimaryKeySelective.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateByPrimaryKeySelective.num");
        }
    }

    private void updateStateSOrderModel(Integer sorderId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == sorderId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sorderId", sorderId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateStateSOrderModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateStateSOrderModel.null");
        }
    }

    private void updateStateSOrderModelByCode(String tenantCode, String sorderCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)sorderCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sorderCode", sorderCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsSOrderMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateStateSOrderModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateStateSOrderModelByCode.null");
        }
    }

    private CrmsSOrder makeSOrder(CrmsSOrderDomain crmsSOrderDomain, CrmsSOrder crmsSOrder) {
        if (null == crmsSOrderDomain) {
            return null;
        }
        if (null == crmsSOrder) {
            crmsSOrder = new CrmsSOrder();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)crmsSOrder, (Object)crmsSOrderDomain);
            return crmsSOrder;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.makeSOrder", (Throwable)e);
            return null;
        }
    }

    private CrmsSOrderReDomain makeCrmsSOrderReDomain(CrmsSOrder crmsSOrder) {
        if (null == crmsSOrder) {
            return null;
        }
        CrmsSOrderReDomain crmsSOrderReDomain = new CrmsSOrderReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crmsSOrderReDomain, (Object)crmsSOrder);
            return crmsSOrderReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.makeCrmsSOrderReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrmsSOrder> querySOrderModelPage(Map<String, Object> parammap) {
        try {
            return this.crmsSOrderMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.querySOrderModel", (Throwable)e);
            return null;
        }
    }

    private int countSOrder(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crmsSOrderMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderServiceImpl.countSOrder", (Throwable)e);
        }
        return i;
    }

    private CrmsSOrder createCrmsSOrder(CrmsSOrderDomain crmsSOrderDomain) {
        String msg = this.checkSOrder(crmsSOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.saveSOrder.checkSOrder", msg);
        }
        CrmsSOrder crmsSOrder = this.makeSOrder(crmsSOrderDomain, null);
        this.setYuShiOrderCode(crmsSOrder);
        this.setSOrderDefault(crmsSOrder);
        return crmsSOrder;
    }

    private void setYuShiOrderCode(CrmsSOrder crmsSOrderDomain) {
        if ("2020050600004084".equals(crmsSOrderDomain.getTenantCode())) {
            StringBuffer sb = new StringBuffer();
            if ("\u6d59\u6c5f\u5b87\u89c6\u79d1\u6280\u6709\u9650\u516c\u53f8".equals(crmsSOrderDomain.getGoodsSupplierName()) || "\u6d59\u6c5f\u5b87\u89c6\u7cfb\u7edf\u6280\u672f\u6709\u9650\u516c\u53f8".equals(crmsSOrderDomain.getGoodsSupplierName())) {
                sb.append("I");
            } else if ("UNV Technology USA LLC".equals(crmsSOrderDomain.getGoodsSupplierName())) {
                sb.append("U");
            } else if ("UNV Digital Technologies Company Limited".equals(crmsSOrderDomain.getGoodsSupplierName())) {
                sb.append("H");
            } else if ("\u041e\u0431\u0449\u0435\u0441\u0442\u0432\u043e \u0441 \u043e\u0433\u0440\u0430\u043d\u0438\u0447\u0435\u043d\u043d\u043e\u0439 \u043e\u0442\u0432\u0435\u0442\u0441\u0442\u0432\u0435\u043d\u043d\u043e\u0441\u0442\u044c\u044e".equals(crmsSOrderDomain.getGoodsSupplierName())) {
                sb.append("R");
            }
            sb.append("1564");
            sb.append(DateUtil.getDateString((Date)new Date(), (String)"yyMMdd"));
            sb.append("B");
            String orderCount = DisUtil.getDisCache().get(sb.toString());
            orderCount = StringUtils.isNotBlank((String)orderCount) ? Integer.valueOf(orderCount) + 1 + "" : "51";
            DisUtil.getDisCache().set(sb.toString(), orderCount, this.getRemainSecondsOneDay(new Date()).intValue());
            try {
                DecimalFormat df = new DecimalFormat("00");
                sb.append(df.format(Integer.parseInt(orderCount)));
            }
            catch (Exception e) {
                this.logger.error("service.crms.CrmsSOrderServiceImpl.setYuShiOrderCode.ex", (Object)e.getMessage());
            }
            crmsSOrderDomain.setCorderCode(sb.toString());
        }
    }

    private Integer getRemainSecondsOneDay(Date currentDate) {
        Calendar midnight = Calendar.getInstance();
        midnight.setTime(currentDate);
        midnight.add(5, 1);
        midnight.set(11, 0);
        midnight.set(12, 0);
        midnight.set(13, 0);
        midnight.set(14, 0);
        Integer seconds = (int)((midnight.getTime().getTime() - currentDate.getTime()) / 1000L);
        return seconds;
    }

    @Override
    public List<CrmsChannelSend> saveSOrder(CrmsSOrderDomain crmsSOrderDomain) throws ApiException {
        CrmsSOrder crmsSOrder = this.createCrmsSOrder(crmsSOrderDomain);
        this.saveSOrderModel(crmsSOrder);
        this.saveOrderGoodsList(crmsSOrderDomain.getCrmsSOrderGoodsDomainList(), crmsSOrder);
        if (crmsSOrderDomain.getPackageList() != null) {
            for (PackageDomain packageDomain : crmsSOrderDomain.getPackageList()) {
                HashMap<String, List<Integer>> map = new HashMap<String, List<Integer>>();
                map.put("idList", packageDomain.getShoppingGoodsIdList());
                try {
                    this.internalInvoke("oc.shopping.deleteShoppingGoodsBatch", map);
                }
                catch (Exception e) {
                    throw new ApiException("\u5220\u9664\u8d2d\u7269\u8f66\u5931\u8d25");
                }
            }
        }
        if (crmsSOrderDomain.getContractBillcode() != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("businessType", "exportInsert");
            if (!this.contractGoodsStockUpdate(crmsSOrderDomain, "SUB", map).equals("success")) {
                throw new ApiException("\u6263\u5e93\u5b58\u5931\u8d25");
            }
            String res = this.banShiChuMoney(crmsSOrder.getSorderCode(), crmsSOrder.getTenantCode(), "SUB", crmsSOrder.getContractMoney());
            crmsSOrder.setContractObillcode(res);
            this.updateByPrimaryKeySelective(crmsSOrder);
            if (crmsSOrder.getDataState() != 0) {
                return new ArrayList<CrmsChannelSend>();
            }
        }
        ArrayList<CrmsSOrder> list = new ArrayList<CrmsSOrder>();
        list.add(crmsSOrder);
        return this.buildChannelSend(list, "insert");
    }

    private void saveOrderGoodsList(List<CrmsSOrderGoodsDomain> crmsSOrderGoodsDomainList, CrmsSOrder crmsSOrder) {
        if (crmsSOrderGoodsDomainList == null || crmsSOrderGoodsDomainList.isEmpty()) {
            return;
        }
        for (CrmsSOrderGoodsDomain crmsSOrderGoodsDomain : crmsSOrderGoodsDomainList) {
            crmsSOrderGoodsDomain.setCorderCode(crmsSOrder.getSorderCode());
            crmsSOrderGoodsDomain.setTenantCode(crmsSOrder.getTenantCode());
            crmsSOrderGoodsDomain.setMemberBcode(crmsSOrder.getMemberBcode());
            crmsSOrderGoodsDomain.setMemberBname(crmsSOrder.getMemberBname());
            if (StringUtils.isBlank((String)crmsSOrderGoodsDomain.getContractGoodsGtype())) {
                crmsSOrderGoodsDomain.setContractGoodsGtype("0");
            }
            if (null == crmsSOrderGoodsDomain.getContractGoodsType()) {
                crmsSOrderGoodsDomain.setContractGoodsType(0);
            }
            if (null == crmsSOrder) continue;
            if (StringUtils.isBlank((String)crmsSOrderGoodsDomain.getMemberCcode()) && StringUtils.isNotBlank((String)crmsSOrder.getMemberCcode())) {
                crmsSOrderGoodsDomain.setMemberCcode(crmsSOrder.getMemberCcode());
                crmsSOrderGoodsDomain.setMemberCname(crmsSOrder.getMemberCname());
            }
            crmsSOrderGoodsDomain.setMemberCode(crmsSOrder.getMemberCode());
            crmsSOrderGoodsDomain.setMemberName(crmsSOrder.getMemberName());
        }
        this.crmsSOrderGoodsService.saveSOrderGoodsBatch(crmsSOrderGoodsDomainList);
    }

    @Override
    public List<CrmsChannelSend> saveSOrderBatch(List<CrmsSOrderDomain> crmsSOrderDomainList) throws ApiException {
        if (null == crmsSOrderDomainList || crmsSOrderDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrmsChannelSend> crmsChannelSendList = new ArrayList<CrmsChannelSend>();
        for (CrmsSOrderDomain crmsSOrderDomain : crmsSOrderDomainList) {
            List<CrmsChannelSend> list = this.saveSOrder(crmsSOrderDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            crmsChannelSendList.addAll(list);
        }
        return crmsChannelSendList;
    }

    @Override
    public void updateSOrderState(Integer sorderId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == sorderId) {
            return;
        }
        this.updateStateSOrderModel(sorderId, dataState, oldDataState, map);
    }

    @Override
    public void updateSOrderStateByCode(String tenantCode, String sorderCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)sorderCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSOrderModelByCode(tenantCode, sorderCode, dataState, oldDataState, map);
    }

    @Override
    public String returnOrderGoods(OcContractReDomain ocContractDomain) throws ApiException {
        this.logger.error("log >>> desc: returnOrderGoods{\u501f\u8d27\u5355\u5546\u54c1\u9000\u56de\u5f00\u59cb}=====");
        JSONArray contractGoods = this.queryContractGoods(ocContractDomain);
        if (contractGoods == null) {
            return "success";
        }
        for (JSONObject o : contractGoods) {
            BigDecimal goodsMoney = BigDecimal.ZERO;
            String sorderGoodsId = o.getString("skuBarcode");
            String contractGoodsNum = o.getString("goodsNum");
            String contractGoodsPrice = o.getString("contractGoodsPrice");
            CrmsSOrderGoods crmsSOrderGoods = this.crmsSOrderGoodsService.getSOrderGoods(Integer.valueOf(sorderGoodsId));
            crmsSOrderGoods.setGoodsAhnum(crmsSOrderGoods.getGoodsAhnum().subtract(new BigDecimal(contractGoodsNum)));
            crmsSOrderGoods.setGmtModified(this.getSysDate());
            CrmsSOrderGoodsDomain crmsSOrderGoodsDomain = new CrmsSOrderGoodsDomain();
            goodsMoney = new BigDecimal(contractGoodsNum).multiply(crmsSOrderGoods.getContractGoodsPrice());
            try {
                BeanUtils.copyAllPropertys((Object)crmsSOrderGoodsDomain, (Object)crmsSOrderGoods);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.crmsSOrderGoodsService.updateSOrderGoods(crmsSOrderGoodsDomain);
            this.updateSOrderStateByCode(crmsSOrderGoods.getTenantCode(), crmsSOrderGoods.getCorderCode(), CrmServerConstants.CRM_ORDER_STATE_2, null, null);
            this.banShiChuMoney(crmsSOrderGoods.getCorderCode(), crmsSOrderGoods.getTenantCode(), "SUB", goodsMoney);
        }
        this.logger.error("log >>> desc: returnOrderGoods{\u501f\u8d27\u5355\u5546\u54c1\u9000\u56de\u7ed3\u675f}=====");
        return "success";
    }

    @Override
    public String contractGoodsStockUpdate(CrmsSOrderDomain crmsSOrderDomain, String type, Map<String, Object> map) {
        this.logger.error("log >>> desc: contractGoodsStockUpdate params{}{\u501f\u8d27\u5355\u5546\u54c1\u66f4\u65b0\u5e93\u5b58\u5f00\u59cb}=====");
        ArrayList<Integer> goodsIdUpList = new ArrayList<Integer>();
        ArrayList<Integer> goodsIdDownList = new ArrayList<Integer>();
        ArrayList<RsSkuDomain> skuList = new ArrayList<RsSkuDomain>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        HashMap<String, String> sendMap = new HashMap<String, String>();
        List<CrmsSOrderGoodsDomain> ocContractGoodsList = null;
        if (crmsSOrderDomain != null) {
            ocContractGoodsList = crmsSOrderDomain.getCrmsSOrderGoodsDomainList();
        }
        if (ocContractGoodsList == null) {
            ocContractGoodsList = this.queryContractGoodsDomainList(map.get("sorderCode").toString(), map.get("tenantCode").toString());
        }
        for (CrmsSOrderGoodsDomain ocContractGoodsDomain : ocContractGoodsList) {
            if ("hangzhou".equals(ocContractGoodsDomain.getWarehouseCode())) continue;
            paramMap.put("skuCode", ocContractGoodsDomain.getSkuCode());
            paramMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            String rsSku = this.internalInvoke("rs.sku.getSkuByCode", sendMap);
            RsSkuDomain rsSkuReDomain = (RsSkuDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsSku, RsSkuDomain.class);
            if (null == rsSkuReDomain) continue;
            BigDecimal goodsStockUpdateNum = ocContractGoodsDomain.getGoodsCamount();
            BigDecimal goodsStockNumOld = rsSkuReDomain.getGoodsSupplynum();
            BigDecimal goodsStockNumNew = BigDecimal.ZERO;
            if (map.get("businessType") != null && map.get("businessType").toString().equals("exportInsert")) {
                goodsStockUpdateNum = ocContractGoodsDomain.getGoodsCamount().subtract(ocContractGoodsDomain.getContractGoodsSendnum());
            }
            if ("SUB".equals(type)) {
                if (goodsStockUpdateNum.compareTo(goodsStockNumOld) > 0) {
                    return "\u5e93\u5b58\u4e0d\u8db3:" + rsSkuReDomain.getSkuShowno();
                }
                goodsStockNumNew = goodsStockNumOld.subtract(goodsStockUpdateNum);
            } else if ("ADD".equals(type)) {
                goodsStockNumNew = goodsStockNumOld.add(goodsStockUpdateNum);
            } else {
                return "false";
            }
            rsSkuReDomain.setGoodsSupplynum(goodsStockNumNew);
            skuList.add(rsSkuReDomain);
            paramMap.clear();
            paramMap.put("goodsCode", rsSkuReDomain.getGoodsCode());
            paramMap.put("tenantCode", ocContractGoodsDomain.getTenantCode());
            sendMap.clear();
            sendMap.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
            String rsResourceGoods = this.internalInvoke("rs.resourceGoods.getResourceGoodsByCode", sendMap);
            RsResourceGoodsDomain rsResourceGoodsDomain = (RsResourceGoodsDomain)JsonUtil.buildNormalBinder().getJsonToObject(rsResourceGoods, RsResourceGoodsDomain.class);
            if (null == rsResourceGoodsDomain) continue;
            if ("1".equals(String.valueOf(rsResourceGoodsDomain.getDataOpbillstate()))) {
                goodsIdDownList.add(rsResourceGoodsDomain.getGoodsId());
            }
            goodsIdUpList.add(rsResourceGoodsDomain.getGoodsId());
        }
        if (ListUtil.isNotEmpty(skuList)) {
            if (ListUtil.isNotEmpty(skuList)) {
                paramMap.clear();
                paramMap.put("skuList", JsonUtil.buildNormalBinder().toJson(skuList));
                this.internalInvoke("rs.sku.updateSkuList", paramMap);
            }
            paramMap.clear();
            paramMap.put("goodsIds", JsonUtil.buildNormalBinder().toJson(goodsIdUpList));
            this.internalInvoke("rs.resource.sendUpdateSoldOutGoods", paramMap);
            paramMap.clear();
            paramMap.put("goodsIds", JsonUtil.buildNormalBinder().toJson(goodsIdUpList));
            this.internalInvoke("rs.resource.sendUpdateShelveGoods", paramMap);
            this.logger.error("log >>> desc: updateAuditCall.otherOperations {\u501f\u8d27\u5355\u5904\u7406\u56de\u9000\u5e93\u5b58es}======");
        }
        return "success";
    }

    private List<CrmsSOrderGoodsDomain> queryContractGoodsDomainList(String sorderCode, String tenantCode) {
        ArrayList<CrmsSOrderGoodsDomain> ocContractGoodsList = new ArrayList<CrmsSOrderGoodsDomain>();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("corderCode", sorderCode);
        map.put("tenantCode", tenantCode);
        List crmsSOrderGoodsList = this.crmsSOrderGoodsService.querySOrderGoodsPage(map).getList();
        for (CrmsSOrderGoods crmsSOrderGoods : crmsSOrderGoodsList) {
            CrmsSOrderGoodsDomain crmsSOrderGoodsDomain = new CrmsSOrderGoodsDomain();
            try {
                BeanUtils.copyAllPropertys((Object)crmsSOrderGoodsDomain, (Object)crmsSOrderGoods);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ocContractGoodsList.add(crmsSOrderGoodsDomain);
        }
        return ocContractGoodsList;
    }

    public JSONArray queryContractGoods(OcContractReDomain ocContractDomain) {
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> mapS = new HashMap<String, String>();
        map.put("contractBillcode", ocContractDomain.getContractBillcode());
        map.put("goodsPro", "2");
        map.put("tenantCode", ocContractDomain.getTenantCode());
        mapS.put("map", JsonUtil.buildNormalBinder().toJson(map));
        String queryResultJson = this.internalInvoke("oc.contract.queryContractGoodsPage", mapS);
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(queryResultJson, QueryResult.class);
        if (queryResult.getList() == null || queryResult.getList().isEmpty()) {
            return null;
        }
        return JSONArray.json2array((String)JsonUtil.buildNonDefaultBinder().toJson((Object)queryResult.getList()));
    }

    @Override
    public List<CrmsChannelSend> updateSOrder(CrmsSOrderDomain crmsSOrderDomain) throws ApiException {
        this.logger.error("log >>> desc: updateSOrder params {}{\u8ba2\u5355\u4fee\u6539}=====");
        this.logger.error("service.crms.CrmsSOrderServiceImpl.updateSOrder", (Object)JsonUtil.buildNormalBinder().toJson((Object)crmsSOrderDomain));
        String msg = this.checkSOrder(crmsSOrderDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateSOrder.checkSOrder", msg);
        }
        CrmsSOrder oldCrmsSOrder = this.getSOrderModelById(crmsSOrderDomain.getSorderId());
        if (null == oldCrmsSOrder) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.updateSOrder.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        if (crmsSOrderDomain.getContractValidate() != null && StringUtils.isNotBlank((String)crmsSOrderDomain.getAreaName())) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("date", crmsSOrderDomain.getContractValidate());
            map.put("remark", crmsSOrderDomain.getAreaName());
            String memo = JsonUtil.buildNonNullBinder().toJson(map);
            CrmsSOrder crmsSOrder = new CrmsSOrder();
            if (StringUtils.isNotBlank((String)oldCrmsSOrder.getMemo())) {
                crmsSOrder.setMemo(oldCrmsSOrder.getMemo() + "," + memo);
            } else {
                crmsSOrder.setMemo(memo);
            }
            crmsSOrder.setSorderId(crmsSOrderDomain.getSorderId());
            crmsSOrder.setDataState(OrderStateEnums.RENEW_IN_AUDIT.getCode());
            this.setSOrderUpdataDefault(crmsSOrder);
            this.updateByPrimaryKeySelective(crmsSOrder);
            ArrayList<CrmsSOrder> list = new ArrayList<CrmsSOrder>();
            oldCrmsSOrder.setMemo(crmsSOrder.getMemo());
            oldCrmsSOrder.setGmtModified(crmsSOrder.getGmtModified());
            list.add(oldCrmsSOrder);
            return this.buildChannelSend(list, "insert");
        }
        this.logger.error("log >>> desc: updateSOrder params {}{\u91cd\u65b0\u63d0\u4ea4}=====");
        CrmsSOrder crmsSOrder = this.makeSOrder(crmsSOrderDomain, oldCrmsSOrder);
        crmsSOrder.setDataState(OrderStateEnums.IN_AUDIT.getCode());
        this.setSOrderUpdataDefault(crmsSOrder);
        this.updateSOrderModel(crmsSOrder);
        this.orderOtherHandel(crmsSOrder);
        ArrayList<CrmsSOrder> list = new ArrayList<CrmsSOrder>();
        list.add(oldCrmsSOrder);
        return this.buildChannelSend(list, "repeat");
    }

    public String orderOtherHandel(CrmsSOrder crmsSOrder) {
        HashMap<String, Object> mapC = new HashMap<String, Object>();
        mapC.put("sorderCode", crmsSOrder.getSorderCode());
        mapC.put("tenantCode", crmsSOrder.getTenantCode());
        String res = this.contractGoodsStockUpdate(null, "SUB", mapC);
        if (!"success".equals(res)) {
            throw new ApiException(res);
        }
        this.banShiChuMoney(crmsSOrder, "SUB");
        return "success";
    }

    public String banShiChuMoney(String sOrderCode, String tenantCode, String type, BigDecimal goodsMoney) {
        JSONArray jsonObjects;
        String res = "NO";
        CrmsSOrder crmsSOrder = this.getSOrderByCode(tenantCode, sOrderCode);
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", tenantCode);
        paramMap.put("userinfoCode", crmsSOrder.getMemberBcode());
        paramMap.put("userinfoQuaKey", "depName");
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String result = this.internalInvoke("um.userinfoQua.queryUserinfoQuaList", map);
        if (StringUtils.isNotBlank((String)result) && (jsonObjects = JSONArray.json2array((String)result)) != null && jsonObjects.size() > 0) {
            JSONObject domain = jsonObjects.get(0);
            BigDecimal priceSetCurrency = BigDecimal.ONE;
            if (crmsSOrder.getPricesetCurrency() != null) {
                priceSetCurrency = new BigDecimal(crmsSOrder.getPricesetCurrency());
            }
            goodsMoney = goodsMoney.divide(priceSetCurrency, 8, 0);
            CrmsURecharge crmsURecharge = this.crmsURechargeService.getURechargeByUserInfoCode(crmsSOrder.getTenantCode(), domain.getString("userinfoQuaVaule1"));
            res = crmsURecharge.getRechargeSmoney().compareTo(goodsMoney) >= 0 ? "NO" : "YES";
            if (type != null && "SUB".equals(type)) {
                goodsMoney = goodsMoney.multiply(new BigDecimal("-1"));
            }
            CrmsURechargeDomain crmsURechargeDomain = new CrmsURechargeDomain();
            crmsURechargeDomain.setUrechargeId(crmsURecharge.getUrechargeId());
            crmsURechargeDomain.setRechargeSmoney(goodsMoney);
            crmsURechargeDomain.setOrderCode(crmsSOrder.getSorderCode());
            crmsURechargeDomain.setTenantCode(crmsURecharge.getTenantCode());
            this.crmsURechargeService.updateURecharge(crmsURechargeDomain);
            this.logger.error("log >>> debug: banShiChuMoney params{goodsMoney}=====", (Object)goodsMoney);
        }
        return res;
    }

    public void banShiChuMoney(CrmsSOrder crmsSOrder, String type) {
        JSONArray jsonObjects;
        HashMap<String, String> map = new HashMap<String, String>();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tenantCode", crmsSOrder.getTenantCode());
        paramMap.put("userinfoCode", crmsSOrder.getMemberBcode());
        paramMap.put("userinfoQuaKey", "depName");
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String result = this.internalInvoke("um.userinfoQua.queryUserinfoQuaList", map);
        if (StringUtils.isNotBlank((String)result) && (jsonObjects = JSONArray.json2array((String)result)) != null && jsonObjects.size() > 0) {
            JSONObject domain = jsonObjects.get(0);
            BigDecimal priceSetCurrency = BigDecimal.ONE;
            BigDecimal contractMoney = BigDecimal.ZERO;
            if (crmsSOrder.getPricesetCurrency() != null) {
                priceSetCurrency = new BigDecimal(crmsSOrder.getPricesetCurrency());
            }
            contractMoney = crmsSOrder.getContractMoney().divide(priceSetCurrency, 8, 0);
            if (type != null && "SUB".equals(type)) {
                contractMoney = contractMoney.multiply(new BigDecimal("-1"));
            }
            CrmsURecharge crmsURecharge = this.crmsURechargeService.getURechargeByUserInfoCode(crmsSOrder.getTenantCode(), domain.getString("userinfoQuaVaule1"));
            CrmsURechargeDomain crmsURechargeDomain = new CrmsURechargeDomain();
            crmsURechargeDomain.setUrechargeId(crmsURecharge.getUrechargeId());
            crmsURechargeDomain.setRechargeSmoney(contractMoney);
            crmsURechargeDomain.setOrderCode(crmsSOrder.getSorderCode());
            crmsURechargeDomain.setTenantCode(crmsURecharge.getTenantCode());
            this.crmsURechargeService.updateURecharge(crmsURechargeDomain);
        }
    }

    @Override
    public List<CrmsChannelSend> cancelCrmsSOrder(Map<String, Object> paramMap) throws ApiException {
        if (MapUtil.isEmpty(paramMap)) {
            throw new ApiException("service.crms.CrmsSOrderServiceImpl.cancelCrmsSOrder", "\u53c2\u6570\u4e3a\u7a7a");
        }
        String sorderId = paramMap.get("sorderId").toString();
        CrmsSOrder crmsSOrder = this.getSOrderModelById(Integer.parseInt(sorderId));
        Object crmsOrderGoods = paramMap.get("crmsOrderGoods");
        if (crmsOrderGoods != null && StringUtils.isNotBlank((String)crmsOrderGoods.toString())) {
            List crmsSOrderGoodsList = (List)JsonUtil.buildNormalBinder().getJsonToList(crmsOrderGoods.toString(), CrmsSOrderGoodsDomain.class);
            crmsSOrder.setCrmsSOrderGoodsDomainList(crmsSOrderGoodsList);
        }
        ArrayList<CrmsSOrder> list = new ArrayList<CrmsSOrder>();
        crmsSOrder.setGoodsPbillno(paramMap.get("memo").toString());
        crmsSOrder.setGmtModified(new Date());
        list.add(crmsSOrder);
        this.updateSOrderState(crmsSOrder.getSorderId(), OrderStateEnums.CANCEL.getCode(), null, null);
        return this.buildChannelSend(list, "cancel");
    }

    @Override
    public List<CrmsChannelSend> returnOrderGoods(Map<String, Object> paramMap) throws ApiException {
        Object crmsSOrderReDomainStr = paramMap.get("crmsSOrderReDomain");
        CrmsSOrder crmsSOrder = new CrmsSOrder();
        if (crmsSOrderReDomainStr != null && StringUtils.isNotBlank((String)JsonUtil.buildNormalBinder().toJson(crmsSOrderReDomainStr))) {
            crmsSOrder = (CrmsSOrder)JsonUtil.buildNormalBinder().getJsonToObject(JsonUtil.buildNormalBinder().toJson(crmsSOrderReDomainStr), CrmsSOrder.class);
        }
        ArrayList<CrmsSOrder> list = new ArrayList<CrmsSOrder>();
        list.add(crmsSOrder);
        this.updateSOrderState(crmsSOrder.getSorderId(), OrderStateEnums.RETURN.getCode(), null, null);
        return this.buildChannelSend(list, "return");
    }

    @Override
    public CrmsSOrder getSOrder(Integer sorderId) {
        if (null == sorderId) {
            return null;
        }
        return this.getSOrderModelById(sorderId);
    }

    @Override
    public void deleteSOrder(Integer sorderId) throws ApiException {
        if (null == sorderId) {
            return;
        }
        this.deleteSOrderModel(sorderId);
    }

    @Override
    public QueryResult<CrmsSOrder> querySOrderPage(Map<String, Object> map) {
        List<CrmsSOrder> crmsSOrderList = this.querySOrderModelPage(map);
        if (map.containsKey("childrenFlag")) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            for (CrmsSOrder crmsSOrder : crmsSOrderList) {
                paramMap.clear();
                paramMap.put("sorderCode", crmsSOrder.getSorderCode());
                paramMap.put("tenantCode", crmsSOrder.getTenantCode());
                List list = this.crmsSOrderGoodsService.querySOrderGoodsPage(paramMap).getList();
                List domains = (List)JsonUtil.buildNonDefaultBinder().getJsonToList(JsonUtil.buildNonDefaultBinder().toJson((Object)list), CrmsSOrderGoodsDomain.class);
                crmsSOrder.setCrmsSOrderGoodsDomainList(domains);
            }
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSOrder(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crmsSOrderList);
        return queryResult;
    }

    @Override
    public CrmsSOrder getSOrderByCode(String tenantCode, String sorderCode) throws ApiException {
        if (StringUtils.isBlank((String)sorderCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sorderCode", sorderCode);
        return this.getSOrderModelByCode(map);
    }

    @Override
    public void deleteSOrderByCode(String tenantCode, String sorderCode) throws ApiException {
        if (StringUtils.isBlank((String)sorderCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sorderCode", sorderCode);
        this.delSOrderModelByCode(map);
    }

    private List<CrmsChannelSend> buildChannelSend(List<CrmsSOrder> crmsSOrderList, String dri) {
        if (ListUtil.isEmpty(crmsSOrderList)) {
            return null;
        }
        ArrayList<CrmsChannelSend> crmsChannelSendList = new ArrayList();
        ArrayList<CrmsChannelSendDomain> crmsChannelSendDomainList = new ArrayList<CrmsChannelSendDomain>();
        for (CrmsSOrder crmsSOrder : crmsSOrderList) {
            CrmsChannelSendDomain crmsChannelSendDomain = new CrmsChannelSendDomain();
            crmsChannelSendDomain.setChannelsendOpcode(crmsSOrder.getSorderCode());
            crmsChannelSendDomain.setChannelsendType("crmsSOrder");
            crmsChannelSendDomain.setChannelsendDir(dri);
            crmsChannelSendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)crmsSOrder));
            crmsChannelSendDomain.setTenantCode(crmsSOrder.getTenantCode());
            crmsChannelSendDomainList.add(crmsChannelSendDomain);
        }
        crmsChannelSendList = this.crmsChannelSendService.saveChannelSendBatch(crmsChannelSendDomainList);
        return crmsChannelSendList;
    }
}

