/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crms.service.impl;

import com.yqbsoft.laser.service.crms.CrmServerConstants;
import com.yqbsoft.laser.service.crms.dao.CrmsSOrderGoodsMapper;
import com.yqbsoft.laser.service.crms.dao.CrmsSOrderMapper;
import com.yqbsoft.laser.service.crms.domain.CrmsSOrderGoodsDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsSOrderGoodsReDomain;
import com.yqbsoft.laser.service.crms.model.CrmsSOrder;
import com.yqbsoft.laser.service.crms.model.CrmsSOrderGoods;
import com.yqbsoft.laser.service.crms.service.CrmsSOrderGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrmsSOrderGoodsServiceImpl
extends BaseServiceImpl
implements CrmsSOrderGoodsService {
    private static final String SYS_CODE = "service.crms.CrmsSOrderGoodsServiceImpl";
    private CrmsSOrderGoodsMapper crmsSOrderGoodsMapper;
    private CrmsSOrderMapper crmsSOrderMapper;

    public void setCrmsSOrderGoodsMapper(CrmsSOrderGoodsMapper crmsSOrderGoodsMapper) {
        this.crmsSOrderGoodsMapper = crmsSOrderGoodsMapper;
    }

    public void setCrmsSOrderMapper(CrmsSOrderMapper crmsSOrderMapper) {
        this.crmsSOrderMapper = crmsSOrderMapper;
    }

    private Date getSysDate() {
        try {
            return this.crmsSOrderGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkSOrderGoods(CrmsSOrderGoodsDomain crmsSOrderGoodsDomain) {
        if (null == crmsSOrderGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crmsSOrderGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setSOrderGoodsDefault(CrmsSOrderGoods crmsSOrderGoods) {
        if (null == crmsSOrderGoods) {
            return;
        }
        if (null == crmsSOrderGoods.getDataState()) {
            crmsSOrderGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crmsSOrderGoods.getGmtCreate()) {
            crmsSOrderGoods.setGmtCreate(date);
        }
        crmsSOrderGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)crmsSOrderGoods.getSorderGoodsCode())) {
            crmsSOrderGoods.setSorderGoodsCode(this.getNo(null, "CrmsSOrderGoods", "crmsSOrderGoods", crmsSOrderGoods.getTenantCode()));
        }
    }

    private int getSOrderGoodsMaxCode() {
        int code = 0;
        try {
            return this.crmsSOrderGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderGoodsServiceImpl.getSOrderGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setSOrderGoodsUpdataDefault(CrmsSOrderGoods crmsSOrderGoods) {
        if (null == crmsSOrderGoods) {
            return;
        }
        crmsSOrderGoods.setGmtModified(this.getSysDate());
    }

    private void saveSOrderGoodsModel(CrmsSOrderGoods crmsSOrderGoods) throws ApiException {
        if (null == crmsSOrderGoods) {
            return;
        }
        try {
            this.crmsSOrderGoodsMapper.insert(crmsSOrderGoods);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.saveSOrderGoodsModel.ex", (Throwable)e);
        }
    }

    private void saveSOrderGoodsBatchModel(List<CrmsSOrderGoods> crmsSOrderGoodsList) throws ApiException {
        if (null == crmsSOrderGoodsList || crmsSOrderGoodsList.isEmpty()) {
            return;
        }
        try {
            this.crmsSOrderGoodsMapper.insertBatch(crmsSOrderGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.saveSOrderGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private CrmsSOrderGoods getSOrderGoodsModelById(Integer sorderGoodsId) {
        if (null == sorderGoodsId) {
            return null;
        }
        try {
            return this.crmsSOrderGoodsMapper.selectByPrimaryKey(sorderGoodsId);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderGoodsServiceImpl.getSOrderGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private CrmsSOrderGoods getSOrderGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crmsSOrderGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderGoodsServiceImpl.getSOrderGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delSOrderGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.delSOrderGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.delSOrderGoodsModelByCode.num");
        }
    }

    private void deleteSOrderGoodsModel(Integer sorderGoodsId) throws ApiException {
        if (null == sorderGoodsId) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderGoodsMapper.deleteByPrimaryKey(sorderGoodsId);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.deleteSOrderGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.deleteSOrderGoodsModel.num");
        }
    }

    private void updateSOrderGoodsModel(CrmsSOrderGoods crmsSOrderGoods) throws ApiException {
        if (null == crmsSOrderGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsSOrderGoodsMapper.updateByPrimaryKey(crmsSOrderGoods);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.updateSOrderGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.updateSOrderGoodsModel.num");
        }
    }

    private void updateStateSOrderGoodsModel(Integer sorderGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == sorderGoodsId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sorderGoodsId", sorderGoodsId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsSOrderGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.updateStateSOrderGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.updateStateSOrderGoodsModel.null");
        }
    }

    private void updateStateSOrderGoodsModelByCode(String tenantCode, String sorderGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)sorderGoodsCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sorderGoodsCode", sorderGoodsCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsSOrderGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.updateStateSOrderGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.updateStateSOrderGoodsModelByCode.null");
        }
    }

    private CrmsSOrderGoods makeSOrderGoods(CrmsSOrderGoodsDomain crmsSOrderGoodsDomain, CrmsSOrderGoods crmsSOrderGoods) {
        if (null == crmsSOrderGoodsDomain) {
            return null;
        }
        if (null == crmsSOrderGoods) {
            crmsSOrderGoods = new CrmsSOrderGoods();
        }
        try {
            BeanUtils.copyAllPropertysNotNull((Object)crmsSOrderGoods, (Object)crmsSOrderGoodsDomain);
            return crmsSOrderGoods;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderGoodsServiceImpl.makeSOrderGoods", (Throwable)e);
            return null;
        }
    }

    private CrmsSOrderGoodsReDomain makeCrmsSOrderGoodsReDomain(CrmsSOrderGoods crmsSOrderGoods) {
        if (null == crmsSOrderGoods) {
            return null;
        }
        CrmsSOrderGoodsReDomain crmsSOrderGoodsReDomain = new CrmsSOrderGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crmsSOrderGoodsReDomain, (Object)crmsSOrderGoods);
            return crmsSOrderGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderGoodsServiceImpl.makeCrmsSOrderGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrmsSOrderGoods> querySOrderGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.crmsSOrderGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderGoodsServiceImpl.querySOrderGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countSOrderGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crmsSOrderGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsSOrderGoodsServiceImpl.countSOrderGoods", (Throwable)e);
        }
        return i;
    }

    private CrmsSOrderGoods createCrmsSOrderGoods(CrmsSOrderGoodsDomain crmsSOrderGoodsDomain) {
        String msg = this.checkSOrderGoods(crmsSOrderGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.saveSOrderGoods.checkSOrderGoods", msg);
        }
        CrmsSOrderGoods crmsSOrderGoods = this.makeSOrderGoods(crmsSOrderGoodsDomain, null);
        this.setSOrderGoodsDefault(crmsSOrderGoods);
        return crmsSOrderGoods;
    }

    @Override
    public String saveSOrderGoods(CrmsSOrderGoodsDomain crmsSOrderGoodsDomain) throws ApiException {
        CrmsSOrderGoods crmsSOrderGoods = this.createCrmsSOrderGoods(crmsSOrderGoodsDomain);
        this.saveSOrderGoodsModel(crmsSOrderGoods);
        return crmsSOrderGoods.getSorderGoodsCode();
    }

    @Override
    public String saveSOrderGoodsBatch(List<CrmsSOrderGoodsDomain> crmsSOrderGoodsDomainList) throws ApiException {
        if (null == crmsSOrderGoodsDomainList || crmsSOrderGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrmsSOrderGoods> crmsSOrderGoodsList = new ArrayList<CrmsSOrderGoods>();
        String code = "";
        for (CrmsSOrderGoodsDomain crmsSOrderGoodsDomain : crmsSOrderGoodsDomainList) {
            CrmsSOrderGoods crmsSOrderGoods = this.createCrmsSOrderGoods(crmsSOrderGoodsDomain);
            code = crmsSOrderGoods.getSorderGoodsCode();
            crmsSOrderGoodsList.add(crmsSOrderGoods);
        }
        this.logger.error("service.crms.CrmsSOrderGoodsServiceImpl.saveSOrderGoodsBatch:crmsSOrderGoodsDomainList", (Object)JsonUtil.buildNormalBinder().jsonObject(crmsSOrderGoodsDomainList));
        this.logger.error("service.crms.CrmsSOrderGoodsServiceImpl.saveSOrderGoodsBatch:crmsSOrderGoodsList", (Object)JsonUtil.buildNormalBinder().jsonObject(crmsSOrderGoodsList));
        this.saveSOrderGoodsBatchModel(crmsSOrderGoodsList);
        return code;
    }

    @Override
    public void updateSOrderGoodsState(Integer sorderGoodsId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == sorderGoodsId) {
            return;
        }
        this.updateStateSOrderGoodsModel(sorderGoodsId, dataState, oldDataState, map);
    }

    @Override
    public void updateSOrderGoodsStateByCode(String tenantCode, String sorderGoodsCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)sorderGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateSOrderGoodsModelByCode(tenantCode, sorderGoodsCode, dataState, oldDataState, map);
    }

    @Override
    public void updateSOrderGoods(CrmsSOrderGoodsDomain crmsSOrderGoodsDomain) throws ApiException {
        String msg = this.checkSOrderGoods(crmsSOrderGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.updateSOrderGoods.checkSOrderGoods", msg);
        }
        CrmsSOrderGoods oldCrmsSOrderGoods = this.getSOrderGoodsModelById(crmsSOrderGoodsDomain.getSorderGoodsId());
        if (null == oldCrmsSOrderGoods) {
            throw new ApiException("service.crms.CrmsSOrderGoodsServiceImpl.updateSOrderGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrmsSOrderGoods crmsSOrderGoods = this.makeSOrderGoods(crmsSOrderGoodsDomain, oldCrmsSOrderGoods);
        this.setSOrderGoodsUpdataDefault(crmsSOrderGoods);
        this.synSendNum(crmsSOrderGoods, crmsSOrderGoodsDomain);
        this.updateSOrderGoodsModel(crmsSOrderGoods);
        this.handelOrderSendState(crmsSOrderGoods);
    }

    private void handelOrderSendState(CrmsSOrderGoods crmsSOrderGoods) {
        Integer contractState = 0;
        boolean flagFullSend = false;
        if (crmsSOrderGoods.getContractGoodsSendnum() == null) {
            crmsSOrderGoods.setContractGoodsSendnum(BigDecimal.ZERO);
        }
        if (crmsSOrderGoods.getGoodsNum() == null) {
            crmsSOrderGoods.setGoodsNum(BigDecimal.ZERO);
        }
        if (crmsSOrderGoods.getContractGoodsSendnum().compareTo(BigDecimal.ZERO) > 0) {
            contractState = CrmServerConstants.CONTRACT_STATE_1;
        }
        if (crmsSOrderGoods.getGoodsNum().compareTo(crmsSOrderGoods.getContractGoodsSendnum()) <= 0) {
            flagFullSend = true;
        }
        List<CrmsSOrderGoods> orderGoodsList = this.queryOrderGoods(crmsSOrderGoods);
        for (CrmsSOrderGoods orderGood : orderGoodsList) {
            if (orderGood.getContractGoodsSendnum() == null) {
                orderGood.setContractGoodsSendnum(BigDecimal.ZERO);
            }
            if (orderGood.getGoodsNum() == null) {
                orderGood.setGoodsNum(BigDecimal.ZERO);
            }
            if (orderGood.getGoodsNum().compareTo(orderGood.getContractGoodsSendnum()) <= 0) continue;
            flagFullSend = false;
            break;
        }
        if (flagFullSend) {
            contractState = CrmServerConstants.CONTRACT_STATE_2;
        }
        CrmsSOrder crmsSOrder = this.getCrmSOrderByCode(crmsSOrderGoods);
        crmsSOrder.setContractState(contractState);
        crmsSOrder.setGmtModified(this.getSysDate());
        this.updateOrder(crmsSOrder);
    }

    private List<CrmsSOrderGoods> queryOrderGoods(CrmsSOrderGoods crmsSOrderGoods) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("corderCode", crmsSOrderGoods.getCorderCode());
        params.put("tenantCode", crmsSOrderGoods.getTenantCode());
        return this.crmsSOrderGoodsMapper.query(params);
    }

    private CrmsSOrder getCrmSOrderByCode(CrmsSOrderGoods crmsSOrderGoods) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("sorderCode", crmsSOrderGoods.getCorderCode());
        params.put("tenantCode", crmsSOrderGoods.getTenantCode());
        return this.crmsSOrderMapper.getByCode(params);
    }

    private void updateOrder(CrmsSOrder crmsSOrder) {
        this.crmsSOrderMapper.updateByPrimaryKey(crmsSOrder);
    }

    private void synSendNum(CrmsSOrderGoods crmsSOrderGoods, CrmsSOrderGoodsDomain crmsSOrderGoodsDomain) {
        if (crmsSOrderGoodsDomain.getContractGoodsSendnum() == null) {
            return;
        }
        crmsSOrderGoods.setContractGoodsSendnum(crmsSOrderGoodsDomain.getContractGoodsSendnum());
    }

    @Override
    public CrmsSOrderGoods getSOrderGoods(Integer sorderGoodsId) {
        if (null == sorderGoodsId) {
            return null;
        }
        return this.getSOrderGoodsModelById(sorderGoodsId);
    }

    @Override
    public void deleteSOrderGoods(Integer sorderGoodsId) throws ApiException {
        if (null == sorderGoodsId) {
            return;
        }
        this.deleteSOrderGoodsModel(sorderGoodsId);
    }

    @Override
    public QueryResult<CrmsSOrderGoods> querySOrderGoodsPage(Map<String, Object> map) {
        List<CrmsSOrderGoods> crmsSOrderGoodsList = this.querySOrderGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countSOrderGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crmsSOrderGoodsList);
        return queryResult;
    }

    @Override
    public CrmsSOrderGoods getSOrderGoodsByCode(String tenantCode, String sorderGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)sorderGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sorderGoodsCode", sorderGoodsCode);
        return this.getSOrderGoodsModelByCode(map);
    }

    @Override
    public void deleteSOrderGoodsByCode(String tenantCode, String sorderGoodsCode) throws ApiException {
        if (StringUtils.isBlank((String)sorderGoodsCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("sorderGoodsCode", sorderGoodsCode);
        this.delSOrderGoodsModelByCode(map);
    }
}

