/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crms.service.impl;

import com.yqbsoft.laser.service.crms.dao.CrmsStockSlaesGoodsMapper;
import com.yqbsoft.laser.service.crms.domain.CrmsStockSlaesGoodsDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsStockSlaesGoodsReDomain;
import com.yqbsoft.laser.service.crms.model.CrmsStockSlaesGoods;
import com.yqbsoft.laser.service.crms.service.CrmsStockSlaesGoodsService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;

public class CrmsStockSlaesGoodsServiceImpl
extends BaseServiceImpl
implements CrmsStockSlaesGoodsService {
    private static final String SYS_CODE = "service.crms.CrmsStockSlaesGoodsServiceImpl";
    private CrmsStockSlaesGoodsMapper crmsStockSlaesGoodsMapper;

    public void setCrmsStockSlaesGoodsMapper(CrmsStockSlaesGoodsMapper crmsStockSlaesGoodsMapper) {
        this.crmsStockSlaesGoodsMapper = crmsStockSlaesGoodsMapper;
    }

    private Date getSysDate() {
        try {
            return this.crmsStockSlaesGoodsMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkcrmsStockSlaesGoods(CrmsStockSlaesGoodsDomain crmsStockSlaesGoodsDomain) {
        if (null == crmsStockSlaesGoodsDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crmsStockSlaesGoodsDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setcrmsStockSlaesGoodsDefault(CrmsStockSlaesGoods crmsStockSlaesGoods) {
        if (null == crmsStockSlaesGoods) {
            return;
        }
        if (null == crmsStockSlaesGoods.getDataState()) {
            crmsStockSlaesGoods.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crmsStockSlaesGoods.getGmtCreate()) {
            crmsStockSlaesGoods.setGmtCreate(date);
        }
        crmsStockSlaesGoods.setGmtModified(date);
        if (StringUtils.isBlank((String)crmsStockSlaesGoods.getStockCode())) {
            crmsStockSlaesGoods.setStockCode(this.getNo(null, "CrmsStockSlaesGoods", "crmsStockSlaesGoods", crmsStockSlaesGoods.getTenantCode()));
        }
    }

    private int getcrmsStockSlaesGoodsMaxCode() {
        int code = 0;
        try {
            return this.crmsStockSlaesGoodsMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl.getcrmsStockSlaesGoodsMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setcrmsStockSlaesGoodsUpdataDefault(CrmsStockSlaesGoods crmsStockSlaesGoods) {
        if (null == crmsStockSlaesGoods) {
            return;
        }
        crmsStockSlaesGoods.setGmtModified(this.getSysDate());
    }

    private void savecrmsStockSlaesGoodsModel(CrmsStockSlaesGoods crmsStockSlaesGoods) throws ApiException {
        if (null == crmsStockSlaesGoods) {
            return;
        }
        try {
            this.crmsStockSlaesGoodsMapper.insert(crmsStockSlaesGoods);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.savecrmsStockSlaesGoodsModel.ex", (Throwable)e);
        }
    }

    private void savecrmsStockSlaesGoodsBatchModel(List<CrmsStockSlaesGoods> crmsStockSlaesGoodsList) throws ApiException {
        if (null == crmsStockSlaesGoodsList || crmsStockSlaesGoodsList.isEmpty()) {
            return;
        }
        try {
            this.crmsStockSlaesGoodsMapper.insertBatch(crmsStockSlaesGoodsList);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.savecrmsStockSlaesGoodsBatchModel.ex", (Throwable)e);
        }
    }

    private CrmsStockSlaesGoods getcrmsStockSlaesGoodsModelById(Integer stockId) {
        if (null == stockId) {
            return null;
        }
        try {
            return this.crmsStockSlaesGoodsMapper.selectByPrimaryKey(stockId);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl.getcrmsStockSlaesGoodsModelById", (Throwable)e);
            return null;
        }
    }

    private CrmsStockSlaesGoods getcrmsStockSlaesGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crmsStockSlaesGoodsMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl.getcrmsStockSlaesGoodsModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delcrmsStockSlaesGoodsModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsStockSlaesGoodsMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.delcrmsStockSlaesGoodsModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.delcrmsStockSlaesGoodsModelByCode.num");
        }
    }

    private void deletecrmsStockSlaesGoodsModel(Integer stockId) throws ApiException {
        if (null == stockId) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsStockSlaesGoodsMapper.deleteByPrimaryKey(stockId);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.deletecrmsStockSlaesGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.deletecrmsStockSlaesGoodsModel.num");
        }
    }

    private void updatecrmsStockSlaesGoodsModel(CrmsStockSlaesGoods crmsStockSlaesGoods) throws ApiException {
        if (null == crmsStockSlaesGoods) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsStockSlaesGoodsMapper.updateByPrimaryKey(crmsStockSlaesGoods);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.updatecrmsStockSlaesGoodsModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.updatecrmsStockSlaesGoodsModel.num");
        }
    }

    private void updateStatecrmsStockSlaesGoodsModel(Integer stockId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == stockId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("stockId", stockId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsStockSlaesGoodsMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.updateStatecrmsStockSlaesGoodsModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.updateStatecrmsStockSlaesGoodsModel.null");
        }
    }

    private void updateStatecrmsStockSlaesGoodsModelByCode(String tenantCode, String stockCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)stockCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("stockCode", stockCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsStockSlaesGoodsMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.updateStatecrmsStockSlaesGoodsModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.updateStatecrmsStockSlaesGoodsModelByCode.null");
        }
    }

    private CrmsStockSlaesGoods makecrmsStockSlaesGoods(CrmsStockSlaesGoodsDomain crmsStockSlaesGoodsDomain, CrmsStockSlaesGoods crmsStockSlaesGoods) {
        if (null == crmsStockSlaesGoodsDomain) {
            return null;
        }
        if (null == crmsStockSlaesGoods) {
            crmsStockSlaesGoods = new CrmsStockSlaesGoods();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crmsStockSlaesGoods, (Object)crmsStockSlaesGoodsDomain);
            return crmsStockSlaesGoods;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl.makecrmsStockSlaesGoods", (Throwable)e);
            return null;
        }
    }

    private CrmsStockSlaesGoodsReDomain makeCrmsStockSlaesGoodsReDomain(CrmsStockSlaesGoods crmsStockSlaesGoods) {
        if (null == crmsStockSlaesGoods) {
            return null;
        }
        CrmsStockSlaesGoodsReDomain crmsStockSlaesGoodsReDomain = new CrmsStockSlaesGoodsReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crmsStockSlaesGoodsReDomain, (Object)crmsStockSlaesGoods);
            return crmsStockSlaesGoodsReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl.makeCrmsStockSlaesGoodsReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrmsStockSlaesGoods> querycrmsStockSlaesGoodsModelPage(Map<String, Object> parammap) {
        try {
            return this.crmsStockSlaesGoodsMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl.querycrmsStockSlaesGoodsModel", (Throwable)e);
            return null;
        }
    }

    private int countcrmsStockSlaesGoods(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crmsStockSlaesGoodsMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl.countcrmsStockSlaesGoods", (Throwable)e);
        }
        return i;
    }

    private CrmsStockSlaesGoods createCrmsStockSlaesGoods(CrmsStockSlaesGoodsDomain crmsStockSlaesGoodsDomain) {
        String msg = this.checkcrmsStockSlaesGoods(crmsStockSlaesGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.savecrmsStockSlaesGoods.checkcrmsStockSlaesGoods", msg);
        }
        CrmsStockSlaesGoods crmsStockSlaesGoods = this.makecrmsStockSlaesGoods(crmsStockSlaesGoodsDomain, null);
        this.setcrmsStockSlaesGoodsDefault(crmsStockSlaesGoods);
        return crmsStockSlaesGoods;
    }

    @Override
    public String savecrmsStockSlaesGoods(CrmsStockSlaesGoodsDomain crmsStockSlaesGoodsDomain) throws ApiException {
        CrmsStockSlaesGoods crmsStockSlaesGoods = this.createCrmsStockSlaesGoods(crmsStockSlaesGoodsDomain);
        this.savecrmsStockSlaesGoodsModel(crmsStockSlaesGoods);
        return crmsStockSlaesGoods.getStockCode();
    }

    @Override
    public String savecrmsStockSlaesGoodsBatch(List<CrmsStockSlaesGoodsDomain> crmsStockSlaesGoodsDomainList) throws ApiException {
        if (null == crmsStockSlaesGoodsDomainList || crmsStockSlaesGoodsDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrmsStockSlaesGoods> crmsStockSlaesGoodsList = new ArrayList<CrmsStockSlaesGoods>();
        String code = "";
        for (CrmsStockSlaesGoodsDomain crmsStockSlaesGoodsDomain : crmsStockSlaesGoodsDomainList) {
            CrmsStockSlaesGoods crmsStockSlaesGoods = this.createCrmsStockSlaesGoods(crmsStockSlaesGoodsDomain);
            code = crmsStockSlaesGoods.getStockCode();
            crmsStockSlaesGoodsList.add(crmsStockSlaesGoods);
        }
        this.savecrmsStockSlaesGoodsBatchModel(crmsStockSlaesGoodsList);
        return code;
    }

    @Override
    public void updatecrmsStockSlaesGoodsState(Integer stockId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == stockId) {
            return;
        }
        this.updateStatecrmsStockSlaesGoodsModel(stockId, dataState, oldDataState, map);
    }

    @Override
    public void updatecrmsStockSlaesGoodsStateByCode(String tenantCode, String stockCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)stockCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStatecrmsStockSlaesGoodsModelByCode(tenantCode, stockCode, dataState, oldDataState, map);
    }

    @Override
    public void updatecrmsStockSlaesGoods(CrmsStockSlaesGoodsDomain crmsStockSlaesGoodsDomain) throws ApiException {
        String msg = this.checkcrmsStockSlaesGoods(crmsStockSlaesGoodsDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.updatecrmsStockSlaesGoods.checkcrmsStockSlaesGoods", msg);
        }
        CrmsStockSlaesGoods oldCrmsStockSlaesGoods = this.getcrmsStockSlaesGoodsModelById(crmsStockSlaesGoodsDomain.getStockId());
        if (null == oldCrmsStockSlaesGoods) {
            throw new ApiException("service.crms.CrmsStockSlaesGoodsServiceImpl.updatecrmsStockSlaesGoods.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrmsStockSlaesGoods crmsStockSlaesGoods = this.makecrmsStockSlaesGoods(crmsStockSlaesGoodsDomain, oldCrmsStockSlaesGoods);
        this.setcrmsStockSlaesGoodsUpdataDefault(crmsStockSlaesGoods);
        this.updatecrmsStockSlaesGoodsModel(crmsStockSlaesGoods);
    }

    @Override
    public CrmsStockSlaesGoods getcrmsStockSlaesGoods(Integer stockId) {
        if (null == stockId) {
            return null;
        }
        return this.getcrmsStockSlaesGoodsModelById(stockId);
    }

    @Override
    public void deletecrmsStockSlaesGoods(Integer stockId) throws ApiException {
        if (null == stockId) {
            return;
        }
        this.deletecrmsStockSlaesGoodsModel(stockId);
    }

    @Override
    public QueryResult<CrmsStockSlaesGoods> querycrmsStockSlaesGoodsPage(Map<String, Object> map) {
        List<CrmsStockSlaesGoods> crmsStockSlaesGoodsList = this.querycrmsStockSlaesGoodsModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countcrmsStockSlaesGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crmsStockSlaesGoodsList);
        return queryResult;
    }

    @Override
    public CrmsStockSlaesGoods getcrmsStockSlaesGoodsByCode(String tenantCode, String stockCode) throws ApiException {
        if (StringUtils.isBlank((String)stockCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("stockCode", stockCode);
        return this.getcrmsStockSlaesGoodsModelByCode(map);
    }

    @Override
    public void deletecrmsStockSlaesGoodsByCode(String tenantCode, String stockCode) throws ApiException {
        if (StringUtils.isBlank((String)stockCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("stockCode", stockCode);
        this.delcrmsStockSlaesGoodsModelByCode(map);
    }

    @Override
    public QueryResult<Map<String, Object>> getCrmsStockSaleGoodsListPage(Map<String, Object> map) throws ApiException {
        this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl getCrmsStockSaleGoodsListPage\u5165\u53c2\uff1a", (Object)JsonUtil.buildNonDefaultBinder().toJson(map));
        QueryResult queryResult = new QueryResult();
        String custerName = map.get("memberName") + "";
        String maxMonth = this.crmsStockSlaesGoodsMapper.getMaxMonthByName(custerName);
        if (StringUtils.isBlank((String)maxMonth)) {
            queryResult.setTotal(0L);
            return queryResult;
        }
        this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl getCrmsStockSaleGoodsListPage\u6700\u5927\u6708\u4efd\uff1a", (Object)maxMonth);
        String minMonth = this.getLastYearMonth(maxMonth);
        map.put("fuzzy", false);
        map.put("uploadMonth", maxMonth);
        map.put("orderStr", "GOODS_MODEL");
        List<CrmsStockSlaesGoods> mainList = this.querycrmsStockSlaesGoodsModelPage(map);
        ArrayList<OrderedMap> mapList = new ArrayList<OrderedMap>(mainList.size());
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countcrmsStockSlaesGoods(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        map.remove("uploadMonth");
        map.remove("orderStr");
        map.put("minMonth", minMonth);
        map.put("maxMonth", maxMonth);
        List<CrmsStockSlaesGoods> sonList = this.querycrmsStockSlaesGoodsModelPage(map);
        ArrayList<CrmsStockSlaesGoods> sonListZero = new ArrayList<CrmsStockSlaesGoods>();
        TreeSet<String> dateSet = new TreeSet<String>();
        String forMonth = minMonth;
        for (int i = 0; i < 12; ++i) {
            dateSet.add(forMonth);
            forMonth = this.getNextMonth(forMonth);
        }
        this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl getCrmsStockSaleGoodsListPage\u5f00\u59cb\u5faa\u73af\u5904\u7406\uff01\uff01\uff01");
        for (CrmsStockSlaesGoods mainCrms : mainList) {
            OrderedMap innerMap = ListOrderedMap.decorate(new HashMap());
            String mainGoodsModel = mainCrms.getGoodsModel();
            innerMap.put("memberName", mainCrms.getMemberName());
            innerMap.put("goodsBom", mainCrms.getGoodsBom());
            innerMap.put("goodsModel", mainGoodsModel);
            for (String dateStr : dateSet) {
                innerMap.put(dateStr, "");
            }
            sonListZero = new ArrayList();
            for (CrmsStockSlaesGoods son : sonList) {
                if (son.getGoodsModel().equals(mainGoodsModel)) {
                    innerMap.put(son.getUploadMonth(), son.getCurryInventory());
                    continue;
                }
                sonListZero.add(son);
            }
            sonList = sonListZero;
            innerMap.put(mainCrms.getUploadMonth(), mainCrms.getCurryInventory());
            innerMap.put("aogNumber", mainCrms.getAogNumber());
            innerMap.put("salesNumber", mainCrms.getSalesNumber());
            innerMap.put("salesRatInventory", mainCrms.getSalesRatInventory());
            innerMap.put("inventoryState", mainCrms.getInventoryState());
            innerMap.put("inAdvices", mainCrms.getInAdvices());
            mapList.add(innerMap);
        }
        queryResult.setList(mapList);
        this.logger.error("service.crms.CrmsStockSlaesGoodsServiceImpl getCrmsStockSaleGoodsListPage() queryResult\u662f\uff1a", (Object)queryResult);
        return queryResult;
    }

    private String getLastYearMonth(String curryMonth) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date time = null;
        try {
            Date currenDate = format.parse(curryMonth);
            Calendar cal = Calendar.getInstance();
            cal.setTime(currenDate);
            cal.add(1, -1);
            time = cal.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return format.format(time);
    }

    private String getNextMonth(String curryMonth) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
        Date time = null;
        try {
            Date currenDate = format.parse(curryMonth);
            Calendar cal = Calendar.getInstance();
            cal.setTime(currenDate);
            cal.add(2, 1);
            time = cal.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return format.format(time);
    }
}

