/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crms.service.impl;

import com.yqbsoft.laser.service.crms.dao.CrmsEURReplenishMapper;
import com.yqbsoft.laser.service.crms.dao.CrmsEURWarehouseOnHandMapper;
import com.yqbsoft.laser.service.crms.model.CrmsEURReplenish;
import com.yqbsoft.laser.service.crms.model.CrmsEURWarehouseOnHand;
import com.yqbsoft.laser.service.crms.service.CrmsEURWarehouseOnHandService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;

public class CrmsEURWarehouseOnHandServiceImpl
extends BaseServiceImpl
implements CrmsEURWarehouseOnHandService {
    private static final String SYS_CODE = "service.crms.CrmsEURWarehouseOnHandServiceImpl";
    private CrmsEURWarehouseOnHandMapper crmsEURWarehouseOnHandMapper;
    private CrmsEURReplenishMapper crmsEURReplenishMapper;

    public void setCrmsEURWarehouseOnHandMapper(CrmsEURWarehouseOnHandMapper crmsEURWarehouseOnHandMapper) {
        this.crmsEURWarehouseOnHandMapper = crmsEURWarehouseOnHandMapper;
    }

    public void setCrmsEURReplenishMapper(CrmsEURReplenishMapper crmsEURReplenishMapper) {
        this.crmsEURReplenishMapper = crmsEURReplenishMapper;
    }

    @Override
    public int saveBatch(List<CrmsEURWarehouseOnHand> inventoryList) {
        this.logger.info("service.crms.CrmsEURWarehouseOnHandServiceImpl saveBatch() \u8fdb\u5165 \u53c2\u6570inventoryList\u662f\uff1a", inventoryList);
        this.crmsEURWarehouseOnHandMapper.truncateTable();
        Integer total = this.crmsEURWarehouseOnHandMapper.batchInsert(inventoryList);
        return total;
    }

    @Override
    public List<CrmsEURWarehouseOnHand> getAll() {
        return this.crmsEURWarehouseOnHandMapper.getAll();
    }

    @Override
    public void removeAll() {
        this.crmsEURWarehouseOnHandMapper.truncateTable();
    }

    @Override
    public QueryResult<Map<String, Object>> getListPageFullParams(Map<String, Object> map) {
        this.logger.error("service.crms.CrmsEURWarehouseOnHandServiceImpl getListPageFullParams() \u8fdb\u5165 \u53c2\u6570map\u662f\uff1a", map);
        if (map.containsKey("items")) {
            String itemsStr = (String)map.get("items");
            String[] split = itemsStr.split(",");
            map.put("items", Arrays.asList(split));
        }
        List<CrmsEURWarehouseOnHand> list = this.crmsEURWarehouseOnHandMapper.queryPageFullParams(map);
        this.logger.error("service.crms.CrmsEURWarehouseOnHandServiceImpl getListPageFullParams() \u67e5\u5e93\u7684\u7ed3\u679c\u662f\uff1a", map);
        ArrayList<OrderedMap> mapList = new ArrayList<OrderedMap>(list.size());
        List<CrmsEURReplenish> replenishList = this.crmsEURReplenishMapper.getAll();
        TreeSet<String> dateSet = new TreeSet<String>();
        for (CrmsEURReplenish e : replenishList) {
            dateSet.add(DateUtil.parseDate((Date)e.getScheduledArrivalDate()));
        }
        for (int i = 0; i < list.size(); ++i) {
            CrmsEURWarehouseOnHand warehouse = list.get(i);
            OrderedMap innerMap = ListOrderedMap.decorate(new HashMap());
            innerMap.put("itemCode", warehouse.getItemCode());
            innerMap.put("itemModel", warehouse.getItemModel());
            innerMap.put("engDesc", warehouse.getEngDesc());
            innerMap.put("prototypeItem", warehouse.getPrototypeItem());
            innerMap.put("prototypeModel", warehouse.getPrototypeModel());
            innerMap.put("inventoryItemStatusCode", warehouse.getInventoryItemStatusCode());
            innerMap.put("erpOnHandQty", warehouse.getErpOnHandQty());
            innerMap.put("uppAvaQty", warehouse.getUppAvaQty());
            innerMap.put("poRcvQty", warehouse.getPoRcvQty());
            innerMap.put("description", warehouse.getDescription());
            innerMap.put("so45DemandQty", warehouse.getSo45DemandQty());
            innerMap.put("soAllDemandQty", warehouse.getSoAllDemandQty());
            innerMap.put("subAllOrderQty", warehouse.getErpOnHandQty() - warehouse.getSoAllDemandQty());
            innerMap.put("estimateAva", (Integer)innerMap.get("subAllOrderQty") + warehouse.getPoRcvQty());
            for (String dateStr : dateSet) {
                innerMap.put(dateStr, 0);
            }
            ArrayList<CrmsEURReplenish> filterList = new ArrayList<CrmsEURReplenish>();
            for (CrmsEURReplenish e : replenishList) {
                if (warehouse.getItemCode() == null || !warehouse.getItemCode().equals(e.getOrderedItem())) continue;
                filterList.add(e);
            }
            for (CrmsEURReplenish e : filterList) {
                String key = DateUtil.parseDate((Date)e.getScheduledArrivalDate());
                Integer o = (Integer)innerMap.get(key);
                if (o != null && o != 0) {
                    innerMap.put(key, o + (e.getShippedQuantity() - e.getDeliverQuantity()));
                    continue;
                }
                innerMap.put(key, e.getShippedQuantity() - e.getDeliverQuantity());
            }
            mapList.add(innerMap);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countByFullParams(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mapList);
        this.logger.error("service.crms.CrmsEURWarehouseOnHandServiceImpl getListPageFullParams() queryResult\u662f\uff1a", (Object)queryResult);
        return queryResult;
    }

    private int countByFullParams(Map<String, Object> map) {
        Integer count = this.crmsEURWarehouseOnHandMapper.countByFullParams(map);
        this.logger.error("service.crms.CrmsEURWarehouseOnHandServiceImpl countByFullParams() \u6267\u884c count\u662f\uff1a", (Object)count);
        return count;
    }
}

