/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crms.service.impl;

import com.yqbsoft.laser.service.crms.dao.CrmsRechargeMapper;
import com.yqbsoft.laser.service.crms.domain.CrmsRechargeDomain;
import com.yqbsoft.laser.service.crms.domain.CrmsRechargeReDomain;
import com.yqbsoft.laser.service.crms.model.CrmsRecharge;
import com.yqbsoft.laser.service.crms.service.CrmsRechargeService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrmsRechargeServiceImpl
extends BaseServiceImpl
implements CrmsRechargeService {
    private static final String SYS_CODE = "service.crms.CrmsRechargeServiceImpl";
    private CrmsRechargeMapper crmsRechargeMapper;

    public void setCrmsRechargeMapper(CrmsRechargeMapper crmsRechargeMapper) {
        this.crmsRechargeMapper = crmsRechargeMapper;
    }

    private Date getSysDate() {
        try {
            return this.crmsRechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsRechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkRecharge(CrmsRechargeDomain crmsRechargeDomain) {
        if (null == crmsRechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crmsRechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setRechargeDefault(CrmsRecharge crmsRecharge) {
        if (null == crmsRecharge) {
            return;
        }
        if (null == crmsRecharge.getDataState()) {
            crmsRecharge.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crmsRecharge.getGmtCreate()) {
            crmsRecharge.setGmtCreate(date);
        }
        crmsRecharge.setGmtModified(date);
        if (StringUtils.isBlank((String)crmsRecharge.getRechargeCode())) {
            crmsRecharge.setRechargeCode(this.getNo(null, "CrmsRecharge", "crmsRecharge", crmsRecharge.getTenantCode()));
        }
    }

    private int getRechargeMaxCode() {
        int code = 0;
        try {
            return this.crmsRechargeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsRechargeServiceImpl.getRechargeMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setRechargeUpdataDefault(CrmsRecharge crmsRecharge) {
        if (null == crmsRecharge) {
            return;
        }
        crmsRecharge.setGmtModified(this.getSysDate());
    }

    private void saveRechargeModel(CrmsRecharge crmsRecharge) throws ApiException {
        if (null == crmsRecharge) {
            return;
        }
        try {
            this.crmsRechargeMapper.insert(crmsRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.saveRechargeModel.ex", (Throwable)e);
        }
    }

    private void saveRechargeBatchModel(List<CrmsRecharge> crmsRechargeList) throws ApiException {
        if (null == crmsRechargeList || crmsRechargeList.isEmpty()) {
            return;
        }
        try {
            this.crmsRechargeMapper.insertBatch(crmsRechargeList);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.saveRechargeBatchModel.ex", (Throwable)e);
        }
    }

    private CrmsRecharge getRechargeModelById(Integer RechargeId) {
        if (null == RechargeId) {
            return null;
        }
        try {
            return this.crmsRechargeMapper.selectByPrimaryKey(RechargeId);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsRechargeServiceImpl.getRechargeModelById", (Throwable)e);
            return null;
        }
    }

    private CrmsRecharge getRechargeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crmsRechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsRechargeServiceImpl.getRechargeModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delRechargeModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsRechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.delRechargeModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.delRechargeModelByCode.num");
        }
    }

    private void deleteRechargeModel(Integer RechargeId) throws ApiException {
        if (null == RechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsRechargeMapper.deleteByPrimaryKey(RechargeId);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.deleteRechargeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.deleteRechargeModel.num");
        }
    }

    private void updateRechargeModel(CrmsRecharge crmsRecharge) throws ApiException {
        if (null == crmsRecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crmsRechargeMapper.updateByPrimaryKey(crmsRecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.updateRechargeModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.updateRechargeModel.num");
        }
    }

    private void updateStateRechargeModel(Integer RechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == RechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RechargeId", RechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsRechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.updateStateRechargeModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.updateStateRechargeModel.null");
        }
    }

    private void updateStateRechargeModelByCode(String tenantCode, String RechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)RechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("RechargeCode", RechargeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crmsRechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.updateStateRechargeModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.updateStateRechargeModelByCode.null");
        }
    }

    private CrmsRecharge makeRecharge(CrmsRechargeDomain crmsRechargeDomain, CrmsRecharge crmsRecharge) {
        if (null == crmsRechargeDomain) {
            return null;
        }
        if (null == crmsRecharge) {
            crmsRecharge = new CrmsRecharge();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crmsRecharge, (Object)crmsRechargeDomain);
            return crmsRecharge;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsRechargeServiceImpl.makeRecharge", (Throwable)e);
            return null;
        }
    }

    private CrmsRechargeReDomain makeCrmsRechargeReDomain(CrmsRecharge crmsRecharge) {
        if (null == crmsRecharge) {
            return null;
        }
        CrmsRechargeReDomain crmsRechargeReDomain = new CrmsRechargeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crmsRechargeReDomain, (Object)crmsRecharge);
            return crmsRechargeReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsRechargeServiceImpl.makeCrmsRechargeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrmsRecharge> queryRechargeModelPage(Map<String, Object> parammap) {
        try {
            return this.crmsRechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsRechargeServiceImpl.queryRechargeModel", (Throwable)e);
            return null;
        }
    }

    private int countRecharge(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crmsRechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.crms.CrmsRechargeServiceImpl.countRecharge", (Throwable)e);
        }
        return i;
    }

    private CrmsRecharge createCrmsRecharge(CrmsRechargeDomain crmsRechargeDomain) {
        String msg = this.checkRecharge(crmsRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.saveRecharge.checkRecharge", msg);
        }
        CrmsRecharge crmsRecharge = this.makeRecharge(crmsRechargeDomain, null);
        this.setRechargeDefault(crmsRecharge);
        return crmsRecharge;
    }

    @Override
    public String saveRecharge(CrmsRechargeDomain crmsRechargeDomain) throws ApiException {
        CrmsRecharge crmsRecharge = this.createCrmsRecharge(crmsRechargeDomain);
        this.saveRechargeModel(crmsRecharge);
        return crmsRecharge.getRechargeCode();
    }

    @Override
    public String saveRechargeBatch(List<CrmsRechargeDomain> crmsRechargeDomainList) throws ApiException {
        if (null == crmsRechargeDomainList || crmsRechargeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrmsRecharge> crmsRechargeList = new ArrayList<CrmsRecharge>();
        String code = "";
        for (CrmsRechargeDomain crmsRechargeDomain : crmsRechargeDomainList) {
            CrmsRecharge crmsRecharge = this.createCrmsRecharge(crmsRechargeDomain);
            code = crmsRecharge.getRechargeCode();
            crmsRechargeList.add(crmsRecharge);
        }
        this.saveRechargeBatchModel(crmsRechargeList);
        return code;
    }

    @Override
    public void updateRechargeState(Integer RechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (null == RechargeId) {
            return;
        }
        this.updateStateRechargeModel(RechargeId, dataState, oldDataState, map);
    }

    @Override
    public void updateRechargeStateByCode(String tenantCode, String RechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        if (StringUtils.isBlank((String)RechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        this.updateStateRechargeModelByCode(tenantCode, RechargeCode, dataState, oldDataState, map);
    }

    @Override
    public void updateRecharge(CrmsRechargeDomain crmsRechargeDomain) throws ApiException {
        String msg = this.checkRecharge(crmsRechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.updateRecharge.checkRecharge", msg);
        }
        CrmsRecharge oldCrmsRecharge = this.getRechargeModelById(crmsRechargeDomain.getRechargeId());
        if (null == oldCrmsRecharge) {
            throw new ApiException("service.crms.CrmsRechargeServiceImpl.updateRecharge.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrmsRecharge crmsRecharge = this.makeRecharge(crmsRechargeDomain, oldCrmsRecharge);
        this.setRechargeUpdataDefault(crmsRecharge);
        this.updateRechargeModel(crmsRecharge);
    }

    @Override
    public CrmsRecharge getRecharge(Integer RechargeId) {
        if (null == RechargeId) {
            return null;
        }
        return this.getRechargeModelById(RechargeId);
    }

    @Override
    public void deleteRecharge(Integer RechargeId) throws ApiException {
        if (null == RechargeId) {
            return;
        }
        this.deleteRechargeModel(RechargeId);
    }

    @Override
    public QueryResult<CrmsRecharge> queryRechargePage(Map<String, Object> map) {
        List<CrmsRecharge> crmsRechargeList = this.queryRechargeModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countRecharge(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crmsRechargeList);
        return queryResult;
    }

    @Override
    public CrmsRecharge getRechargeByCode(String tenantCode, String RechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)RechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("RechargeCode", RechargeCode);
        return this.getRechargeModelByCode(map);
    }

    @Override
    public void deleteRechargeByCode(String tenantCode, String RechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)RechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("RechargeCode", RechargeCode);
        this.delRechargeModelByCode(map);
    }
}

