/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crms.service.impl;

import com.yqbsoft.laser.service.crms.dao.CrmsUSAReplenishMapper;
import com.yqbsoft.laser.service.crms.dao.CrmsUSAWarehouseOnHandMapper;
import com.yqbsoft.laser.service.crms.model.CrmsUSAReplenish;
import com.yqbsoft.laser.service.crms.model.CrmsUSAWarehouseOnHand;
import com.yqbsoft.laser.service.crms.service.CrmsUSAWarehouseOnHandService;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.DateUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.ListOrderedMap;

public class CrmsUSAWarehouseOnHandServiceImpl
extends BaseServiceImpl
implements CrmsUSAWarehouseOnHandService {
    private static final String SYS_CODE = "service.crms.CrmsUSAWarehouseOnHandServiceImpl";
    private CrmsUSAWarehouseOnHandMapper crmsUSAWarehouseOnHandMapper;
    private CrmsUSAReplenishMapper crmsUSAReplenishMapper;

    public void setCrmsUSAWarehouseOnHandMapper(CrmsUSAWarehouseOnHandMapper crmsUSAWarehouseOnHandMapper) {
        this.crmsUSAWarehouseOnHandMapper = crmsUSAWarehouseOnHandMapper;
    }

    public void setCrmsUSAReplenishMapper(CrmsUSAReplenishMapper crmsUSAReplenishMapper) {
        this.crmsUSAReplenishMapper = crmsUSAReplenishMapper;
    }

    @Override
    public int saveBatch(List<CrmsUSAWarehouseOnHand> inventoryList) {
        this.logger.info("service.crms.CrmsUSAWarehouseOnHandServiceImpl saveBatch() \u8fdb\u5165 \u53c2\u6570inventoryList\u662f\uff1a", inventoryList);
        this.crmsUSAWarehouseOnHandMapper.truncateTable();
        Integer total = this.crmsUSAWarehouseOnHandMapper.batchInsert(inventoryList);
        return total;
    }

    @Override
    public List<CrmsUSAWarehouseOnHand> getAll() {
        return this.crmsUSAWarehouseOnHandMapper.getAll();
    }

    @Override
    public void removeAll() {
        this.crmsUSAWarehouseOnHandMapper.truncateTable();
    }

    @Override
    public QueryResult<Map<String, Object>> getListPageFullParams(Map<String, Object> map) {
        this.logger.error("service.crms.CrmsUSAWarehouseOnHandServiceImpl getListPageFullParams() \u8fdb\u5165 \u53c2\u6570map\u662f\uff1a", map);
        if (map.containsKey("items")) {
            String itemsStr = (String)map.get("items");
            String[] split = itemsStr.split(",");
            map.put("items", Arrays.asList(split));
        }
        List<CrmsUSAWarehouseOnHand> list = this.crmsUSAWarehouseOnHandMapper.queryPageFullParams(map);
        this.logger.error("service.crms.CrmsUSAWarehouseOnHandServiceImpl getListPageFullParams() \u67e5\u5e93\u7684\u7ed3\u679c\u662f\uff1a", map);
        ArrayList<OrderedMap> mapList = new ArrayList<OrderedMap>(list.size());
        List<CrmsUSAReplenish> replenishList = this.crmsUSAReplenishMapper.getAll();
        TreeSet<String> dateSet = new TreeSet<String>();
        for (CrmsUSAReplenish e : replenishList) {
            dateSet.add(DateUtil.parseDate((Date)e.getScheduledArrivalDate()));
        }
        for (int i = 0; i < list.size(); ++i) {
            CrmsUSAWarehouseOnHand warehouse = list.get(i);
            OrderedMap innerMap = ListOrderedMap.decorate(new HashMap());
            innerMap.put("itemCode", warehouse.getItemCode());
            innerMap.put("itemModel", warehouse.getItemModel());
            innerMap.put("engDesc", warehouse.getEngDesc());
            innerMap.put("prototypeItem", warehouse.getPrototypeItem());
            innerMap.put("prototypeModel", warehouse.getPrototypeModel());
            innerMap.put("inventoryItemStatusCode", warehouse.getInventoryItemStatusCode());
            innerMap.put("erpOnHandQty", warehouse.getErpOnHandQty());
            innerMap.put("uppAvaQty", warehouse.getUppAvaQty());
            innerMap.put("poRcvQty", warehouse.getPoRcvQty());
            innerMap.put("description", warehouse.getDescription());
            innerMap.put("so45DemandQty", warehouse.getSo45DemandQty());
            innerMap.put("soAllDemandQty", warehouse.getSoAllDemandQty());
            innerMap.put("subAllOrderQty", warehouse.getErpOnHandQty() - warehouse.getSoAllDemandQty());
            innerMap.put("estimateAva", (Integer)innerMap.get("subAllOrderQty") + warehouse.getPoRcvQty());
            for (String dateStr : dateSet) {
                innerMap.put(dateStr, 0);
            }
            ArrayList<CrmsUSAReplenish> filterList = new ArrayList<CrmsUSAReplenish>();
            for (CrmsUSAReplenish e : replenishList) {
                if (warehouse.getItemCode() == null || !warehouse.getItemCode().equals(e.getOrderedItem())) continue;
                filterList.add(e);
            }
            for (CrmsUSAReplenish e : filterList) {
                String key = DateUtil.parseDate((Date)e.getScheduledArrivalDate());
                Integer o = (Integer)innerMap.get(key);
                if (o != null && o != 0) {
                    innerMap.put(key, o + (e.getShippedQuantity() - e.getDeliverQuantity()));
                    continue;
                }
                innerMap.put(key, e.getShippedQuantity() - e.getDeliverQuantity());
            }
            mapList.add(innerMap);
        }
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countByFullParams(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(mapList);
        this.logger.error("service.crms.CrmsUSAWarehouseOnHandServiceImpl getListPageFullParams() queryResult\u662f\uff1a", (Object)queryResult);
        return queryResult;
    }

    private int countByFullParams(Map<String, Object> map) {
        Integer count = this.crmsUSAWarehouseOnHandMapper.countByFullParams(map);
        this.logger.error("service.crms.CrmsUSAWarehouseOnHandServiceImpl countByFullParams() \u6267\u884c count\u662f\uff1a", (Object)count);
        return count;
    }
}

