/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.crp.service.impl;

import com.yqbsoft.laser.service.crp.dao.CrpUrechargeMapper;
import com.yqbsoft.laser.service.crp.domain.CrpChannelsendDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargeReDomain;
import com.yqbsoft.laser.service.crp.domain.CrpUrechargelistDomain;
import com.yqbsoft.laser.service.crp.enums.URechargeListTypeEnum;
import com.yqbsoft.laser.service.crp.model.CrpChannelsend;
import com.yqbsoft.laser.service.crp.model.CrpUrecharge;
import com.yqbsoft.laser.service.crp.service.CrpChannelsendService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargeService;
import com.yqbsoft.laser.service.crp.service.CrpUrechargelistService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CrpUrechargeServiceImpl
extends BaseServiceImpl
implements CrpUrechargeService {
    private static final String SYS_CODE = "service.adapter.crp.CrpUrechargeServiceImpl";
    private CrpUrechargeMapper crpUrechargeMapper;
    private CrpChannelsendService crpChannelsendService;
    private CrpUrechargelistService crpUrechargelistService;

    public CrpChannelsendService getCrpChannelsendService() {
        return this.crpChannelsendService;
    }

    public void setCrpChannelsendService(CrpChannelsendService crpChannelsendService) {
        this.crpChannelsendService = crpChannelsendService;
    }

    public void setCrpUrechargeMapper(CrpUrechargeMapper crpUrechargeMapper) {
        this.crpUrechargeMapper = crpUrechargeMapper;
    }

    public CrpUrechargelistService getCrpUrechargelistService() {
        return this.crpUrechargelistService;
    }

    public void setCrpUrechargelistService(CrpUrechargelistService crpUrechargelistService) {
        this.crpUrechargelistService = crpUrechargelistService;
    }

    private Date getSysDate() {
        try {
            return this.crpUrechargeMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCrp(CrpUrechargeDomain crpUrechargeDomain) {
        if (null == crpUrechargeDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)crpUrechargeDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCrpDefault(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return;
        }
        if (null == crpUrecharge.getDataState()) {
            crpUrecharge.setDataState(0);
        }
        Date date = this.getSysDate();
        if (null == crpUrecharge.getGmtCreate()) {
            crpUrecharge.setGmtCreate(date);
        }
        crpUrecharge.setGmtModified(date);
        if (StringUtils.isBlank((String)crpUrecharge.getUrechargeCode())) {
            crpUrecharge.setUrechargeCode(this.getNo(null, "CrpUrecharge", "crpUrecharge", crpUrecharge.getTenantCode()));
        }
    }

    private int getCrpMaxCode() {
        int code = 0;
        try {
            return this.crpUrechargeMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCrpUpdataDefault(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return;
        }
        crpUrecharge.setGmtModified(this.getSysDate());
    }

    private void saveCrpModel(CrpUrecharge crpUrecharge) throws ApiException {
        if (null == crpUrecharge) {
            return;
        }
        try {
            this.crpUrechargeMapper.insert(crpUrecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.saveCrpModel.ex", (Throwable)e);
        }
    }

    private void saveCrpBatchModel(List<CrpUrecharge> crpUrechargeList) throws ApiException {
        if (null == crpUrechargeList || crpUrechargeList.isEmpty()) {
            return;
        }
        try {
            this.crpUrechargeMapper.insertBatch(crpUrechargeList);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.saveCrpBatchModel.ex", (Throwable)e);
        }
    }

    private CrpUrecharge getCrpModelById(Integer urechargeId) {
        if (null == urechargeId) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.selectByPrimaryKey(urechargeId);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrecharge getCrpModelByUserInfoCode(String tenantCode, String userInfoCode) {
        if (null == userInfoCode) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.selectByUserInfoCode(tenantCode, userInfoCode);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpModelById", (Throwable)e);
            return null;
        }
    }

    private CrpUrecharge getCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.crpUrechargeMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.getCrpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCrpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.delCrpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.delCrpModelByCode.num");
        }
    }

    private void deleteCrpModel(Integer urechargeId) throws ApiException {
        if (null == urechargeId) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.deleteByPrimaryKey(urechargeId);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.deleteCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.deleteCrpModel.num");
        }
    }

    private void updateCrpModel(CrpUrecharge crpUrecharge) throws ApiException {
        if (null == crpUrecharge) {
            return;
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateByPrimaryKey(crpUrecharge);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrpModel.num");
        }
    }

    private void updateStateCrpModel(Integer urechargeId, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (null == urechargeId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("urechargeId", urechargeId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModel.null");
        }
    }

    private void updateAvailableQuotaModel(Integer urechargeId, BigDecimal quota, BigDecimal allMoney) throws ApiException {
        if (null == urechargeId || null == quota) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("urechargeId", urechargeId);
        map.put("quota", quota);
        map.put("allMoney", allMoney);
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateAvailableQuota(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateAvailableQuotaModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateAvailableQuotaModel.null");
        }
    }

    private void updateStateCrpModelByCode(String tenantCode, String urechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> expmap) throws ApiException {
        if (StringUtils.isBlank((String)urechargeCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        if (null != expmap && !expmap.isEmpty()) {
            map.putAll(expmap);
        }
        int i = 0;
        try {
            i = this.crpUrechargeMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateStateCrpModelByCode.null");
        }
    }

    private CrpUrecharge makeCrp(CrpUrechargeDomain crpUrechargeDomain, CrpUrecharge crpUrecharge) {
        if (null == crpUrechargeDomain) {
            return null;
        }
        if (null == crpUrecharge) {
            crpUrecharge = new CrpUrecharge();
        }
        try {
            BeanUtils.copyAllPropertys((Object)crpUrecharge, (Object)crpUrechargeDomain);
            return crpUrecharge;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.makeCrp", (Throwable)e);
            return null;
        }
    }

    private CrpUrechargeReDomain makeCrpUrechargeReDomain(CrpUrecharge crpUrecharge) {
        if (null == crpUrecharge) {
            return null;
        }
        CrpUrechargeReDomain crpUrechargeReDomain = new CrpUrechargeReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargeReDomain, (Object)crpUrecharge);
            return crpUrechargeReDomain;
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.makeCrpUrechargeReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CrpUrecharge> queryCrpModelPage(Map<String, Object> parammap) {
        try {
            return this.crpUrechargeMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.queryCrpModel", (Throwable)e);
            return null;
        }
    }

    private List<CrpUrechargeReDomain> queryCrpUModelPageList(Map<String, Object> parammap) {
        try {
            return this.crpUrechargeMapper.queryCrpURechargePageList(parammap);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.queryCrpModelPageList", (Throwable)e);
            return null;
        }
    }

    private int countCrp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpUrechargeMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private int countCrpURechargeRe(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.crpUrechargeMapper.countCrpURechargeRe(map);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.countCrp", (Throwable)e);
        }
        return i;
    }

    private CrpUrecharge createCrpUrecharge(CrpUrechargeDomain crpUrechargeDomain) {
        String msg = this.checkCrp(crpUrechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.saveCrp.checkCrp", msg);
        }
        CrpUrecharge crpUrecharge = this.makeCrp(crpUrechargeDomain, null);
        this.setCrpDefault(crpUrecharge);
        return crpUrecharge;
    }

    private List<CrpChannelsend> buidPmChannelsend(List<CrpUrecharge> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CrpChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<CrpChannelsendDomain> disChannelsendDomainList = new ArrayList<CrpChannelsendDomain>();
        for (CrpUrecharge promotion : pmPromotionList) {
            CrpChannelsendDomain pmChannelsendDomain = new CrpChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getUrechargeCode());
            pmChannelsendDomain.setChannelsendType("crpUrecharge");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.crpChannelsendService.saveCrpBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }

    @Override
    public List<CrpChannelsend> saveCrpUrecharge(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        CrpUrecharge crpUrecharge = this.createCrpUrecharge(crpUrechargeDomain);
        this.saveCrpModel(crpUrecharge);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        this.handlerCrpURecharge(crpUrecharge, URechargeListTypeEnum.ADD.getCode());
        return this.buidPmChannelsend(list, "insert");
    }

    @Override
    public List<CrpChannelsend> saveCrpUrechargeBatch(List<CrpUrechargeDomain> crpUrechargeDomainList) throws ApiException {
        if (null == crpUrechargeDomainList || crpUrechargeDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CrpChannelsend> crpUrechargeList = new ArrayList<CrpChannelsend>();
        for (CrpUrechargeDomain crpUrechargeDomain : crpUrechargeDomainList) {
            List<CrpChannelsend> list = this.saveCrpUrecharge(crpUrechargeDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            crpUrechargeList.addAll(list);
        }
        return crpUrechargeList;
    }

    private List<CrpChannelsend> buidPmChannelsendStr(List<CrpUrecharge> crpUrechargeList, String dri) {
        if (ListUtil.isEmpty(crpUrechargeList)) {
            return null;
        }
        ArrayList<CrpChannelsendDomain> crpChannelsendDomainArrayList = new ArrayList<CrpChannelsendDomain>();
        for (CrpUrecharge crpUrecharge : crpUrechargeList) {
            CrpChannelsendDomain crpChannelsendDomain = new CrpChannelsendDomain();
            crpChannelsendDomain.setChannelsendOpcode(crpUrecharge.getUrechargeCode());
            crpChannelsendDomain.setChannelsendType("crpUrecharge");
            crpChannelsendDomain.setChannelsendDir(dri);
            crpChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)crpUrecharge));
            crpChannelsendDomain.setTenantCode(crpUrecharge.getTenantCode());
            crpChannelsendDomainArrayList.add(crpChannelsendDomain);
        }
        List<CrpChannelsend> pmChannelsendList = this.crpChannelsendService.saveCrpBatch(crpChannelsendDomainArrayList);
        return pmChannelsendList;
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeState(Integer urechargeId, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModel(urechargeId, dataState, oldDataState, map);
        CrpUrecharge orgDepartemp = this.getCrpUrecharge(urechargeId);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateAvailableQuota(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        CrpUrecharge crpUrecharge = this.getCrpUrecharge(crpUrechargeDomain.getUrechargeId());
        crpUrecharge.setRechargeAllmoney(crpUrecharge.getRechargeAllmoney().add(crpUrechargeDomain.getRechargeAllmoney()));
        crpUrecharge.setRechargeSmoney(crpUrecharge.getRechargeSmoney().add(crpUrechargeDomain.getRechargeAllmoney()));
        crpUrecharge.setRechargePeriod(crpUrechargeDomain.getRechargePeriod());
        crpUrecharge.setRechargeName8(crpUrechargeDomain.getRechargeName8());
        crpUrecharge.setRechargeName9(crpUrechargeDomain.getRechargeName9());
        crpUrecharge.setRechargeName10(crpUrechargeDomain.getRechargeName10());
        crpUrecharge.setRechargeState(crpUrechargeDomain.getRechargeState());
        this.setCrpUpdataDefault(crpUrecharge);
        this.updateCrpModel(crpUrecharge);
        crpUrecharge.setQuota(crpUrechargeDomain.getRechargeAllmoney());
        crpUrecharge.setAllMoney(crpUrechargeDomain.getRechargeAllmoney());
        this.handlerCrpURecharge(crpUrecharge, URechargeListTypeEnum.UPDATE.getCode());
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> changeAvailableQuota(CrpUrecharge crpUrecharge, Map<String, Object> map) throws ApiException {
        BigDecimal quota = new BigDecimal(map.get("quota").toString());
        String quotaType = map.get("quotaType").toString();
        String rechargeOpno = map.get("contractBillcode").toString();
        if (URechargeListTypeEnum.ORDER_WITHHOLDING.getCode().equals(quotaType)) {
            quota = quota.multiply(new BigDecimal(-1));
        }
        crpUrecharge.setRechargeSmoney(crpUrecharge.getRechargeSmoney().add(quota));
        this.setCrpUpdataDefault(crpUrecharge);
        this.updateCrpModel(crpUrecharge);
        crpUrecharge.setQuota(quota);
        this.handlerCrpURecharge(crpUrecharge, quotaType, rechargeOpno);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    private void handlerCrpURecharge(CrpUrecharge crpUrecharge, String rechargeType) {
        this.handlerCrpURecharge(crpUrecharge, rechargeType, null);
    }

    private void handlerCrpURecharge(CrpUrecharge crpUrecharge, String rechargeType, String rechargeOpno) {
        CrpUrechargelistDomain crpUrechargelistDomain = new CrpUrechargelistDomain();
        try {
            BeanUtils.copyAllPropertys((Object)crpUrechargelistDomain, (Object)crpUrecharge);
            crpUrechargelistDomain.setRechargeAllmoney(crpUrecharge.getQuota() == null ? crpUrecharge.getRechargeSmoney() : crpUrecharge.getQuota());
            crpUrechargelistDomain.setUrechargeCode(crpUrecharge.getUrechargeCode());
            crpUrechargelistDomain.setRechargeType(rechargeType);
            crpUrechargelistDomain.setRechargeOpno(rechargeOpno);
            this.crpUrechargelistService.saveCrpUrechargelist(crpUrechargelistDomain);
        }
        catch (Exception e) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.handlerCrpRecharge", (Throwable)e);
        }
    }

    @Override
    public List<CrpChannelsend> updateCrpUrechargeStateByCode(String tenantCode, String urechargeCode, Integer dataState, Integer oldDataState, Map<String, Object> map) throws ApiException {
        this.updateStateCrpModelByCode(tenantCode, urechargeCode, dataState, oldDataState, map);
        CrpUrecharge orgDepartemp = this.getCrpUrechargeByCode(tenantCode, urechargeCode);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public List<CrpChannelsend> updateCrpUrecharge(CrpUrechargeDomain crpUrechargeDomain) throws ApiException {
        String msg = this.checkCrp(crpUrechargeDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrp.checkCrp", msg);
        }
        CrpUrecharge oldCrpUrecharge = this.getCrpModelById(crpUrechargeDomain.getUrechargeId());
        if (null == oldCrpUrecharge) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCrp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CrpUrecharge crpUrecharge = this.makeCrp(crpUrechargeDomain, oldCrpUrecharge);
        this.setCrpUpdataDefault(crpUrecharge);
        this.updateCrpModel(crpUrecharge);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(crpUrecharge);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public CrpUrecharge getCrpUrecharge(Integer urechargeId) {
        if (null == urechargeId) {
            return null;
        }
        return this.getCrpModelById(urechargeId);
    }

    @Override
    public List<CrpChannelsend> deleteCrpUrecharge(Integer urechargeId) throws ApiException {
        CrpUrecharge orgDepartemp = this.getCrpUrecharge(urechargeId);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        this.deleteCrpModel(urechargeId);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public QueryResult<CrpUrecharge> queryCrpUrechargePage(Map<String, Object> map) {
        List<CrpUrecharge> crpUrechargeList = this.queryCrpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpUrechargeList);
        return queryResult;
    }

    @Override
    public QueryResult<CrpUrechargeReDomain> queryCrpURechargePageList(Map<String, Object> map) {
        List<CrpUrechargeReDomain> crpUrechargeList = this.queryCrpUModelPageList(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCrpURechargeRe(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(crpUrechargeList);
        return queryResult;
    }

    @Override
    public CrpUrecharge getCrpUrechargeByCode(String tenantCode, String urechargeCode) throws ApiException {
        if (StringUtils.isBlank((String)urechargeCode) || StringUtils.isBlank((String)tenantCode)) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        return this.getCrpModelByCode(map);
    }

    @Override
    public CrpUrecharge selectByUserInfoCode(String tenantCode, String userInfoCode) throws ApiException {
        if (null == userInfoCode) {
            return null;
        }
        return this.getCrpModelByUserInfoCode(tenantCode, userInfoCode);
    }

    @Override
    public List<CrpChannelsend> deleteCrpUrechargeByCode(String tenantCode, String urechargeCode) throws ApiException {
        CrpUrecharge orgDepartemp = this.getCrpUrechargeByCode(tenantCode, urechargeCode);
        ArrayList<CrpUrecharge> list = new ArrayList<CrpUrecharge>();
        list.add(orgDepartemp);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("urechargeCode", urechargeCode);
        this.delCrpModelByCode(map);
        return this.buidPmChannelsendStr(list, "update");
    }

    @Override
    public Map<String, Object> deductibleCrp(BigDecimal goodsPmoney, String tenantCode, String userinfoCode) throws ApiException {
        if (null == goodsPmoney || StringUtils.isBlank((String)tenantCode) || StringUtils.isBlank((String)userinfoCode)) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.deductibleCrp", (Object)("goodsPmoney:" + goodsPmoney + "tenantCode:" + tenantCode + "userinfoCode:" + userinfoCode));
            return null;
        }
        HashMap<String, Object> iamap = new HashMap<String, Object>();
        CrpUrecharge crpUrecharge = this.selectByUserInfoCode(tenantCode, userinfoCode);
        if (null == crpUrecharge) {
            this.logger.error("service.adapter.crp.CrpUrechargeServiceImpl.deductibleCrp", (Object)("goodsPmoney:" + goodsPmoney + "tenantCode:" + tenantCode + "userinfoCode:" + userinfoCode));
            return null;
        }
        BigDecimal rechargeSmoney = crpUrecharge.getRechargeSmoney();
        if (null == rechargeSmoney) {
            rechargeSmoney = new BigDecimal(0);
        }
        BigDecimal disamount = new BigDecimal(0);
        disamount = rechargeSmoney.compareTo(goodsPmoney) > -1 ? goodsPmoney : rechargeSmoney;
        iamap.put("dataState", "0");
        iamap.put("disamount", disamount);
        return iamap;
    }

    @Override
    public void sendupdateCreditRepaymentMoneyOb(Map<String, Object> map) {
        this.updateCreditMoneys(map);
    }

    public void updateCreditMoneys(Map<String, Object> map) {
        int i = 0;
        try {
            this.logger.error("map---->", map);
            i = this.crpUrechargeMapper.updateCreditMoney(map);
        }
        catch (Exception e) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCreditMoney.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("service.adapter.crp.CrpUrechargeServiceImpl.updateCreditMoney.null");
        }
    }
}

