/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.customer.service.impl;

import com.yqbsoft.laser.service.customer.dao.CtCustrelEmpMapper;
import com.yqbsoft.laser.service.customer.dao.CtCustrelMapper;
import com.yqbsoft.laser.service.customer.domain.CtCustrelDomain;
import com.yqbsoft.laser.service.customer.domain.CtCustrelEmpDomain;
import com.yqbsoft.laser.service.customer.domain.CtCustrelEmpReDomain;
import com.yqbsoft.laser.service.customer.domain.CtCustrelReDomain;
import com.yqbsoft.laser.service.customer.domain.OrgCompany;
import com.yqbsoft.laser.service.customer.domain.OrgEmployee;
import com.yqbsoft.laser.service.customer.domain.UmUserinfo;
import com.yqbsoft.laser.service.customer.model.CtCustrel;
import com.yqbsoft.laser.service.customer.model.CtCustrelEmp;
import com.yqbsoft.laser.service.customer.service.CtCustrelService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CtCustrelServiceImpl
extends BaseServiceImpl
implements CtCustrelService {
    private static final String SYS_CODE = "ct.CtCustrelServiceImpl";
    private CtCustrelMapper ctCustrelMapper;
    private CtCustrelEmpMapper ctCustrelEmpMapper;

    public void setCtCustrelMapper(CtCustrelMapper ctCustrelMapper) {
        this.ctCustrelMapper = ctCustrelMapper;
    }

    public void setCtCustrelEmpMapper(CtCustrelEmpMapper ctCustrelEmpMapper) {
        this.ctCustrelEmpMapper = ctCustrelEmpMapper;
    }

    private Date getSysDate() {
        try {
            return this.ctCustrelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCustrel(CtCustrelDomain ctCustrelDomain) {
        if (null == ctCustrelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ctCustrelDomain.getCompanyCode())) {
            msg = msg + "CompanyCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ctCustrelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCustrelDefault(CtCustrel ctCustrel) {
        if (null == ctCustrel) {
            return;
        }
        ctCustrel.setCustrelId(null);
        if (null == ctCustrel.getDataState()) {
            ctCustrel.setDataState(0);
        }
        if (null == ctCustrel.getGmtCreate()) {
            ctCustrel.setGmtCreate(this.getSysDate());
        }
        ctCustrel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ctCustrel.getCustrelCode())) {
            ctCustrel.setCustrelCode(this.createUUIDString());
        }
    }

    private int getCustrelMaxCode() {
        int code = 0;
        try {
            return this.ctCustrelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCustrelUpdataDefault(CtCustrel ctCustrel) {
        if (null == ctCustrel) {
            return;
        }
        ctCustrel.setGmtModified(this.getSysDate());
    }

    private void saveCustrelModel(CtCustrel ctCustrel) throws ApiException {
        if (null == ctCustrel) {
            return;
        }
        try {
            this.ctCustrelMapper.insert(ctCustrel);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelModel.ex", (Throwable)e);
        }
    }

    private void saveCustrelBatchModel(List<CtCustrel> ctCustrelList) throws ApiException {
        if (null == ctCustrelList || ctCustrelList.isEmpty()) {
            return;
        }
        try {
            this.ctCustrelMapper.insertBatch(ctCustrelList);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelBatchModel.ex", (Throwable)e);
        }
    }

    private CtCustrel getCustrelModelById(Integer custrelId) {
        if (null == custrelId) {
            return null;
        }
        try {
            return this.ctCustrelMapper.selectByPrimaryKey(custrelId);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelModelById", (Throwable)e);
            return null;
        }
    }

    private CtCustrel getCustrelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ctCustrelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCustrelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.delCustrelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.delCustrelModelByCode.num");
        }
    }

    private void deleteCustrelModel(Integer custrelId) throws ApiException {
        if (null == custrelId) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelMapper.deleteByPrimaryKey(custrelId);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.deleteCustrelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.deleteCustrelModel.num");
        }
    }

    private void updateCustrelModel(CtCustrel ctCustrel) throws ApiException {
        if (null == ctCustrel) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelMapper.updateByPrimaryKeySelective(ctCustrel);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelModel.num");
        }
    }

    private void updateEmpByCode(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelMapper.updateEmpByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateEmpByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateEmpByCode.num");
        }
    }

    private void updateStateCustrelModel(Integer custrelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == custrelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("custrelId", custrelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ctCustrelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelModel.null");
        }
    }

    private void updateStateCustrelModelByCode(String tenantCode, String custrelCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)custrelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelCode", custrelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ctCustrelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelModelByCode.null");
        }
    }

    private CtCustrel makeCustrel(CtCustrelDomain ctCustrelDomain, CtCustrel ctCustrel) {
        if (null == ctCustrelDomain) {
            return null;
        }
        if (null == ctCustrel) {
            ctCustrel = new CtCustrel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrel, (Object)ctCustrelDomain);
            return ctCustrel;
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.makeCustrel", (Throwable)e);
            return null;
        }
    }

    private CtCustrelReDomain makeCtCustrelReDomain(CtCustrel ctCustrel) {
        if (null == ctCustrel) {
            return null;
        }
        CtCustrelReDomain ctCustrelReDomain = new CtCustrelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrelReDomain, (Object)ctCustrel);
            return ctCustrelReDomain;
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.makeCtCustrelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CtCustrel> queryCustrelModelPage(Map<String, Object> parammap) {
        try {
            return this.ctCustrelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.queryCustrelModel", (Throwable)e);
            return null;
        }
    }

    private int countCustrel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ctCustrelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.countCustrel", (Throwable)e);
        }
        return i;
    }

    private CtCustrel createCtCustrel(CtCustrelDomain ctCustrelDomain) {
        String msg = this.checkCustrel(ctCustrelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrel.checkCustrel", msg);
        }
        CtCustrel ctCustrel = this.makeCustrel(ctCustrelDomain, null);
        this.setCustrelDefault(ctCustrel);
        return ctCustrel;
    }

    private String checkCustrelEmp(CtCustrelEmpDomain ctCustrelEmpDomain) {
        if (null == ctCustrelEmpDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ctCustrelEmpDomain.getEmployeeCode())) {
            msg = msg + "EmployeeCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ctCustrelEmpDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCustrelEmpDefault(CtCustrelEmp ctCustrelEmp) {
        if (null == ctCustrelEmp) {
            return;
        }
        if (null == ctCustrelEmp.getDataState()) {
            ctCustrelEmp.setDataState(0);
        }
        if (null == ctCustrelEmp.getGmtCreate()) {
            ctCustrelEmp.setGmtCreate(this.getSysDate());
        }
        ctCustrelEmp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ctCustrelEmp.getCustrelEmpCode())) {
            ctCustrelEmp.setCustrelEmpCode(this.createUUIDString());
        }
    }

    private int getCustrelEmpMaxCode() {
        int code = 0;
        try {
            return this.ctCustrelEmpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelEmpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCustrelEmpUpdataDefault(CtCustrelEmp ctCustrelEmp) {
        if (null == ctCustrelEmp) {
            return;
        }
        ctCustrelEmp.setGmtModified(this.getSysDate());
    }

    private void saveCustrelEmpModel(CtCustrelEmp ctCustrelEmp) throws ApiException {
        if (null == ctCustrelEmp) {
            return;
        }
        try {
            this.ctCustrelEmpMapper.insert(ctCustrelEmp);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelEmpModel.ex", (Throwable)e);
        }
    }

    private void saveCustrelEmpBatchModel(List<CtCustrelEmp> ctCustrelEmpList) throws ApiException {
        if (null == ctCustrelEmpList || ctCustrelEmpList.isEmpty()) {
            return;
        }
        try {
            this.ctCustrelEmpMapper.insertBatch(ctCustrelEmpList);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelEmpBatchModel.ex", (Throwable)e);
        }
    }

    private CtCustrelEmp getCustrelEmpModelById(Integer custrelEmpId) {
        if (null == custrelEmpId) {
            return null;
        }
        try {
            return this.ctCustrelEmpMapper.selectByPrimaryKey(custrelEmpId);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelEmpModelById", (Throwable)e);
            return null;
        }
    }

    private CtCustrelEmp getCustrelEmpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ctCustrelEmpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelEmpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCustrelEmpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.delCustrelEmpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.delCustrelEmpModelByCode.num");
        }
    }

    private void deleteCustrelEmpModel(Integer custrelEmpId) throws ApiException {
        if (null == custrelEmpId) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.deleteByPrimaryKey(custrelEmpId);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.deleteCustrelEmpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.deleteCustrelEmpModel.num");
        }
    }

    private void updateCustrelEmpModel(CtCustrelEmp ctCustrelEmp) throws ApiException {
        if (null == ctCustrelEmp) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.updateByPrimaryKeySelective(ctCustrelEmp);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelEmpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelEmpModel.num");
        }
    }

    private void updateStateCustrelEmpModel(Integer custrelEmpId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == custrelEmpId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("custrelEmpId", custrelEmpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelEmpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelEmpModel.null");
        }
    }

    private void updateStateCustrelEmpModelByCode(String tenantCode, String custrelEmpCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)custrelEmpCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelEmpCode", custrelEmpCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelEmpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelEmpModelByCode.null");
        }
    }

    private CtCustrelEmp makeCustrelEmp(CtCustrelEmpDomain ctCustrelEmpDomain, CtCustrelEmp ctCustrelEmp) {
        if (null == ctCustrelEmpDomain) {
            return null;
        }
        if (null == ctCustrelEmp) {
            ctCustrelEmp = new CtCustrelEmp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrelEmp, (Object)ctCustrelEmpDomain);
            return ctCustrelEmp;
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.makeCustrelEmp", (Throwable)e);
            return null;
        }
    }

    private CtCustrelEmpReDomain makeCtCustrelEmpReDomain(CtCustrelEmp ctCustrelEmp) {
        if (null == ctCustrelEmp) {
            return null;
        }
        CtCustrelEmpReDomain ctCustrelEmpReDomain = new CtCustrelEmpReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrelEmpReDomain, (Object)ctCustrelEmp);
            return ctCustrelEmpReDomain;
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.makeCtCustrelEmpReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CtCustrelEmp> queryCustrelEmpModelPage(Map<String, Object> parammap) {
        try {
            return this.ctCustrelEmpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.queryCustrelEmpModel", (Throwable)e);
            return null;
        }
    }

    private int countCustrelEmp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.countCustrelEmp", (Throwable)e);
        }
        return i;
    }

    private CtCustrelEmp createCtCustrelEmp(CtCustrelEmpDomain ctCustrelEmpDomain) {
        String msg = this.checkCustrelEmp(ctCustrelEmpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelEmp.checkCustrelEmp", msg);
        }
        CtCustrelEmp ctCustrelEmp = this.makeCustrelEmp(ctCustrelEmpDomain, null);
        this.setCustrelEmpDefault(ctCustrelEmp);
        return ctCustrelEmp;
    }

    @Override
    public String saveCustrel(CtCustrelDomain ctCustrelDomain) throws ApiException {
        CtCustrel ctCustrel = this.createCtCustrel(ctCustrelDomain);
        this.saveCustrelModel(ctCustrel);
        return ctCustrel.getCustrelCode();
    }

    private void saveCustrelEmp(CtCustrel ctCustrel, OrgEmployee orgEmployee) {
        if (null == ctCustrel || null == orgEmployee) {
            return;
        }
        ctCustrel.setEmployeeCode(orgEmployee.getEmployeeCode());
        ctCustrel.setEmployeeName(orgEmployee.getEmployeeName());
        CtCustrelEmpDomain ctCustrelEmpDomain = new CtCustrelEmpDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrelEmpDomain, (Object)ctCustrel);
        }
        catch (Exception e) {
            // empty catch block
        }
        ctCustrelEmpDomain.setEmployeeCode(orgEmployee.getEmployeeCode());
        ctCustrelEmpDomain.setEmployeeName(orgEmployee.getEmployeeName());
        this.saveCustrelEmp(ctCustrelEmpDomain);
    }

    private OrgEmployee getEmp(String tenantCode, String employeeCode) {
        if (StringUtils.isBlank((String)employeeCode)) {
            return null;
        }
        String api = "org.employee.getEmployeeByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("employeeCode", employeeCode);
        paramMap.put("tenantCode", tenantCode);
        String json = this.internalInvoke(api, paramMap);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelEmp.json");
        }
        OrgEmployee orgEmployee = (OrgEmployee)JsonUtil.buildNormalBinder().getJsonToObject(json, OrgEmployee.class);
        if (null == orgEmployee) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelEmp.orgEmployee");
        }
        return orgEmployee;
    }

    @Override
    public CtCustrel saveCustrelByUserinfoCode(String userinfoCode, String companyCode, String employeeCode, String tenantCode) throws ApiException {
        this.logger.error("===1.1====" + userinfoCode + companyCode + tenantCode);
        if (StringUtils.hasBlank((String[])new String[]{userinfoCode, companyCode, tenantCode})) {
            return null;
        }
        this.logger.error("===1====" + employeeCode);
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("userinfoCode", userinfoCode);
        parammap.put("companyCode", companyCode);
        parammap.put("tenantCode", tenantCode);
        List<CtCustrel> ulist = this.queryCustrelModelPage(parammap);
        OrgEmployee orgEmployee = this.getEmp(tenantCode, employeeCode);
        if (null != ulist && !ulist.isEmpty()) {
            CtCustrel ctCustrel = ulist.get(0);
            this.logger.error("===2====" + employeeCode);
            if (StringUtils.isNotBlank((String)employeeCode)) {
                this.saveCustrelEmp(ctCustrel, orgEmployee);
                this.updateCustrelModel(ctCustrel);
                this.logger.error("====3===" + employeeCode);
            }
            return ulist.get(0);
        }
        String json = DisUtil.getMap((String)"OrgCompany-companyCode", (String)(companyCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelByUserinfoCode.companyCode");
        }
        if (StringUtils.isBlank((String)(json = DisUtil.getMap((String)"OrgCompany-all", (String)(json + "-" + tenantCode))))) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelByUserinfoCode.OrgCompany");
        }
        OrgCompany orgCompany = (OrgCompany)JsonUtil.buildNormalBinder().getJsonToObject(json, OrgCompany.class);
        if (null == orgCompany) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelByUserinfoCode.orgCompany");
        }
        CtCustrelDomain ctCustrelDomain = this.makeCtCustrelDomain(userinfoCode, tenantCode);
        if (null == ctCustrelDomain) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelByUserinfoCode.ctCustrelDomain");
        }
        ctCustrelDomain.setCompanyCode(orgCompany.getCompanyCode());
        ctCustrelDomain.setEmployeeCode(employeeCode);
        if (null != orgEmployee) {
            ctCustrelDomain.setEmployeeName(orgEmployee.getEmployeeName());
        }
        ctCustrelDomain.setCompanyShortname(orgCompany.getCompanyShortname());
        CtCustrel ctCustrel = this.createCtCustrel(ctCustrelDomain);
        this.saveCustrelModel(ctCustrel);
        if (StringUtils.isNotBlank((String)employeeCode)) {
            this.saveCustrelEmp(ctCustrel, orgEmployee);
        }
        return ctCustrel;
    }

    private CtCustrelDomain makeCtCustrelDomain(String userinfoCode, String tenantCode) {
        if (StringUtils.hasBlank((String[])new String[]{userinfoCode, tenantCode})) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByUserCode";
        CtCustrelDomain ctCustrelDomain = new CtCustrelDomain();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        String json = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(json, UmUserinfo.class);
        if (null == umUserinfo) {
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrelDomain, (Object)umUserinfo);
        }
        catch (Exception e) {
            return null;
        }
        ctCustrelDomain.setCustrelType(umUserinfo.getUserinfoType());
        ctCustrelDomain.setCustrelTel(umUserinfo.getUserinfoTel());
        ctCustrelDomain.setCustrelCorp(umUserinfo.getUserinfoCorp());
        ctCustrelDomain.setCustrelCoid(umUserinfo.getUserinfoCoid());
        ctCustrelDomain.setCustrelEmail(umUserinfo.getUserinfoEmail());
        ctCustrelDomain.setCustrelTaun(umUserinfo.getUserinfoTaun());
        ctCustrelDomain.setCustrelCon(umUserinfo.getUserinfoCon());
        ctCustrelDomain.setCustrelPhone(umUserinfo.getUserinfoPhone());
        ctCustrelDomain.setCustrelConQq(umUserinfo.getUserinfoConQq());
        ctCustrelDomain.setCustrelCertNo(umUserinfo.getUserinfoCertNo());
        ctCustrelDomain.setCustrelCert1No(umUserinfo.getUserinfoCert1No());
        ctCustrelDomain.setCustrelCert2No(umUserinfo.getUserinfoCert2No());
        ctCustrelDomain.setCustrelCertUrl(umUserinfo.getUserinfoCertUrl());
        ctCustrelDomain.setCustrelCert1Url(umUserinfo.getUserinfoCert1Url());
        ctCustrelDomain.setCustrelCert2Url(umUserinfo.getUserinfoCert2Url());
        ctCustrelDomain.setCustrelConPhone(umUserinfo.getUserinfoConPhone());
        ctCustrelDomain.setCustrelName(umUserinfo.getUserinfoCompname());
        return ctCustrelDomain;
    }

    @Override
    public String saveCustrelBatch(List<CtCustrelDomain> ctCustrelDomainList) throws ApiException {
        if (null == ctCustrelDomainList || ctCustrelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CtCustrel> ctCustrelList = new ArrayList<CtCustrel>();
        String code = "";
        for (CtCustrelDomain ctCustrelDomain : ctCustrelDomainList) {
            CtCustrel ctCustrel = this.createCtCustrel(ctCustrelDomain);
            code = ctCustrel.getCustrelCode();
            ctCustrelList.add(ctCustrel);
        }
        this.saveCustrelBatchModel(ctCustrelList);
        return code;
    }

    @Override
    public void updateCustrelState(Integer custrelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCustrelModel(custrelId, dataState, oldDataState);
    }

    @Override
    public void updateCustrelStateByCode(String tenantCode, String custrelCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCustrelModelByCode(tenantCode, custrelCode, dataState, oldDataState);
    }

    @Override
    public void updateCustrel(CtCustrelDomain ctCustrelDomain) throws ApiException {
        String msg = this.checkCustrel(ctCustrelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrel.checkCustrel", msg);
        }
        CtCustrel oldCtCustrel = this.getCustrelModelById(ctCustrelDomain.getCustrelId());
        if (null == oldCtCustrel) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CtCustrel ctCustrel = this.makeCustrel(ctCustrelDomain, oldCtCustrel);
        this.setCustrelUpdataDefault(ctCustrel);
        this.updateCustrelModel(ctCustrel);
    }

    @Override
    public CtCustrel getCustrel(Integer custrelId) {
        return this.getCustrelModelById(custrelId);
    }

    @Override
    public void deleteCustrel(Integer custrelId) throws ApiException {
        this.deleteCustrelModel(custrelId);
    }

    @Override
    public QueryResult<CtCustrel> queryCustrelPage(Map<String, Object> map) {
        List<CtCustrel> ctCustrelList = this.queryCustrelModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCustrel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ctCustrelList);
        return queryResult;
    }

    @Override
    public CtCustrel getCustrelByCode(String tenantCode, String custrelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelCode", custrelCode);
        return this.getCustrelModelByCode(map);
    }

    @Override
    public void deleteCustrelByCode(String tenantCode, String custrelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelCode", custrelCode);
        this.delCustrelModelByCode(map);
    }

    @Override
    public String saveCustrelEmp(CtCustrelEmpDomain ctCustrelEmpDomain) throws ApiException {
        CtCustrelEmp ctCustrelEmp = this.createCtCustrelEmp(ctCustrelEmpDomain);
        this.saveCust(ctCustrelEmp);
        this.saveCustrelEmpModel(ctCustrelEmp);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("custrelCode", ctCustrelEmp.getCustrelCode());
        map.put("employeeCode", ctCustrelEmp.getEmployeeCode());
        map.put("employeeName", ctCustrelEmp.getEmployeeName());
        map.put("tenantCode", ctCustrelEmp.getTenantCode());
        map.put("dataState", 2);
        this.updateEmpByCode(map);
        return ctCustrelEmp.getCustrelEmpCode();
    }

    private void saveCust(CtCustrelEmp ctCustrelEmp) {
        if (null == ctCustrelEmp) {
            return;
        }
        CtCustrel ctCustrel = this.getCustrelByCode(ctCustrelEmp.getTenantCode(), ctCustrelEmp.getCustrelCode());
        if (null == ctCustrel) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCust.ctCustrel", "\u6570\u636e\u4e3a\u7a7a");
        }
        ctCustrel.setEmployeeCode(ctCustrelEmp.getEmployeeCode());
        ctCustrel.setDataState(2);
        this.updateCustrelModel(ctCustrel);
    }

    @Override
    public String saveCustrelEmpBatch(List<CtCustrelEmpDomain> ctCustrelEmpDomainList) throws ApiException {
        if (null == ctCustrelEmpDomainList || ctCustrelEmpDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CtCustrelEmp> ctCustrelEmpList = new ArrayList<CtCustrelEmp>();
        String code = "";
        for (CtCustrelEmpDomain ctCustrelEmpDomain : ctCustrelEmpDomainList) {
            CtCustrelEmp ctCustrelEmp = this.createCtCustrelEmp(ctCustrelEmpDomain);
            code = ctCustrelEmp.getCustrelEmpCode();
            ctCustrelEmpList.add(ctCustrelEmp);
            this.saveCust(ctCustrelEmp);
        }
        this.saveCustrelEmpBatchModel(ctCustrelEmpList);
        return code;
    }

    @Override
    public void updateCustrelEmpState(Integer custrelEmpId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCustrelEmpModel(custrelEmpId, dataState, oldDataState);
    }

    @Override
    public void updateCustrelEmpStateByCode(String tenantCode, String custrelEmpCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCustrelEmpModelByCode(tenantCode, custrelEmpCode, dataState, oldDataState);
    }

    @Override
    public void updateCustrelEmp(CtCustrelEmpDomain ctCustrelEmpDomain) throws ApiException {
        String msg = this.checkCustrelEmp(ctCustrelEmpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelEmp.checkCustrelEmp", msg);
        }
        CtCustrelEmp oldCtCustrelEmp = this.getCustrelEmpModelById(ctCustrelEmpDomain.getCustrelEmpId());
        if (null == oldCtCustrelEmp) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelEmp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CtCustrelEmp ctCustrelEmp = this.makeCustrelEmp(ctCustrelEmpDomain, oldCtCustrelEmp);
        this.setCustrelEmpUpdataDefault(ctCustrelEmp);
        this.updateCustrelEmpModel(ctCustrelEmp);
    }

    @Override
    public CtCustrelEmp getCustrelEmp(Integer custrelEmpId) {
        return this.getCustrelEmpModelById(custrelEmpId);
    }

    @Override
    public void deleteCustrelEmp(Integer custrelEmpId) throws ApiException {
        this.deleteCustrelEmpModel(custrelEmpId);
    }

    @Override
    public QueryResult<CtCustrelEmp> queryCustrelEmpPage(Map<String, Object> map) {
        List<CtCustrelEmp> ctCustrelEmpList = this.queryCustrelEmpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCustrelEmp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ctCustrelEmpList);
        return queryResult;
    }

    @Override
    public CtCustrelEmp getCustrelEmpByCode(String tenantCode, String custrelEmpCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelEmpCode", custrelEmpCode);
        return this.getCustrelEmpModelByCode(map);
    }

    @Override
    public void deleteCustrelEmpByCode(String tenantCode, String custrelEmpCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelEmpCode", custrelEmpCode);
        this.delCustrelEmpModelByCode(map);
    }
}

