/*
 * Decompiled with CFR 0.152.
 */
package com.yqbsoft.laser.service.customer.service.impl;

import com.yqbsoft.laser.service.customer.dao.CtCustrelEmpMapper;
import com.yqbsoft.laser.service.customer.dao.CtCustrelMapper;
import com.yqbsoft.laser.service.customer.domain.CtChannelsendDomain;
import com.yqbsoft.laser.service.customer.domain.CtCustrelDomain;
import com.yqbsoft.laser.service.customer.domain.CtCustrelEmpDomain;
import com.yqbsoft.laser.service.customer.domain.CtCustrelEmpReDomain;
import com.yqbsoft.laser.service.customer.domain.CtCustrelReDomain;
import com.yqbsoft.laser.service.customer.domain.OrgCompany;
import com.yqbsoft.laser.service.customer.domain.OrgDepartemp;
import com.yqbsoft.laser.service.customer.domain.OrgEmployee;
import com.yqbsoft.laser.service.customer.domain.UmUserinfo;
import com.yqbsoft.laser.service.customer.model.CtChannelsend;
import com.yqbsoft.laser.service.customer.model.CtCustrel;
import com.yqbsoft.laser.service.customer.model.CtCustrelEmp;
import com.yqbsoft.laser.service.customer.service.CtChannelsendService;
import com.yqbsoft.laser.service.customer.service.CtCustrelService;
import com.yqbsoft.laser.service.esb.core.ApiException;
import com.yqbsoft.laser.service.esb.core.cache.dis.DisUtil;
import com.yqbsoft.laser.service.esb.core.support.BaseServiceImpl;
import com.yqbsoft.laser.service.esb.core.transformer.PageTools;
import com.yqbsoft.laser.service.esb.core.transformer.QueryResult;
import com.yqbsoft.laser.service.suppercore.transformer.SupPageTools;
import com.yqbsoft.laser.service.tool.util.BeanUtils;
import com.yqbsoft.laser.service.tool.util.JsonUtil;
import com.yqbsoft.laser.service.tool.util.ListUtil;
import com.yqbsoft.laser.service.tool.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CtCustrelServiceImpl
extends BaseServiceImpl
implements CtCustrelService {
    private static final String SYS_CODE = "ct.CtCustrelServiceImpl";
    private CtCustrelMapper ctCustrelMapper;
    private CtCustrelEmpMapper ctCustrelEmpMapper;
    private CtChannelsendService ctChannelsendService;

    public void setCtCustrelMapper(CtCustrelMapper ctCustrelMapper) {
        this.ctCustrelMapper = ctCustrelMapper;
    }

    public void setCtCustrelEmpMapper(CtCustrelEmpMapper ctCustrelEmpMapper) {
        this.ctCustrelEmpMapper = ctCustrelEmpMapper;
    }

    public void setCtChannelsendService(CtChannelsendService ctChannelsendService) {
        this.ctChannelsendService = ctChannelsendService;
    }

    private Date getSysDate() {
        try {
            return this.ctCustrelMapper.selectSysDate();
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getSysDate", (Throwable)e);
            return null;
        }
    }

    private String checkCustrel(CtCustrelDomain ctCustrelDomain) {
        if (null == ctCustrelDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ctCustrelDomain.getCompanyCode())) {
            msg = msg + "CompanyCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ctCustrelDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCustrelDefault(CtCustrel ctCustrel) {
        if (null == ctCustrel) {
            return;
        }
        ctCustrel.setCustrelId(null);
        if (null == ctCustrel.getDataState()) {
            ctCustrel.setDataState(0);
        }
        if (null == ctCustrel.getGmtCreate()) {
            ctCustrel.setGmtCreate(this.getSysDate());
        }
        ctCustrel.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ctCustrel.getCustrelCode())) {
            ctCustrel.setCustrelCode(this.createUUIDString());
        }
    }

    private int getCustrelMaxCode() {
        int code = 0;
        try {
            return this.ctCustrelMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCustrelUpdataDefault(CtCustrel ctCustrel) {
        if (null == ctCustrel) {
            return;
        }
        ctCustrel.setGmtModified(this.getSysDate());
    }

    private void saveCustrelModel(CtCustrel ctCustrel) throws ApiException {
        if (null == ctCustrel) {
            return;
        }
        try {
            this.ctCustrelMapper.insert(ctCustrel);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelModel.ex", (Throwable)e);
        }
    }

    private void saveCustrelBatchModel(List<CtCustrel> ctCustrelList) throws ApiException {
        if (null == ctCustrelList || ctCustrelList.isEmpty()) {
            return;
        }
        try {
            this.ctCustrelMapper.insertBatch(ctCustrelList);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelBatchModel.ex", (Throwable)e);
        }
    }

    private CtCustrel getCustrelModelById(Integer custrelId) {
        if (null == custrelId) {
            return null;
        }
        try {
            return this.ctCustrelMapper.selectByPrimaryKey(custrelId);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelModelById", (Throwable)e);
            return null;
        }
    }

    private CtCustrel getCustrelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ctCustrelMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCustrelModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.delCustrelModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.delCustrelModelByCode.num");
        }
    }

    private void deleteCustrelModel(Integer custrelId) throws ApiException {
        if (null == custrelId) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelMapper.deleteByPrimaryKey(custrelId);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.deleteCustrelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.deleteCustrelModel.num");
        }
    }

    private void updateCustrelModel(CtCustrel ctCustrel) throws ApiException {
        if (null == ctCustrel) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelMapper.updateByPrimaryKeySelective(ctCustrel);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelModel.num");
        }
    }

    private void updateEmpByCode(Map<String, Object> map) throws ApiException {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelMapper.updateEmpByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateEmpByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateEmpByCode.num");
        }
    }

    private void updateStateCustrelModel(Integer custrelId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == custrelId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("custrelId", custrelId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ctCustrelMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelModel.null");
        }
    }

    private void updateBatchStateCustrelModel(List<String> custrelIds, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == custrelIds || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            for (String string : custrelIds.get(0).split(",")) {
                this.logger.info("string==============" + string + "====================");
                map.put("custrelId", Integer.valueOf(string));
                i = this.ctCustrelMapper.updateBatchStateCustrelModel(map);
            }
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelModel.null");
        }
    }

    private void updateStateCustrelModelByCode(String tenantCode, String custrelCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)custrelCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelCode", custrelCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ctCustrelMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelModelByCode.null");
        }
    }

    private CtCustrel makeCustrel(CtCustrelDomain ctCustrelDomain, CtCustrel ctCustrel) {
        if (null == ctCustrelDomain) {
            return null;
        }
        if (null == ctCustrel) {
            ctCustrel = new CtCustrel();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrel, (Object)ctCustrelDomain);
            return ctCustrel;
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.makeCustrel", (Throwable)e);
            return null;
        }
    }

    private CtCustrelReDomain makeCtCustrelReDomain(CtCustrel ctCustrel) {
        if (null == ctCustrel) {
            return null;
        }
        CtCustrelReDomain ctCustrelReDomain = new CtCustrelReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrelReDomain, (Object)ctCustrel);
            return ctCustrelReDomain;
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.makeCtCustrelReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CtCustrel> queryCustrelModelPage(Map<String, Object> parammap) {
        try {
            return this.ctCustrelMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.queryCustrelModel", (Throwable)e);
            return null;
        }
    }

    private int countCustrel(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ctCustrelMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.countCustrel", (Throwable)e);
        }
        return i;
    }

    private CtCustrel createCtCustrel(CtCustrelDomain ctCustrelDomain) {
        String msg = this.checkCustrel(ctCustrelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrel.checkCustrel", msg);
        }
        CtCustrel ctCustrel = this.makeCustrel(ctCustrelDomain, null);
        this.setCustrelDefault(ctCustrel);
        return ctCustrel;
    }

    private String checkCustrelEmp(CtCustrelEmpDomain ctCustrelEmpDomain) {
        if (null == ctCustrelEmpDomain) {
            return "\u53c2\u6570\u4e3a\u7a7a";
        }
        String msg = "";
        if (StringUtils.isBlank((String)ctCustrelEmpDomain.getEmployeeCode())) {
            msg = msg + "EmployeeCode\u4e3a\u7a7a;";
        }
        if (StringUtils.isBlank((String)ctCustrelEmpDomain.getTenantCode())) {
            msg = msg + "TenantCode\u4e3a\u7a7a;";
        }
        return msg;
    }

    private void setCustrelEmpDefault(CtCustrelEmp ctCustrelEmp) {
        if (null == ctCustrelEmp) {
            return;
        }
        if (null == ctCustrelEmp.getDataState()) {
            ctCustrelEmp.setDataState(0);
        }
        if (null == ctCustrelEmp.getGmtCreate()) {
            ctCustrelEmp.setGmtCreate(this.getSysDate());
        }
        ctCustrelEmp.setGmtModified(this.getSysDate());
        if (StringUtils.isBlank((String)ctCustrelEmp.getCustrelEmpCode())) {
            ctCustrelEmp.setCustrelEmpCode(this.createUUIDString());
        }
    }

    private int getCustrelEmpMaxCode() {
        int code = 0;
        try {
            return this.ctCustrelEmpMapper.getMaxCode();
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelEmpMaxCode", (Throwable)e);
            return code;
        }
    }

    private void setCustrelEmpUpdataDefault(CtCustrelEmp ctCustrelEmp) {
        if (null == ctCustrelEmp) {
            return;
        }
        ctCustrelEmp.setGmtModified(this.getSysDate());
    }

    private void saveCustrelEmpModel(CtCustrelEmp ctCustrelEmp) throws ApiException {
        int i = 0;
        if (null == ctCustrelEmp) {
            return;
        }
        try {
            i = this.ctCustrelEmpMapper.insert(ctCustrelEmp);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelEmpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelEmpModel.null");
        }
    }

    private void saveCustrelEmpBatchModel(List<CtCustrelEmp> ctCustrelEmpList) throws ApiException {
        if (null == ctCustrelEmpList || ctCustrelEmpList.isEmpty()) {
            return;
        }
        try {
            this.ctCustrelEmpMapper.insertBatch(ctCustrelEmpList);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelEmpBatchModel.ex", (Throwable)e);
        }
    }

    private CtCustrelEmp getCustrelEmpModelById(Integer custrelEmpId) {
        if (null == custrelEmpId) {
            return null;
        }
        try {
            return this.ctCustrelEmpMapper.selectByPrimaryKey(custrelEmpId);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelEmpModelById", (Throwable)e);
            return null;
        }
    }

    private CtCustrelEmp getCustrelEmpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return null;
        }
        try {
            return this.ctCustrelEmpMapper.getByCode(map);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.getCustrelEmpModelByCode", (Throwable)e);
            return null;
        }
    }

    private void delCustrelEmpModelByCode(Map<String, Object> map) {
        if (null == map || map.isEmpty()) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.delByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.delCustrelEmpModelByCode.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.delCustrelEmpModelByCode.num");
        }
    }

    private void deleteCustrelEmpModel(Integer custrelEmpId) throws ApiException {
        if (null == custrelEmpId) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.deleteByPrimaryKey(custrelEmpId);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.deleteCustrelEmpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.deleteCustrelEmpModel.num");
        }
    }

    private void updateCustrelEmpModel(CtCustrelEmp ctCustrelEmp) throws ApiException {
        if (null == ctCustrelEmp) {
            return;
        }
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.updateByPrimaryKeySelective(ctCustrelEmp);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelEmpModel.ex", (Throwable)e);
        }
        if (1 != i) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelEmpModel.num");
        }
    }

    private void updateStateCustrelEmpModel(Integer custrelEmpId, Integer dataState, Integer oldDataState) throws ApiException {
        if (null == custrelEmpId || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("custrelEmpId", custrelEmpId);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.updateStateByPrimaryKey(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelEmpModel.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelEmpModel.null");
        }
    }

    private void updateStateCustrelEmpModelByCode(String tenantCode, String custrelEmpCode, Integer dataState, Integer oldDataState) throws ApiException {
        if (StringUtils.isBlank((String)custrelEmpCode) || null == dataState) {
            return;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelEmpCode", custrelEmpCode);
        map.put("dataState", dataState);
        map.put("oldDataState", oldDataState);
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.updateStateByCode(map);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelEmpModelByCode.ex", (Throwable)e);
        }
        if (i <= 0) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateStateCustrelEmpModelByCode.null");
        }
    }

    private CtCustrelEmp makeCustrelEmp(CtCustrelEmpDomain ctCustrelEmpDomain, CtCustrelEmp ctCustrelEmp) {
        if (null == ctCustrelEmpDomain) {
            return null;
        }
        if (null == ctCustrelEmp) {
            ctCustrelEmp = new CtCustrelEmp();
        }
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrelEmp, (Object)ctCustrelEmpDomain);
            return ctCustrelEmp;
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.makeCustrelEmp", (Throwable)e);
            return null;
        }
    }

    private CtCustrelEmpReDomain makeCtCustrelEmpReDomain(CtCustrelEmp ctCustrelEmp) {
        if (null == ctCustrelEmp) {
            return null;
        }
        CtCustrelEmpReDomain ctCustrelEmpReDomain = new CtCustrelEmpReDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrelEmpReDomain, (Object)ctCustrelEmp);
            return ctCustrelEmpReDomain;
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.makeCtCustrelEmpReDomain", (Throwable)e);
            return null;
        }
    }

    private List<CtCustrelEmp> queryCustrelEmpModelPage(Map<String, Object> parammap) {
        try {
            return this.ctCustrelEmpMapper.query(parammap);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.queryCustrelEmpModel", (Throwable)e);
            return null;
        }
    }

    private List<CtCustrel> queryCustrelPages(Map<String, Object> parammap) {
        try {
            return this.ctCustrelMapper.queryCustrelPages(parammap);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.queryCustrelEmpModel", (Throwable)e);
            return null;
        }
    }

    private int countCustrelEmp(Map<String, Object> map) {
        int i = 0;
        try {
            i = this.ctCustrelEmpMapper.count(map);
        }
        catch (Exception e) {
            this.logger.error("ct.CtCustrelServiceImpl.countCustrelEmp", (Throwable)e);
        }
        return i;
    }

    private CtCustrelEmp createCtCustrelEmp(CtCustrelEmpDomain ctCustrelEmpDomain) {
        String msg = this.checkCustrelEmp(ctCustrelEmpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelEmp.checkCustrelEmp", msg);
        }
        CtCustrelEmp ctCustrelEmp = this.makeCustrelEmp(ctCustrelEmpDomain, null);
        this.setCustrelEmpDefault(ctCustrelEmp);
        return ctCustrelEmp;
    }

    @Override
    public List<CtChannelsend> saveCustrel(CtCustrelDomain ctCustrelDomain) throws ApiException {
        CtCustrel ctCustrel = this.createCtCustrel(ctCustrelDomain);
        if (StringUtils.isNotBlank((String)ctCustrel.getEmployeeCode())) {
            ctCustrel.setDataState(2);
        } else if (StringUtils.isNotBlank((String)ctCustrelDomain.getDepartCode())) {
            ctCustrel.setDataState(1);
        }
        this.saveCustrelModel(ctCustrel);
        if (StringUtils.isNotBlank((String)ctCustrelDomain.getEmployeeCode())) {
            CtCustrelEmp ctCustrelEmp = new CtCustrelEmp();
            ctCustrelEmp.setCustrelName(ctCustrel.getCustrelName());
            ctCustrelEmp.setCustrelCode(ctCustrel.getCustrelCode());
            ctCustrelEmp.setEmployeeCode(ctCustrel.getEmployeeCode());
            ctCustrelEmp.setEmployeeName(ctCustrel.getEmployeeName());
            ctCustrelEmp.setTenantCode(ctCustrel.getTenantCode());
            ctCustrelEmp.setUserCode(ctCustrel.getUserCode());
            ctCustrelEmp.setCustrelPhone(ctCustrel.getCustrelPhone());
            ctCustrelEmp.setUserinfoCode(ctCustrel.getUserinfoCode());
            ctCustrelEmp.setDataState(ctCustrel.getDataState());
            this.saveCustrelEmpModel(ctCustrelEmp);
        }
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "insert");
    }

    private void saveCustrelEmp(CtCustrel ctCustrel, OrgEmployee orgEmployee) {
        if (null == ctCustrel || null == orgEmployee) {
            return;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("employeeCode", orgEmployee.getEmployeeCode());
        parammap.put("custrelCode", ctCustrel.getCustrelCode());
        parammap.put("tenantCode", ctCustrel.getTenantCode());
        List<CtCustrelEmp> empList = this.queryCustrelEmpModelPage(parammap);
        if (ListUtil.isNotEmpty(empList)) {
            return;
        }
        ctCustrel.setEmployeeCode(orgEmployee.getEmployeeCode());
        ctCustrel.setEmployeeName(orgEmployee.getEmployeeName());
        CtCustrelEmpDomain ctCustrelEmpDomain = new CtCustrelEmpDomain();
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrelEmpDomain, (Object)ctCustrel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ctCustrelEmpDomain.setEmployeeCode(orgEmployee.getEmployeeCode());
        ctCustrelEmpDomain.setEmployeeName(orgEmployee.getEmployeeName());
        this.saveCustrelEmp(ctCustrelEmpDomain);
    }

    private OrgDepartemp getDeptemp(String tenantCode, String companyCode, String employeeCode) {
        if (StringUtils.isBlank((String)employeeCode) || StringUtils.isBlank((String)companyCode)) {
            return null;
        }
        String api = "org.depart.queryDepartempPage";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("employeeCode", employeeCode);
        paramMap.put("companyCode", companyCode);
        paramMap.put("tenantCode", tenantCode);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("map", JsonUtil.buildNormalBinder().toJson(paramMap));
        String json = this.internalInvoke(api, map);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        QueryResult queryResult = (QueryResult)JsonUtil.buildNormalBinder().getJsonToObject(json, QueryResult.class);
        if (null == queryResult) {
            return null;
        }
        List orgDepartempList = (List)JsonUtil.buildNormalBinder().getJsonToList(JsonUtil.buildNormalBinder().toJson((Object)queryResult.getList()), OrgDepartemp.class);
        if (ListUtil.isEmpty((Collection)orgDepartempList)) {
            return null;
        }
        return (OrgDepartemp)orgDepartempList.get(0);
    }

    private OrgEmployee getEmp(String tenantCode, String employeeCode) {
        if (StringUtils.isBlank((String)employeeCode)) {
            return null;
        }
        String api = "org.employee.getEmployeeByCode";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("employeeCode", employeeCode);
        paramMap.put("tenantCode", tenantCode);
        String json = this.internalInvoke(api, paramMap);
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("ct.CtCustrelServiceImpl.getEmp.json");
        }
        OrgEmployee orgEmployee = (OrgEmployee)JsonUtil.buildNormalBinder().getJsonToObject(json, OrgEmployee.class);
        if (null == orgEmployee) {
            throw new ApiException("ct.CtCustrelServiceImpl.getEmp.orgEmployee");
        }
        return orgEmployee;
    }

    @Override
    public List<CtChannelsend> saveCustrelByUserinfoCode(String userinfoCode, String companyCode, String employeeCode, String tenantCode) throws ApiException {
        CtCustrel ctCustrel = this.saveCustrel(userinfoCode, companyCode, null, null, employeeCode, tenantCode);
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "update");
    }

    private CtCustrelDomain makeCtCustrelDomain(String userinfoCode, String tenantCode) {
        if (StringUtils.hasBlank((String[])new String[]{userinfoCode, tenantCode})) {
            return null;
        }
        String apiCode = "um.user.getUserinfoByUserCode";
        CtCustrelDomain ctCustrelDomain = new CtCustrelDomain();
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("userinfoCode", userinfoCode);
        paramMap.put("tenantCode", tenantCode);
        String json = this.internalInvoke(apiCode, paramMap);
        if (StringUtils.isBlank((String)json)) {
            return null;
        }
        UmUserinfo umUserinfo = (UmUserinfo)JsonUtil.buildNormalBinder().getJsonToObject(json, UmUserinfo.class);
        if (null == umUserinfo) {
            return null;
        }
        try {
            BeanUtils.copyAllPropertys((Object)ctCustrelDomain, (Object)umUserinfo);
        }
        catch (Exception e) {
            return null;
        }
        ctCustrelDomain.setCustrelType(umUserinfo.getUserinfoType());
        ctCustrelDomain.setCustrelTel(umUserinfo.getUserinfoTel());
        ctCustrelDomain.setCustrelCorp(umUserinfo.getUserinfoCorp());
        ctCustrelDomain.setCustrelCoid(umUserinfo.getUserinfoCoid());
        ctCustrelDomain.setCustrelEmail(umUserinfo.getUserinfoEmail());
        ctCustrelDomain.setCustrelTaun(umUserinfo.getUserinfoTaun());
        ctCustrelDomain.setCustrelCon(umUserinfo.getUserinfoCon());
        ctCustrelDomain.setCustrelPhone(umUserinfo.getUserinfoPhone());
        ctCustrelDomain.setCustrelConQq(umUserinfo.getUserinfoConQq());
        ctCustrelDomain.setCustrelCertNo(umUserinfo.getUserinfoCertNo());
        ctCustrelDomain.setCustrelCert1No(umUserinfo.getUserinfoCert1No());
        ctCustrelDomain.setCustrelCert2No(umUserinfo.getUserinfoCert2No());
        ctCustrelDomain.setCustrelCertUrl(umUserinfo.getUserinfoCertUrl());
        ctCustrelDomain.setCustrelCert1Url(umUserinfo.getUserinfoCert1Url());
        ctCustrelDomain.setCustrelCert2Url(umUserinfo.getUserinfoCert2Url());
        ctCustrelDomain.setCustrelConPhone(StringUtils.isBlank((String)umUserinfo.getUserinfoConPhone()) ? umUserinfo.getUserinfoPhone() : umUserinfo.getUserinfoConPhone());
        ctCustrelDomain.setCustrelName(umUserinfo.getUserinfoCompname());
        return ctCustrelDomain;
    }

    @Override
    public List<CtChannelsend> saveCustrelBatch(List<CtCustrelDomain> ctCustrelDomainList) throws ApiException {
        if (null == ctCustrelDomainList || ctCustrelDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CtChannelsend> relist = new ArrayList<CtChannelsend>();
        ArrayList ctCustrelList = new ArrayList();
        String code = "";
        for (CtCustrelDomain ctCustrelDomain : ctCustrelDomainList) {
            List<CtChannelsend> list = this.saveCustrel(ctCustrelDomain);
            if (!ListUtil.isNotEmpty(list)) continue;
            relist.addAll(list);
        }
        return relist;
    }

    @Override
    public List<CtChannelsend> updateCustrelState(Integer custrelId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCustrelModel(custrelId, dataState, oldDataState);
        CtCustrel custrel = this.getCustrel(custrelId);
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(custrel);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<CtChannelsend> updateCustrelBatchState(List<String> custrelIds, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateBatchStateCustrelModel(custrelIds, dataState, oldDataState);
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        for (String custrelId : custrelIds) {
            CtCustrel custrel = this.getCustrel(Integer.valueOf(custrelId));
            list.add(custrel);
        }
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<CtChannelsend> updateCustrelStateByCode(String tenantCode, String custrelCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCustrelModelByCode(tenantCode, custrelCode, dataState, oldDataState);
        CtCustrel custrelByCode = this.getCustrelByCode(tenantCode, custrelCode);
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(custrelByCode);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<CtChannelsend> updateCustrel(CtCustrelDomain ctCustrelDomain) throws ApiException {
        List<CtCustrelEmp> orgEmployeeList;
        String msg = this.checkCustrel(ctCustrelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrel.checkCustrel", msg);
        }
        CtCustrel oldCtCustrel = this.getCustrelModelById(ctCustrelDomain.getCustrelId());
        if (null == oldCtCustrel) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrel.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CtCustrel ctCustrel = this.makeCustrel(ctCustrelDomain, oldCtCustrel);
        this.setCustrelUpdataDefault(ctCustrel);
        if (StringUtils.isNotBlank((String)ctCustrel.getDepartCode())) {
            ctCustrel.setDataState(1);
        }
        this.updateCustrelModel(ctCustrel);
        if (StringUtils.isNotBlank((String)ctCustrel.getEmployeeCode()) && ListUtil.isEmpty(orgEmployeeList = this.queryCustrelEmpModelPage(this.getQueryMapParam("employeeCode,CustrelCode,tenantCode", new Object[]{ctCustrel.getEmployeeCode(), ctCustrel.getCustrelCode(), ctCustrel.getTenantCode()})))) {
            CtCustrelEmp ctCustrelEmp = new CtCustrelEmp();
            ctCustrelEmp.setCustrelName(ctCustrel.getCustrelName());
            ctCustrelEmp.setCustrelCode(ctCustrel.getCustrelCode());
            ctCustrelEmp.setEmployeeCode(ctCustrel.getEmployeeCode());
            ctCustrelEmp.setEmployeeName(ctCustrel.getEmployeeName());
            ctCustrelEmp.setTenantCode(ctCustrel.getTenantCode());
            ctCustrelEmp.setUserCode(ctCustrel.getUserCode());
            ctCustrelEmp.setCustrelPhone(ctCustrel.getCustrelPhone());
            ctCustrelEmp.setDataState(2);
            this.saveCustrelEmpModel(ctCustrelEmp);
        }
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public CtCustrel getCustrel(Integer custrelId) {
        return this.getCustrelModelById(custrelId);
    }

    @Override
    public List<CtChannelsend> deleteCustrel(Integer custrelId) throws ApiException {
        CtCustrel ctCustrel = this.getCtCustrel(custrelId);
        if (null == ctCustrel) {
            throw new ApiException("ct.CtCustrelServiceImpl.deleteCustrel.null", "\u6ca1\u6709\u8be5\u5ba2\u6237\u7684\u6570\u636e");
        }
        if (StringUtils.isNotBlank((String)ctCustrel.getCompanyCode()) && StringUtils.isBlank((String)ctCustrel.getEmployeeCode()) && StringUtils.isBlank((String)ctCustrel.getDepartCode())) {
            this.deleteCustrelModel(ctCustrel.getCustrelId());
        } else if (StringUtils.isNotBlank((String)ctCustrel.getCompanyCode()) && StringUtils.isNotBlank((String)ctCustrel.getDepartCode()) && StringUtils.isBlank((String)ctCustrel.getEmployeeCode())) {
            ctCustrel.setDepartCode(null);
            ctCustrel.setDepartName(null);
            ctCustrel.setEmployeeCode(null);
            ctCustrel.setEmployeeName(null);
            ctCustrel.setDataState(0);
            this.updateCtcustrelByCustrelCodeModel(ctCustrel);
        } else if (StringUtils.isNotBlank((String)ctCustrel.getCompanyCode()) && StringUtils.isNotBlank((String)ctCustrel.getDepartCode()) && StringUtils.isNotBlank((String)ctCustrel.getEmployeeCode())) {
            ctCustrel.setEmployeeCode(null);
            ctCustrel.setEmployeeName(null);
            ctCustrel.setDataState(1);
            this.updateCtcustrelByCustrelCodeModel(ctCustrel);
            this.deleteEmpByUserinfoCodeModel(ctCustrel.getUserinfoCode());
        }
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "update");
    }

    private CtCustrel getCtCustrel(Integer cantrellId) {
        CtCustrel custrel = this.getCustrel(cantrellId);
        return custrel;
    }

    @Override
    public QueryResult<CtCustrel> queryCustrelPage(Map<String, Object> map) {
        List<CtCustrel> ctCustrelList = this.queryCustrelPages(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCustrelEmp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ctCustrelList);
        return queryResult;
    }

    @Override
    public CtCustrel getCustrelByCode(String tenantCode, String custrelCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelCode", custrelCode);
        return this.getCustrelModelByCode(map);
    }

    @Override
    public List<CtChannelsend> deleteCustrelByCode(String tenantCode, String custrelCode) throws ApiException {
        CtCustrel ctCustrel = this.getCtCustrel(tenantCode, custrelCode);
        HashMap map = new HashMap();
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "delete");
    }

    private CtCustrel getCtCustrel(String tenantCode, String custrelCode) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelCode", custrelCode);
        CtCustrel ctCustrel = this.getCustrelByCode(tenantCode, custrelCode);
        this.delCustrelModelByCode(map);
        return ctCustrel;
    }

    @Override
    public String saveCustrelEmp(CtCustrelEmpDomain ctCustrelEmpDomain) throws ApiException {
        CtCustrelEmp ctCustrelEmp = this.createCtCustrelEmp(ctCustrelEmpDomain);
        this.saveCust(ctCustrelEmp);
        this.saveCustrelEmpModel(ctCustrelEmp);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("custrelCode", ctCustrelEmp.getCustrelCode());
        map.put("employeeCode", ctCustrelEmp.getEmployeeCode());
        map.put("employeeName", ctCustrelEmp.getEmployeeName());
        map.put("tenantCode", ctCustrelEmp.getTenantCode());
        map.put("dataState", 2);
        this.updateEmpByCode(map);
        return ctCustrelEmp.getCustrelEmpCode();
    }

    private void saveCust(CtCustrelEmp ctCustrelEmp) {
        if (null == ctCustrelEmp) {
            return;
        }
        CtCustrel ctCustrel = this.getCustrelByCode(ctCustrelEmp.getTenantCode(), ctCustrelEmp.getCustrelCode());
        if (null == ctCustrel) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCust.ctCustrel", "\u6570\u636e\u4e3a\u7a7a");
        }
        ctCustrel.setEmployeeCode(ctCustrelEmp.getEmployeeCode());
        ctCustrel.setDataState(2);
        this.updateCustrelModel(ctCustrel);
    }

    @Override
    public String saveCustrelEmpBatch(List<CtCustrelEmpDomain> ctCustrelEmpDomainList) throws ApiException {
        if (null == ctCustrelEmpDomainList || ctCustrelEmpDomainList.isEmpty()) {
            return null;
        }
        ArrayList<CtCustrelEmp> ctCustrelEmpList = new ArrayList<CtCustrelEmp>();
        String code = "";
        for (CtCustrelEmpDomain ctCustrelEmpDomain : ctCustrelEmpDomainList) {
            CtCustrelEmp ctCustrelEmp = this.createCtCustrelEmp(ctCustrelEmpDomain);
            code = ctCustrelEmp.getCustrelEmpCode();
            ctCustrelEmpList.add(ctCustrelEmp);
            this.saveCust(ctCustrelEmp);
        }
        this.saveCustrelEmpBatchModel(ctCustrelEmpList);
        return code;
    }

    @Override
    public void updateCustrelEmpState(Integer custrelEmpId, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCustrelEmpModel(custrelEmpId, dataState, oldDataState);
    }

    @Override
    public void updateCustrelEmpStateByCode(String tenantCode, String custrelEmpCode, Integer dataState, Integer oldDataState) throws ApiException {
        this.updateStateCustrelEmpModelByCode(tenantCode, custrelEmpCode, dataState, oldDataState);
    }

    @Override
    public void updateCustrelEmp(CtCustrelEmpDomain ctCustrelEmpDomain) throws ApiException {
        String msg = this.checkCustrelEmp(ctCustrelEmpDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelEmp.checkCustrelEmp", msg);
        }
        CtCustrelEmp oldCtCustrelEmp = this.getCustrelEmpModelById(ctCustrelEmpDomain.getCustrelEmpId());
        if (null == oldCtCustrelEmp) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelEmp.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CtCustrelEmp ctCustrelEmp = this.makeCustrelEmp(ctCustrelEmpDomain, oldCtCustrelEmp);
        this.setCustrelEmpUpdataDefault(ctCustrelEmp);
        this.updateCustrelEmpModel(ctCustrelEmp);
    }

    @Override
    public CtCustrelEmp getCustrelEmp(Integer custrelEmpId) {
        return this.getCustrelEmpModelById(custrelEmpId);
    }

    @Override
    public void deleteCustrelEmp(Integer custrelEmpId) throws ApiException {
        this.deleteCustrelEmpModel(custrelEmpId);
    }

    @Override
    public QueryResult<CtCustrelEmp> queryCustrelEmpPage(Map<String, Object> map) {
        List<CtCustrelEmp> ctCustrelEmpList = this.queryCustrelEmpModelPage(map);
        QueryResult queryResult = new QueryResult();
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCustrelEmp(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        queryResult.setList(ctCustrelEmpList);
        return queryResult;
    }

    @Override
    public CtCustrelEmp getCustrelEmpByCode(String tenantCode, String custrelEmpCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelEmpCode", custrelEmpCode);
        return this.getCustrelEmpModelByCode(map);
    }

    @Override
    public void deleteCustrelEmpByCode(String tenantCode, String custrelEmpCode) throws ApiException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelEmpCode", custrelEmpCode);
        this.delCustrelEmpModelByCode(map);
    }

    private void updateCustrelByEmployee(String userinfoCode, String companyCode, String departCode, String departName, String employeeCode, String oldEmployeeCode, String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("userinfoCode", userinfoCode);
        parammap.put("companyCode", companyCode);
        parammap.put("employeeCode", oldEmployeeCode);
        parammap.put("tenantCode", tenantCode);
        List<CtCustrel> ulist = this.queryCustrelModelPage(parammap);
        if (ListUtil.isEmpty(ulist)) {
            return;
        }
        OrgEmployee orgEmployee = this.getEmp(tenantCode, employeeCode);
        if (null == orgEmployee) {
            return;
        }
        CtCustrel ctCustrel = ulist.get(0);
        ctCustrel.setDepartCode(departCode);
        ctCustrel.setDepartName(departName);
        ctCustrel.setEmployeeCode(employeeCode);
        ctCustrel.setEmployeeName(orgEmployee.getEmployeeName());
        this.updateCustrelModel(ctCustrel);
        parammap = new HashMap();
        parammap.put("custrelCode", ctCustrel.getCustrelCode());
        parammap.put("tenantCode", tenantCode);
        List<CtCustrelEmp> uelist = this.queryCustrelEmpModelPage(parammap);
        if (ListUtil.isEmpty(uelist)) {
            return;
        }
        CtCustrelEmp ctCustrelEmp = uelist.get(0);
        ctCustrelEmp.setEmployeeCode(employeeCode);
        ctCustrelEmp.setEmployeeName(orgEmployee.getEmployeeName());
        this.updateCustrelEmpModel(ctCustrelEmp);
    }

    private void updateCustrelByCompany(String userinfoCode, String companyCode, String oldCompanyCode, String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("userinfoCode", userinfoCode);
        parammap.put("companyCode", oldCompanyCode);
        parammap.put("tenantCode", tenantCode);
        List<CtCustrel> ulist = this.queryCustrelModelPage(parammap);
        if (ListUtil.isEmpty(ulist)) {
            return;
        }
        CtCustrel ctCustrel = ulist.get(0);
        String json = DisUtil.getMap((String)"OrgCompany-companyCode", (String)(companyCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelByUserinfoCode.companyCode", companyCode + "-" + tenantCode);
        }
        OrgCompany orgCompany = (OrgCompany)DisUtil.getMapJson((String)"OrgCompany-all", (String)(json + "-" + tenantCode), OrgCompany.class);
        if (null == orgCompany) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelByUserinfoCode.orgCompany", json + "-" + tenantCode);
        }
        ctCustrel.setCompanyCode(companyCode);
        ctCustrel.setCompanyShortname(orgCompany.getCompanyShortname());
        ctCustrel.setDepartCode(null);
        ctCustrel.setDepartName(null);
        ctCustrel.setEmployeeCode(null);
        ctCustrel.setEmployeeName(null);
        ctCustrel.setDataState(0);
        this.updateCustrelModel(ctCustrel);
    }

    private void updateCustrelByCompanyCode(String userinfoCode, String companyCode, String oldCompanyCode, String companyShortname, String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("userinfoCode", userinfoCode);
        parammap.put("companyCode", oldCompanyCode);
        parammap.put("tenantCode", tenantCode);
        List<CtCustrel> ulist = this.queryCustrelModelPage(parammap);
        if (ListUtil.isEmpty(ulist)) {
            return;
        }
        CtCustrel ctCustrel = ulist.get(0);
        String employeeCode = ctCustrel.getEmployeeCode();
        String custrelCode = ctCustrel.getCustrelCode();
        ctCustrel.setCompanyCode(companyCode);
        ctCustrel.setCompanyShortname(companyShortname);
        ctCustrel.setDepartCode("");
        ctCustrel.setDepartName("");
        ctCustrel.setEmployeeCode("");
        ctCustrel.setEmployeeName("");
        ctCustrel.setDataState(0);
        this.updateCustrelModel(ctCustrel);
        HashMap<String, Object> parammap2 = new HashMap<String, Object>();
        parammap2.put("employeeCode", employeeCode);
        parammap2.put("custrelCode", custrelCode);
        parammap2.put("tenantCode", tenantCode);
        List<CtCustrelEmp> empList = this.queryCustrelEmpModelPage(parammap2);
        if (ListUtil.isEmpty(empList)) {
            return;
        }
        CtCustrelEmp ctCustrelEmp = empList.get(0);
        String custrelEmpCode = ctCustrelEmp.getCustrelEmpCode();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("tenantCode", tenantCode);
        map.put("custrelEmpCode", custrelEmpCode);
        this.delCustrelEmpModelByCode(map);
    }

    private void updateCustrelByDepart(String userinfoCode, String companyCode, String departCode, String departName, String oldDepartCode, String tenantCode) {
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("userinfoCode", userinfoCode);
        parammap.put("companyCode", companyCode);
        parammap.put("departCode", oldDepartCode);
        parammap.put("tenantCode", tenantCode);
        List<CtCustrel> ulist = this.queryCustrelModelPage(parammap);
        if (ListUtil.isEmpty(ulist)) {
            return;
        }
        CtCustrel ctCustrel = ulist.get(0);
        ctCustrel.setDepartCode(oldDepartCode);
        ctCustrel.setDepartName(departName);
        ctCustrel.setEmployeeCode(null);
        ctCustrel.setEmployeeName(null);
        ctCustrel.setDataState(0);
        this.updateCustrelModel(ctCustrel);
    }

    private CtCustrel saveCustrel(String userinfoCode, String companyCode, String departCode, String departName, String employeeCode, String tenantCode) {
        OrgDepartemp orgDepartemp;
        if (StringUtils.hasBlank((String[])new String[]{userinfoCode, companyCode, tenantCode})) {
            return null;
        }
        HashMap<String, Object> parammap = new HashMap<String, Object>();
        parammap.put("userinfoCode", userinfoCode);
        parammap.put("companyCode", companyCode);
        parammap.put("tenantCode", tenantCode);
        List<CtCustrel> ulist = this.queryCustrelModelPage(parammap);
        OrgEmployee orgEmployee = this.getEmp(tenantCode, employeeCode);
        if (StringUtils.isBlank((String)departCode) && null != (orgDepartemp = this.getDeptemp(tenantCode, companyCode, employeeCode))) {
            departName = departCode = orgDepartemp.getDepartCode();
        }
        if (null != ulist && !ulist.isEmpty()) {
            CtCustrel ctCustrel = ulist.get(0);
            if (StringUtils.isNotBlank((String)employeeCode)) {
                ctCustrel.setDepartCode(departCode);
                ctCustrel.setDepartName(departName);
                this.saveCustrelEmp(ctCustrel, orgEmployee);
                ctCustrel.setDataState(2);
                this.updateCustrelModel(ctCustrel);
            } else if (StringUtils.isNotBlank((String)departCode)) {
                ctCustrel.setDepartCode(departCode);
                ctCustrel.setDepartName(departName);
                ctCustrel.setDataState(1);
                this.updateCustrelModel(ctCustrel);
            }
            ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
            list.add(ctCustrel);
            return ctCustrel;
        }
        String json = DisUtil.getMap((String)"OrgCompany-companyCode", (String)(companyCode + "-" + tenantCode));
        if (StringUtils.isBlank((String)json)) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelByUserinfoCode.companyCode", companyCode + "-" + tenantCode);
        }
        OrgCompany orgCompany = (OrgCompany)DisUtil.getMapJson((String)"OrgCompany-all", (String)(json + "-" + tenantCode), OrgCompany.class);
        if (null == orgCompany) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelByUserinfoCode.orgCompany", json + "-" + tenantCode);
        }
        CtCustrelDomain ctCustrelDomain = this.makeCtCustrelDomain(userinfoCode, tenantCode);
        if (null == ctCustrelDomain) {
            throw new ApiException("ct.CtCustrelServiceImpl.saveCustrelByUserinfoCode.ctCustrelDomain", userinfoCode + "-" + tenantCode);
        }
        ctCustrelDomain.setCompanyCode(orgCompany.getCompanyCode());
        ctCustrelDomain.setEmployeeCode(employeeCode);
        ctCustrelDomain.setDepartCode(departCode);
        ctCustrelDomain.setDepartName(departName);
        if (null != orgEmployee) {
            ctCustrelDomain.setEmployeeName(orgEmployee.getEmployeeName());
        }
        ctCustrelDomain.setCompanyShortname(orgCompany.getCompanyShortname());
        CtCustrel ctCustrel = this.createCtCustrel(ctCustrelDomain);
        if (StringUtils.isNotBlank((String)employeeCode)) {
            ctCustrel.setDataState(1);
        }
        this.saveCustrelModel(ctCustrel);
        if (StringUtils.isNotBlank((String)employeeCode)) {
            this.saveCustrelEmp(ctCustrel, orgEmployee);
        }
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(ctCustrel);
        return ctCustrel;
    }

    private void updateCustomer(CtCustrelDomain ctCustrelDomain) throws ApiException {
        String msg = this.checkCustrel(ctCustrelDomain);
        if (StringUtils.isNotBlank((String)msg)) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustomer.checkCustrel", msg);
        }
        CtCustrel oldCtCustrel = this.getCustrelModelById(ctCustrelDomain.getCustrelId());
        if (null == oldCtCustrel) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustomer.null", "\u6570\u636e\u4e3a\u7a7a");
        }
        CtCustrel ctCustrel = this.makeCustrel(ctCustrelDomain, oldCtCustrel);
        this.setCustrelUpdataDefault(ctCustrel);
        this.updateCustrelModel(ctCustrel);
    }

    @Override
    public List<CtChannelsend> saveCustrelToCom(String userinfoCode, String companyCode, String tenantCode) throws ApiException {
        CtCustrel ctCustrel = this.saveCustrel(userinfoCode, companyCode, null, null, null, tenantCode);
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public void updateCustrelToB(String userinfoCode, String companyCode, String oldCompanyCode, String tenantCode) throws ApiException {
        this.updateCustrelByCompany(userinfoCode, companyCode, oldCompanyCode, tenantCode);
    }

    @Override
    public List<CtChannelsend> saveCustrelToDepartStr(String userinfoCode, String companyCode, String departCode, String departName, String tenantCode) throws ApiException {
        CtCustrel ctCustrel = this.saveCustrel(userinfoCode, companyCode, departCode, departName, null, tenantCode);
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public List<CtChannelsend> saveCustrelToEmployee(String userinfoCode, String companyCode, String departCode, String departName, String employeeCode, String tenantCode) throws ApiException {
        CtCustrel ctCustrel = this.saveCustrel(userinfoCode, companyCode, departCode, departName, employeeCode, tenantCode);
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public void updateCustrelToDepartmentForCom(String userinfoCode, String companyCode, String departCode, String departName, String oldDepartCode, String tenantCode) throws ApiException {
        this.updateCustrelByDepart(userinfoCode, companyCode, departCode, departName, oldDepartCode, tenantCode);
    }

    @Override
    public void updateCustrelToEmployeeForCom(String userinfoCode, String companyCode, String departCode, String departName, String employeeCode, String oldEmployeeCode, String tenantCode) throws ApiException {
        this.updateCustrelByEmployee(userinfoCode, companyCode, departCode, departName, employeeCode, oldEmployeeCode, tenantCode);
    }

    @Override
    public List<CtChannelsend> saveCustrelToEmployeeForDepartment(String userinfoCode, String companyCode, String departCode, String departName, String employeeCode, String tenantCode) throws ApiException {
        CtCustrel ctCustrel = this.saveCustrel(userinfoCode, companyCode, departCode, departName, employeeCode, tenantCode);
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(ctCustrel);
        return this.buidPmChannelsend(list, "update");
    }

    @Override
    public void updateCustrelToEmployeeForDepartment(String userinfoCode, String companyCode, String departCode, String departName, String employeeCode, String oldEmployeeCode, String tenantCode) throws ApiException {
        this.updateCustrelByEmployee(userinfoCode, companyCode, departCode, departName, employeeCode, oldEmployeeCode, tenantCode);
    }

    @Override
    public void updateCustrelForComToB(String userinfoCode, String companyCode, String oldCompanyCode, String companyShortname, String tenantCode) throws ApiException {
        this.updateCustrelByCompanyCode(userinfoCode, companyCode, oldCompanyCode, companyShortname, tenantCode);
    }

    @Override
    public String checkCustrelByCustrelCode(String tanantCode, String custrelCode) throws ApiException {
        CtCustrel ctCustre = this.getCustrelByCode(tanantCode, custrelCode);
        if (ctCustre == null) {
            throw new ApiException("ct.CtCustrelServiceImpl.checkCustrelByUserinfoCode.ex", "\u5ba2\u6237\u4e3a\u7a7a");
        }
        if (StringUtils.isNotBlank((String)ctCustre.getEmployeeCode())) {
            throw new ApiException("ct.CtCustrelServiceImpl.checkCustrelByUserinfoCode.ex", "\u8be5\u5ba2\u6237\u5df2\u7ecf\u5206\u914d\u5458\u5de5");
        }
        if (StringUtils.isNotBlank((String)ctCustre.getDepartCode())) {
            throw new ApiException("ct.CtCustrelServiceImpl.checkCustrelByUserinfoCode.ex", "\u8be5\u5ba2\u6237\u5df2\u7ecf\u5206\u914d\u90e8\u95e8");
        }
        return "success";
    }

    private CtCustrel checkCustrelByUserinfoCodeModel(String userinfoCode) throws ApiException {
        if (StringUtils.isBlank((String)userinfoCode)) {
            return null;
        }
        try {
            return this.ctCustrelMapper.selectOneByUserinfoCode(userinfoCode);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.checkCustrelByUserinfoCodeModel.ex", (Throwable)e);
        }
    }

    @Override
    public List<CtChannelsend> updateCustrelByCustrelId(Integer custrelId, String custrelName, String tenantCode) {
        if (StringUtils.isBlank((Integer)custrelId) || StringUtils.isBlank((String)custrelName)) {
            return null;
        }
        CtCustrel custrel = this.getCustrel(custrelId);
        custrel.setCustrelShortname(custrelName);
        custrel.setCustrelName(custrelName);
        if (StringUtils.isNotBlank((String)custrel.getEmployeeCode())) {
            this.updateCustrelEmpByCustrelCodeModel(custrel.getCustrelCode(), custrelName);
            this.updateCustrelByCustrelCodeModel(custrel);
        } else {
            this.updateCustrelByCustrelCodeModel(custrel);
        }
        ArrayList<CtCustrel> list = new ArrayList<CtCustrel>();
        list.add(custrel);
        return this.buidPmChannelsend(list, "update");
    }

    private void updateCustrelByCustrelCodeModel(CtCustrel updated) {
        if (null == updated) {
            return;
        }
        try {
            this.ctCustrelMapper.updateByCustrelCode(updated, updated.getCustrelCode());
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelByCustrelCodeModel.ex", (Throwable)e);
        }
    }

    private void updateCustrelEmpByCustrelCodeModel(String custrelCode, String custrelName) {
        if (StringUtils.isBlank((String)custrelCode) || StringUtils.isBlank((String)custrelName)) {
            return;
        }
        try {
            CtCustrelEmp updated = new CtCustrelEmp();
            updated.setCustrelName(custrelName);
            this.ctCustrelEmpMapper.updateByCustrelCode(updated, custrelCode);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCustrelEmpByCustrelCodeModel.ex", (Throwable)e);
        }
    }

    private void deleteEmpByUserinfoCodeModel(String userinfoCOde) {
        if (StringUtils.isBlank((String)userinfoCOde)) {
            return;
        }
        try {
            this.ctCustrelEmpMapper.deleteByUserinfoCode(userinfoCOde);
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.deleteByUserinfoCodeModel.ex", (Throwable)e);
        }
    }

    private void updateCtcustrelByCustrelCodeModel(CtCustrel updated) {
        int a = 0;
        if (null == updated) {
            return;
        }
        try {
            a = this.ctCustrelMapper.updateByCustrelCode(updated, updated.getCustrelCode());
        }
        catch (Exception e) {
            throw new ApiException("ct.CtCustrelServiceImpl.updateCtcusrelByCustrelCodeModel.ex", (Throwable)e);
        }
    }

    @Override
    public QueryResult<CtCustrel> queryUnDistribution(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String companyCode = (String)map.get("companyCode");
        if (StringUtils.isBlank((String)companyCode)) {
            return null;
        }
        String departCode = (String)map.get("departCode");
        String employeeCode = (String)map.get("employeeCode");
        ArrayList<CtCustrel> companyCt = new ArrayList<CtCustrel>();
        ArrayList<CtCustrel> departCt = new ArrayList<CtCustrel>();
        List<CtCustrel> ctCustrels = this.queryCustrelModelPage(map);
        QueryResult queryResult = new QueryResult();
        for (CtCustrel ctCustrel : ctCustrels) {
            if (StringUtils.isBlank((String)ctCustrel.getDepartCode()) && StringUtils.isBlank((String)ctCustrel.getEmployeeCode())) {
                companyCt.add(ctCustrel);
            }
            if (!StringUtils.isNotBlank((String)ctCustrel.getDepartCode()) || !StringUtils.isBlank((String)ctCustrel.getEmployeeCode())) continue;
            departCt.add(ctCustrel);
        }
        if (StringUtils.isBlank((String)departCode)) {
            queryResult.setList(companyCt);
        }
        if (StringUtils.isBlank((String)employeeCode) && StringUtils.isNotBlank((String)departCode)) {
            queryResult.setList(departCt);
        }
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCustrel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        return queryResult;
    }

    @Override
    public QueryResult<CtCustrel> queryAlredyCustrel(Map<String, Object> map) {
        if (null == map) {
            return null;
        }
        String companyCode = (String)map.get("companyCode");
        if (StringUtils.isBlank((String)companyCode)) {
            return null;
        }
        String departCode = (String)map.get("departCode");
        String employeeCode = (String)map.get("employeeCode");
        ArrayList<CtCustrel> company = new ArrayList<CtCustrel>();
        ArrayList<CtCustrel> departCt = new ArrayList<CtCustrel>();
        ArrayList<CtCustrel> employee = new ArrayList<CtCustrel>();
        List<CtCustrel> ctCustrels = this.queryCustrelModelPage(map);
        QueryResult queryResult = new QueryResult();
        for (CtCustrel ctCustrel : ctCustrels) {
            if (StringUtils.isNotBlank((String)ctCustrel.getCompanyCode())) {
                company.add(ctCustrel);
            }
            if (StringUtils.isNotBlank((String)ctCustrel.getDepartCode()) && StringUtils.isNotBlank((String)ctCustrel.getCompanyCode())) {
                departCt.add(ctCustrel);
            }
            if (!StringUtils.isNotBlank((String)employeeCode) || !StringUtils.isNotBlank((String)ctCustrel.getEmployeeCode()) || !employeeCode.equals(ctCustrel.getEmployeeCode())) continue;
            employee.add(ctCustrel);
        }
        if (StringUtils.isNotBlank((String)companyCode)) {
            queryResult.setList(company);
        }
        if (StringUtils.isNotBlank((String)companyCode) && StringUtils.isNotBlank((String)departCode)) {
            queryResult.setList(departCt);
        }
        if (StringUtils.isNotBlank((String)companyCode) && StringUtils.isNotBlank((String)departCode) && StringUtils.isNotBlank((String)employeeCode)) {
            queryResult.setList(employee);
        }
        PageTools pageTools = new PageTools();
        pageTools.setRecordCount(this.countCustrel(map));
        queryResult.setPageTools((SupPageTools)pageTools);
        return queryResult;
    }

    private List<CtChannelsend> buidPmChannelsend(List<CtCustrel> pmPromotionList, String dri) {
        if (ListUtil.isEmpty(pmPromotionList)) {
            return null;
        }
        ArrayList<CtChannelsend> pmChannelsendList = new ArrayList();
        ArrayList<CtChannelsendDomain> disChannelsendDomainList = new ArrayList<CtChannelsendDomain>();
        for (CtCustrel promotion : pmPromotionList) {
            CtChannelsendDomain pmChannelsendDomain = new CtChannelsendDomain();
            pmChannelsendDomain.setChannelsendOpcode(promotion.getCustrelCode());
            pmChannelsendDomain.setChannelsendType("ctCustrel");
            pmChannelsendDomain.setChannelsendDir(dri);
            pmChannelsendDomain.setChannelsendTxt(JsonUtil.buildNormalBinder().toJson((Object)promotion));
            pmChannelsendDomain.setTenantCode(promotion.getTenantCode());
            disChannelsendDomainList.add(pmChannelsendDomain);
        }
        pmChannelsendList = this.ctChannelsendService.saveSendCtChannelsendBatch(disChannelsendDomainList);
        return pmChannelsendList;
    }
}

